/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.convt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConvtByUserDefinedRate {
    private static final String ISRESERVIBLE_YES = "1";
    private static final boolean SINGLE_CAL = true;
    private static final String OPRT_DIV = "div";
    private static final String OPRT_MUL = "mul";
    private Map cacheMap = new HashMap();
    private Map rateCacheMap = new HashMap();
    private String targetCurrency = "";
    private String curSrcCurrency = "";
    private String DataCollectNum = "";
    private String exChgdRateTblID = "";
    private Context ctx;
    private int curYear;
    private int curPeriod;
    private int curPeriodType;
    private StringBuffer sql = new StringBuffer();
    private List params = new ArrayList(8);
    private BigDecimal zero = new BigDecimal("0.00000");

    protected void InitParamsByReport(Map params, String targCurrency, String exChgdRateTblID, Context ctx) {
        this.curYear = (Integer)params.get("YEAR");
        this.curPeriod = (Integer)params.get("PERIOD");
        this.curPeriodType = ((RptPeriodTypeEnum)params.get("PERIODTYPE")).getValue();
        this.curSrcCurrency = ((CurrencyInfo)params.get("SRCCURRENCY")).getId().toString();
        this.DataCollectNum = params.get("DCNUMBER") == null ? "ACTUALDATA" : (String)params.get("DCNUMBER");
        this.targetCurrency = targCurrency;
        this.exChgdRateTblID = exChgdRateTblID;
        this.ctx = ctx;
    }

    protected void preparedUserDefinedRate() throws BOSException, EASBizException {
        this.combineSql();
        this.cacheMap.clear();
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)this.sql.toString(), (Object[])this.params.toArray());
        try {
            StringBuffer keystr = new StringBuffer();
            while (rs.next()) {
                BigDecimal rate;
                keystr.setLength(0);
                this.getKey(rs, keystr);
                BigDecimal bigDecimal = rate = rs.getBigDecimal("convertRate") == null ? this.zero : rs.getBigDecimal("convertRate");
                if (ConvtUtil.isLogConvtFormula) {
                    String period = rs.getString("period");
                    this.cacheMap.put(keystr.toString(), new OperateState(rate, rs.getString("isReversible"), true, "user Defined Rate\uff1a " + rs.getString("fyear") + (period != null && period.length() > 1 ? "" : "0") + period));
                    continue;
                }
                this.cacheMap.put(keystr.toString(), new OperateState(rate, rs.getString("isReversible"), true));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void combineSql() {
        this.sql.delete(0, this.sql.length());
        this.sql.append(this.getCommonSql(false));
        this.params.clear();
        this.params.add(this.curSrcCurrency);
        this.params.add(this.targetCurrency);
        this.params.add(new Integer(this.curYear));
        this.params.add(new Integer(this.curPeriod));
        this.params.add(new Integer(this.curPeriodType));
        this.params.add(this.exChgdRateTblID);
        this.params.add(this.DataCollectNum);
    }

    protected BigDecimal convertValue(BigDecimal value, Date endDate, int dataElementValue, String DataCollectNum, String srcCurrency, String strExChgdRateTblID) throws BOSException, EASBizException {
        List times = RPTDateUtil.getRptPeriod(endDate, RptPeriodTypeEnum.getEnum((int)this.curPeriodType));
        Integer year = new Integer(times.get(0).toString());
        Integer period = new Integer(times.get(1).toString());
        String orderKey = null;
        BigDecimal rate = null;
        orderKey = this.getCombineKey(srcCurrency, this.targetCurrency, year, period, this.curPeriodType, DataCollectNum, dataElementValue);
        if (this.cacheMap.containsKey(orderKey)) {
            OperateState operate = (OperateState)this.cacheMap.get(orderKey);
            return operate.getConvtValue(value);
        }
        IRowSet rs = this.fetchSingleRecord(srcCurrency, year, period, DataCollectNum, dataElementValue, strExChgdRateTblID);
        String src2targKey = this.combineCurrencyKey(srcCurrency, this.targetCurrency);
        try {
            boolean find = false;
            while (rs.next()) {
                String curKey = this.combineCurrencyKey(rs.getString("sourceCurrencyId"), rs.getString("targetCurrencyId"));
                if (src2targKey.equals(curKey)) {
                    rate = rs.getBigDecimal("convertRate");
                    String userDefinedRate = ConvtUtil.buildUserDefinedRateDetail(year + (period > 9 ? "" : "0") + period);
                    value = this.getConvertVal(value, rate, OPRT_MUL, userDefinedRate);
                    find = true;
                    this.cacheMap.put(orderKey, new OperateState(rate, rs.getString("isReversible"), true, userDefinedRate));
                    break;
                }
                if (!rs.getString("isReversible").equals(ISRESERVIBLE_YES)) continue;
                rate = rs.getBigDecimal("convertRate");
                String userDefinedRate = ConvtUtil.buildUserDefinedRateDetail(year + (period > 9 ? "" : "0") + period);
                value = this.getConvertVal(value, rate, OPRT_DIV, userDefinedRate);
                find = true;
                this.cacheMap.put(orderKey, new OperateState(rate, rs.getString("isReversible"), false, userDefinedRate));
                break;
            }
            if (find) {
                return value;
            }
            throw new ServerException(ServerException.NOT_FOUND_USERDEFINEDRATE, new Object[0]);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private String combineCurrencyKey(String srcCurrencyId, String targCurrencyId) {
        StringBuffer keyCurrenyId = new StringBuffer();
        this.combineKey(keyCurrenyId, srcCurrencyId);
        this.combineKey(keyCurrenyId, targCurrencyId);
        return keyCurrenyId.toString();
    }

    private String getCombineKey(String srcCurrency, String tgCurrency, Integer year, Integer period, int PeriodTypeVal, String dcNum, int dataElementValue) {
        StringBuffer keyStr = new StringBuffer();
        this.combineKey(keyStr, srcCurrency);
        this.combineKey(keyStr, tgCurrency);
        this.combineKey(keyStr, year.toString());
        this.combineKey(keyStr, period.toString());
        this.combineKey(keyStr, "" + PeriodTypeVal);
        this.combineKey(keyStr, dcNum);
        this.combineKey(keyStr, "" + dataElementValue);
        return keyStr.toString();
    }

    private IRowSet fetchSingleRecord(String srcCurrency, Integer year, Integer period, String DataCollect2, int dataElement, String strExChgdRateTblID) throws BOSException {
        this.combineSqlUnion();
        this.params.clear();
        this.params.add(srcCurrency);
        this.params.add(this.targetCurrency);
        this.params.add(new Integer(dataElement));
        this.params.add(year);
        this.params.add(year);
        this.params.add(period);
        this.params.add(new Integer(this.curPeriodType));
        this.params.add(this.exChgdRateTblID);
        this.params.add(DataCollect2);
        this.params.add(this.targetCurrency);
        this.params.add(srcCurrency);
        this.params.add(new Integer(dataElement));
        this.params.add(year);
        this.params.add(year);
        this.params.add(period);
        this.params.add(new Integer(this.curPeriodType));
        this.params.add(this.exChgdRateTblID);
        this.params.add(DataCollect2);
        return DbUtil.executeQuery((Context)this.ctx, (String)this.sql.toString(), (Object[])this.params.toArray());
    }

    private void combineSqlUnion() {
        this.sql.setLength(0);
        this.sql.append(" select * from (").append(" select * from (").append(this.getCommonSql(true)).append(") a ").append(" union ").append(" select * from (").append(this.getCommonSql(true)).append(") b ").append(") t order by fyear desc,period desc");
    }

    private void getKey(IRowSet rs, StringBuffer keyStr) throws SQLException {
        this.combineKey(keyStr, rs.getString("sourceCurrencyId"));
        this.combineKey(keyStr, rs.getString("targetCurrencyId"));
        this.combineKey(keyStr, rs.getString("fyear"));
        this.combineKey(keyStr, rs.getString("period"));
        this.combineKey(keyStr, rs.getString("periodType"));
        this.combineKey(keyStr, rs.getString("dataCollect"));
        this.combineKey(keyStr, rs.getString("dataElement"));
    }

    private String getCommonSql(boolean singleCal) {
        StringBuffer sql = new StringBuffer();
        String topsign = singleCal ? " top 1 " : "";
        sql.append(" select ").append(topsign).append(" u.Fid as Id, u.FisReversible as isReversible, u.FsourceCurrencyId as sourceCurrencyId,\n").append(" u.FtargetCurrencyId as targetCurrencyId,u.Fyear as fyear,u.Fperiod as period,u.FperiodType periodType, \n").append(" d.Fnumber as dataCollect,e.FInterSeq as dataElement,u.FconvertRate as convertRate from t_csl_userDefinedRate u \n").append(" join t_bd_currency s on u.FsourceCurrencyId = s.Fid  \n").append(" join t_bd_currency t on u.FtargetCurrencyId = t.Fid  \n").append(" join t_csl_dataElement e on u.FdataElementId = e.Fid \n").append(" join t_csl_dataCollect d on u.FdataCollectId = d.Fid \n");
        if (!singleCal) {
            sql.append(" where u.FsourceCurrencyId = ? and u.FtargetCurrencyId = ?    \n").append(" and u.Fyear = ? and u.Fperiod = ? and u.FperiodType = ?      \n").append(" and u.FRateTabID = ? \n").append(" and d.Fnumber = ?                                            \n");
        } else {
            sql.append(" where u.FsourceCurrencyId = ? and u.FtargetCurrencyId = ?    \n").append(" and e.FInterSeq = ?                                          \n").append(" and (u.Fyear<? or (u.Fyear = ? and u.Fperiod <= ?)) and u.FperiodType = ?    \n").append(" and u.FRateTabID = ? \n").append(" and d.Fnumber = ?                                            \n").append(" order by u.Fyear desc,u.Fperiod desc                         \n");
        }
        return sql.toString();
    }

    private BigDecimal getConvertVal(BigDecimal val, BigDecimal rate, String Oprt) {
        return this.getConvertVal(val, rate, Oprt, null);
    }

    private BigDecimal getConvertVal(BigDecimal val, BigDecimal rate, String Oprt, String detail) {
        if (Oprt.equals(OPRT_MUL)) {
            if (val != null) {
                ConvtUtil.setConvtCalcFormula(val + "*" + rate, rate + "=" + detail, "+");
            }
            return val == null ? this.zero : val.multiply(rate);
        }
        if (val != null) {
            boolean isConvtFormulaNull = StringUtils.isEmpty((String)ConvtUtil.getConvtCalcFormulaValue());
            ConvtUtil.setConvtCalcFormula((isConvtFormulaNull ? val : "") + "/" + rate, rate + "=" + detail, "+");
        }
        return val == null ? this.zero : val.divide(rate, 10, 4);
    }

    private void combineKey(StringBuffer keystr, String item) {
        if (StringUtils.isEmpty((String)item)) {
            return;
        }
        keystr.append("[").append(item).append("]");
    }

    protected String getCurSrcCurrency() {
        return this.curSrcCurrency;
    }

    protected void setCurSrcCurrency(String curSrcCurrency) {
        this.curSrcCurrency = curSrcCurrency;
    }

    protected boolean equales(String srcCurreny, int periodType) {
        return this.curSrcCurrency.equals(srcCurreny) && this.curPeriodType == periodType;
    }

    protected String getDataCollectNum() {
        return this.DataCollectNum;
    }

    protected void setDataCollectNum(String dataCollectNum) {
        this.DataCollectNum = dataCollectNum;
    }

    protected int getCurPeriod() {
        return this.curPeriod;
    }

    protected void setCurPeriod(int curPeriod) {
        this.curPeriod = curPeriod;
    }

    protected int getCurPeriodType() {
        return this.curPeriodType;
    }

    protected void setCurPeriodType(int curPeriodType) {
        this.curPeriodType = curPeriodType;
    }

    protected void clearCache() {
        if (!this.cacheMap.isEmpty()) {
            this.cacheMap.clear();
        }
        this.cacheMap = null;
    }

    private class OperateState {
        private BigDecimal _rate;
        private String _isReversible;
        private boolean _isExists = false;
        private String detail = null;

        public OperateState(BigDecimal rate, String isReversible, boolean isExists) {
            this._rate = rate;
            this._isReversible = isReversible;
            this._isExists = isExists;
        }

        public OperateState(BigDecimal rate, String isReversible, boolean isExists, String detail) {
            this(rate, isReversible, isExists);
            this.detail = detail;
        }

        private String getOperate() {
            if (this._isExists) {
                return ConvtByUserDefinedRate.OPRT_MUL;
            }
            return ConvtByUserDefinedRate.ISRESERVIBLE_YES.equals(this._isReversible) ? ConvtByUserDefinedRate.OPRT_DIV : ConvtByUserDefinedRate.OPRT_MUL;
        }

        public BigDecimal getConvtValue(BigDecimal originalVal) {
            return ConvtByUserDefinedRate.this.getConvertVal(originalVal, this._rate, this.getOperate(), this.detail);
        }
    }
}

