/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.convt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ConvertModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.IElimDynaItemEntry;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.AbstractCslConvt;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ElimConvtImp
extends AbstractCslConvt {
    public ElimConvtImp() {
        super("ELIM");
    }

    public ElimConvtImp(String convtType) {
        super(convtType);
    }

    @Override
    public String excConvert(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        int j;
        EliminationInfo elimInfo = (EliminationInfo)info;
        EliminationEntryCollection entry = elimInfo.getEntries();
        EliminationEntryInfo entryInfo = null;
        ConvertModeEnum convertMode = null;
        BigDecimal curValue = null;
        int currencyScale = this.paramsManager.getTargetCurrencyInfo().getPrecision();
        if (currencyScale == 0) {
            currencyScale = 2;
        }
        boolean isDebit = true;
        if (entry != null && entry.size() > 0) {
            for (int i = 0; i < entry.size(); ++i) {
                boolean isExistDefineRate;
                curValue = null;
                entryInfo = entry.get(i);
                entryInfo.setId(null);
                if (entryInfo.getDebit() != null && entryInfo.getDebit().compareTo(new BigDecimal("0")) != 0) {
                    curValue = entryInfo.getDebit();
                    isDebit = true;
                } else if (entryInfo.getCredit() != null && entryInfo.getCredit().compareTo(new BigDecimal("0")) != 0) {
                    curValue = entryInfo.getCredit();
                    isDebit = false;
                }
                int dataElementValue = entryInfo.getDataElement();
                convertMode = this.paramsManager.getConvtModeByItemNum(entryInfo.getItem().getNumber());
                if (this.paramsManager.isDontConvtMode(entryInfo.getItem().getNumber())) continue;
                if (convertMode == null) {
                    throw new ServerException(ServerException.ITEM_NOT_FOUND_CONVERTMODE, new Object[]{entryInfo.getItem().getNumber()});
                }
                if (dataElementValue > 100 && !(isExistDefineRate = ConvtUtil.isExistUserDefinedRate(ctx, curValue, dataElementValue, entryInfo.getItem().getNumber(), info, this.paramsManager)) && (dataElementValue = this.paramsManager.getdataElementByInterSeq(dataElementValue)) == -1) {
                    convertMode = ConvertModeEnum.ENDPERIODEXCHANGERATE;
                    dataElementValue = 4;
                }
                if ((curValue = ConvtUtil.convertValueForAdjustOrElim(ctx, curValue, convertMode, dataElementValue, entryInfo.getItem().getNumber(), info, this.paramsManager)) != null) {
                    curValue = curValue.setScale(currencyScale, 4);
                }
                if (isDebit) {
                    entryInfo.setDebit(curValue);
                    continue;
                }
                entryInfo.setCredit(curValue);
            }
        }
        String id = null;
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sql.append(" select fid from t_csl_elimination where FConvertBeforeId= ?");
        sql.append(" and FCurrencyID = ? ");
        params.add(elimInfo.getId().toString());
        params.add(this.paramsManager.getTargetCurrencyInfo().getId().toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            if (rs.next()) {
                id = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (id != null) {
            ArrayList<String> idList = new ArrayList<String>();
            sql = new StringBuffer();
            sql.append("select fid from t_csl_EliminationEntry where FEliminationID= ? ");
            params.clear();
            params.add(id);
            IRowSet rsDyna = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            if (rsDyna != null && rsDyna.size() > 0) {
                try {
                    while (rsDyna.next()) {
                        idList.add(rsDyna.getString("fid"));
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            sql.delete(0, sql.length());
            if (idList.size() > 0) {
                sql.append("delete from T_CSL_ElimDynaItemEntry where FEliminationEntryID in (");
                for (j = 0; j < idList.size(); ++j) {
                    sql.append("'").append(idList.get(j)).append("'").append(",");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(")");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            sql = new StringBuffer();
            sql.append("delete from t_csl_EliminationEntry where FEliminationID= ? ");
            params.clear();
            params.add(id);
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            sql = new StringBuffer();
            sql.append("delete from t_csl_elimination where fid= ? ");
            params.clear();
            params.add(id);
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        }
        if (!this.paramsManager.hasCodeRule()) {
            elimInfo.setNumber("convert_" + this.paramsManager.getTargetCurrencyInfo().getNumber() + "_" + elimInfo.getNumber());
        } else {
            elimInfo.setNumber(null);
        }
        elimInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        elimInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        elimInfo.setCurrency(this.paramsManager.getTargetCurrencyInfo());
        elimInfo.setConvertBefore(elimInfo.getId().toString());
        elimInfo.setSourceElimination(null);
        elimInfo.setId(null);
        IObjectPK pk = EliminationFactory.getLocalInstance(ctx).submit((CoreBaseInfo)elimInfo);
        EliminationEntryCollection entries = elimInfo.getEntries();
        for (j = 0; j < entries.size(); ++j) {
            EliminationEntryInfo entryInfo1 = entries.get(j);
            if (!this.paramsManager.hasDispensedConvtMode(entryInfo1.getItem().getNumber())) {
                throw new ServerException(ServerException.ITEM_NOT_FOUND_CONVERTMODE, new Object[]{entryInfo1.getItem().getNumber()});
            }
            convertMode = this.paramsManager.getConvtModeByItemNum(entryInfo1.getItem().getNumber());
            this.convtDynaLinkElim(ctx, convertMode, entryInfo1.getDataElement(), elimInfo, entryInfo1);
        }
        return pk.toString();
    }

    @Override
    public IObjectCollection getBizCollectionByIdList(Context ctx, List idList) throws BOSException, EASBizException {
        EliminationCollection col = null;
        if (idList != null && idList.size() > 0) {
            StringBuffer strFilterMask = new StringBuffer();
            IElimination iElim = EliminationFactory.getLocalInstance(ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            for (int i = 0; i < idList.size(); ++i) {
                filter.getFilterItems().add(new FilterItemInfo("id", idList.get(i)));
                if (strFilterMask.length() > 0) {
                    strFilterMask.append(" or ");
                }
                strFilterMask.append("#" + i);
            }
            filter.setMaskString(strFilterMask.toString());
            view.setFilter(filter);
            view.getSelector().addObjectCollection((IObjectCollection)this.getElimSelector());
            col = iElim.getEliminationCollection(view);
        }
        if (col == null || col.size() <= 0) {
            throw new ServerException(ServerException.NOT_FOUND_CONVERT_ELIMINATION);
        }
        return col;
    }

    private void convtDynaLinkElim(Context ctx, ConvertModeEnum convertMode, int dataElementValue, EliminationInfo elimInfo, EliminationEntryInfo entryInfo) throws BOSException, EASBizException {
        String oldEntryId = null;
        int seq = entryInfo.getSeq();
        String oldElimId = elimInfo.getConvertBefore();
        IElimination iElim = EliminationFactory.getLocalInstance(ctx);
        EliminationInfo oldElimInfo = iElim.getEliminationInfo("select * where id='" + oldElimId + "'");
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_csl_EliminationEntry where FEliminationID = ").append("'").append(oldElimId).append("'");
        sql.append(" and fseq = ").append(seq);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs != null && rs.next()) {
                oldEntryId = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        IElimDynaItemEntry iDynaItem = ElimDynaItemEntryFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("eliminationEntry.id", (Object)oldEntryId, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("eliminationEntry.*"));
        view.getSelector().add(new SelectorItemInfo("rptItem.*"));
        view.setFilter(filter);
        ElimDynaItemEntryCollection col = iDynaItem.getElimDynaItemEntryCollection(view);
        BigDecimal curValue = null;
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                ElimDynaItemEntryInfo info = col.get(i);
                curValue = info.getValue();
                if (!this.paramsManager.isDontConvtMode(info.getRptItem().getNumber()) && curValue != null) {
                    curValue = ConvtUtil.convertValueForAdjustOrElim(ctx, curValue, convertMode, dataElementValue, info.getRptItem().getNumber(), (IObjectValue)oldElimInfo, this.paramsManager);
                }
                if (curValue == null) continue;
                info.setValue(curValue);
                info.setEliminationEntry(entryInfo);
                info.setSeq(entryInfo.getSeq());
                info.setId(null);
                iDynaItem.submit((CoreBaseInfo)info);
            }
        }
    }

    @Override
    public String getExceptionReport(IObjectValue info, Exception e) {
        EliminationInfo elimInfo = (EliminationInfo)info;
        StringBuffer error = new StringBuffer(100);
        Locale locale = ContextUtils.getOriginalLocaleFromEnv();
        error.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"828_Msg_Cyconvt_Company", (Locale)locale)).append(elimInfo.getOrgUnit().getName());
        error.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"829_Msg_Cyconvt_EntityName", (Locale)locale)).append(elimInfo.getNumber());
        error.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"830_Msg_Cyconvt_Currency", (Locale)locale)).append(elimInfo.getSourceCurrency().getName());
        error.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_Cyconvt_Error", (Locale)locale)).append(e.getLocalizedMessage()).append("\n");
        error.append("\n");
        return error.toString();
    }

    private SelectorItemCollection getElimSelector() {
        SelectorItemCollection cl = new SelectorItemCollection();
        cl.add(new SelectorItemInfo("*"));
        cl.add(new SelectorItemInfo("entries.*"));
        cl.add(new SelectorItemInfo("entries.item.*"));
        cl.add(new SelectorItemInfo("currency.precision"));
        cl.add(new SelectorItemInfo("currency.name"));
        cl.add(new SelectorItemInfo("currency.number"));
        cl.add(new SelectorItemInfo("sourceCurrency.precision"));
        cl.add(new SelectorItemInfo("sourceCurrency.name"));
        cl.add(new SelectorItemInfo("sourceCurrency.number"));
        cl.add(new SelectorItemInfo("orgBound.number"));
        cl.add(new SelectorItemInfo("orgBound.name"));
        cl.add(new SelectorItemInfo("orgUnit.number"));
        cl.add(new SelectorItemInfo("orgUnit.name"));
        cl.add(new SelectorItemInfo("company.number"));
        cl.add(new SelectorItemInfo("company.name"));
        return cl;
    }
}

