/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.convt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ConvertModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtParamsManager;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public final class ExchangeRateUtil {
    public static BigDecimal getAvgExchgRateByLastPeriod(Context ctx, RptPeriodTypeEnum rptPeriodType, CurrencyInfo sourceCurrency, ConvtParamsManager pm) throws BOSException, EASBizException {
        String key = sourceCurrency.getId().toString() + pm.getEndDate() + pm.getCurConvertMode();
        if (!pm.hasCacheAvgExchgRateByLastPeriod(key)) {
            int[] preYearAndPeriod = null;
            preYearAndPeriod = pm.getPeriod() == 13 && !pm.isMergeByFiscalPeriod() && RptPeriodTypeEnum.MONTHLY.equals((Object)rptPeriodType) && pm.getStartDate().compareTo(pm.getEndDate()) == 0 ? FiscalPeriodHelper.getPrevYearAndPeriod(pm.getFiscalPeriods(), pm.getYear(), 12, rptPeriodType, pm.isMergeByFiscalPeriod(), false) : FiscalPeriodHelper.getPrevYearAndPeriod(pm.getFiscalPeriods(), pm.getYear(), pm.getPeriod(), rptPeriodType, pm.isMergeByFiscalPeriod(), false);
            Date newDate = FiscalPeriodHelper.getPeriodLastDate(pm.getFiscalPeriods(), preYearAndPeriod[0], preYearAndPeriod[1], rptPeriodType, pm.isMergeByFiscalPeriod());
            Date startDate = FiscalPeriodHelper.getPeriodFirstDate(preYearAndPeriod[0], preYearAndPeriod[1], rptPeriodType, pm.getFiscalPeriods(), pm.isMergeByFiscalPeriod());
            Date curStartDate = pm.getStartDate();
            Date curEndDate = pm.getEndDate();
            pm.setStartDate(startDate);
            pm.setEndDate(newDate);
            BigDecimal exchgRate = null;
            boolean isNeedReverse = pm.checkIsChangeSrc2targCurrencyId(sourceCurrency.getId().toString());
            exchgRate = isNeedReverse ? ExchangeRateUtil.getAvgExchangeRate(ctx, pm.getTargetCurrencyInfo(), rptPeriodType, pm.getExchangeTableInfo(), sourceCurrency, newDate, pm) : ExchangeRateUtil.getAvgExchangeRate(ctx, sourceCurrency, rptPeriodType, pm.getExchangeTableInfo(), pm.getTargetCurrencyInfo(), newDate, pm);
            exchgRate = ExchangeRateUtil.handleExchgRate(exchgRate, pm, ServerException.NOT_FOUND_PREVPERIOD_AVG_EXCHGRATE, isNeedReverse);
            pm.setStartDate(curStartDate);
            pm.setEndDate(curEndDate);
            pm.cacheAvgExchgRateByLastPeriod(key, exchgRate);
            return exchgRate;
        }
        return pm.getAvgExchgRateByLastPeriodFromCache(key);
    }

    public static BigDecimal getAvgExchgRateByCurPeriod(Context ctx, RptPeriodTypeEnum rptPeriodType, CurrencyInfo sourceCurrency, ConvtParamsManager pm, ConvertModeEnum convertMode) throws BOSException, EASBizException {
        String key = sourceCurrency.getId().toString() + pm.getEndDate() + pm.getCurConvertMode() + convertMode.getValue();
        if (!pm.hasCacheAvgExchgRateByCurPeriod(key)) {
            BigDecimal exchgRate = null;
            boolean isNeedReverse = pm.checkIsChangeSrc2targCurrencyId(sourceCurrency.getId().toString());
            if (ConvertModeEnum.AVERAGEEXCHANGERATE.equals((Object)convertMode)) {
                exchgRate = isNeedReverse ? ExchangeRateUtil.getAvgExchangeRate(ctx, pm.getTargetCurrencyInfo(), rptPeriodType, pm.getExchangeTableInfo(), sourceCurrency, pm.getEndDate(), pm) : ExchangeRateUtil.getAvgExchangeRate(ctx, sourceCurrency, rptPeriodType, pm.getExchangeTableInfo(), pm.getTargetCurrencyInfo(), pm.getEndDate(), pm);
            } else if (ConvertModeEnum.DAYAVGEXCHANGERATE.equals((Object)convertMode)) {
                exchgRate = isNeedReverse ? ExchangeRateUtil.getDateAvgExchangeRate(ctx, pm.getTargetCurrencyInfo(), rptPeriodType, pm.getExchangeTableInfo(), sourceCurrency, pm.getEndDate(), pm) : ExchangeRateUtil.getDateAvgExchangeRate(ctx, sourceCurrency, rptPeriodType, pm.getExchangeTableInfo(), pm.getTargetCurrencyInfo(), pm.getEndDate(), pm);
            }
            exchgRate = ExchangeRateUtil.handleExchgRate(exchgRate, pm, ServerException.NOT_FOUND_CURPERIOD_AVG_EXCHGRATE, isNeedReverse);
            pm.cacheAvgExchgRateByCurPeriod(key, exchgRate);
            return exchgRate;
        }
        return pm.getAvgExchgRateByCurPeriodFromCache(key);
    }

    public static BigDecimal getAvgExchgRateByYear(Context ctx, RptPeriodTypeEnum periodType, CurrencyInfo sourceCurrency, ConvtParamsManager pm, ConvertModeEnum convertMode) throws BOSException, EASBizException {
        String key = sourceCurrency.getId().toString() + pm.getEndDate() + pm.getCurConvertMode();
        if (!pm.hasCacheAvgExchgRateByYear(key)) {
            BigDecimal exchgRate = null;
            boolean isNeedReverse = pm.checkIsChangeSrc2targCurrencyId(sourceCurrency.getId().toString());
            if (ConvertModeEnum.AVERAGEEXCHANGERATE.equals((Object)convertMode)) {
                exchgRate = isNeedReverse ? ExchangeRateUtil.getYTDAvgExchangeRate(ctx, pm.getTargetCurrencyInfo(), periodType, pm.getExchangeTableInfo(), sourceCurrency, pm.getEndDate(), pm) : ExchangeRateUtil.getYTDAvgExchangeRate(ctx, sourceCurrency, periodType, pm.getExchangeTableInfo(), pm.getTargetCurrencyInfo(), pm.getEndDate(), pm);
            } else if (ConvertModeEnum.DAYAVGEXCHANGERATE.equals((Object)convertMode)) {
                exchgRate = isNeedReverse ? ExchangeRateUtil.getYTDAvgExchangeRateByDay(ctx, pm.getTargetCurrencyInfo(), periodType, pm.getExchangeTableInfo(), sourceCurrency, pm.getEndDate(), pm) : ExchangeRateUtil.getYTDAvgExchangeRateByDay(ctx, sourceCurrency, periodType, pm.getExchangeTableInfo(), pm.getTargetCurrencyInfo(), pm.getEndDate(), pm);
            }
            exchgRate = ExchangeRateUtil.handleExchgRate(exchgRate, pm, ServerException.NOT_FOUND_YEARACCUM_AVG_EXCHGRATE, isNeedReverse);
            pm.cacheAvgExchgRateByYear(key, exchgRate);
            return exchgRate;
        }
        return pm.getAvgExchgRateByYearFromCache(key);
    }

    public static BigDecimal getEndBalanceAvgExchgRateByCurPeriod(Context ctx, RptPeriodTypeEnum rptPeriodType, CurrencyInfo sourceCurrency, ConvtParamsManager pm) throws BOSException, EASBizException {
        String key = sourceCurrency.getId().toString() + pm.getEndDate() + pm.getCurConvertMode();
        if (!pm.hasCacheEndAvgExchgRateByCurPeriod(key)) {
            BigDecimal exchgRate = null;
            boolean isNeedReverse = pm.checkIsChangeSrc2targCurrencyId(sourceCurrency.getId().toString());
            exchgRate = isNeedReverse ? ExchangeRateUtil.getAvgExchangeRate(ctx, pm.getTargetCurrencyInfo(), rptPeriodType, pm.getExchangeTableInfo(), sourceCurrency, pm.getEndDate(), pm) : ExchangeRateUtil.getAvgExchangeRate(ctx, sourceCurrency, rptPeriodType, pm.getExchangeTableInfo(), pm.getTargetCurrencyInfo(), pm.getEndDate(), pm);
            exchgRate = ExchangeRateUtil.handleExchgRate(exchgRate, pm, ServerException.NOT_FOUND_CURPERIOD_AVG_EXCHGRATE, isNeedReverse);
            pm.cacheEndAvgExchgRateByCurPeriod(key, exchgRate);
            return exchgRate;
        }
        return pm.getEndAvgExchgRateByCurPeriodFromCache(key);
    }

    public static BigDecimal getExchgRateByYearFirst(Context ctx, CurrencyInfo sourceCurrency, ConvtParamsManager pm) throws BOSException, EASBizException {
        String key = sourceCurrency.getId().toString() + pm.getEndDate() + pm.getCurConvertMode();
        if (!pm.hasCacheExchgRateByYearFirst(key)) {
            Date newDate = null;
            newDate = FiscalPeriodHelper.getPeriodFirstDate(pm.getYear(), 1, RptPeriodTypeEnum.YEARLY, pm.getFiscalPeriods(), pm.isMergeByFiscalPeriod());
            if (newDate == null) {
                newDate = RPTDateUtil.getYearFirstDayByDate(pm.getEndDate());
            }
            BigDecimal exchgRate = null;
            boolean isNeedReverse = pm.checkIsChangeSrc2targCurrencyId(sourceCurrency.getId().toString());
            exchgRate = isNeedReverse ? ExchangeRateUtil.getExchangeRate(ctx, pm.getExchangeTableInfo().getId().toString(), pm.getTargetCurrencyInfo().getId().toString(), sourceCurrency.getId().toString(), newDate) : ExchangeRateUtil.getExchangeRate(ctx, pm.getExchangeTableInfo().getId().toString(), sourceCurrency.getId().toString(), pm.getTargetCurrencyInfo().getId().toString(), newDate);
            exchgRate = ExchangeRateUtil.handleExchgRate(exchgRate, pm, ServerException.NOT_FOUND_YEARFIRST_AVG_EXCHGRATE, isNeedReverse);
            pm.cacheExchgRateByYearFirst(key, exchgRate);
            return exchgRate;
        }
        return pm.getExchgRateByYearFirstFromCache(key);
    }

    public static BigDecimal getExchgRateByPeriodFirst(Context ctx, RptPeriodTypeEnum periodType, CurrencyInfo sourceCurrency, ConvtParamsManager pm) throws BOSException, EASBizException {
        String key = sourceCurrency.getId().toString() + pm.getEndDate() + pm.getCurConvertMode();
        if (!pm.hasCacheExchgRateByPeriodFirst(key)) {
            int[] year_period = null;
            year_period = pm.getPeriod() == 13 && !pm.isMergeByFiscalPeriod() && RptPeriodTypeEnum.MONTHLY.equals((Object)periodType) && pm.getStartDate().compareTo(pm.getEndDate()) == 0 ? FiscalPeriodHelper.getPrevYearAndPeriod(pm.getFiscalPeriods(), pm.getYear(), 12, periodType, pm.isMergeByFiscalPeriod(), pm.isSupport13Period()) : FiscalPeriodHelper.getPrevYearAndPeriod(pm.getFiscalPeriods(), pm.getYear(), pm.getPeriod(), periodType, pm.isMergeByFiscalPeriod(), pm.isSupport13Period());
            Date newDate = FiscalPeriodHelper.getPeriodLastDate(pm.getFiscalPeriods(), year_period[0], year_period[1], periodType, pm.isMergeByFiscalPeriod());
            BigDecimal exchgRate = null;
            boolean isNeedReverse = pm.checkIsChangeSrc2targCurrencyId(sourceCurrency.getId().toString());
            exchgRate = isNeedReverse ? ExchangeRateUtil.getExchangeRate(ctx, pm.getExchangeTableInfo().getId().toString(), pm.getTargetCurrencyInfo().getId().toString(), sourceCurrency.getId().toString(), newDate) : ExchangeRateUtil.getExchangeRate(ctx, pm.getExchangeTableInfo().getId().toString(), sourceCurrency.getId().toString(), pm.getTargetCurrencyInfo().getId().toString(), newDate);
            exchgRate = ExchangeRateUtil.handleExchgRate(exchgRate, pm, ServerException.NOT_FOUND_YEARFIRST_AVG_EXCHGRATE, isNeedReverse);
            pm.cacheExchgRateByPeriodFirst(key, exchgRate);
            return exchgRate;
        }
        return pm.getExchgRateByPeriodFirstFromCache(key);
    }

    public static BigDecimal getEndExchgRateByCurPeriod(Context ctx, RptPeriodTypeEnum rptPeriodType, CurrencyInfo sourceCurrency, ConvtParamsManager pm) throws BOSException, EASBizException {
        String key = sourceCurrency.getId().toString() + pm.getEndDate() + pm.getCurConvertMode();
        if (!pm.hasCacheEndExchgRateByCurPeriod(key)) {
            BigDecimal exchgRate = null;
            boolean isNeedReverse = pm.checkIsChangeSrc2targCurrencyId(sourceCurrency.getId().toString());
            exchgRate = isNeedReverse ? ExchangeRateUtil.getExchangeRate(ctx, pm.getExchangeTableInfo().getId().toString(), pm.getTargetCurrencyInfo().getId().toString(), sourceCurrency.getId().toString(), pm.getEndDate()) : ExchangeRateUtil.getExchangeRate(ctx, pm.getExchangeTableInfo().getId().toString(), sourceCurrency.getId().toString(), pm.getTargetCurrencyInfo().getId().toString(), pm.getEndDate());
            exchgRate = ExchangeRateUtil.handleExchgRate(exchgRate, pm, ServerException.NOT_FOUND_CURPERIOD_END_EXCHGRATE, isNeedReverse);
            pm.cacheEndExchgRateByCurPeriod(key, exchgRate);
            return exchgRate;
        }
        return pm.getEndExchgRateByCurPeriodFromCache(key);
    }

    public static BigDecimal getYTDAvgExchangeRate(Context ctx, CurrencyInfo sourceCurrency, RptPeriodTypeEnum periodType, ExchangeTableInfo exchgTableInfo, CurrencyInfo targetCurrency, Date curDate, ConvtParamsManager pm) throws EASBizException, BOSException {
        BigDecimal startExchgRate = null;
        BigDecimal endExchgRate = null;
        Date startDate = null;
        Date endDate = null;
        int[] arrYearAndPeriod = FiscalPeriodHelper.getYearAndPeriod(pm.getFiscalPeriods(), curDate, RptPeriodTypeEnum.MONTHLY, pm.isMergeByFiscalPeriod());
        arrYearAndPeriod = new int[]{arrYearAndPeriod[0], 1};
        int[] arrYearAndPeriod2 = pm.isSupport13Period() && periodType == RptPeriodTypeEnum.MONTHLY && pm.getPeriod() == 13 ? new int[]{pm.getYear(), 12} : new int[]{pm.getYear(), pm.getPeriod()};
        startDate = FiscalPeriodHelper.getPeriodFirstDate(arrYearAndPeriod[0], arrYearAndPeriod[1], periodType, pm.getFiscalPeriods(), pm.isMergeByFiscalPeriod());
        startExchgRate = ExchangeRateUtil.getExchangeRate(ctx, exchgTableInfo.getId().toString(), sourceCurrency.getId().toString(), targetCurrency.getId().toString(), startDate);
        startExchgRate = ExchangeRateUtil.handleExchgRate(startExchgRate, pm, ServerException.NOT_FOUND_START_EXCHGRATE, false);
        for (int i = 1; i <= arrYearAndPeriod2[1]; ++i) {
            endDate = FiscalPeriodHelper.getPeriodLastDate(pm.getFiscalPeriods(), arrYearAndPeriod2[0], i, periodType, pm.isMergeByFiscalPeriod());
            endExchgRate = ExchangeRateUtil.getExchangeRate(ctx, exchgTableInfo.getId().toString(), sourceCurrency.getId().toString(), targetCurrency.getId().toString(), endDate);
            endExchgRate = ExchangeRateUtil.handleExchgRate(endExchgRate, pm, ServerException.NOT_FOUND_END_EXCHGRATE, false);
            startExchgRate = ExchangeRateUtil.add(startExchgRate, endExchgRate, pm);
            startDate = endDate;
        }
        return ExchangeRateUtil.divide(startExchgRate, new BigDecimal("" + (arrYearAndPeriod2[1] + 1)), pm);
    }

    public static BigDecimal getDateAvgExchangeRate(Context ctx, CurrencyInfo sourceCurrency, RptPeriodTypeEnum rptPeriodTypeEnum, ExchangeTableInfo exchgTableInfo, CurrencyInfo targetCurrency, Date curDate, ConvtParamsManager pm) throws BOSException, EASBizException {
        BigDecimal startExchgRate = null;
        Date startDate = null;
        Date endDate = null;
        startDate = pm.getPeriod() == 13 && !pm.isMergeByFiscalPeriod() && RptPeriodTypeEnum.MONTHLY.equals((Object)rptPeriodTypeEnum) && pm.getStartDate().compareTo(pm.getEndDate()) == 0 ? FiscalPeriodHelper.getPeriodFirstDate(pm.getYear(), 12, rptPeriodTypeEnum, null, false) : FiscalPeriodHelper.getPeriodFirstDate(pm.getYear(), pm.getPeriod(), rptPeriodTypeEnum, pm.getFiscalPeriods(), pm.isMergeByFiscalPeriod());
        endDate = curDate;
        startExchgRate = ExchangeRateUtil.getExchangeRate(ctx, exchgTableInfo.getId().toString(), sourceCurrency.getId().toString(), targetCurrency.getId().toString(), startDate);
        startExchgRate = ExchangeRateUtil.handleExchgRate(startExchgRate, pm, ServerException.NOT_FOUND_START_EXCHGRATE, false);
        if (rptPeriodTypeEnum.getValue() == 1) {
            return ExchangeRateUtil.getPeriodAvgExchangeRate(ctx, startDate, endDate, (IObjectPK)new ObjectUuidPK(exchgTableInfo.getId().toString()), (IObjectPK)new ObjectUuidPK(sourceCurrency.getId().toString()), (IObjectPK)new ObjectUuidPK(targetCurrency.getId().toString()), 1, pm);
        }
        if (rptPeriodTypeEnum.getValue() == 2 || rptPeriodTypeEnum.getValue() == 3 || rptPeriodTypeEnum.getValue() == 4 || rptPeriodTypeEnum.getValue() == 5 || rptPeriodTypeEnum.getValue() == 6) {
            long Quot = RPTDateUtil.getQuotOfDates(startDate, endDate);
            int days = Integer.parseInt("" + Quot);
            return ExchangeRateUtil.getPeriodAvgExchangeRate(ctx, startDate, endDate, (IObjectPK)new ObjectUuidPK(exchgTableInfo.getId().toString()), (IObjectPK)new ObjectUuidPK(sourceCurrency.getId().toString()), (IObjectPK)new ObjectUuidPK(targetCurrency.getId().toString()), days, pm);
        }
        return null;
    }

    public static BigDecimal getYTDAvgExchangeRateByDay(Context ctx, CurrencyInfo sourceCurrency, RptPeriodTypeEnum periodType, ExchangeTableInfo exchgTableInfo, CurrencyInfo targetCurrency, Date curDate, ConvtParamsManager pm) throws EASBizException, BOSException {
        Date startDate = null;
        Date endDate = null;
        endDate = curDate;
        startDate = FiscalPeriodHelper.getPeriodFirstDate(pm.getYear(), 1, RptPeriodTypeEnum.YEARLY, pm.getFiscalPeriods(), pm.isMergeByFiscalPeriod());
        if (startDate == null) {
            startDate = RPTDateUtil.getYearFirstDayByDate(pm.getEndDate());
        }
        long Quot = RPTDateUtil.getQuotOfDates(startDate, endDate);
        int days = Integer.parseInt("" + Quot);
        return ExchangeRateUtil.getPeriodAvgExchangeRate(ctx, startDate, endDate, (IObjectPK)new ObjectUuidPK(exchgTableInfo.getId().toString()), (IObjectPK)new ObjectUuidPK(sourceCurrency.getId().toString()), (IObjectPK)new ObjectUuidPK(targetCurrency.getId().toString()), days, pm);
    }

    public static BigDecimal getPeriodAvgExchangeRate(Context ctx, Date startDate, Date endDate, IObjectPK exchangeTablePk, IObjectPK sourceCurrencyPk, IObjectPK targetCurrencyPk, int numberDay, ConvtParamsManager pm) throws BOSException, EASBizException {
        return ExchangeRateUtil.getPeriodExchangeRate(ctx, startDate, endDate, exchangeTablePk, sourceCurrencyPk, targetCurrencyPk, numberDay, pm);
    }

    public static BigDecimal getPeriodExchangeRate(Context ctx, Date startDate, Date endDate, IObjectPK exchangeTablePk, IObjectPK sourceCurrencyPk, IObjectPK targetCurrencyPk, int numberDay, ConvtParamsManager pm) throws BOSException, EASBizException {
        IExchangeRate exchgRate = null;
        exchgRate = ctx != null ? ExchangeRateFactory.getLocalInstance((Context)ctx) : ExchangeRateFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.exchangeTable.id", (Object)exchangeTablePk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("availTime", (Object)startDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("availTime", (Object)endDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.sourceCurrency.id", (Object)sourceCurrencyPk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.targetCurrency.id", (Object)targetCurrencyPk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isUsedBG", (Object)"0"));
        filter.setMaskString("#0 and #1  and #2 and #3 and #4 and #5");
        viewInfo.setFilter(filter);
        SorterItemInfo sortItem = new SorterItemInfo("availTime");
        sortItem.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sortItem);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("exchangeAux.*"));
        ExchangeRateCollection vos = exchgRate.getExchangeRateCollection(viewInfo);
        BigDecimal avgRate = BigDecimal.ZERO;
        BigDecimal temp = null;
        Date beginDate = startDate;
        if (vos != null && vos.size() > 0) {
            while (beginDate.compareTo(endDate) <= 0) {
                temp = ExchangeRateUtil.getExchangeRate(ctx, vos, beginDate);
                if (temp == null) {
                    --numberDay;
                    beginDate = ExchangeRateUtil.getNextDate(beginDate);
                    continue;
                }
                avgRate = avgRate.compareTo(BigDecimal.ZERO) == 0 ? temp : ExchangeRateUtil.add(avgRate, temp, pm);
                beginDate = ExchangeRateUtil.getNextDate(beginDate);
            }
            if (numberDay > 0) {
                return ExchangeRateUtil.divide(avgRate, new BigDecimal(numberDay), pm);
            }
        }
        return null;
    }

    private static Date getNextDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(date);
        cal.add(5, 1);
        return cal.getTime();
    }

    private static BigDecimal getExchangeRate(Context ctx, ExchangeRateCollection vos, Date date) {
        if (vos != null && vos.size() > 0) {
            int l = 0;
            int h = vos.size() - 1;
            int mid = (l + h) / 2;
            ExchangeRateInfo info = null;
            BigDecimal returanRate = null;
            while (l <= h) {
                int compare = ExchangeRateUtil.compareDate(date, vos.get(mid).getAvailTime());
                if (compare == 0) {
                    info = vos.get(mid);
                    returanRate = info.getConvertRate().setScale(info.getExchangeAux().getPrecision(), 4);
                    ConvtUtil.setConvtCalcFormula("", returanRate + " = " + ConvtUtil.buildRateDetail(info.getExchangeTable().getId().toString(), info.getSourceCurrency().getId().toString(), info.getTargetCurrency().getId().toString(), info.getAvailTime(), date));
                    return returanRate;
                }
                if (compare > 0) {
                    l = mid + 1;
                } else {
                    h = mid - 1;
                }
                mid = (l + h) / 2;
            }
            if (l <= h) {
                info = vos.get(l);
                returanRate = info.getConvertRate().setScale(info.getExchangeAux().getPrecision(), 4);
                ConvtUtil.setConvtCalcFormula("", returanRate + " = " + ConvtUtil.buildRateDetail(info.getExchangeTable().getId().toString(), info.getSourceCurrency().getId().toString(), info.getTargetCurrency().getId().toString(), info.getAvailTime(), date));
                return returanRate;
            }
        }
        return null;
    }

    private static int compareDate(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        if (c1.get(1) > c2.get(1)) {
            return 1;
        }
        if (c1.get(1) < c2.get(1)) {
            return -1;
        }
        if (c1.get(2) > c2.get(2)) {
            return 1;
        }
        if (c1.get(2) < c2.get(2)) {
            return -1;
        }
        if (c1.get(6) > c2.get(6)) {
            return 1;
        }
        if (c1.get(6) < c2.get(6)) {
            return -1;
        }
        return 0;
    }

    public static BigDecimal getAvgExchangeRate(Context ctx, CurrencyInfo sourceCurrency, RptPeriodTypeEnum rptPeriodTypeEnum, ExchangeTableInfo exchgTableInfo, CurrencyInfo targetCurrency, Date curDate, ConvtParamsManager pm) throws BOSException, EASBizException {
        BigDecimal startExchgRate = null;
        BigDecimal endExchgRate = null;
        Date startDate = null;
        Date endDate = null;
        int[] arrYearAndPeriod = FiscalPeriodHelper.getYearAndPeriod(pm.getFiscalPeriods(), curDate, RptPeriodTypeEnum.MONTHLY, pm.isMergeByFiscalPeriod());
        startDate = pm.getPeriod() == 13 && !pm.isMergeByFiscalPeriod() && RptPeriodTypeEnum.MONTHLY.equals((Object)rptPeriodTypeEnum) && pm.getStartDate().compareTo(pm.getEndDate()) == 0 ? FiscalPeriodHelper.getPeriodFirstDate(pm.getYear(), 12, rptPeriodTypeEnum, null, false) : pm.getStartDate();
        endDate = pm.getEndDate();
        startExchgRate = ExchangeRateUtil.getExchangeRate(ctx, exchgTableInfo.getId().toString(), sourceCurrency.getId().toString(), targetCurrency.getId().toString(), startDate);
        startExchgRate = ExchangeRateUtil.handleExchgRate(startExchgRate, pm, ServerException.NOT_FOUND_START_EXCHGRATE, false);
        if (rptPeriodTypeEnum.getValue() == 1) {
            return ExchangeRateUtil.getExchangeRate(ctx, exchgTableInfo.getId().toString(), sourceCurrency.getId().toString(), targetCurrency.getId().toString(), startDate);
        }
        if (rptPeriodTypeEnum.getValue() == 2) {
            endExchgRate = ExchangeRateUtil.getExchangeRate(ctx, exchgTableInfo.getId().toString(), sourceCurrency.getId().toString(), targetCurrency.getId().toString(), endDate);
            if (startExchgRate.equals(endExchgRate)) {
                return startExchgRate;
            }
            return ExchangeRateUtil.divide(ExchangeRateUtil.add(startExchgRate, endExchgRate, pm), new BigDecimal("2"), pm);
        }
        if (rptPeriodTypeEnum.getValue() == 3) {
            endExchgRate = ExchangeRateUtil.getExchangeRate(ctx, exchgTableInfo.getId().toString(), sourceCurrency.getId().toString(), targetCurrency.getId().toString(), endDate);
            if (startExchgRate.equals(endExchgRate)) {
                return startExchgRate;
            }
            endExchgRate = ExchangeRateUtil.handleExchgRate(endExchgRate, pm, ServerException.NOT_FOUND_END_EXCHGRATE, false);
            return ExchangeRateUtil.divide(ExchangeRateUtil.add(startExchgRate, endExchgRate, pm), new BigDecimal("2"), pm);
        }
        if (rptPeriodTypeEnum.getValue() == 4) {
            List periodList = FiscalPeriodHelper.getPeriodList(pm.getFiscalPeriods(), rptPeriodTypeEnum, arrYearAndPeriod, pm.isMergeByFiscalPeriod());
            for (int i = 0; i < periodList.size(); ++i) {
                int period = (Integer)periodList.get(i);
                endDate = FiscalPeriodHelper.getPeriodLastDate(pm.getFiscalPeriods(), arrYearAndPeriod[0], period, RptPeriodTypeEnum.MONTHLY, pm.isMergeByFiscalPeriod());
                endExchgRate = ExchangeRateUtil.getExchangeRate(ctx, exchgTableInfo.getId().toString(), sourceCurrency.getId().toString(), targetCurrency.getId().toString(), endDate);
                endExchgRate = ExchangeRateUtil.handleExchgRate(endExchgRate, pm, ServerException.NOT_FOUND_END_EXCHGRATE, false);
                startExchgRate = ExchangeRateUtil.add(startExchgRate, endExchgRate, pm);
            }
            return ExchangeRateUtil.divide(startExchgRate, new BigDecimal(String.valueOf(periodList.size() + 1)), pm);
        }
        if (rptPeriodTypeEnum.getValue() == 5) {
            List periodList = FiscalPeriodHelper.getPeriodList(pm.getFiscalPeriods(), rptPeriodTypeEnum, arrYearAndPeriod, pm.isMergeByFiscalPeriod());
            for (int i = 0; i < periodList.size(); ++i) {
                int period = (Integer)periodList.get(i);
                endDate = FiscalPeriodHelper.getPeriodLastDate(pm.getFiscalPeriods(), arrYearAndPeriod[0], period, RptPeriodTypeEnum.MONTHLY, pm.isMergeByFiscalPeriod());
                endExchgRate = ExchangeRateUtil.getExchangeRate(ctx, exchgTableInfo.getId().toString(), sourceCurrency.getId().toString(), targetCurrency.getId().toString(), endDate);
                endExchgRate = ExchangeRateUtil.handleExchgRate(endExchgRate, pm, ServerException.NOT_FOUND_END_EXCHGRATE, false);
                startExchgRate = ExchangeRateUtil.add(startExchgRate, endExchgRate, pm);
                startDate = endDate;
            }
            return ExchangeRateUtil.divide(startExchgRate, new BigDecimal(String.valueOf(periodList.size() + 1)), pm);
        }
        if (rptPeriodTypeEnum.getValue() == 6) {
            List periodList = FiscalPeriodHelper.getPeriodList(pm.getFiscalPeriods(), rptPeriodTypeEnum, arrYearAndPeriod, pm.isMergeByFiscalPeriod());
            for (int i = 0; i < periodList.size(); ++i) {
                int period = (Integer)periodList.get(i);
                endDate = FiscalPeriodHelper.getPeriodLastDate(pm.getFiscalPeriods(), arrYearAndPeriod[0], period, RptPeriodTypeEnum.MONTHLY, pm.isMergeByFiscalPeriod());
                endExchgRate = ExchangeRateUtil.getExchangeRate(ctx, exchgTableInfo.getId().toString(), sourceCurrency.getId().toString(), targetCurrency.getId().toString(), endDate);
                endExchgRate = ExchangeRateUtil.handleExchgRate(endExchgRate, pm, ServerException.NOT_FOUND_END_EXCHGRATE, false);
                startExchgRate = ExchangeRateUtil.add(startExchgRate, endExchgRate, pm);
                startDate = endDate;
            }
            if (startExchgRate != null) {
                return ExchangeRateUtil.divide(startExchgRate, new BigDecimal(String.valueOf(periodList.size() + 1)), pm);
            }
        }
        return null;
    }

    public static BigDecimal getExchangeRate(Context ctx, String exchgTbID, String sourceCurrencyID, String targetCurrencyID, Date curDate) throws BOSException, EASBizException {
        IExchangeRate exchgRate = null;
        exchgRate = ctx != null ? ExchangeRateFactory.getLocalInstance((Context)ctx) : ExchangeRateFactory.getRemoteInstance();
        ExchangeRateInfo exchgRateInfo = exchgRate.getExchangeRateConvertInfo((IObjectPK)new ObjectStringPK(exchgTbID), (IObjectPK)new ObjectStringPK(sourceCurrencyID), (IObjectPK)new ObjectStringPK(targetCurrencyID), curDate);
        if (exchgRateInfo != null) {
            BigDecimal bgResult = exchgRateInfo.getConvertRate();
            int iConvertPrecision = exchgRateInfo.getPrecision();
            if (iConvertPrecision <= 0) {
                iConvertPrecision = 2;
            }
            ConvtUtil.setConvtCalcFormula("", bgResult + " = " + ConvtUtil.buildRateDetail(exchgTbID, sourceCurrencyID, targetCurrencyID, exchgRateInfo.getAvailTime(), curDate));
            return bgResult.setScale(iConvertPrecision, 4);
        }
        return null;
    }

    private static BigDecimal handleExchgRate(BigDecimal exchgRate, ConvtParamsManager pm, NumericExceptionSubItem exceptionItem, boolean isNeedReverse) throws ServerException {
        if (exchgRate == null || exchgRate.compareTo(BigDecimal.ZERO) == 0) {
            if (pm.isFromOther()) {
                return BigDecimal.ZERO;
            }
            throw new ServerException(exceptionItem);
        }
        if (pm.isFromOther() && isNeedReverse) {
            BigDecimal b = new BigDecimal("1.0");
            BigDecimal result = b.divide(exchgRate, exchgRate.scale(), 4);
            ExchangeRateUtil.logArithmeticProcess(b, exchgRate, pm, "/", result);
            return result;
        }
        return exchgRate;
    }

    private static BigDecimal add(BigDecimal v1, BigDecimal v2, ConvtParamsManager pm) {
        BigDecimal result = v1.add(v2);
        ExchangeRateUtil.logArithmeticProcess(v1, v2, pm, "+", result);
        return result;
    }

    private static BigDecimal subtract(BigDecimal v1, BigDecimal v2, ConvtParamsManager pm) {
        BigDecimal result = v1.subtract(v2);
        ExchangeRateUtil.logArithmeticProcess(v1, v2, pm, "-", result);
        return result;
    }

    private static BigDecimal multiply(BigDecimal v1, BigDecimal v2, ConvtParamsManager pm) {
        BigDecimal result = v1.multiply(v2);
        ExchangeRateUtil.logArithmeticProcess(v1, v2, pm, "*", result);
        return result;
    }

    private static BigDecimal divide(BigDecimal v1, BigDecimal v2, ConvtParamsManager pm) {
        BigDecimal result = v1.divide(v2, 4);
        ExchangeRateUtil.logArithmeticProcess(v1, v2, pm, "/", result);
        return result;
    }

    private static void logArithmeticProcess(BigDecimal v1, BigDecimal v2, ConvtParamsManager pm, String arithType, BigDecimal result) {
        ConvtUtil.setConvtCalcFormula("", result + "=" + v1 + arithType + v2);
        if (pm != null && pm.isGetReview()) {
            StringBuffer buffer = new StringBuffer();
            String pre = pm.getArithmeticProcess();
            String a1 = v1.toString();
            String a2 = v2.toString();
            if (!StringUtils.isEmpty((String)pre)) {
                a1 = pre;
            }
            buffer.append("(").append(a1).append(arithType).append(a2).append(")");
            pm.setArithmeticProcess(buffer.toString());
        }
    }
}

