/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.convt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.AbstractHistoryRateConv;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtParamsManager;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.HistoryExchRateConvtUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HistoryRateConvDefineRate
extends AbstractHistoryRateConv {
    public String changeDateStr = null;

    public HistoryRateConvDefineRate(int dataElementValue, Context ctx, ConvtParamsManager pm) {
        super(dataElementValue, ctx, pm);
    }

    @Override
    protected BigDecimal caclConvertValueByHistoryAmount(CslReportInfo report, ItemFormula itemFormula, BigDecimal curValue, Map mapInitYearData, OrgTreeInfo orgTreeInfo) throws BOSException, EASBizException {
        return ConvtUtil.convtValueByUserDefinedRate(this.ctx, curValue, this.dataElementValue, itemFormula.getItemNumber(), (IObjectValue)report, this.pm);
    }

    @Override
    protected BigDecimal caclConvertValueByHistoryEndbalance(CslReportInfo report, ItemFormula itemFormula, BigDecimal curValue, Map mapInitYearData, OrgTreeInfo orgTreeInfo) throws BOSException, EASBizException {
        if (curValue == null) {
            return null;
        }
        BigDecimal[] beforeAndAfterCoveInitValue = this.getYearInitItemDataBeforeAndAfterConv(this.ctx, report, itemFormula, mapInitYearData, ConvertStatusEnum.Converted, orgTreeInfo, this.pm);
        BigDecimal bgYearInitConvertedValue = beforeAndAfterCoveInitValue[1];
        BigDecimal tmpValue = curValue;
        curValue = curValue.subtract(beforeAndAfterCoveInitValue[0]);
        ConvtUtil.setConvtCalcFormula("", curValue + "=" + tmpValue + "-" + beforeAndAfterCoveInitValue[0]);
        BigDecimal bgResultValue = ConvtUtil.convtValueByUserDefinedRate(this.ctx, curValue, this.dataElementValue, itemFormula.getItemNumber(), (IObjectValue)report, this.pm);
        if (bgYearInitConvertedValue != null && bgResultValue != null) {
            ConvtUtil.setConvtCalcFormula(String.valueOf(bgYearInitConvertedValue), null, "+");
            return bgYearInitConvertedValue.add(bgResultValue);
        }
        if (bgYearInitConvertedValue == null) {
            return bgResultValue;
        }
        return null;
    }

    @Override
    protected BigDecimal caclConvertValueByHistoryYTDAmount(CslReportInfo report, ItemFormula itemFormula, BigDecimal curValue, Map mapInitYearData, OrgTreeInfo orgTreeInfo) throws BOSException, EASBizException {
        return ConvtUtil.convtValueByUserDefinedRate(this.ctx, curValue, this.dataElementValue, itemFormula.getItemNumber(), (IObjectValue)report, this.pm);
    }

    private BigDecimal[] getYearInitItemDataBeforeAndAfterConv(Context ctx, CslReportInfo report, ItemFormula itemFormula, Map mapInitYearData, ConvertStatusEnum convertStatus, OrgTreeInfo orgTreeInfo, ConvtParamsManager pm) throws BOSException, EASBizException {
        BigDecimal afterCoveInitValue = HistoryExchRateConvtUtil.getOnlyYearInitItemData(ctx, report, itemFormula, convertStatus, orgTreeInfo, pm);
        BigDecimal beforeCoveInitValue = HistoryExchRateConvtUtil.getOnlyYearInitItemData(ctx, report, itemFormula, ConvertStatusEnum.BeforeConvert, orgTreeInfo, pm);
        BigDecimal[] beforAndAfterCoveValue = null;
        if (afterCoveInitValue == null || afterCoveInitValue.compareTo(SysConstant.BIGZERO) == 0 || beforeCoveInitValue == null || beforeCoveInitValue.compareTo(SysConstant.BIGZERO) == 0) {
            beforAndAfterCoveValue = this.getYearInitItemData_from_HisExchgRateForDefine(ctx, report, itemFormula, convertStatus, orgTreeInfo, pm, true);
        }
        if (beforAndAfterCoveValue != null && beforAndAfterCoveValue.length > 1) {
            if (afterCoveInitValue == null || afterCoveInitValue.compareTo(SysConstant.BIGZERO) == 0) {
                afterCoveInitValue = beforAndAfterCoveValue[1];
            }
            if (beforeCoveInitValue == null || beforeCoveInitValue.compareTo(SysConstant.BIGZERO) == 0) {
                beforeCoveInitValue = beforAndAfterCoveValue[0];
            }
        }
        return new BigDecimal[]{beforeCoveInitValue, afterCoveInitValue};
    }

    private BigDecimal[] getYearInitItemData_from_HisExchgRateForDefine(Context ctx, CslReportInfo report, ItemFormula itemFormula, ConvertStatusEnum convertStatus, OrgTreeInfo orgTreeInfo, ConvtParamsManager pm, boolean isByHisRate) throws BOSException, EASBizException {
        BigDecimal convAfterInitData = null;
        BigDecimal convbeforeInitData = null;
        IRowSet rowSet = this.getHisExchgRateRowSet(ctx, report, itemFormula, orgTreeInfo, pm);
        try {
            while (rowSet.next()) {
                convAfterInitData = rowSet.getBigDecimal("FPromAmount");
                convbeforeInitData = rowSet.getBigDecimal("FChangeAmount");
                ConvtUtil.setConvtCalcFormula(null, ConvtUtil.buildHisRateDetail(String.valueOf(convAfterInitData), this.changeDateStr, false));
                ConvtUtil.setConvtCalcFormula(null, ConvtUtil.buildHisRateDetail(String.valueOf(convbeforeInitData), this.changeDateStr, true));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (convAfterInitData == null) {
            convAfterInitData = SysConstant.BIGZERO;
        }
        if (convbeforeInitData == null) {
            convbeforeInitData = SysConstant.BIGZERO;
        }
        return new BigDecimal[]{convbeforeInitData, convAfterInitData};
    }

    @Override
    protected String getHisExchgRateSQLOrder() {
        return "  group by RptItem.FNumber ";
    }

    @Override
    protected String getHisExchgRateSQLSelect() {
        StringBuffer strSql = new StringBuffer();
        strSql.append("select  RptItem.FNumber as itemNumber,");
        strSql.append("sum(ItemHisExchgRate.FChangeAmount) as FChangeAmount,");
        strSql.append("sum(ItemHisExchgPromRate.FAmount) as FPromAmount ");
        return strSql.toString();
    }

    @Override
    protected String getOrgUnitBoundFilterSql(String treeId, String unitId, List params, CslReportInfo report, ItemFormula itemFormula) throws BOSException {
        if (this.dataElementValue != 4) {
            return super.getOrgUnitBoundFilterSql(treeId, unitId, params, report, itemFormula);
        }
        java.util.Date chgDate = FiscalPeriodHelper.getBeginOfYear(this.pm.getFiscalPeriods(), itemFormula.getYear(), report.getPeriodType(), this.pm.isMergeByFiscalPeriod());
        String[] idStr = this.getIDStrOfTreeAndUnit(treeId, unitId, chgDate);
        if (idStr == null) {
            return super.getOrgUnitBoundFilterSql(treeId, unitId, params, report, itemFormula);
        }
        StringBuffer strSql = new StringBuffer();
        strSql.append("and ItemHisExchgRate.FOrgBoundID in ").append(idStr[0]);
        strSql.append("and ItemHisExchgRate.FOrgBoundGrpID in ").append(idStr[1]);
        strSql.append(" and ItemHisExchgRate.FBoundType = ?");
        params.add(new Integer(1));
        return strSql.toString();
    }

    private String[] getIDStrOfTreeAndUnit(String treeId, String unitId, java.util.Date date) throws BOSException {
        StringBuffer sql = new StringBuffer();
        try {
            sql.append(" select distinct fid from t_org_tree where ((fstatus =2 and fenddate <= ?) or ").append(" (fstatus =2 and fstartDate <= ? and fendDate >= ? ) or").append(" (fstatus =1 and fenddate is null and fstartdate <= ?)) ").append(" and fnumber=(select fnumber from t_org_tree where fid = ?) and ftype = 8 ");
            Date date1 = new Date(date.getTime());
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{date1, date1, date1, date1, treeId});
            if (rowSet == null || rowSet.size() <= 0) {
                return null;
            }
            String[] idStr = new String[2];
            ArrayList<String> ids = new ArrayList<String>();
            while (rowSet.next()) {
                ids.add(rowSet.getString("fid"));
            }
            idStr[0] = "(" + CslRptUtil.changeIdList2String(ids) + ")";
            sql.setLength(0);
            ids.clear();
            sql.append(" select distinct unit.fid fid from t_org_tree tree ").append(" join t_org_structure s on tree.fid = s.ftreeid \n").append(" join t_org_baseunit unit on unit.fid = s.funitid \n").append(" where tree.fid in ").append(idStr[0]).append(" and unit.fnumber = (select fnumber from t_org_baseunit where fid = ?)");
            rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{unitId});
            while (rowSet.next()) {
                ids.add(rowSet.getString("fid"));
            }
            idStr[1] = "(" + CslRptUtil.changeIdList2String(ids) + ")";
            return idStr;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String getHisExchgRateSQLWhere(CslReportInfo report, ItemFormula itemFormula) {
        if (this.dataElementValue == 4) {
            java.util.Date chgDate = FiscalPeriodHelper.getBeginOfYear(this.pm.getFiscalPeriods(), itemFormula.getYear(), report.getPeriodType(), this.pm.isMergeByFiscalPeriod());
            String dateStr = " and ItemHisExchgRate.FChangeDate < ";
            dateStr = dateStr + CslRptUtil.formatDateForSql(chgDate);
            if (ConvtUtil.isLogConvtFormula) {
                this.changeDateStr = "<" + ConvtUtil.sdf.format(chgDate);
            }
            return dateStr;
        }
        if (this.dataElementValue == 2) {
            java.util.Date periodFirstDate = FiscalPeriodHelper.getPeriodFirstDate(this.pm.getYear(), this.pm.getPeriod(), report.getPeriodType(), this.pm.getFiscalPeriods(), this.pm.isMergeByFiscalPeriod());
            String dateStr = " and ItemHisExchgRate.FChangeDate >= ";
            dateStr = dateStr + CslRptUtil.formatDateForSql(periodFirstDate);
            java.util.Date periodLastDate = FiscalPeriodHelper.getPeriodLastDate(this.pm.getFiscalPeriods(), this.pm.getYear(), this.pm.getPeriod(), report.getPeriodType(), this.pm.isMergeByFiscalPeriod());
            dateStr = dateStr + " and ItemHisExchgRate.FChangeDate <= " + CslRptUtil.formatDateForSql(periodLastDate);
            if (ConvtUtil.isLogConvtFormula) {
                this.changeDateStr = ">=" + ConvtUtil.sdf.format(periodFirstDate) + " <=" + ConvtUtil.sdf.format(periodLastDate);
            }
            return dateStr;
        }
        if (this.dataElementValue == 3) {
            java.util.Date beginOfYearDate = FiscalPeriodHelper.getBeginOfYear(this.pm.getFiscalPeriods(), this.pm.getYear(), report.getPeriodType(), this.pm.isMergeByFiscalPeriod());
            String dateStr = " and ItemHisExchgRate.FChangeDate >= ";
            dateStr = dateStr + CslRptUtil.formatDateForSql(beginOfYearDate);
            java.util.Date endOfYearDate = FiscalPeriodHelper.getPeriodLastDate(this.pm.getFiscalPeriods(), this.pm.getYear(), this.pm.getPeriod(), report.getPeriodType(), this.pm.isMergeByFiscalPeriod());
            dateStr = dateStr + " and ItemHisExchgRate.FChangeDate <= " + CslRptUtil.formatDateForSql(endOfYearDate);
            if (ConvtUtil.isLogConvtFormula) {
                this.changeDateStr = ">=" + ConvtUtil.sdf.format(beginOfYearDate) + " <=" + ConvtUtil.sdf.format(endOfYearDate);
            }
            return dateStr;
        }
        return "";
    }

    @Override
    protected BigDecimal caclConvertValueByHistoryOtherType(CslReportInfo report, ItemFormula itemFormula, BigDecimal curValue, Map mapInitYearData, OrgTreeInfo orgTreeInfo) throws BOSException, EASBizException {
        return HistoryExchRateConvtUtil.getConvertValueByHisRate(this.ctx, report, itemFormula, this.dataElementValue, orgTreeInfo, this.pm);
    }
}

