/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.innertrade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CheckageConfirmEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.InterCheckControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class InterExchReportChecker {
    private Context ctx;
    private final List<String> checkIDs;
    private List<String> unPassIDs;
    private List<Map<String, Object>> checkResult;
    private List<CheckageConfirmEnum> checkageConfirms;

    public InterExchReportChecker(Context ctx, List<String> checkIDs) {
        this.ctx = ctx;
        this.checkIDs = checkIDs;
        this.unPassIDs = new ArrayList<String>();
        this.checkResult = new ArrayList<Map<String, Object>>();
    }

    public InterExchReportChecker(Context ctx, List<String> checkIDs, List<CheckageConfirmEnum> checkageConfirms) {
        this.ctx = ctx;
        this.checkIDs = checkIDs;
        this.unPassIDs = new ArrayList<String>();
        this.checkResult = new ArrayList<Map<String, Object>>();
        this.checkageConfirms = checkageConfirms;
    }

    public void checkRule() throws BOSException, EASBizException {
        if (!CSLParamUtil.isCheckInterExchRptIsCheckage(this.ctx) || CSLParamUtil.isCheckedInterExchRptByReceived(this.ctx) || this.checkIDs == null || this.checkIDs.size() <= 0) {
            return;
        }
        List<String> ids = this.collectInterExchRptIDs();
        if (ids.size() <= 0) {
            return;
        }
        if (this.checkageConfirms != null && !this.checkageConfirms.isEmpty()) {
            this.checkRecIsUnConfirmStateForState(ids);
        } else {
            this.checkRecIsUnConfirmState(ids);
        }
    }

    public List<String> getUnPassIDs() {
        return this.unPassIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRecIsUnConfirmState(List<String> ids) throws BOSException, EASBizException {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" SELECT rptId,max(isUnCheck) isUnCheck,max(isUpdate) isUpdate,max(isUnConfirm) isUnConfirm,max(isTimeUpdate) isTimeUpdate FROM ( \n");
        this.getUnConfirmRecSQL(ids, sql, new InterCheckControllerBean.CommonTable(ElimTypeEnum.ComeAndGo), true);
        sql.append(" UNION \n");
        this.getUnConfirmRecSQL(ids, sql, new InterCheckControllerBean.CommonTable(ElimTypeEnum.exchange), false);
        sql.append(") t group by rptId ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        MessageManager msgMg = new MessageManager();
        try {
            int isTimeUpdate = 0;
            int isUpdate = 0;
            int isUnConfirm = 0;
            int isUnCheck = 0;
            HashSet<String> checkCheckIds = new HashSet<String>();
            HashSet<String> checkUpdateIds = new HashSet<String>();
            while (rs.next()) {
                String rptID = rs.getString("rptId");
                isTimeUpdate = rs.getInt("isTimeUpdate");
                isUpdate = rs.getInt("isUpdate");
                isUnConfirm = rs.getInt("isUnConfirm");
                isUnCheck = rs.getInt("isUnCheck");
                if (isUnCheck == 1) {
                    checkCheckIds.add(rptID);
                    continue;
                }
                if (isUpdate == 1) {
                    msgMg.put(rptID, isUnCheck == 1, 1, isUnConfirm == 1);
                } else if (isTimeUpdate == 1) {
                    if (isUnConfirm == 1) {
                        msgMg.put(rptID, isUnCheck == 1, isUpdate, isUnConfirm == 1);
                        continue;
                    }
                    checkUpdateIds.add(rptID);
                    continue;
                }
                msgMg.put(rptID, isUnCheck == 1, isUpdate, isUnConfirm == 1);
            }
            if (!checkCheckIds.isEmpty()) {
                sql.reset();
                this.getUnCheckSQL(checkCheckIds, sql, true);
                sql.append(" union ");
                this.getUnCheckSQL(checkCheckIds, sql, false);
                rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                while (rs.next()) {
                    msgMg.put(rs.getString("rptId"), true, 0, false);
                }
            }
            if (!checkUpdateIds.isEmpty()) {
                sql.reset();
                String elimTemplateTmpTbl = null;
                try {
                    elimTemplateTmpTbl = this.getRptElimTemplateTmpTbl(checkUpdateIds);
                    this.getDataChangedSQL(checkUpdateIds, new InterCheckControllerBean.CommonTable(ElimTypeEnum.ComeAndGo), sql, elimTemplateTmpTbl);
                    sql.append(" union ");
                    this.getDataChangedSQL(checkUpdateIds, new InterCheckControllerBean.CommonTable(ElimTypeEnum.exchange), sql, elimTemplateTmpTbl);
                    rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                    while (rs.next()) {
                        msgMg.put(rs.getString("rptId"), false, 1, false);
                    }
                }
                finally {
                    if (elimTemplateTmpTbl != null && !DebugLogger.isDebug) {
                        TempTablePool.getInstance((Context)this.ctx).releaseTable(elimTemplateTmpTbl);
                    }
                }
            }
            msgMg.makeResult();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void getDataChangedSQL(Set<String> checkUpdateIds, InterCheckControllerBean.CommonTable comm, SQLBuilder sql, String elimTemplateTmpTbl) {
        sql.append(" select distinct rpt.fid rptId  ");
        sql.append(" From ").append(comm.getMasterTable()).append(" m   \n");
        sql.append(" JOIN ").append(comm.getEntryTable()).append(" e ON m.fid=e.fcheckageid \r\n");
        sql.append(" JOIN T_CSL_RptItem item ON item.FID = e.FItemID \n");
        sql.append(" JOIN t_csl_cslreport rpt on rpt.FPeriodType=m.FPeriodType and rpt.FYear=m.FYear and rpt.FPeriod = m.FPeriod ");
        sql.append(" \tand rpt.forgUnitId = e.fcompanyId and rpt.FcurrencyID = m.FcurrencyID ");
        sql.append(" JOIN t_rpt_template tmp on tmp.fid=rpt.ftemplateid ");
        sql.append(" JOIN t_csl_templetitemlist tmpList on (tmpList.ftemplateid=tmp.fid or tmpList.ftemplateid=tmp.fgrouptemplateid) ");
        sql.append(" and tmpList.fitemNumber=item.FNumber and e.FDataElement=tmpList.fdataElement ");
        sql.append(" left join ").append(comm.getItemDataTable()).append(" rptData on rptData.FReport in ", checkUpdateIds);
        sql.append("   AND rptData.FItemNumber = item.FNumber and rptData.FtargetCompanyID = e.FtargetCompanyID \n");
        sql.append("   AND rptData.FCompanyID = e.FCompanyID AND rptData.FcurrencyID = m.FcurrencyID \n");
        sql.append("   AND rptData.FYear = m.FYear AND rptData.FPeriod = m.FPeriod \n");
        sql.append("   AND rptData.FPeriodType = m.FPeriodType AND rptData.FDataElement = e.FDataElement \n");
        sql.append(" WHERE rpt.fid IN", checkUpdateIds).append(" \n");
        sql.append(" AND rptData.fid is null ");
        sql.append(" and (e.Fdebit<>0 or e.Fcredit<>0) \n");
        sql.append(" union \n");
        sql.append(" select distinct rptData.FReport rptId  ");
        sql.append(" From ").append(comm.getItemDataTable()).append(" rptData  \n");
        sql.append(" inner join t_csl_rptitem item on item.fnumber=rptdata.fitemnumber \n");
        sql.append(" inner join t_csl_elimtempletentry elimEn on elimEn.fitemid=item.fid and elimEn.FDataElement=rptData.fdataelement \n");
        sql.append(" inner join t_csl_elimtemplet elim on elim.fid = elimEn.ftempletid and elim.felimtype=?", (Object)comm.getElimTypeValue());
        sql.append(" inner join ").append(elimTemplateTmpTbl).append(" tmpTbl on tmpTbl.elimTmplateId=elim.fid and tmpTbl.frptid=rptData.FReport \n");
        sql.append(" left join (select distinct e.fcompanyid,e.ftargetCompanyid,e.fitemid,e.fdataelement,rpt.fid ");
        sql.append("    from ").append(comm.getEntryTable()).append(" e \n");
        sql.append(" \tjoin ").append(comm.getMasterTable()).append(" m on m.fid=e.fcheckageid \n");
        sql.append(" \tJOIN t_csl_cslreport rpt on rpt.FPeriodType=m.FPeriodType and rpt.FYear=m.FYear and rpt.FPeriod = m.FPeriod ");
        sql.append(" \t\tand rpt.forgUnitId = e.fcompanyId and rpt.FcurrencyID = m.FcurrencyID ");
        sql.append("    WHERE rpt.fid IN", checkUpdateIds).append(" \n");
        sql.append(" \tand (e.Fdebit<>0 or e.Fcredit<>0) \n");
        sql.append("   ) checkData on checkData.fcompanyid=rptData.fcompanyid and checkData.ftargetCompanyid=rptData.ftargetCompanyid and checkData.fid=rptData.FReport ");
        sql.append(" and checkData.fitemid=item.fid and checkData.fdataelement=rptData.fdataelement");
        sql.append(" WHERE rptData.FReport IN", checkUpdateIds).append(" \n");
        sql.append(" AND checkData.fcompanyid is null \n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRptElimTemplateTmpTbl(Set<String> checkUpdateIds) throws Exception {
        TempTablePool tablePool = TempTablePool.getInstance((Context)this.ctx);
        String treeTmpTbl = null;
        try {
            treeTmpTbl = tablePool.createTempTable("create table t_csl_orgTree(frptId varchar(44),ftreeId varchar(44),funitId varchar(44),mergeType int)");
            SQLBuilder sql = new SQLBuilder();
            sql.append(" insert into ").append(treeTmpTbl).append("(frptId,ftreeId,funitId,mergeType)");
            sql.append("  select distinct rpt.fid,rec.forgtreeid,parentStr.Funitid,case when item.fvalue_l2=1 then 1 else 0 end ");
            sql.append("  from t_csl_cslreport rpt ");
            sql.append("  inner join t_csl_rptreceived rec on rpt.fid=rec.freportid ");
            sql.append("  inner join t_org_structure str on str.ftreeid=rec.forgtreeid and str.funitid=rpt.forgunitid ");
            sql.append("  inner join t_org_structure parentStr on str.ftreeid=parentStr.ftreeid and parentStr.fid=str.fparentid ");
            sql.append("   inner join t_bas_paramItem item on item.forgtreeid=rec.forgtreeid ");
            sql.append(" where rpt.fid in ", checkUpdateIds);
            sql.append(" and item.fkeyid in(select fid from t_bas_param where fnumber='GR_CSL_MERGETYPE_004') ");
            DbUtil.execute((Context)this.ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            String elimTemplateTmpTbl = tablePool.createTempTable("create table t_csl_elimTemplate(frptId varchar(44),elimTmplateId varchar(44))");
            sql.reset();
            sql.append(" insert into ").append(elimTemplateTmpTbl).append("(frptId,elimTmplateId)");
            sql.append("  select distinct treeTbl.frptId,elimTmp.fid ");
            sql.append("  from t_csl_elimtemplet elimTmp ");
            sql.append("  inner join T_CSL_TempletDispense disp on disp.fdispensesrcid=elimTmp.felimGroupId ");
            sql.append("  inner join ").append(treeTmpTbl).append(" treeTbl on treeTbl.ftreeId=disp.forgBoundID and disp.fsourceType=2");
            sql.append(" and (treeTbl.mergeType=1 and treeTbl.funitId=disp.FCOMPANYID or treeTbl.mergeType<>1)");
            sql.append(" where elimTmp.fCheckedStatus = 2 ");
            DbUtil.execute((Context)this.ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            tablePool.analyzeTable(EJBFactory.getConnection((Context)this.ctx), elimTemplateTmpTbl);
            String string = elimTemplateTmpTbl;
            return string;
        }
        finally {
            if (treeTmpTbl != null && !DebugLogger.isDebug) {
                tablePool.releaseTable(treeTmpTbl);
            }
        }
    }

    private void getUnCheckSQL(Set<String> checkCheckIds, SQLBuilder sql, boolean isInter) {
        sql.append(" select distinct report.fid rptId ").append(" from T_CSL_CslReport report  \n").append(" JOIN T_RPT_RptSheetPara param ON param.FReportID = report.FID \n").append(" left join T_Csl_InterExchCheckLog log ON log.FOrgUnitId = report.forgunitid \n").append(" and log.fperiodtype=report.fperiodtype and log.fyear=report.fyear and log.fperiod=report.fperiod \n").append(" and log.fcreatetime>=report.flastUpdateTime and FElimType=").append((Object)(isInter ? 1 : 2)).append(" WHERE report.FID IN", checkCheckIds).append(" \n").append(" and log.fid is null and param.FReportClass=").append((Object)(isInter ? 10 : 20));
    }

    private void checkRecIsUnConfirmStateForState(List<String> ids) throws BOSException, EASBizException {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" SELECT * FROM ( \n");
        this.getUnConfirmRecSQLForState(ids, sql, new InterCheckControllerBean.CommonTable(ElimTypeEnum.ComeAndGo), true);
        sql.append(" UNION ALL \n");
        this.getUnConfirmRecSQLForState(ids, sql, new InterCheckControllerBean.CommonTable(ElimTypeEnum.exchange), false);
        sql.append(" UNION ALL \n");
        this.getDynaUnConfirmRecSQLForState(ids, sql, new InterCheckControllerBean.CommonTable(ElimTypeEnum.exchange), false);
        sql.append(") t order by FRptID ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        MessageManager msgMg = new MessageManager();
        try {
            while (rs.next()) {
                String rptID = rs.getString("FRptID");
                String treeName = rs.getString("treeName");
                String orgunitName = rs.getString("orgunitName");
                msgMg.put(rptID, treeName, orgunitName);
            }
            msgMg.makeResult();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void getDynaUnConfirmRecSQLForState(List<String> ids, SQLBuilder sql, InterCheckControllerBean.CommonTable comm, boolean isInter) {
        String lang = this.ctx.getLocale().toString();
        sql.append(" SELECT tree.FName_").append(lang).append(" treeName,company.FName_").append(lang).append(" companyName,\n").append(" target.FName_").append(lang).append(" targName, \n").append(" orgunit.FNAME_").append(lang).append(" orgunitName,\n").append(" itemData.FRptID \n").append(" FROM ").append(comm.getMasterTable()).append(" mast \n").append(" JOIN ").append(comm.getEntryTable()).append(" entry \n").append(" ON mast.FID = entry.FCheckageID \n").append(" JOIN T_ORG_Tree tree ON tree.FID = mast.FOrgBoundID \n").append(" JOIN T_ORG_BaseUnit orgunit ON orgunit.FID = mast.FORGUNITID \n").append(" JOIN T_ORG_BaseUnit company ON company.FID = entry.FCompanyID \n").append(" JOIN T_ORG_BaseUnit target ON target.FID = entry.FTargetCompanyID \n").append(" JOIN T_CSL_DataElement dataElement ON dataElement.FInterSeq = entry.FDataElement \n").append(" JOIN T_CSL_RptItem item ON item.FID = entry.FItemID \n").append(" JOIN ( \n").append(" SELECT item.FID FItemID,entry.FDataElement,entry.FCompanyID,entry.FTargetCompanyID, \n").append(" entry.FYear,entry.FPeriod,entry.FPeriodType,entry.FCurrencyID,report.FID FRptID \n").append(" FROM ").append(comm.getItemDataTable()).append(" entry \n").append(" JOIN T_CSL_CslReport report ON report.FID = entry.FReport \n").append(" JOIN T_RPT_RptSheetPara param ON param.FReportID = report.FID \n").append(" JOIN T_CSL_RptItem item ON item.FNumber = entry.FItemNumber \n").append(" WHERE report.FID IN", ids).append(" \n").append(" AND FReportClass = ? ", (Object)(isInter ? 10 : 20)).append(" ) itemData ON itemData.FItemID = entry.FItemID \n").append(" AND itemData.FDataElement = entry.FDataElement \n").append(" AND itemData.FCompanyID = entry.FCompanyID \n").append(" AND itemData.FTargetCompanyID = entry.FTargetCompanyID \n").append(" AND itemData.FYear = mast.FYear \n").append(" AND itemData.FPeriod = mast.FPeriod \n").append(" AND itemData.FPeriodType = mast.FPeriodType \n").append(" AND itemData.FCurrencyID = mast.FCurrencyID \n");
        if (this.checkageConfirms != null) {
            sql.append(" AND mast.FCheckedStatus in ( ");
            for (int i = 0; i < this.checkageConfirms.size(); ++i) {
                sql.append((Object)this.checkageConfirms.get(i).getValue());
                if (i == this.checkageConfirms.size() - 1) continue;
                sql.append(",");
            }
            sql.append(" ) ");
        } else {
            sql.append(" AND mast.FCheckedStatus <> 2 ");
        }
    }

    private void getUnConfirmRecSQLForState(List<String> ids, SQLBuilder sql, InterCheckControllerBean.CommonTable comm, boolean isInter) {
        String lang = this.ctx.getLocale().toString();
        sql.append(" SELECT tree.FName_").append(lang).append(" treeName,company.FName_").append(lang).append(" companyName,\n").append(" target.FName_").append(lang).append(" targName, \n").append(" orgunit.FNAME_").append(lang).append(" orgunitName,\n").append(" itemData.FRptID \n").append(" FROM ").append(comm.getMasterTable()).append(" mast \n").append(" JOIN ").append(comm.getEntryTable()).append(" entry \n").append(" ON mast.FID = entry.FCheckageID \n").append(" JOIN T_ORG_Tree tree ON tree.FID = mast.FOrgBoundID \n").append(" JOIN T_ORG_BaseUnit orgunit ON orgunit.FID = mast.FORGUNITID \n").append(" JOIN T_ORG_BaseUnit company ON company.FID = entry.FCompanyID \n").append(" JOIN T_ORG_BaseUnit target ON target.FID = entry.FTargetCompanyID \n").append(" JOIN T_CSL_DataElement dataElement ON dataElement.FInterSeq = entry.FDataElement \n").append(" JOIN T_CSL_RptItem item ON item.FID = entry.FItemID \n").append(" JOIN ( \n").append(" SELECT item.FID FItemID,entry.FDataElement,entry.FCompanyID,entry.FTargetCompanyID, \n").append(" entry.FYear,entry.FPeriod,entry.FPeriodType,entry.FCurrencyID,report.FID FRptID \n").append(" FROM ").append(comm.getItemDataTable()).append(" entry \n").append(" JOIN T_CSL_CslReport report ON report.FID = entry.FReport \n").append(" JOIN T_RPT_RptSheetPara param ON param.FReportID = report.FID \n").append(" JOIN T_CSL_RptItem item ON item.FNumber = entry.FItemNumber \n").append(" WHERE report.FID IN", ids).append(" \n").append(" AND FReportClass = ? ", (Object)(isInter ? 10 : 20)).append(" ) itemData ON itemData.FItemID = entry.FItemID \n").append(" AND itemData.FDataElement = entry.FDataElement \n").append(" AND itemData.FCompanyID = entry.FCompanyID \n").append(" AND itemData.FTargetCompanyID = entry.FTargetCompanyID \n").append(" AND itemData.FYear = mast.FYear \n").append(" AND itemData.FPeriod = mast.FPeriod \n").append(" AND itemData.FPeriodType = mast.FPeriodType \n").append(" AND itemData.FCurrencyID = mast.FCurrencyID \n");
        if (this.checkageConfirms != null) {
            sql.append(" AND mast.FCheckedStatus in ( ");
            for (int i = 0; i < this.checkageConfirms.size(); ++i) {
                sql.append((Object)this.checkageConfirms.get(i).getValue());
                if (i == this.checkageConfirms.size() - 1) continue;
                sql.append(",");
            }
            sql.append(" ) ");
        } else {
            sql.append(" AND mast.FCheckedStatus <> 2 ");
        }
    }

    private List<String> collectInterExchRptIDs() throws BOSException, EASBizException {
        ArrayList<String> ids = new ArrayList<String>();
        SQLBuilder builder = this.getInterExchReportSQLBuilder();
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        try {
            while (rs.next()) {
                ids.add(rs.getString("FReportId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ids;
    }

    private SQLBuilder getInterExchReportSQLBuilder() {
        SQLBuilder builder = new SQLBuilder();
        builder.append(" SELECT FReportID FROM T_RPT_RptSheetPara ").append(" WHERE FReportID in", this.checkIDs).append(" AND FReportClass in(10,20)");
        builder.append(" UNION ");
        builder.append(" SELECT FID FROM T_CSL_CslReport ").append(" WHERE FID in", this.checkIDs).append(" AND FSourceType =10");
        return builder;
    }

    private void getUnConfirmRecSQL(List<String> ids, SQLBuilder sql, InterCheckControllerBean.CommonTable comm, boolean isInter) {
        String lang = this.ctx.getLocale().toString();
        sql.append(" select report.fid rptId, ").append(" case when checkData.existRptId is null then 1 else 0 end isUnCheck, ").append(" case when checkData.createtime<report.flastupdatetime then 1 else 0 end isTimeUpdate, \n").append(" case when checkData.isValueChanged=1 then 1 else 0 end isUpdate, \n").append(" case when checkedstatus<>2 then 1 else 0 end isUnConfirm ");
        sql.append(" FROM T_CSL_CslReport report  \n");
        sql.append(" left join (");
        sql.append(" select FRptID existRptId ,max(fisValueChanged) isValueChanged,min(fcheckedstatus) checkedstatus,max(fcreateTime) createtime ");
        sql.append(" from (");
        sql.append(" SELECT distinct case when entry.Fmoney <> mentry.Fdebit AND entry.Fmoney <> mentry.Fcredit  then 1 else 0 end fisValueChanged,mast.fcreateTime, \n").append(" report.fid FRptID,mast.FCheckedStatus  ").append(" FROM ").append(comm.getItemDataTable()).append(" entry \n").append(" JOIN T_CSL_CslReport report ON report.FID = entry.FReport \n").append(" JOIN T_RPT_RptSheetPara param ON param.FReportID = report.FID \n").append(" JOIN T_CSL_RptItem item ON item.FNumber = entry.FItemNumber \n").append(" JOIN ").append(comm.getEntryTable()).append(" mentry on mentry.FDataElement=entry.FDataElement ").append("    and mentry.FCompanyID=entry.FCompanyID and mentry.FTargetCompanyID=entry.FTargetCompanyID and mentry.FItemID=item.FID \n").append(" JOIN ").append(comm.getMasterTable()).append(" mast on mast.FID=mentry.FCheckageID ").append("    and entry.FYear = mast.FYear and entry.FPeriod=mast.FPeriod and entry.FPeriodType=mast.FPeriodType").append("    and entry.FCurrencyID = mast.FCurrencyID \n").append(" WHERE report.FID IN", ids).append(" \n").append(" \tAND FReportClass = ? ", (Object)(isInter ? 10 : 20)).append(") group by FRptID ");
        sql.append(" ) checkData on checkData.existRptId=report.fid ");
        sql.append(" WHERE report.FID IN", ids).append(" \n");
        sql.append(" and exists(select 1 from ").append(comm.getItemDataTable()).append(" itemEntry where itemEntry.FReport=report.fid) ");
        sql.append(" and (");
        sql.append(" checkData.existRptId is null ");
        sql.append(" or isValueChanged=1 ");
        sql.append(" or checkData.createtime<report.flastupdatetime ");
        sql.append(" or checkedstatus<>2) ");
    }

    private void getDynaUnConfirmRecSQL(List<String> ids, SQLBuilder sql, InterCheckControllerBean.CommonTable comm, boolean isInter) {
        String lang = this.ctx.getLocale().toString();
        sql.append(" SELECT distinct tree.FName_").append(lang).append(" treeName,").append(" orgunit.FNAME_").append(lang).append(" orgunitName,\n").append(" itemData.FRptID,0 isUnCheck,0 isUpdate\n").append(" FROM ").append(comm.getMasterTable()).append(" mast \n").append(" JOIN ").append(comm.getEntryTable()).append(" entry \n").append(" ON mast.FID = entry.FCheckageID \n").append(" JOIN T_ORG_Tree tree ON tree.FID = mast.FOrgBoundID \n").append(" JOIN T_ORG_BaseUnit orgunit ON orgunit.FID = mast.FORGUNITID \n").append(" JOIN T_ORG_BaseUnit company ON company.FID = entry.FCompanyID \n").append(" JOIN T_ORG_BaseUnit target ON target.FID = entry.FTargetCompanyID \n").append(" JOIN T_CSL_DataElement dataElement ON dataElement.FInterSeq = entry.FDataElement \n").append(" JOIN T_CSL_RptItem item ON item.FID = entry.FItemID \n").append(" JOIN ( \n").append(" SELECT item.FID FItemID,entry.FDataElement,entry.FCompanyID,entry.FTargetCompanyID, \n").append(" entry.FYear,entry.FPeriod,entry.FPeriodType,entry.FCurrencyID,report.FID FRptID \n").append(" FROM ").append(comm.getItemDataTable()).append(" entry \n").append(" JOIN T_CSL_CslReport report ON report.FID = entry.FReport \n").append(" JOIN T_RPT_RptSheetPara param ON param.FReportID = report.FID \n").append(" JOIN T_CSL_RptItem item ON item.FNumber = entry.FItemNumber \n").append(" WHERE report.FID IN", ids).append(" \n").append(" AND FReportClass = ? ", (Object)(isInter ? 10 : 20)).append(" ) itemData ON itemData.FItemID = entry.FItemID \n").append(" AND itemData.FDataElement = entry.FDataElement \n").append(" AND itemData.FCompanyID = entry.FCompanyID \n").append(" AND itemData.FTargetCompanyID = entry.FTargetCompanyID \n").append(" AND itemData.FYear = mast.FYear \n").append(" AND itemData.FPeriod = mast.FPeriod \n").append(" AND itemData.FPeriodType = mast.FPeriodType \n").append(" AND itemData.FCurrencyID = mast.FCurrencyID \n");
        if (this.checkageConfirms != null) {
            sql.append(" AND mast.FCheckedStatus in ( ");
            for (int i = 0; i < this.checkageConfirms.size(); ++i) {
                sql.append((Object)this.checkageConfirms.get(i).getValue());
                if (i == this.checkageConfirms.size() - 1) continue;
                sql.append(",");
            }
            sql.append(" ) ");
        } else {
            sql.append(" AND mast.FCheckedStatus <> 2 ");
        }
    }

    public List<String> removeUnPassIDs() {
        this.checkIDs.removeAll(this.unPassIDs);
        return this.checkIDs;
    }

    public List<Map<String, Object>> mergeCheckResult(List<Map<String, Object>> result) {
        result.addAll(this.checkResult);
        return result;
    }

    public List<Map<String, Object>> getCheckResult() {
        return this.checkResult;
    }

    class IDCounter {
        int count = 0;
        boolean isUnCheck = true;
        boolean isUnConfirm = true;
        String title = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"CantCommitInterExchReport", (Locale)InterExchReportChecker.access$200(InterExchReportChecker.this).getOriginLocale());
        StringBuffer msg = new StringBuffer("<br>" + this.title);
        Map<Integer, Map> msgMap = new HashMap<Integer, Map>();

        public IDCounter(boolean isUnConfirm, boolean isUnCheck) {
            this.isUnCheck = isUnCheck;
            this.isUnConfirm = isUnConfirm;
        }

        public IDCounter() {
            this.isUnCheck = false;
            this.isUnConfirm = false;
        }

        void addOne(String treeName, String companyName, String targName) {
            ++this.count;
            if (this.count <= 3) {
                if (this.msg.length() > 0) {
                    this.msg.append("<br>");
                }
                this.msg.append(treeName).append("  ").append(companyName).append("  ").append(targName);
            }
            if (this.count == 4) {
                this.msg.append("<br>...");
            }
        }

        public void addOne(int isDataUpdate) {
            Map treeMap = this.msgMap.get(isDataUpdate);
            if (treeMap == null) {
                treeMap = new OneToManyMap(2);
                this.msgMap.put(isDataUpdate, treeMap);
            }
        }

        String getResult() {
            StringBuffer result = new StringBuffer();
            if (this.isUnCheck) {
                return "<br>" + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"165_noCheck", (Locale)InterExchReportChecker.this.ctx.getOriginLocale());
            }
            if (this.isUnConfirm) {
                return "<br>" + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"166_noConfirm", (Locale)InterExchReportChecker.this.ctx.getOriginLocale());
            }
            for (int isDataUpdate : this.msgMap.keySet()) {
                Map treeMap = this.msgMap.get(isDataUpdate);
                if (isDataUpdate == 1) {
                    result.append("<br>").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"167_noReCheck", (Locale)InterExchReportChecker.this.ctx.getOriginLocale()));
                } else {
                    result.append("<br>" + this.title);
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    String treeName = (String)entry.getKey();
                    Set orgUnitSet = (Set)entry.getValue();
                    String orgUnit = orgUnitSet.toString();
                    orgUnit = orgUnit.substring(1, orgUnit.length() - 1);
                    result.append("<br><br>").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"CantCommitInterExchReportTree", (Locale)InterExchReportChecker.this.ctx.getOriginLocale())).append(treeName).append("<br>").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"CantCommitInterExchReportOrgUnit", (Locale)InterExchReportChecker.this.ctx.getOriginLocale())).append(orgUnit);
                }
            }
            return result.toString();
        }
    }

    class MessageManager {
        Map<String, IDCounter> mg = new HashMap<String, IDCounter>();

        MessageManager() {
        }

        void put(String id, String treeName, String companyName, String targName) {
            if (!this.mg.containsKey(id)) {
                this.mg.put(id, new IDCounter());
            }
            this.mg.get(id).addOne(treeName, companyName, targName);
        }

        void makeResult() {
            for (Map.Entry<String, IDCounter> entry : this.mg.entrySet()) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("KEY_ID", entry.getKey());
                item.put("KEY_CHECK_FLAG", false);
                item.put("KEY_CHECK_MESSAGE", entry.getValue().getResult());
                InterExchReportChecker.this.checkResult.add(item);
            }
            InterExchReportChecker.this.unPassIDs.addAll(this.mg.keySet());
        }

        public void put(String id, boolean isUnCheck, int isDataUpdate, boolean isUnConfirm) {
            if (!this.mg.containsKey(id)) {
                this.mg.put(id, new IDCounter(isUnConfirm, isUnCheck));
            }
            this.mg.get(id).addOne(isDataUpdate);
        }

        public void put(String id, String treeName, String orgunitName) {
            if (!this.mg.containsKey(id)) {
                this.mg.put(id, new IDCounter());
            }
            this.mg.get(id).addOne(treeName, orgunitName, "0");
        }
    }
}

