/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.multicalculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.app.multicalculate.IMultiCalculateProcess;
import com.kingdee.eas.fi.gr.cslrpt.app.multicalculate.MultiCalculateContext;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.dynamic.MultiDynaSumTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.util.MultiDynaItem;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiCalculateProcess
implements IMultiCalculateProcess {
    protected SQLBuilder sql = new SQLBuilder(1000);
    private MultiCalculateContext _calCtx;
    private ItemFormula currItemFormula;
    private boolean addOr = false;
    private MultiDynaItem multiDynaItem = MultiDynaItem.getInstance();
    private static final int APPEND_FIELD_ALIAS = 1;
    private static final int APPEND_ONLY_ALIAS = 2;
    private static final int APPEND_ONLY_FIELD = 3;

    public MultiCalculateProcess(MultiCalculateContext calculateContext) {
        this._calCtx = calculateContext;
    }

    @Override
    public Map<Object, Object> calculate() throws EASBizException, BOSException {
        if (!this.checkParamIsOK()) {
            return null;
        }
        HashSet<Object> dynaKeySet = null;
        if (this._calCtx.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            dynaKeySet = new HashSet<Object>();
        }
        Map<Object, Object> result = new HashMap<Object, Object>();
        ArrayList<Object> itemFormulaList = new ArrayList<Object>(this._calCtx.getItemFormulaMap().values());
        this.currItemFormula = (ItemFormula)itemFormulaList.get(0);
        this.buildSQL();
        IRowSet rowSet = DbUtil.executeQuery((Context)this._calCtx.getCtx(), (String)this.sql.toString(), (Object[])this.sql.getParams());
        try {
            result = this.exportMultiDynaResult(this._calCtx.getAsstActTypeCollection(), this._calCtx.getSumType(), dynaKeySet, this.currItemFormula.getValueType(), result, rowSet);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (this._calCtx.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            result.put("KEY_ALL_MULTIDYNAKEY", dynaKeySet);
        }
        this.sql.reset();
        return result;
    }

    private void replaceSpecialChar(AsstActTypeCollection asstActTypeCollection) {
        if (asstActTypeCollection != null && asstActTypeCollection.get(0) != null && StringUtils.isEmpty((String)asstActTypeCollection.get(0).getString("sqlField"))) {
            HashSet<String> specialChars = new HashSet<String>();
            specialChars.add("-");
            specialChars.add("\\.");
            for (int i = 0; i < asstActTypeCollection.size(); ++i) {
                AsstActTypeInfo info = asstActTypeCollection.get(i);
                String sqlField = info.getNumber();
                if (info == null || StringUtils.isEmpty((String)sqlField)) continue;
                for (String specialChar : specialChars) {
                    sqlField = sqlField.replaceAll(specialChar, "");
                }
                info.setString("sqlField", sqlField);
            }
        }
    }

    private boolean checkParamIsOK() {
        if (this._calCtx.getItemFormulaMap() == null || this._calCtx.getItemFormulaMap().size() == 0) {
            return false;
        }
        if (this._calCtx.getAsstActTypeCollection() == null || this._calCtx.getAsstActTypeCollection().size() == 0) {
            return false;
        }
        if (this._calCtx.getTask() == null || this._calCtx.getTask().companyIDs.size() == 0) {
            return false;
        }
        return this._calCtx.getReportInfo() != null && this._calCtx.getReportInfo().getOrgTree() != null;
    }

    private void buildSQL() throws EASBizException, BOSException {
        this.replaceSpecialChar(this._calCtx.getAsstActTypeCollection());
        if (this.currItemFormula.getValueType() != 3 && this._calCtx.isElimRpt()) {
            this.sql.append(" select * from ( ");
        }
        this.buildSelectPartSQL();
        this.buildFromPartSQL();
        this.buildWhereCommonSQL();
        this.sql.append(" and ( ");
        ArrayList<Object> itemFormulaList = new ArrayList<Object>(this._calCtx.getItemFormulaMap().values());
        for (int index = 0; index < itemFormulaList.size(); ++index) {
            this.currItemFormula = (ItemFormula)itemFormulaList.get(index);
            this.buildWhereVarSQL();
        }
        this.sql.append(" ) ");
        this.buildGroupByPartSQL();
        if (this.currItemFormula.getValueType() != 3 && this._calCtx.isElimRpt()) {
            this.sql.append(" ) t1 where t1.value > 0 ");
        }
    }

    protected void buildSelectPartSQL() {
        if (this.currItemFormula.getValueType() == 3) {
            this.sql.append(" select ItemDataEntry.FTextValue Value  ");
        } else if (this._calCtx.getReportInfo().getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICCSLREPORT)) {
            this.sql.append(" select data.dc dc,sum(data.value) Value,data.itemNumber itemNumber,data.dataElement dataElement");
            if (this._calCtx.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                this.sql.append(",data.orgUnitID orgUnitID");
            }
            this.buildAsstActTypeSQLPartForSelect(2);
            this.sql.append(" from (");
            this.sql.append(" select rptitem.fdc dc,case when ItemDataEntry.FdetailCompanyId is null then ItemDataEntry.FValue");
            this.sql.append(" else ItemDataEntry.FValue*(-1) end Value ");
        } else {
            this.sql.append(" select rptitem.fdc dc,sum(ItemDataEntry.FValue) Value  ");
        }
        this.sql.append(" ,ItemDataEntry.FItemID ItemNumber ");
        this.sql.append(" ,ItemDataEntry.FDataElement DataElement ");
        if (this._calCtx.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            if (this._calCtx.getReportInfo().getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICCSLREPORT)) {
                if (this._calCtx.getTask().isAutoExpandUnit) {
                    this.sql.append(",'").append(this._calCtx.getTask().expandUnitId).append("' OrgUnitID ");
                } else {
                    this.sql.append(" ,case when ItemDataEntry.FdetailCompanyId is null then ItemData.FOrgUnitID ");
                    this.sql.append(" else ItemDataEntry.FdetailCompanyId end OrgUnitID ");
                }
            } else {
                this.sql.append(" ,ItemData.FOrgUnitID OrgUnitID ");
            }
        }
        this.buildAsstActTypeSQLPart(1);
    }

    protected void buildFromPartSQL() {
        this.sql.append(" from T_CSL_MultiDynaItemData ItemData           ");
        this.sql.append(" inner join T_CSL_MultiDynaItemDataEntry ItemDataEntry on ItemData.FID = ItemDataEntry.FItemDataID  ");
        this.sql.append(" inner join T_CSL_RptReceived RptReceived on ItemData.FReportID =  RptReceived.FReportID  ");
        this.sql.append(" inner join T_CSL_CslRptAssistantHG hg on hg.FID = ItemDataEntry.FCslRptAssistantHGId   ");
        this.sql.append(" inner join T_CSL_RptItem rptitem on rptitem.fnumber=ItemDataEntry.FitemId \t");
        for (int i = 0; i < this._calCtx.getAsstActTypeCollection().size(); ++i) {
            AsstActTypeInfo asstActTypeInfo = this._calCtx.getAsstActTypeCollection().get(i);
            String sqlField = asstActTypeInfo.getString("sqlField");
            this.sql.append(" inner join ").append(asstActTypeInfo.getRealtionDataObject()).append(" AsstActType").append(sqlField);
            this.sql.append(" on hg.").append(asstActTypeInfo.getMappingFieldName()).append(" = AsstActType").append(sqlField).append(".FID");
        }
    }

    protected void buildWhereCommonSQL() throws EASBizException, BOSException {
        CslReportInfo reportInfo = this._calCtx.getReportInfo();
        this.sql.append(" where RptReceived.FOrgTreeId = ? ", (Object)reportInfo.getOrgTree().getId().toString());
        this.sql.append(" and ItemData.FCurrencyID = ?    ", (Object)reportInfo.getCurrency().getId().toString());
        this.sql.append(" and ItemDataEntry.FValueType = ? ", (Object)this.currItemFormula.getValueType());
        this.sql.append(" and ItemData.FPeriodType = ? ", (Object)reportInfo.getPeriodType().getValue());
        this.sql.append(" and ItemData.FYear = ? ", (Object)reportInfo.getYear());
        this.sql.append(" and ItemData.FPeriod = ? ", (Object)reportInfo.getPeriod());
        if (reportInfo.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICCSLREPORT)) {
            this.sql.append(" and ((ItemData.FDataSource = 13    ");
            this.sql.append(" and ItemData.FOrgUnitID in ", this._calCtx.getTask().companyIDs);
            this.sql.append(" and ItemData.FCommitStatus = 3\t\t\t");
            this.sql.append(" )or (ItemData.FDataSource = 45    ");
            this.sql.append(" and ItemData.FOrgUnitID in ", this._calCtx.getTask().unitIDs);
            this.sql.append(" and ItemDataEntry.FdetailCompanyId in ", this._calCtx.getTask().companyIDs);
            this.sql.append(" ))");
        } else {
            this.sql.append(" and ItemData.FCommitStatus = 3\t\t\t");
            this.sql.append(" and ItemData.FOrgUnitID in ", this._calCtx.getTask().companyIDs);
            this.sql.append(" and ItemData.FDataSource in (13)    ");
        }
    }

    protected void buildWhereVarSQL() throws EASBizException, BOSException {
        ArrayList<Map> dynaMapList = new ArrayList<Map>();
        ArrayList<ItemFormula> itemList = new ArrayList<ItemFormula>();
        if (this.addOr) {
            this.sql.append("OR   ");
        } else {
            this.addOr = true;
        }
        this.sql.append(" (  ItemDataEntry.FItemID = ?  ", (Object)this.currItemFormula.getItemNumber());
        if (this._calCtx.getSumType() == MultiDynaSumTypeEnum.BYASSTACCOUNT) {
            Map ditemMap = this.multiDynaItem.parseDItemNumber(this.currItemFormula.getDItemNumber());
            dynaMapList.add(ditemMap);
            itemList.add(this.currItemFormula);
            for (int i = 0; i < this._calCtx.getAsstActTypeCollection().size(); ++i) {
                AsstActTypeInfo asstActTypeInfo = this._calCtx.getAsstActTypeCollection().get(i);
                String asstActTypeNumber = asstActTypeInfo.getNumber();
                String sqlField = asstActTypeInfo.getString("sqlField");
                String itemNumber = (String)ditemMap.get(asstActTypeNumber);
                if (itemNumber == null) continue;
                String numberOrLongNumber = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo) ? ".FLongNumber" : ".FNumber";
                this.sql.append(" and AsstActType").append(sqlField).append(numberOrLongNumber).append(" = ? ", (Object)itemNumber);
            }
        }
        this.sql.append(" AND ItemDataEntry.FDataElement = ? ) ", (Object)DataElementProvider.getDataElementInnerValue(this._calCtx.getCtx(), this.currItemFormula.getDataElementNumber()));
    }

    protected void buildGroupByPartSQL() {
        if (this.currItemFormula.getValueType() != 3) {
            if (this._calCtx.getReportInfo().getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICCSLREPORT)) {
                this.sql.append("as data ) Group by data.dc,data.itemNumber,data.dataElement");
                if (this._calCtx.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                    this.sql.append(" ,data.orgUnitID");
                }
                this.buildAsstActTypeSQLPart(2);
            } else {
                this.sql.append("Group by rptitem.fdc,ItemDataEntry.FItemID , ItemDataEntry.FDataElement ");
                if (this._calCtx.getSumType() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                    this.sql.append(" ,ItemData.FOrgUnitID");
                }
                this.buildAsstActTypeSQLPart(3);
            }
        }
    }

    private void buildAsstActTypeSQLPart(int addType) {
        for (int i = 0; i < this._calCtx.getAsstActTypeCollection().size(); ++i) {
            AsstActTypeInfo asstActTypeInfo = this._calCtx.getAsstActTypeCollection().get(i);
            String numberOrLongNumber = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo) ? ".FLongNumber" : ".FNumber";
            String name = ".FName_" + this._calCtx.getCtx().getLocale().getLanguage();
            String asstActTypeNumber = asstActTypeInfo.getNumber();
            String sqlField = asstActTypeInfo.getString("sqlField");
            if (3 == addType) {
                this.sql.append(",AsstActType").append(sqlField).append(numberOrLongNumber);
                this.sql.append(",AsstActType").append(sqlField).append(name);
                continue;
            }
            if (2 == addType) {
                this.sql.append(",data.Number").append(sqlField);
                this.sql.append(",data.Name").append(sqlField);
                continue;
            }
            if (1 != addType) continue;
            this.sql.append(",AsstActType").append(sqlField).append(numberOrLongNumber).append(" Number").append(sqlField);
            this.sql.append(",AsstActType").append(sqlField).append(name).append(" Name").append(sqlField);
        }
    }

    private void buildAsstActTypeSQLPartForSelect(int addType) {
        for (int i = 0; i < this._calCtx.getAsstActTypeCollection().size(); ++i) {
            AsstActTypeInfo asstActTypeInfo = this._calCtx.getAsstActTypeCollection().get(i);
            String numberOrLongNumber = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo) ? ".FLongNumber" : ".FNumber";
            String name = ".FName_" + this._calCtx.getCtx().getLocale().getLanguage();
            String asstActTypeNumber = asstActTypeInfo.getNumber();
            String sqlField = asstActTypeInfo.getString("sqlField");
            if (3 == addType) {
                this.sql.append(",AsstActType").append(sqlField).append(numberOrLongNumber);
                this.sql.append(",AsstActType").append(sqlField).append(name);
                continue;
            }
            if (2 == addType) {
                this.sql.append(",data.Number").append(sqlField).append(" Number").append(sqlField);
                this.sql.append(",data.Name").append(sqlField).append(" Name").append(sqlField);
                continue;
            }
            if (1 != addType) continue;
            this.sql.append(",AsstActType").append(sqlField).append(numberOrLongNumber).append(" Number").append(sqlField);
            this.sql.append(",AsstActType").append(sqlField).append(name).append(" Name").append(sqlField);
        }
    }

    private Map<Object, Object> exportMultiDynaResult(AsstActTypeCollection asstActTypeCollection, MultiDynaSumTypeEnum sumType, Set<Object> dynaKeySet, int valueType, Map<Object, Object> result, IRowSet rowSet) throws SQLException {
        while (rowSet.next()) {
            HashMap<String, Object> multiValueMap;
            Map<Object, Object> valueMap = null;
            if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                String orgUnitID = rowSet.getString("OrgUnitID");
                HashMap<Object, Object> companyValueMap = (HashMap<Object, Object>)result.get(orgUnitID);
                if (companyValueMap == null) {
                    companyValueMap = new HashMap<Object, Object>();
                }
                result.put(orgUnitID, companyValueMap);
                valueMap = companyValueMap;
            } else {
                valueMap = result;
            }
            StringBuffer key = new StringBuffer();
            for (int i = 0; i < asstActTypeCollection.size(); ++i) {
                if (i != 0) {
                    key.append(";");
                }
                AsstActTypeInfo asstActTypeInfo = asstActTypeCollection.get(i);
                String typeNumber = asstActTypeInfo.getNumber();
                String sqlField = asstActTypeInfo.getString("sqlField");
                String number = rowSet.getString("Number" + sqlField);
                String name = rowSet.getString("Name" + sqlField);
                key.append(typeNumber).append("|").append(number).append("@!@").append(name);
            }
            if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                dynaKeySet.add(key.toString());
            }
            if ((multiValueMap = (HashMap<String, Object>)valueMap.get(key.toString())) == null) {
                multiValueMap = new HashMap<String, Object>();
                valueMap.put(key.toString(), multiValueMap);
            }
            String itemNumber = rowSet.getString("ItemNumber") + "@!@" + rowSet.getInt("DataElement") + "@!@" + valueType;
            Object itemValue = multiValueMap.get(itemNumber);
            if (valueType == 3) {
                List<String> valueList;
                String textValue = rowSet.getString("Value");
                if (itemValue == null) {
                    valueList = new ArrayList<String>();
                    valueList.add(textValue);
                    multiValueMap.put(itemNumber, valueList);
                    continue;
                }
                valueList = (List)multiValueMap.get(itemNumber);
                if (valueList.contains(textValue)) continue;
                valueList.add(textValue);
                continue;
            }
            BigDecimal numberValue = rowSet.getBigDecimal("Value");
            if (itemValue == null) {
                multiValueMap.put(itemNumber, numberValue);
                multiValueMap.put("dc" + itemNumber, rowSet.getString("dc"));
                continue;
            }
            multiValueMap.put(itemNumber, numberValue.add((BigDecimal)itemValue));
        }
        if (result != null && !result.isEmpty()) {
            Iterator<Object> it = result.keySet().iterator();
            StringBuffer sb = null;
            while (it.hasNext()) {
                String key = (String)it.next();
                Map multiValueMap = (Map)result.get(key);
                for (String vkey : multiValueMap.keySet()) {
                    if (multiValueMap.get(vkey) instanceof HashMap) {
                        HashMap textValues = (HashMap)multiValueMap.get(vkey);
                        for (String tvkey : textValues.keySet()) {
                            if (!(textValues.get(tvkey) instanceof ArrayList)) continue;
                            ArrayList values = (ArrayList)textValues.get(tvkey);
                            sb = new StringBuffer();
                            for (String textValue : values) {
                                sb.append(textValue);
                            }
                            textValues.put(tvkey, sb.toString());
                        }
                        continue;
                    }
                    if (!(multiValueMap.get(vkey) instanceof ArrayList)) continue;
                    ArrayList values = (ArrayList)multiValueMap.get(vkey);
                    sb = new StringBuffer();
                    for (String textValue : values) {
                        sb.append(textValue);
                    }
                    multiValueMap.put(vkey, sb.toString());
                }
            }
        }
        return result;
    }
}

