/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.paramhandle;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.IParamParser;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamCommonParser;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ParamTempTblService {
    private final TableInfo _table;
    private String _tmpTblName;
    private final Context _ctx;
    private final Collection _paramCols;
    private boolean hasParser = false;
    private String parserSql;
    private IParamParser _parser;
    public static final int Max_Size = 25;

    public ParamTempTblService(Context ctx, TableInfo table, Collection params, IParamParser parser) {
        this._ctx = ctx;
        this._table = table;
        this._paramCols = params;
        this._parser = parser == null ? new ParamCommonParser() : parser;
    }

    public static ParamTempTblService getInstance(Context ctx, TableInfo table, Collection params, IParamParser parser) {
        return new ParamTempTblService(ctx, table, params, parser);
    }

    public static ParamTempTblService getDefaultInstance(Context ctx, Collection params, IParamParser parser) {
        TableInfo table = new TableInfo("ID_param_temp");
        table.addColumn("id");
        return new ParamTempTblService(ctx, table, params, parser);
    }

    public String getParamsSql() throws BOSException {
        if (!this.hasParser) {
            this.ParserParams();
        }
        if (!this._table.isMutilColums() && 25 < this._paramCols.size()) {
            this.constuctSelectSql();
        }
        return this.parserSql;
    }

    public String getTmpName() throws BOSException {
        if (!this.hasParser) {
            this.ParserParams();
        }
        return this._tmpTblName;
    }

    public String getTmpTableName() throws BOSException {
        if (!this.hasParser) {
            this.insertParams2Tbl();
            this.hasParser = true;
        }
        return this._tmpTblName;
    }

    private void ParserParams() throws BOSException {
        if (this._paramCols == null || this._paramCols.size() == 0) {
            this.parserSql = "''";
        }
        if (25 >= this._paramCols.size() && !this._table.isMutilColums()) {
            this.parserSql = this.AryToItemString(this.wrappedParam2List());
        } else {
            this.insertParams2Tbl();
        }
        this.hasParser = true;
    }

    private String AryToItemString(List params) {
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        Iterator it = params.iterator();
        while (it.hasNext()) {
            Object obj = ((Object[])it.next())[0];
            if (!isFirst) {
                sb.append(",");
            }
            if (obj instanceof Integer) {
                sb.append((Integer)obj);
            } else if (obj instanceof BigDecimal) {
                sb.append(((BigDecimal)obj).doubleValue());
            } else if (obj instanceof Double) {
                sb.append((Double)obj);
            } else if (obj instanceof Long) {
                sb.append((Long)obj);
            } else {
                sb.append("'").append(String.valueOf(obj)).append("'");
            }
            isFirst = false;
        }
        return sb.toString();
    }

    private void constuctSelectSql() {
        if (this._table.isMutilColums()) {
            throw new UnsupportedOperationException("not Supported mutil colums!");
        }
        this.parserSql = " Select " + this._table.parserColumnSql(false) + " from " + this._tmpTblName;
    }

    private void insertParams2Tbl() throws BOSException {
        this.createTemplateTbl();
        this.insert2Tbl();
    }

    private void createTemplateTbl() throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)this._ctx);
        try {
            this._tmpTblName = pool.createTempTable(this._table.createTableStr());
            pool.createIndex(this._tmpTblName, this._table.parserColumnSql(false), false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void insert2Tbl() throws BOSException {
        CslRptUtil.executeBatch(this._ctx, this.getPrepareStatementSql(), this.wrappedParam2List());
    }

    private List wrappedParam2List() {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(this._paramCols.size());
        Iterator it = this._paramCols.iterator();
        while (it.hasNext()) {
            paramsList.add(this._parser.parserParam2List(it.next()));
        }
        return paramsList;
    }

    private String getPrepareStatementSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(this._tmpTblName);
        sql.append(" values(").append(this._table.getParamsSql()).append(")");
        return sql.toString();
    }

    public void release() {
        if (!StringUtils.isEmpty((String)this._tmpTblName)) {
            TempTablePool.getInstance((Context)this._ctx).releaseTable(this._tmpTblName);
        }
    }

    public Collection getParams() {
        return this._paramCols;
    }

    public static void test(Context ctx) {
        TableInfo table = new TableInfo("TESTTABLE");
        table.addColumn(new ColumnInfo("column1"));
        ArrayList<String> params = new ArrayList<String>(999);
        for (int i = 0; i < 999; ++i) {
            params.add("" + i);
        }
        TableInfo table2 = new TableInfo("TESTTABLE");
        table2.addColumn(new ColumnInfo("column1"));
        table2.addColumn(new ColumnInfo("column2", "int"));
        ArrayList<Object[]> params2 = new ArrayList<Object[]>(1510);
        for (int i = 0; i < 1510; ++i) {
            params2.add(new Object[]{"" + i, i});
        }
    }
}

