/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.reportcalc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.AbstractCslReportParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.MnsRptParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.ReportCalcGroupKey;
import com.kingdee.eas.fi.gr.cslrpt.util.ClearCompanyItemInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.jdbc.statement.CslPreparedStatement;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ElimDataUtil {
    private static final String SPLIT = "!";

    public static String getTempElimIDTable(Context ctx, ItemDataCondition condition, AbstractCslReportParamInfo rptParamInfo, String currOrgTreeId, String currOrgUnitId) throws EASBizException, BOSException {
        String string;
        String temCompanyIdName = null;
        try {
            Map unionMap = rptParamInfo.getUnionMap();
            ElimDataMap elimDataMap = null;
            if (unionMap != null && !unionMap.isEmpty()) {
                HashMap tmpUnionMap = new HashMap();
                tmpUnionMap.putAll(unionMap);
                Map<ReportCalcGroupKey, Set<String>> companyGroupMap = rptParamInfo.getCompanyGroupMap();
                Set unionSet = null;
                if (companyGroupMap != null) {
                    for (ReportCalcGroupKey key : companyGroupMap.keySet()) {
                        if (key.getPeriodOffset() == 0 || (unionSet = (Set)tmpUnionMap.get(key.getOrgTree())) == null) continue;
                        unionSet.removeAll((Collection)companyGroupMap.get(key));
                    }
                }
                if (!tmpUnionMap.isEmpty()) {
                    elimDataMap = ElimDataUtil.expandUnionChild(ctx, tmpUnionMap);
                }
            }
            temCompanyIdName = ElimDataUtil.insertValue2TempTable(ctx, rptParamInfo, elimDataMap);
            Map allUnitMap = ElimDataUtil.getAllUnitMap(ctx, currOrgTreeId, currOrgUnitId);
            ArrayList parentUnitList = null;
            if (allUnitMap.size() == 1) {
                parentUnitList = new ArrayList(1);
            } else {
                List allOrgUnitList = ElimDataUtil.getAllOrgUnitList(ctx, currOrgTreeId, temCompanyIdName);
                parentUnitList = ElimDataUtil.getParentUnitList(allOrgUnitList, elimDataMap, allUnitMap);
            }
            parentUnitList.add(currOrgUnitId);
            condition.setOrgUnit(parentUnitList);
            condition.setOrgTreeId(currOrgTreeId);
            StringBuffer create = new StringBuffer();
            create.append("CREATE TABLE Tmp_TempTable");
            create.append("(FID VARCHAR(44))");
            String tempElimIDTable = ElimDataUtil.createTempTable(ctx, create.toString());
            ArrayList params = new ArrayList();
            StringBuffer sql = new StringBuffer("INSERT INTO ").append(tempElimIDTable).append(" ").append(ElimDataUtil.getSumElimSQL(ctx, temCompanyIdName, condition, params));
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            sql = new StringBuffer("DELETE ").append(tempElimIDTable).append(" WHERE FID IN (");
            sql.append(" SELECT T1.FID FROM ").append(tempElimIDTable).append(" T1 ");
            sql.append(" INNER JOIN T_CSL_ElIMINATIONENTRY ElimEntry ");
            sql.append(" ON T1.FID = ElimEntry.FEliminationID ");
            sql.append(" WHERE NOT EXISTS ( SELECT 1  FROM ").append(temCompanyIdName);
            sql.append(" T2 WHERE T2.FCompanyId =  ElimEntry.FCompanyId )) ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            string = tempElimIDTable;
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                if (!StringUtils.isEmpty(temCompanyIdName)) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(temCompanyIdName);
                }
                throw throwable;
            }
        }
        if (!StringUtils.isEmpty((String)temCompanyIdName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(temCompanyIdName);
        }
        return string;
    }

    private static ArrayList getParentUnitList(List allOrgUnitList, ElimDataMap elimDataMap, Map allUnitMap) {
        int m;
        ArrayList<Object> parentUnitList = new ArrayList<Object>();
        String sameNumber = null;
        int count = allOrgUnitList.size();
        Object unitId = null;
        HashMap<String, String[]> longNumber_Number = new HashMap<String, String[]>();
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> longNumbers = new ArrayList<String>();
        for (m = 0; m < count; ++m) {
            ids.add(((OrgUnitInfo)allOrgUnitList.get(m)).get("id").toString());
            longNumbers.add(((OrgUnitInfo)allOrgUnitList.get(m)).get("longNumber").toString());
        }
        for (m = 0; m < count; ++m) {
            OrgUnitInfo leftInfo = (OrgUnitInfo)allOrgUnitList.get(m);
            String leftId = (String)ids.get(m);
            String leftLongNumber = (String)longNumbers.get(m);
            for (int n = m + 1; n < count; ++n) {
                OrgUnitInfo rightInfo = (OrgUnitInfo)allOrgUnitList.get(n);
                String rigthId = (String)ids.get(n);
                String rigthLongNumber = (String)longNumbers.get(n);
                if (leftId.equals(rigthId) || ElimDataUtil.isInSameUnit(leftId, rigthId, elimDataMap) || (sameNumber = ElimDataUtil.getSameUnitNumber(leftLongNumber, rigthLongNumber, longNumber_Number)) == null || (unitId = (Object)allUnitMap.remove(sameNumber)) == null) continue;
                parentUnitList.add(unitId);
                if (!allUnitMap.isEmpty()) continue;
                return parentUnitList;
            }
        }
        ids.clear();
        longNumbers.clear();
        longNumber_Number.clear();
        allUnitMap.clear();
        allOrgUnitList.clear();
        return parentUnitList;
    }

    private static String getSameUnitNumber(String leftNumber, String rightNumber, Map<String, String[]> longNumber_Number) {
        String[] left = longNumber_Number.get(leftNumber);
        String[] right = longNumber_Number.get(rightNumber);
        if (left == null) {
            left = leftNumber.split(SPLIT);
            longNumber_Number.put(leftNumber, left);
        }
        if (right == null) {
            right = rightNumber.split(SPLIT);
            longNumber_Number.put(rightNumber, right);
        }
        String number = null;
        for (int i = (left.length > right.length ? right.length : left.length) - 1 - 1; i >= 0; --i) {
            if (!right[i].equals(left[i]) || !(number = ElimDataUtil.getIndexLongNumber(right, i)).equals(ElimDataUtil.getIndexLongNumber(left, i))) continue;
            return number;
        }
        return null;
    }

    private static String getIndexLongNumber(String[] str, int index) {
        if (index == 0) {
            return str[0];
        }
        StringBuffer longNumber = new StringBuffer();
        for (int i = 0; i < index + 1 && i < str.length; ++i) {
            longNumber.append(str[i]);
            if (i == index) continue;
            longNumber.append(SPLIT);
        }
        return longNumber.toString();
    }

    private static boolean isInSameUnit(String leftId, String rightId, ElimDataMap elimDataMap) {
        if (elimDataMap == null) {
            return false;
        }
        ElimData elimData = null;
        Set childUnitIdSet = null;
        Iterator iterator = elimDataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            elimData = (ElimData)iterator.next().getValue();
            Iterator elimDataIter = elimData.childUnitMap.entrySet().iterator();
            while (elimDataIter.hasNext()) {
                childUnitIdSet = (Set)elimDataIter.next().getValue();
                if (!childUnitIdSet.contains(rightId) || !childUnitIdSet.contains(leftId)) continue;
                return true;
            }
        }
        return false;
    }

    private static List getAllOrgUnitList(Context ctx, String currOrgTreeId, String temCompanyIdName) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FLONGNUMBER,FUNITID FROM T_ORG_Structure S");
        sql.append(" INNER JOIN ").append(temCompanyIdName).append(" T ");
        sql.append(" ON  S.FUNITID = T.FCompanyId ");
        sql.append(" WHERE S.FTREEID = ? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currOrgTreeId});
        OrgUnitInfo orgUnitInfo = null;
        ArrayList<OrgUnitInfo> orgUnitList = new ArrayList<OrgUnitInfo>(rowSet.size());
        while (rowSet.next()) {
            orgUnitInfo = new OrgUnitInfo();
            orgUnitInfo.put("id", (Object)rowSet.getString("FUNITID"));
            orgUnitInfo.put("longNumber", (Object)rowSet.getString("FLONGNUMBER"));
            orgUnitList.add(orgUnitInfo);
        }
        return orgUnitList;
    }

    private static String getSumElimSQL(Context ctx, String tempTable, ItemDataCondition condition, List params) throws EASBizException, BOSException {
        StringBuffer sbSumElim = new StringBuffer();
        sbSumElim.append("SELECT Elim.FID ");
        sbSumElim.append(" FROM T_CSL_ElIMINATIONENTRY AS ElimEntry ");
        sbSumElim.append(" INNER JOIN T_CSL_ELIMINATION AS Elim ");
        sbSumElim.append(" \t ON ElimEntry.FEliminationID = Elim.FID ");
        sbSumElim.append(" INNER JOIN ").append(tempTable);
        sbSumElim.append(" tmp ON tmp.FCompanyId = ElimEntry.FCompanyId");
        sbSumElim.append(" WHERE Elim.FOrgBoundID = ? ");
        params.add(condition.getOrgTreeId());
        sbSumElim.append(" AND Elim.FOrgUnit IN (").append(condition.getOrgUnitString());
        sbSumElim.append(" ) ");
        if (condition.getElimTypeFilter() != null && !condition.getElimTypeFilter().isEmpty()) {
            sbSumElim.append(" AND ").append(CSLServerHelper.getOrStringByList(condition.getElimTypeFilter(), "Elim", "feliminationmodeid"));
        }
        if (condition.getCurrency() != null) {
            sbSumElim.append(" AND Elim.FSourceCurrencyId = ? ");
            params.add(condition.getCurrency());
        }
        if (condition.getTargetCurrency() != null) {
            sbSumElim.append(" AND Elim.FCurrencyID = ? ");
            params.add(condition.getTargetCurrency());
        }
        if (condition.getValueType() != -100) {
            sbSumElim.append(" AND Elim.FValueType = ? ");
            params.add(new Integer(condition.getValueType()));
        }
        if (condition.getRptPeriodType() != -1) {
            sbSumElim.append(" AND Elim.FPeriodType = ? ");
            params.add(new Integer(condition.getRptPeriodType()));
        }
        if (condition.getSystemVars() != null && condition.getSystemVars().containsKey("YearAndPeriod")) {
            List l = (List)condition.getSystemVars().get("YearAndPeriod");
            if (l.size() > 0) {
                sbSumElim.append(" AND (");
            }
            for (int i = 0; i < l.size(); ++i) {
                int[] x = (int[])l.get(i);
                if (i != 0) {
                    sbSumElim.append(" OR ");
                }
                sbSumElim.append(" (Elim.FYear =").append(x[0]).append(" AND Elim.FPeriod=").append(x[1]).append(" )");
            }
            if (l.size() > 0) {
                sbSumElim.append(" )");
            }
            condition.setSystemVars(null);
        }
        if (condition.getRptYearStart() != -1) {
            sbSumElim.append(" AND Elim.FYear = ? ");
            params.add(new Integer(condition.getRptYearStart()));
        }
        if (condition.getRptPeriodStart() != -1) {
            sbSumElim.append(" AND Elim.FPeriod = ? ");
            params.add(new Integer(condition.getRptPeriodStart()));
        }
        if (!condition.isIncludeUnAuditElim()) {
            sbSumElim.append(" AND Elim.FCheckedStatus = ? ");
            params.add(new Integer(2));
        }
        String dataCollectNumber = null;
        dataCollectNumber = StringUtils.isEmpty((String)condition.getDataCollectNumber()) ? "ACTUALDATA" : condition.getDataCollectNumber();
        sbSumElim.append(" AND Elim.FDataCollectNumber = ? ");
        params.add(dataCollectNumber);
        sbSumElim.append(" GROUP BY Elim.FID ");
        return sbSumElim.toString();
    }

    private static ElimDataMap expandUnionChild(Context ctx, Map unionMap) throws BOSException, SQLException {
        ElimDataMap elimDataMap = new ElimDataMap();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FLONGNUMBER,FUNITID,FTREEID FROM T_ORG_Structure ");
        Iterator iter = unionMap.keySet().iterator();
        int i = 0;
        OrgTreeInfo orgTreeInfo = null;
        Set unionSet = null;
        String treeId = null;
        String unitId = null;
        ArrayList<String> params = new ArrayList<String>();
        while (iter.hasNext()) {
            orgTreeInfo = (OrgTreeInfo)iter.next();
            treeId = orgTreeInfo.getId().toString();
            unionSet = (Set)unionMap.get(orgTreeInfo);
            Iterator iterator = unionSet.iterator();
            while (iterator.hasNext()) {
                unitId = iterator.next().toString();
                sql.append(i == 0 ? " WHERE " : " OR ");
                sql.append("(FTREEID = ? AND FUNITID = ?)");
                ++i;
                params.add(treeId);
                params.add(unitId);
            }
        }
        if (!params.isEmpty()) {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            String longNumber = null;
            sql.setLength(0);
            sql.append(" SELECT UNIT.FID FID FROM T_ORG_Structure S");
            sql.append(" INNER JOIN T_ORG_BASEUNIT UNIT ON UNIT.FID = S.FUNITID ");
            sql.append(" WHERE  UNIT.FIsGrouping = ? AND S.FLONGNUMBER LIKE ?");
            sql.append(" AND S.FTREEID = ? ");
            IRowSet row = null;
            while (rowSet.next()) {
                longNumber = rowSet.getString("FLONGNUMBER");
                treeId = rowSet.getString("FTREEID");
                unitId = rowSet.getString("FUNITID");
                row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(0), longNumber + "!%", treeId});
                while (row.next()) {
                    elimDataMap.addChildUnitMap(treeId, unitId, row.getString("FID"));
                }
            }
        }
        return elimDataMap;
    }

    private static String insertValue2TempTable(Context ctx, AbstractCslReportParamInfo rptParamInfo, ElimDataMap elimDataMap) throws EASBizException, BOSException {
        String string;
        Map<ReportCalcGroupKey, Set<String>> companyMap;
        Set unionSet;
        Set<String> companyIdSet;
        OrgTreeInfo orgTreeInfo;
        String tempTable;
        CslPreparedStatement ps;
        Connection cn;
        block15: {
            cn = null;
            ps = null;
            cn = ElimDataUtil.getConnection(ctx);
            StringBuffer create = new StringBuffer();
            create.append("CREATE TABLE TEMPUNITIDTABLE");
            create.append("(FCompanyId VARCHAR(44))");
            tempTable = ElimDataUtil.createTempTable(ctx, create.toString());
            String insert = " INSERT INTO " + tempTable + " VALUES(?)";
            ps = CslPreparedStatement.prepareStatement((Connection)cn, (String)insert);
            orgTreeInfo = null;
            ReportCalcGroupKey calcGropKey = null;
            companyIdSet = null;
            unionSet = null;
            companyMap = rptParamInfo.getCompanyGroupMap();
            if (companyMap != null) break block15;
            String string2 = tempTable;
            SQLUtils.cleanup((Statement)(ps == null ? null : ps.getStatement()), (Connection)cn);
            return string2;
        }
        try {
            for (ReportCalcGroupKey calcGropKey : companyMap.keySet()) {
                if (calcGropKey.getPeriodOffset() != 0) continue;
                orgTreeInfo = calcGropKey.getOrgTree();
                companyIdSet = companyMap.get(calcGropKey);
                if (rptParamInfo.getUnionMap() != null && (unionSet = (Set)rptParamInfo.getUnionMap().get(orgTreeInfo)) != null) {
                    companyIdSet.removeAll(unionSet);
                }
                Iterator<String> iterator = companyIdSet.iterator();
                while (iterator.hasNext()) {
                    ps.setString(1, iterator.next().toString());
                    ps.addBatch();
                }
            }
            if (elimDataMap != null && elimDataMap.entrySet() != null) {
                ElimData elimData = null;
                Set childUnitIdSet = null;
                Iterator childUnitIter = null;
                Iterator iterator = elimDataMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    elimData = (ElimData)iterator.next().getValue();
                    Iterator elimDataIter = elimData.childUnitMap.entrySet().iterator();
                    while (elimDataIter.hasNext()) {
                        childUnitIdSet = (Set)elimDataIter.next().getValue();
                        childUnitIter = childUnitIdSet.iterator();
                        while (childUnitIter.hasNext()) {
                            ps.setString(1, childUnitIter.next().toString());
                            ps.addBatch();
                        }
                    }
                }
            }
            if (rptParamInfo instanceof MnsRptParamInfo && !StringUtils.isEmpty((String)((MnsRptParamInfo)rptParamInfo).getReportID())) {
                String cslReportId = ((MnsRptParamInfo)rptParamInfo).getReportID();
                StringBuffer oql = new StringBuffer();
                oql.append(" select orgUnit.*,orgTree.*,year,period,periodType where id ='" + cslReportId + "'");
                CslReportCollection cslCol = CslReportFactory.getLocalInstance(ctx).getCslReportCollection(oql.toString());
                if (cslCol.size() >= 0 && cslCol.get(0).getPeriodType().equals((Object)RptPeriodTypeEnum.MONTHLY)) {
                    CslReportInfo cslReportInfo = cslCol.get(0);
                    HashMap<String, Integer> params = new HashMap<String, Integer>();
                    params.put("year", cslReportInfo.getYear());
                    params.put("period", Integer.valueOf("" + cslReportInfo.getPeriod()));
                    params.put("periodType", 3);
                    params.put("orgTreeInfo", (Integer)cslReportInfo.getOrgTree());
                    params.put("orgUnitInfo", (Integer)cslReportInfo.getOrgUnit());
                    Map clearCompMap = ElimInvestRateFactory.getLocalInstance(ctx).getClearingCompanyInfors(params);
                    List clearCompanys = clearCompMap.get("clearCompList") == null ? new ArrayList(0) : (List)clearCompMap.get("clearCompList");
                    for (ClearCompanyItemInfo companyItemInfo : clearCompanys) {
                        ps.setString(1, companyItemInfo.getClearCompany().getId().toString());
                        ps.addBatch();
                    }
                }
            }
            ps.executeBatch();
            ps.clearBatch();
            string = tempTable;
            SQLUtils.cleanup((Statement)(ps == null ? null : ps.getStatement()), (Connection)cn);
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Statement)(ps == null ? null : ps.getStatement()), (Connection)cn);
                throw throwable;
            }
        }
        return string;
    }

    private static Map getAllUnitMap(Context ctx, String currOrgTreeId, String currOrgUnitId) throws BOSException, SQLException {
        HashMap<String, String> allUnitMap = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FLONGNUMBER FROM T_ORG_Structure ");
        sql.append(" WHERE FTREEID = ? AND FUNITID = ?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currOrgTreeId, currOrgUnitId});
        String longNumber = null;
        if (rowSet.next()) {
            longNumber = rowSet.getString("FLONGNUMBER");
            allUnitMap.put(longNumber, currOrgUnitId);
        }
        sql.setLength(0);
        sql.append(" SELECT UNIT.FID FID,S.FLONGNUMBER FROM T_ORG_Structure S");
        sql.append(" INNER JOIN T_ORG_BASEUNIT UNIT ON UNIT.FID = S.FUNITID ");
        sql.append(" WHERE  UNIT.FIsGrouping = ? AND S.FLONGNUMBER LIKE ?");
        sql.append(" AND S.FTREEID = ? ");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(1), longNumber + "!%", currOrgTreeId});
        while (rowSet.next()) {
            longNumber = rowSet.getString("FLONGNUMBER");
            allUnitMap.put(rowSet.getString("FLONGNUMBER"), rowSet.getString("FID"));
        }
        return allUnitMap;
    }

    private static String createTempTable(Context ctx, String createSql) throws BOSException {
        String tableName;
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tableName = pool.createTempTable(createSql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    private static class ElimDataMap
    extends HashMap {
        private static final long serialVersionUID = 8271010516416628856L;

        void addChildUnitMap(String treeId, String unitId, String childUnitId) {
            if (unitId == null) {
                return;
            }
            ElimData elimData = this.getElimData(treeId);
            HashSet<String> set = (HashSet<String>)elimData.childUnitMap.get(unitId);
            if (set == null) {
                set = new HashSet<String>();
                elimData.childUnitMap.put(unitId, set);
            }
            set.add(childUnitId);
        }

        private ElimData getElimData(String treeId) {
            ElimData elimData = (ElimData)this.get(treeId);
            if (elimData == null) {
                elimData = new ElimData();
                this.put(treeId, elimData);
            }
            return elimData;
        }
    }

    private static class ElimData {
        Map childUnitMap = new HashMap();

        private ElimData() {
        }
    }
}

