/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.reportcalc;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcParam;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcSingleData;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsColumnCollection;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import java.awt.Point;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class MnsRptCalcAdjustData
extends MnsRptCalcSingleData {
    private MnsColumnCollection adjustBeforeColl;
    private MnsColumnCollection adjustColl;
    private MnsColumnCollection adjustAfterColl;
    private Map<Point, BigDecimal> adjustDataMap = new HashMap<Point, BigDecimal>();
    private int colDataType = 1;

    @Override
    protected void calcData() throws BOSException, EASBizException, CloneNotSupportedException {
        if (this.colDataType == 1) {
            this.calcSingleData();
        } else {
            this.calcSumOrComnData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calcSumOrComnData() throws BOSException, EASBizException, CloneNotSupportedException {
        boolean isAdjustData = this.mnsRptCalcParam.condition.isAdjustData();
        int[] dataSources = this.mnsRptCalcParam.condition.getSources();
        boolean isSupportCrossMerger = this.mnsRptCalcParam.isSupportCrossMerger;
        try {
            this.mnsRptCalcParam.isSupportCrossMerger = false;
            this.mnsRptCalcParam.condition.setAdjustData(true);
            this.mnsRptCalcParam.condition.setDataSourceString(new int[]{this.colDataType});
            super.calcData();
            if (!this.adjustAfterColl.isEmpty()) {
                if (!this.adjustColl.isEmpty()) {
                    this.adjustDataMap = this.sheetData;
                }
                MnsColumnCollection sinColl = super.getSinColColl();
                MnsColumnInfo colInfo = null;
                HashMap<String, Integer> key_colIndex_before = new HashMap<String, Integer>();
                for (int i = 0; i < sinColl.size(); ++i) {
                    colInfo = sinColl.get(i);
                    key_colIndex_before.put(colInfo.companyId + colInfo.calcKey.dataElementNumber + colInfo.calcKey.valueType, colInfo.col);
                }
                HashMap<String, Integer> key_colIndex_after = new HashMap<String, Integer>();
                for (int i = 0; i < this.adjustAfterColl.size(); ++i) {
                    colInfo = this.adjustAfterColl.get(i);
                    key_colIndex_after.put(colInfo.companyId + colInfo.calcKey.dataElementNumber + colInfo.calcKey.valueType, colInfo.col);
                }
                MnsColumnCollection tmpAdjustColl = !this.adjustColl.isEmpty() ? this.adjustColl : this.adjustAfterColl;
                BigDecimal adjustValue = null;
                BigDecimal adjustAfterValue = null;
                BigDecimal adjustBeforeValue = null;
                int adjustAfterCol = -1;
                int adjustBeforeCol = -1;
                for (int i = 0; i < tmpAdjustColl.size(); ++i) {
                    colInfo = tmpAdjustColl.get(i);
                    adjustAfterCol = (Integer)key_colIndex_after.get(colInfo.companyId + colInfo.calcKey.dataElementNumber + colInfo.calcKey.valueType);
                    adjustBeforeCol = (Integer)key_colIndex_before.get(colInfo.companyId + colInfo.calcKey.dataElementNumber + colInfo.calcKey.valueType);
                    if (adjustBeforeCol <= 0) continue;
                    for (Object rowIndex : this.itemRows.values()) {
                        adjustValue = this.adjustDataMap.get(new Point(colInfo.col, Integer.valueOf(rowIndex.toString())));
                        adjustBeforeValue = (BigDecimal)this.sheetData.get(new Point(adjustBeforeCol, Integer.valueOf(rowIndex.toString())));
                        if (adjustBeforeValue == null && adjustValue == null) continue;
                        if (adjustBeforeValue == null) {
                            adjustBeforeValue = BigDecimal.ZERO;
                        }
                        if (adjustValue == null) {
                            adjustValue = BigDecimal.ZERO;
                        }
                        adjustAfterValue = adjustBeforeValue.add(adjustValue);
                        this.sheetData.put(new Point(adjustAfterCol, Integer.valueOf(rowIndex.toString())), adjustAfterValue);
                    }
                }
                key_colIndex_after.clear();
                key_colIndex_before.clear();
            }
        }
        finally {
            this.mnsRptCalcParam.isSupportCrossMerger = isSupportCrossMerger;
            this.mnsRptCalcParam.condition.setAdjustData(isAdjustData);
            this.mnsRptCalcParam.condition.setDataSourceString(dataSources);
        }
    }

    protected void calcSingleData() throws BOSException, EASBizException, CloneNotSupportedException {
        boolean isAdjustData = this.mnsRptCalcParam.condition.isAdjustData();
        this.mnsRptCalcParam.condition.setAdjustData(true);
        super.calcData();
        if (!this.adjustBeforeColl.isEmpty()) {
            if (!this.adjustColl.isEmpty()) {
                this.adjustDataMap = this.sheetData;
            }
            MnsColumnCollection sinColl = super.getSinColColl();
            MnsColumnInfo colInfo = null;
            HashMap<String, Integer> key_colIndex_after = new HashMap<String, Integer>();
            for (int i = 0; i < sinColl.size(); ++i) {
                colInfo = sinColl.get(i);
                key_colIndex_after.put(colInfo.companyId + colInfo.calcKey.dataElementNumber + colInfo.calcKey.valueType, colInfo.col);
            }
            HashMap<String, Integer> key_colIndex_before = new HashMap<String, Integer>();
            for (int i = 0; i < this.adjustBeforeColl.size(); ++i) {
                colInfo = this.adjustBeforeColl.get(i);
                key_colIndex_before.put(colInfo.companyId + colInfo.calcKey.dataElementNumber + colInfo.calcKey.valueType, colInfo.col);
            }
            MnsColumnCollection tmpAdjustColl = !this.adjustColl.isEmpty() ? this.adjustColl : this.adjustBeforeColl;
            BigDecimal adjustValue = null;
            BigDecimal adjustAfterValue = null;
            BigDecimal adjustBeforeValue = null;
            int adjustAfterCol = -1;
            int adjustBeforeCol = -1;
            for (int i = 0; i < tmpAdjustColl.size(); ++i) {
                colInfo = tmpAdjustColl.get(i);
                adjustAfterCol = (Integer)key_colIndex_after.get(colInfo.companyId + colInfo.calcKey.dataElementNumber + colInfo.calcKey.valueType);
                adjustBeforeCol = (Integer)key_colIndex_before.get(colInfo.companyId + colInfo.calcKey.dataElementNumber + colInfo.calcKey.valueType);
                if (adjustAfterCol <= 0) continue;
                for (Object rowIndex : this.itemRows.values()) {
                    adjustValue = this.adjustDataMap.get(new Point(colInfo.col, Integer.valueOf(rowIndex.toString())));
                    adjustAfterValue = (BigDecimal)this.sheetData.get(new Point(adjustAfterCol, Integer.valueOf(rowIndex.toString())));
                    if (adjustAfterValue == null && adjustValue == null) continue;
                    if (adjustAfterValue == null) {
                        adjustAfterValue = BigDecimal.ZERO;
                    }
                    if (adjustValue == null) {
                        adjustValue = BigDecimal.ZERO;
                    }
                    adjustBeforeValue = adjustAfterValue.subtract(adjustValue);
                    this.sheetData.put(new Point(adjustBeforeCol, Integer.valueOf(rowIndex.toString())), adjustBeforeValue);
                }
            }
            key_colIndex_after.clear();
            key_colIndex_before.clear();
        }
        this.mnsRptCalcParam.condition.setAdjustData(isAdjustData);
    }

    @Override
    protected void putMnsData(BigDecimal result, int col, Integer rowIndex) {
        if (this.adjustColl.isEmpty()) {
            if (col == -1 || rowIndex == null) {
                return;
            }
            if (result != null && result.compareTo(CslConstant.BGZERO) != 0) {
                Point position = new Point(col, rowIndex);
                this.adjustDataMap.put(position, result);
            }
        } else {
            super.putMnsData(result, col, rowIndex);
        }
    }

    @Override
    public MnsColumnCollection getSinColColl() {
        return this.colDataType == 1 ? (this.adjustColl.isEmpty() ? this.adjustBeforeColl : this.adjustColl) : (this.adjustColl.isEmpty() ? this.adjustAfterColl : this.adjustColl);
    }

    public MnsColumnCollection getAdjustBeforeColl() {
        return this.adjustBeforeColl;
    }

    public void setAdjustBeforeColl(MnsColumnCollection adjustBeforeColl) {
        this.adjustBeforeColl = adjustBeforeColl;
    }

    public MnsColumnCollection getAdjustColl() {
        return this.adjustColl;
    }

    public void setAdjustColl(MnsColumnCollection adjustColl) {
        this.adjustColl = adjustColl;
    }

    public MnsColumnCollection getAdjustAfterColl() {
        return this.adjustAfterColl;
    }

    public void setAdjustAfterColl(MnsColumnCollection adjustAfterColl) {
        this.adjustAfterColl = adjustAfterColl;
    }

    public MnsRptCalcAdjustData(MnsRptCalcParam mnsRptCalcParam) {
        super(mnsRptCalcParam);
    }

    public int getColDataType() {
        return this.colDataType;
    }

    public void setColDataType(int colDataType) {
        this.colDataType = colDataType;
    }
}

