/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.reportcalc;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.AbstractMnsRptCalcColumn;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcParam;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsCalcKey;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsColumnCollection;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.ClearCompanyItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.MnsRptFillCondition;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MnsRptCalcClearSingleData
extends AbstractMnsRptCalcColumn {
    private MnsColumnCollection sinColColl;
    private MnsColumnCollection sumColColl;

    public MnsRptCalcClearSingleData(MnsRptCalcParam mnsRptCalcParam) {
        super(mnsRptCalcParam);
    }

    @Override
    protected void setMnsColumnCollection(MnsColumnCollection collection) {
        this.sinColColl = collection;
    }

    public void setSumColColl(MnsColumnCollection sumColColl) {
        this.sumColColl = sumColColl;
    }

    @Override
    protected void calcData() throws BOSException, EASBizException, CloneNotSupportedException {
        if (this.sinColColl.isEmpty()) {
            return;
        }
        CslReportInfo cslRptInfo = this.mnsRptCalcParam.report;
        MnsRptFillCondition condition = new MnsRptFillCondition(this.ctx, cslRptInfo.getOrgTree(), (OrgUnitInfo)cslRptInfo.getOrgUnit(), cslRptInfo.getYear(), cslRptInfo.getPeriod(), cslRptInfo.getPeriodType().getValue(), this.mnsRptCalcParam.isSupportCrossMerger());
        List<ClearCompanyItemInfo> clearItems = condition.getClearingCompanyList();
        if (clearItems == null || clearItems.size() <= 0) {
            return;
        }
        String clearCompId = null;
        ClearCompanyItemInfo clearItemInfo2 = null;
        Iterator itr = this.sinColColl.getMnsCalcKeySet().iterator();
        ItemDataCondition tmpCondition = (ItemDataCondition)this.mnsRptCalcParam.condition.clone();
        tmpCondition.setItemList(this.items);
        Map columnValue = null;
        MnsCalcKey calcKey = null;
        while (itr.hasNext()) {
            calcKey = (MnsCalcKey)itr.next();
            int j = this.sinColColl.size();
            for (int i = 0; i < j; ++i) {
                clearCompId = this.sinColColl.get((int)i).companyId;
                if (!this.sinColColl.get((int)i).calcKey.equals(calcKey)) continue;
                for (ClearCompanyItemInfo clearItemInfo2 : clearItems) {
                    if (!clearCompId.equals(clearItemInfo2.getClearCompany().getId().toString())) continue;
                    tmpCondition.setOrgUnitNumber(Arrays.asList(clearItemInfo2.getClearCompany().getNumber()));
                    tmpCondition.setOrgTreeId(clearItemInfo2.getTreeInfo().getId().toString());
                    tmpCondition.setDataSource(7);
                    tmpCondition.setGroupByCompany(true);
                    tmpCondition.setDataElement(this.getDataElementInnerValue(calcKey.dataElementNumber));
                    tmpCondition.setValueType(calcKey.valueType);
                    tmpCondition.setRptPeriodStart(clearItemInfo2.getPeriod());
                    tmpCondition.setRptPeriodEnd(clearItemInfo2.getPeriod());
                    tmpCondition.setRptYearStart(clearItemInfo2.getYear());
                    tmpCondition.setRptYearEnd(clearItemInfo2.getYear());
                    columnValue = this.getItemDataProvider().getAcctItems(tmpCondition);
                    this.putMnsSingleData(columnValue, calcKey, null, false);
                }
            }
        }
    }

    private void putMnsSingleData(Map columnValue, MnsCalcKey calcKey, Set companyIdSet, boolean isFeignCalc) {
        if (this.sinColColl.isEmpty()) {
            return;
        }
        String itemNumber2 = null;
        Integer rowIndex = null;
        String key = null;
        MnsColumnInfo columnInfo = null;
        Set itemNumberSet = this.itemNumbers.keySet();
        BigDecimal result = null;
        boolean sign = false;
        if (isFeignCalc && !this.mnsRptCalcParam.isSupportCrossMerger) {
            sign = true;
        }
        MnsColumnInfo sumColumnInfo = this.getSumColumnInfo(this.sumColColl, calcKey);
        int j = this.sinColColl.size();
        for (int i = 0; i < j; ++i) {
            columnInfo = this.sinColColl.get(i);
            if (companyIdSet != null && !companyIdSet.contains(columnInfo.companyId) || !calcKey.equals(columnInfo.calcKey)) continue;
            for (String itemNumber2 : itemNumberSet) {
                key = isFeignCalc ? itemNumber2 : new StringBuffer(itemNumber2).append("!").append(columnInfo.companyId).toString();
                result = columnValue == null ? null : (BigDecimal)columnValue.remove(key);
                if (result == null) continue;
                this.calcMnsSummary(sumColumnInfo, itemNumber2, result);
                this.calcMnsSummary(columnInfo, itemNumber2, result);
                rowIndex = (Integer)this.itemRows.get(itemNumber2);
                this.putMnsData(result, columnInfo.col, rowIndex);
            }
        }
    }

    private MnsColumnInfo getSumColumnInfo(MnsColumnCollection sumColColl, MnsCalcKey calcKey) {
        int count = sumColColl.size();
        MnsColumnInfo columnInfo = null;
        for (int i = 0; i < count; ++i) {
            columnInfo = sumColColl.get(i);
            if (!calcKey.equals(columnInfo.calcKey)) continue;
            return columnInfo;
        }
        return null;
    }

    private void calcMnsSummary(MnsColumnInfo sumColumnInfo, String itemNumber, BigDecimal result) {
        if (sumColumnInfo != null) {
            sumColumnInfo.addForSum(itemNumber, result);
        }
    }
}

