/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.reportcalc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IItemFieldMapped;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.ItemFieldMappedFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.SumRptException;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.ElimDataUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcAdjustData;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcClearSingleData;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcCombineData;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcElimData;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcExcludeSinData;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcParam;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcSingleData;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcSummaryData;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.MnsRptParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.RptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsCalcKey;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsColumnCollection;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.samecontrol.SameControlUtil;
import com.kingdee.eas.fi.newrpt.samecontrol.mnsCalc.MnsDisposalColumnCollection;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MnsRptCalcHelper {
    private static final String T_ELIM = "T_CSL_ELIMINATION";
    private static final String T_HISELIM = "T_CSL_HISELIMINATION";
    private static final String T_ELIM_ENTRY = "T_CSL_ElIMINATIONENTRY";
    private static final String T_HISELIM_ENTRY = "T_CSL_HISElIMINATIONENTRY";
    private static final String T_ITEM = "T_CSL_RPTITEM";

    private MnsRptCalcHelper() {
    }

    public static Map _calculateMnsReport(Context ctx, MnsRptParamInfo mnsRptParamInfo) throws BOSException, EASBizException {
        if (mnsRptParamInfo == null || StringUtils.isEmpty((String)mnsRptParamInfo.getReportID())) {
            return null;
        }
        MnsRptCalcParam mnsRptCalcParam = new MnsRptCalcParam(ctx, mnsRptParamInfo);
        Map tableFormulas = mnsRptParamInfo.getTableFormulas();
        Iterator iterSheets = tableFormulas.keySet().iterator();
        HashMap sheetData = null;
        String sheetID = null;
        List itemList = null;
        Map items = null;
        try {
            IItemFieldMapped fieldMapped = ItemFieldMappedFactory.getLocalInstance(ctx);
            while (iterSheets.hasNext()) {
                sheetID = (String)iterSheets.next();
                sheetData = (HashMap)tableFormulas.get(sheetID);
                HashMap hmItems = (HashMap)sheetData.get("KEY_ITEMS");
                HashMap hmParams = (HashMap)sheetData.get("KEY_PARAMS");
                if (hmItems == null || hmParams == null) continue;
                mnsRptParamInfo.reSetCompanyMap();
                HashMap[] hashMaps = MnsRptCalcHelper.getItemNumbers(hmItems);
                HashMap itemNumbers = hashMaps[0];
                HashMap itemRows = hashMaps[1];
                itemList = CslRptUtil.hashMapToList(itemNumbers);
                items = fieldMapped.getHiberMapInfoByItemNumbers(itemList);
                MnsRptCalcHelper.calcMns(ctx, mnsRptCalcParam, itemNumbers, hmParams, itemRows, items, sheetData, sheetID);
                sheetData.remove("KEY_ITEMS");
                sheetData.remove("KEY_PARAMS");
                sheetData.remove("KEY_CUR_ORGBOUND_ID");
                sheetData.remove("KEY_CUR_ORGBOUND_NUMBER");
                sheetData.remove("KEY_CUR_ORGBOUNDGROUP_ID");
                sheetData.remove("KEY_CUR_ORGBOUNDGROUP_NUMBER");
            }
        }
        catch (EASBizException e) {
            throw new SumRptException(SumRptException.DBEXCEPTION, e);
        }
        catch (CloneNotSupportedException e) {
            throw new SumRptException(SumRptException.DBEXCEPTION, e);
        }
        return tableFormulas;
    }

    private static HashMap[] getItemNumbers(Map hmItems) {
        HashMap itemNumbers = new HashMap();
        HashMap itemRows = new HashMap();
        for (Object rowIndex : hmItems.keySet()) {
            Object itemNumber = hmItems.get(rowIndex);
            itemNumbers.put(itemNumber, null);
            itemRows.put(itemNumber, rowIndex);
        }
        return new HashMap[]{itemNumbers, itemRows};
    }

    private static void calcMns(Context ctx, MnsRptCalcParam mnsRptCalcParam, HashMap itemNumbers, Map hmParams, Map itemRows, Map items, Map sheetData, String sheetID) throws EASBizException, BOSException, CloneNotSupportedException {
        Integer columnKey = null;
        ItemFormula curFormula = null;
        ItemFormula firstFormula = null;
        Iterator iterColumn = hmParams.keySet().iterator();
        MnsColumnCollection sinColColl = null;
        if (mnsRptCalcParam.isSupportCrossMerger && mnsRptCalcParam.mnsRptParamInfo.isSupportHandSingleData()) {
            sinColColl = (MnsColumnCollection)mnsRptCalcParam.mnsRptParamInfo.getSingleDataMap().get(sheetID);
        }
        if (sinColColl == null) {
            sinColColl = new MnsColumnCollection(hmParams.size());
        }
        MnsColumnCollection clearSinColColl = new MnsColumnCollection(hmParams.size());
        MnsColumnCollection excludeSinColColl = new MnsColumnCollection(hmParams.size());
        MnsDisposalColumnCollection disposalSinColColl = new MnsDisposalColumnCollection(hmParams.size());
        MnsColumnCollection sumColColl = new MnsColumnCollection(4);
        MnsColumnCollection excludeSumColColl = new MnsColumnCollection(4);
        MnsColumnCollection elimColColl = null;
        if (mnsRptCalcParam.isSupportCrossMerger && mnsRptCalcParam.mnsRptParamInfo.getRelateElimColColl() != null) {
            elimColColl = (MnsColumnCollection)mnsRptCalcParam.mnsRptParamInfo.getRelateElimColColl().get(sheetID);
        }
        if (elimColColl == null) {
            elimColColl = new MnsColumnCollection(8);
        }
        MnsColumnCollection comColColl = new MnsColumnCollection(4);
        HashMap<Integer, Map<Integer, MnsColumnCollection>> dataType_AdjustTypeColl = new HashMap<Integer, Map<Integer, MnsColumnCollection>>();
        for (Integer dataType : new Integer[]{1, 2, 3}) {
            HashMap<Integer, MnsColumnCollection> adjustType_Coll = new HashMap<Integer, MnsColumnCollection>();
            MnsColumnCollection adjustColl = new MnsColumnCollection(hmParams.size());
            if (dataType == 1) {
                adjustType_Coll.put(12, sinColColl);
                adjustType_Coll.put(11, new MnsColumnCollection(hmParams.size()));
                adjustType_Coll.put(10, adjustColl);
            } else {
                adjustType_Coll.put(12, new MnsColumnCollection(hmParams.size()));
                adjustType_Coll.put(11, dataType == 2 ? sumColColl : comColColl);
                adjustType_Coll.put(10, adjustColl);
            }
            dataType_AdjustTypeColl.put(dataType, adjustType_Coll);
        }
        boolean isFirst = true;
        String adjustType = null;
        while (iterColumn.hasNext()) {
            columnKey = (Integer)iterColumn.next();
            int columnIndex = columnKey;
            curFormula = (ItemFormula)hmParams.get(columnKey);
            int columnDataType = Integer.valueOf(curFormula.getExt("DataSrc"));
            if (isFirst) {
                MnsRptCalcHelper.offsetYearAndPeriod(mnsRptCalcParam, curFormula);
                MnsRptCalcHelper.setItemDataCondition(mnsRptCalcParam.condition, curFormula);
                firstFormula = curFormula;
                isFirst = false;
            }
            String dataElementNumber = curFormula.getDataElementNumber();
            int valueType = curFormula.getValueType();
            switch (columnDataType) {
                case 1: {
                    String companyID = curFormula.getExt("Company");
                    if (StringUtils.isEmpty((String)companyID)) break;
                    if (!mnsRptCalcParam.isSupportCrossMerger && !mnsRptCalcParam.companys.contains(companyID) && curFormula.getExt("CompanyNumber") != null && mnsRptCalcParam.orgUnits_IdNumber.containsKey(curFormula.getExt("CompanyNumber"))) {
                        companyID = (String)mnsRptCalcParam.orgUnits_IdNumber.get(curFormula.getExt("CompanyNumber"));
                    }
                    if (!StringUtils.isEmpty((String)(adjustType = curFormula.getExt("DATASRCFORADJUST")))) {
                        ((MnsColumnCollection)((Map)dataType_AdjustTypeColl.get(1)).get(Integer.valueOf(adjustType))).add(columnIndex, companyID, dataElementNumber, valueType);
                        break;
                    }
                    sinColColl.add(columnIndex, companyID, dataElementNumber, valueType);
                    break;
                }
                case 9: {
                    String clearCompanyID = curFormula.getExt("Company");
                    if (StringUtils.isEmpty((String)clearCompanyID)) break;
                    if (!mnsRptCalcParam.isSupportCrossMerger && !mnsRptCalcParam.companys.contains(clearCompanyID) && curFormula.getExt("CompanyNumber") != null && mnsRptCalcParam.orgUnits_IdNumber.containsKey(curFormula.getExt("CompanyNumber"))) {
                        String string = (String)mnsRptCalcParam.orgUnits_IdNumber.get(curFormula.getExt("CompanyNumber"));
                    }
                    clearSinColColl.add(columnIndex, clearCompanyID, dataElementNumber, valueType);
                    break;
                }
                case 13: {
                    String disposalCompanyID = curFormula.getExt("Company");
                    if (StringUtils.isEmpty((String)disposalCompanyID)) break;
                    disposalSinColColl.add(columnIndex, disposalCompanyID, dataElementNumber, valueType, curFormula.getExt("CompanyNumber"), "1".equals(curFormula.getExt("isunion")));
                    FullOrgUnitInfo unitInfo = new FullOrgUnitInfo();
                    unitInfo.setNumber(curFormula.getExt("CompanyNumber"));
                    unitInfo.setIsUnion("1".equals(curFormula.getExt("isunion")));
                    mnsRptCalcParam.disposalCompnays.put(disposalCompanyID, unitInfo);
                    break;
                }
                case 2: {
                    adjustType = curFormula.getExt("DATASRCFORADJUST");
                    if (!StringUtils.isEmpty((String)adjustType)) {
                        ((MnsColumnCollection)((Map)dataType_AdjustTypeColl.get(2)).get(Integer.valueOf(adjustType))).add(columnIndex, mnsRptCalcParam.report.getOrgUnit().getId().toString(), dataElementNumber, valueType);
                        break;
                    }
                    sumColColl.add(columnIndex, dataElementNumber, valueType);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    elimColColl.add(columnIndex, columnDataType, dataElementNumber, valueType);
                    break;
                }
                case 3: {
                    adjustType = curFormula.getExt("DATASRCFORADJUST");
                    if (!StringUtils.isEmpty((String)adjustType)) {
                        ((MnsColumnCollection)((Map)dataType_AdjustTypeColl.get(3)).get(Integer.valueOf(adjustType))).add(columnIndex, mnsRptCalcParam.report.getOrgUnit().getId().toString(), dataElementNumber, valueType);
                        break;
                    }
                    comColColl.add(columnIndex, dataElementNumber, valueType);
                    break;
                }
            }
        }
        MnsRptCalcHelper.calcMns(ctx, mnsRptCalcParam, itemNumbers, itemRows, items, sheetData, sheetID, sinColColl, clearSinColColl, excludeSinColColl, disposalSinColColl, sumColColl, excludeSumColColl, elimColColl, comColColl, dataType_AdjustTypeColl, firstFormula);
        dataType_AdjustTypeColl.clear();
    }

    private static void calcMns(Context ctx, MnsRptCalcParam mnsRptCalcParam, HashMap itemNumbers, Map itemRows, Map items, Map sheetData, String sheetID, MnsColumnCollection sinColColl, MnsColumnCollection clearSinColColl, MnsColumnCollection excludeSinColColl, MnsDisposalColumnCollection disposalSinColColl, MnsColumnCollection sumColColl, MnsColumnCollection excludeSumColColl, MnsColumnCollection elimColColl, MnsColumnCollection comColColl, Map<Integer, Map<Integer, MnsColumnCollection>> dataType_AdjustTypeColl, ItemFormula curFormula) throws EASBizException, BOSException, CloneNotSupportedException {
        boolean excludeSinColCollIsEmpty = excludeSinColColl.isEmpty();
        boolean sumColCollIsEmpty = sumColColl.isEmpty();
        boolean excludeSumColCollIsEmpty = excludeSumColColl.isEmpty();
        boolean clearSinColCollIsEmpty = clearSinColColl.isEmpty();
        int calcKeySize = comColColl.getMnsCalcKeySet().size();
        if (excludeSinColCollIsEmpty || sumColCollIsEmpty || excludeSumColCollIsEmpty || calcKeySize > excludeSinColColl.getMnsCalcKeySet().size() || calcKeySize > sumColColl.getMnsCalcKeySet().size() || calcKeySize > excludeSumColColl.getMnsCalcKeySet().size()) {
            Iterator itr = comColColl.getMnsCalcKeySet().iterator();
            MnsCalcKey calcKey = null;
            while (itr.hasNext()) {
                calcKey = (MnsCalcKey)itr.next();
                if (excludeSinColCollIsEmpty || calcKeySize > excludeSinColColl.getMnsCalcKeySet().size()) {
                    excludeSinColColl.add(-1, calcKey.dataElementNumber, calcKey.valueType);
                }
                if (sumColCollIsEmpty || calcKeySize > sumColColl.getMnsCalcKeySet().size()) {
                    sumColColl.add(-1, calcKey.dataElementNumber, calcKey.valueType);
                }
                if (excludeSumColCollIsEmpty || calcKeySize > excludeSumColColl.getMnsCalcKeySet().size()) {
                    excludeSumColColl.add(-1, calcKey.dataElementNumber, calcKey.valueType);
                }
                if (!clearSinColCollIsEmpty) continue;
                sumColColl.add(-1, calcKey.dataElementNumber, calcKey.valueType);
            }
        }
        MnsRptCalcSingleData calcSingleData = new MnsRptCalcSingleData(mnsRptCalcParam);
        calcSingleData.setMnsColumnCollection(sinColColl);
        calcSingleData.initParams(itemNumbers, itemRows, sheetData, items);
        calcSingleData.setSumColColl(sumColColl);
        calcSingleData.setCurFormula(curFormula);
        calcSingleData.calcData();
        MnsRptCalcHelper.calAdjust(1, dataType_AdjustTypeColl, mnsRptCalcParam, itemNumbers, itemRows, items, sheetData, curFormula);
        sinColColl.clear();
        MnsRptCalcClearSingleData clearSingleData = new MnsRptCalcClearSingleData(mnsRptCalcParam);
        clearSingleData.setMnsColumnCollection(clearSinColColl);
        clearSingleData.initParams(itemNumbers, itemRows, sheetData, items);
        clearSingleData.setSumColColl(sumColColl);
        clearSingleData.setCurFormula(curFormula);
        clearSingleData.calcData();
        MnsRptCalcExcludeSinData calcExcludeSingleData = new MnsRptCalcExcludeSinData(mnsRptCalcParam);
        calcExcludeSingleData.setMnsColumnCollection(excludeSinColColl);
        calcExcludeSingleData.initParams(itemNumbers, itemRows, sheetData, items);
        calcExcludeSingleData.setSumColColl(sumColColl);
        calcExcludeSingleData.setExcludeSumSumColColl(excludeSumColColl);
        calcExcludeSingleData.setCurFormula(curFormula);
        calcExcludeSingleData.calcData();
        MnsRptCalcSummaryData calcSummaryData = new MnsRptCalcSummaryData(mnsRptCalcParam);
        calcSummaryData.setMnsColumnCollection(sumColColl);
        calcSummaryData.initParams(itemNumbers, itemRows, sheetData, items);
        calcSummaryData.calcData();
        MnsRptCalcHelper.calAdjust(2, dataType_AdjustTypeColl, mnsRptCalcParam, itemNumbers, itemRows, items, sheetData, curFormula);
        MnsRptCalcSummaryData calcExcludeSummaryData = new MnsRptCalcSummaryData(mnsRptCalcParam);
        calcExcludeSummaryData.setMnsColumnCollection(excludeSumColColl);
        calcExcludeSummaryData.initParams(itemNumbers, itemRows, sheetData, items);
        calcExcludeSummaryData.calcData();
        MnsRptCalcElimData calcElimData = new MnsRptCalcElimData(mnsRptCalcParam);
        calcElimData.setMnsColumnCollection(elimColColl);
        calcElimData.initParams(itemNumbers, itemRows, sheetData, items);
        calcElimData.setFeignCalc(false);
        calcElimData.setSheetID(sheetID);
        calcElimData.calcData();
        String parentCompanyID = mnsRptCalcParam.report.getOrgUnit().getId().toString();
        MnsRptCalcCombineData calcCombineData = new MnsRptCalcCombineData(mnsRptCalcParam);
        calcCombineData.setMnsColumnCollection(comColColl);
        calcCombineData.initParams(itemNumbers, itemRows, sheetData, items);
        calcCombineData.setFeignCalc(false);
        calcCombineData.setSheetID(sheetID);
        calcCombineData.setElimColColl(elimColColl);
        calcCombineData.setSumColColl(excludeSumColColl);
        calcCombineData.setClearColColl(clearSinColColl);
        calcCombineData.setParentCompanyID(parentCompanyID);
        calcCombineData.setCurFormula(curFormula);
        HashMap<String, MnsDisposalColumnCollection> disposalMnsColumnCollMap = new HashMap<String, MnsDisposalColumnCollection>();
        if (disposalSinColColl != null && !disposalSinColColl.isEmpty()) {
            disposalMnsColumnCollMap.put(mnsRptCalcParam.report.getYear() + "," + mnsRptCalcParam.report.getPeriod(), disposalSinColColl);
        }
        calcCombineData.setDisposalMnsColumnCollMap(disposalMnsColumnCollMap);
        calcCombineData.calcData();
        MnsRptCalcHelper.calAdjust(3, dataType_AdjustTypeColl, mnsRptCalcParam, itemNumbers, itemRows, items, sheetData, curFormula);
        SameControlUtil.calMnsDisposal((Context)ctx, (MnsRptCalcParam)mnsRptCalcParam, (HashMap)itemNumbers, (Map)itemRows, (Map)items, (Map)sheetData, (String)sheetID, disposalMnsColumnCollMap, (MnsColumnCollection)sumColColl, (MnsColumnCollection)comColColl, dataType_AdjustTypeColl);
    }

    private static void calAdjust(int colDataType, Map<Integer, Map<Integer, MnsColumnCollection>> dataType_AdjustTypeColl, MnsRptCalcParam mnsRptCalcParam, HashMap itemNumbers, Map itemRows, Map items, Map sheetData, ItemFormula curFormula) throws EASBizException, BOSException, CloneNotSupportedException {
        Map<Integer, MnsColumnCollection> adjustMap = dataType_AdjustTypeColl.get(colDataType);
        MnsColumnCollection adjustBeforeColl = null;
        MnsColumnCollection adjustColl = null;
        MnsColumnCollection adjustAfterColl = null;
        if (adjustMap != null) {
            adjustBeforeColl = adjustMap.get(11);
            adjustColl = adjustMap.get(10);
            adjustAfterColl = adjustMap.get(12);
        }
        if (colDataType == 1 && (adjustBeforeColl != null && !adjustBeforeColl.isEmpty() || adjustColl != null && !adjustColl.isEmpty()) || colDataType != 1 && (adjustAfterColl != null && !adjustAfterColl.isEmpty() || adjustColl != null && !adjustColl.isEmpty())) {
            MnsRptCalcAdjustData calcAdjustData = new MnsRptCalcAdjustData(mnsRptCalcParam);
            calcAdjustData.setMnsColumnCollection(colDataType == 1 ? adjustAfterColl : adjustBeforeColl);
            calcAdjustData.initParams(itemNumbers, itemRows, sheetData, items);
            calcAdjustData.setSumColColl(null);
            calcAdjustData.setCurFormula(curFormula);
            calcAdjustData.setAdjustBeforeColl(adjustBeforeColl);
            calcAdjustData.setAdjustColl(adjustColl);
            calcAdjustData.setAdjustAfterColl(adjustAfterColl);
            calcAdjustData.setColDataType(colDataType);
            calcAdjustData.calcData();
        }
    }

    protected static String getTempElimIDTable(Context ctx, ItemDataCondition condition, MnsColumnCollection elimColColl, MnsRptParamInfo mnsRptParamInfo, Map itemNumbers, String currOrgTreeId, String currOrgUnitId) throws EASBizException, BOSException {
        return ElimDataUtil.getTempElimIDTable(ctx, condition, mnsRptParamInfo, currOrgTreeId, currOrgUnitId);
    }

    private static void offsetYearAndPeriod(MnsRptCalcParam mnsRptCalcParam, ItemFormula curFormula) throws EASBizException, BOSException {
        int reportYear = mnsRptCalcParam.report.getYear();
        short reportPeriod = mnsRptCalcParam.report.getPeriod();
        RptPeriodTypeEnum rptPeriodType = mnsRptCalcParam.report.getPeriodType();
        RptCalcHelper.offsetYearAndPeriod(mnsRptCalcParam.isMergeByFiscalPeriod, mnsRptCalcParam.isSupport13Period, rptPeriodType, reportYear, reportPeriod, curFormula, mnsRptCalcParam.periods);
    }

    public static void setItemDataCondition(ItemDataCondition condition, ItemFormula curFormula) {
        condition.setValueType(curFormula.getValueType());
        condition.setRptYearStart(curFormula.getYear());
        condition.setRptPeriodStart(curFormula.getPeriod());
        condition.setRptYearEnd(curFormula.getYear());
        condition.setRptPeriodEnd(curFormula.getPeriod());
    }

    protected static SelectorItemCollection getSelectors(boolean WidthData) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isPublished"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("startDate"));
        if (WidthData) {
            sic.add(new SelectorItemInfo("data"));
        }
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("sourceCurrency"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("publicStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        return sic;
    }

    public static List _sendBackedCompany(Context ctx, IObjectPK reportid, Map itemFormulas) throws BOSException, EASBizException {
        ArrayList<String> arrayList;
        StringBuffer sql;
        String tmpTableName;
        PreparedStatement prepareStatement;
        Connection connection;
        TempTablePool pool;
        ParamTempTblService paramSrv;
        StringBuffer orpart;
        CslReportInfo rpt;
        block25: {
            Object[] objs;
            boolean[] v = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_INCLUDE_SENDBACKED_001", "GR_CSL_Support13Period", "GR_CSL_MergeByFiscalPeriod"});
            if (!v[0]) {
                return null;
            }
            boolean isSupport13Period = v[1];
            rpt = CslReportFactory.getLocalInstance(ctx).getCslReportInfo(reportid, MnsRptCalcHelper.getSelectors(false));
            PeriodCollection periods = null;
            boolean isMergeByFiscalPeriod = v[2];
            if (isMergeByFiscalPeriod) {
                periods = FiscalPeriodHelper.getPeriodCollection(ctx, rpt);
            }
            Iterator iterSheets = itemFormulas.entrySet().iterator();
            HashMap<String, Object[]> datatype_element = new HashMap<String, Object[]>();
            HashSet<String> itemNumSet = new HashSet<String>();
            while (iterSheets.hasNext()) {
                HashMap sheetData = (HashMap)iterSheets.next().getValue();
                if (sheetData.get("KEY_ITEMS") == null || sheetData.get("KEY_PARAMS") == null) continue;
                HashMap hmItems = (HashMap)sheetData.get("KEY_ITEMS");
                HashMap hmParams = (HashMap)sheetData.get("KEY_PARAMS");
                HashMap<String, Object> itemNumbers = new HashMap<String, Object>();
                HashMap<String, Integer> itemRows = new HashMap<String, Integer>();
                for (Integer rowIndex : hmItems.keySet()) {
                    String itemNumber = (String)hmItems.get(rowIndex);
                    itemNumSet.add(itemNumber);
                    itemNumbers.put(itemNumber, null);
                    itemRows.put(itemNumber, rowIndex);
                }
                for (Integer columnKey : hmParams.keySet()) {
                    ItemFormula curFormula = (ItemFormula)hmParams.get(columnKey);
                    int columnDataType = Integer.valueOf(curFormula.getExt("DataSrc"));
                    if (isSupport13Period) {
                        RPTDate13Util.getRptYearAndPeriod(curFormula, rpt.getYear(), rpt.getPeriod(), rpt.getPeriodType(), isSupport13Period);
                    } else {
                        FiscalPeriodHelper.getRptYearAndPeriod(periods, curFormula, rpt.getYear(), rpt.getPeriod(), rpt.getPeriodType(), isMergeByFiscalPeriod);
                    }
                    switch (columnDataType) {
                        case 1: {
                            String companyID = curFormula.getExt("Company");
                            if (StringUtils.isEmpty((String)companyID)) break;
                            int element = DataElementProvider.getDataElementInnerValue(ctx, curFormula.getDataElementNumber());
                            int type = curFormula.getValueType();
                            if (datatype_element.containsKey(companyID + element + '_' + type)) break;
                            datatype_element.put(companyID + element + '_' + type, new Object[]{companyID, new Integer(element), new Integer(type)});
                        }
                    }
                }
            }
            Iterator it = datatype_element.values().iterator();
            orpart = new StringBuffer();
            TableInfo table = new TableInfo("T_TPL_ITEMS");
            table.addColumn("ItemNumber", "varchar(100)");
            paramSrv = ParamTempTblService.getInstance(ctx, table, itemNumSet, null);
            pool = TempTablePool.getInstance((Context)ctx);
            connection = null;
            prepareStatement = null;
            tmpTableName = null;
            sql = new StringBuffer();
            if (datatype_element.size() > 20) {
                sql.append("create table t_csl_companyDataType(FCompanyID VARCHAR(44),FDataElement int,FValueType int)");
                tmpTableName = pool.createTempTable(sql.toString());
                sql.setLength(0);
                sql.append("insert into ").append(tmpTableName).append("(FCompanyID,FDataElement,FValueType) values(?,?,?)");
                connection = EJBFactory.getConnection((Context)ctx);
                prepareStatement = connection.prepareStatement(sql.toString());
                while (it.hasNext()) {
                    objs = (Object[])it.next();
                    prepareStatement.setObject(1, objs[0]);
                    prepareStatement.setObject(2, objs[1]);
                    prepareStatement.setObject(3, objs[2]);
                    prepareStatement.addBatch();
                }
                prepareStatement.executeBatch();
                prepareStatement.clearBatch();
                break block25;
            }
            while (it.hasNext()) {
                objs = (Object[])it.next();
                if (orpart.length() > 1) {
                    orpart.append(" or ");
                }
                orpart.append(" ( ItemDataBd.FCompanyID = '").append(objs[0]).append('\'');
                orpart.append(" and ItemDataBd.FDataElement = ").append(objs[1]);
                orpart.append(" and ItemDataBd.FValueType = ").append(objs[2]);
                orpart.append(" ) \n");
            }
            if (orpart.length() > 0) break block25;
            objs = null;
            paramSrv.release();
            if (!StringUtils.isEmpty((String)tmpTableName)) {
                pool.releaseTable(tmpTableName);
            }
            SQLUtils.cleanup(null, prepareStatement, connection);
            return objs;
        }
        try {
            sql.setLength(0);
            sql.append("Select distinct org.fnumber,org.fname_").append(ctx.getLocale()).append("\n from  T_CSL_ItemDataEntry ItemDataBd ").append("\n Inner join T_Csl_RptReceived Received on Received.FReportID = ItemDataBd.FReportID ").append("\n inner join t_csl_cslreport report on report.fid= Received.FReportID ").append("\n  inner join t_csl_templetitemlist itemlist on itemlist.ftemplateid=report.ftemplateid ").append("\n inner join t_org_baseunit org on ItemDataBd.FCompanyID=org.fid ");
            if (!StringUtils.isEmpty((String)tmpTableName)) {
                sql.append(" inner join ").append(tmpTableName).append(" tmpTable on (tmpTable.FCompanyID=ItemDataBd.FCompanyID").append(" and tmpTable.FDataElement=ItemDataBd.FDataElement and ItemDataBd.FValueType=tmpTable.FValueType) ");
            }
            sql.append("\n where 1=1 And Received.FOrgTreeID = '" + rpt.getOrgTree().getId() + "'").append("\n\t\t and ItemDataBd.FTargetCurrencyID = '" + rpt.getCurrency().getId() + "' ").append("\n\t\t and ItemDataBd.FPeriodType = ").append(rpt.getPeriodType().getValue()).append("\n\t\t and ItemDataBd.FYear = ").append(rpt.getYear()).append("\n\t\t and ItemDataBd.FPeriod = ").append(rpt.getPeriod()).append("\n\t\t AND ItemDataBd.FDataSource in(1,3,7)").append("\n\t\t and report.fReceiveStatus=1 ").append(" and itemlist.fitemnumber in (").append(paramSrv.getParamsSql()).append(") ");
            if (StringUtils.isEmpty((String)tmpTableName)) {
                sql.append("\n\t\t and (").append(orpart).append(')');
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<String> result = new ArrayList<String>();
            while (rs.next()) {
                result.add(rs.getString(2) + "  [" + rs.getString(1) + "]");
            }
            arrayList = result;
            paramSrv.release();
        }
        catch (Exception e) {
            try {
                Logger.error((Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                paramSrv.release();
                if (!StringUtils.isEmpty(tmpTableName)) {
                    pool.releaseTable(tmpTableName);
                }
                SQLUtils.cleanup(null, prepareStatement, connection);
                throw throwable;
            }
        }
        if (!StringUtils.isEmpty((String)tmpTableName)) {
            pool.releaseTable(tmpTableName);
        }
        SQLUtils.cleanup(null, (Statement)prepareStatement, (Connection)connection);
        return arrayList;
    }

    public static Map _getElimDataByItems(Context ctx, Map paramMap) throws BOSException, EASBizException {
        ItemDataCondition condition = (ItemDataCondition)paramMap.get("condition");
        boolean isQueryBudget = (Boolean)paramMap.get("isQueryBudget");
        boolean isSupportCrossMerger = false;
        if (paramMap.get("isSupportCrossMerger") != null) {
            isSupportCrossMerger = Boolean.TRUE.equals(paramMap.get("isSupportCrossMerger"));
        }
        if (isSupportCrossMerger) {
            String tempElimIDTable = (String)paramMap.get("tempElimIDTable");
            Map relateValueMap = (Map)paramMap.get("relateValueMap");
            if (relateValueMap != null) {
                return MnsRptCalcHelper.getElimDataByItems(ctx, tempElimIDTable, condition, isQueryBudget, relateValueMap);
            }
            return MnsRptCalcHelper.getElimDataByItems(ctx, tempElimIDTable, condition, isQueryBudget);
        }
        Object isSupportHandElim = paramMap.get("isSupportHandElim");
        if (isSupportHandElim != null && Boolean.TRUE.equals(isSupportHandElim)) {
            return MnsRptCalcHelper.getHandElimDataByItems(ctx, paramMap, condition, isQueryBudget);
        }
        return MnsRptCalcHelper._getElimByItems(ctx, condition, isQueryBudget);
    }

    public static Map _getElimByItems(Context ctx, ItemDataCondition condition, boolean isQueryBudget) throws EASBizException, BOSException {
        return MnsRptCalcHelper.getElimDataByItems(ctx, null, condition, isQueryBudget);
    }

    private static Map getElimDataByItems(Context ctx, String tempElimIDTable, ItemDataCondition condition, boolean isQueryBudget) throws BOSException, EASBizException {
        try {
            ArrayList params = new ArrayList();
            String strSQL = null;
            strSQL = tempElimIDTable == null ? MnsRptCalcHelper.getSumElimSQL(ctx, null, condition, isQueryBudget, false, params) : MnsRptCalcHelper.getSumElimSQL(ctx, tempElimIDTable, condition, isQueryBudget, true, params);
            HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(condition.getItemList());
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL, (Object[])params.toArray());
            while (rs.next()) {
                String number = rs.getString("FItemNumber").trim();
                BigDecimal sumResult = rs.getBigDecimal("FValue");
                result.put(number, sumResult);
            }
            return result;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static Map getElimDataByItems(Context ctx, String tempElimIDTable, ItemDataCondition condition, boolean isQueryBudget, Map relateValueMap) throws BOSException, EASBizException {
        try {
            ArrayList params = new ArrayList();
            String strSQL = null;
            strSQL = tempElimIDTable == null ? MnsRptCalcHelper.getSumElimSQL(ctx, null, condition, isQueryBudget, false, params) : MnsRptCalcHelper.getSumElimSQL(ctx, tempElimIDTable, condition, isQueryBudget, true, params);
            HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(condition.getItemList());
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL, (Object[])params.toArray());
            while (rs.next()) {
                String number = rs.getString("FItemNumber").trim();
                BigDecimal sumResult = rs.getBigDecimal("FValue");
                if (relateValueMap.containsKey(number) && relateValueMap.get(number) != null) {
                    sumResult = ((BigDecimal)relateValueMap.get(number)).add(sumResult);
                }
                result.put(number, sumResult);
            }
            return result;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static String getSelectPartElimSQL(int creditEnum) {
        StringBuffer sbSumElim = new StringBuffer();
        if (creditEnum == 0) {
            sbSumElim.append(" SUM(FCredit) AS FValue ");
        } else if (creditEnum == 1) {
            sbSumElim.append(" SUM(FDebit) AS FValue  ");
        } else if (creditEnum == 2) {
            sbSumElim.append(" CASE WHEN (Sum(FDebit) Is Null and Sum(FCredit) Is Null) THEN 0  ELSE ISNULL(SUM(FDebit*(1-item.fdc*2)),0)+ISNULL(SUM(FCredit*(item.fdc*2-1)),0) END AS FValue ");
        } else {
            sbSumElim.append(" CASE WHEN (Sum(FDebit) Is Null and Sum(FCredit) Is Null) THEN 0  ELSE ISNULL(SUM(FDebit*(1-item.fdc*2)),0)+ISNULL(SUM(FCredit*(item.fdc*2-1)),0) END AS FValue ");
        }
        return sbSumElim.toString();
    }

    private static String getSumElimSQL(Context ctx, String tempElimIDTable, ItemDataCondition condition, boolean isQueryBudget, boolean isSupportCrossMerger, List params) throws SumRptException {
        if (!isSupportCrossMerger) {
            MnsRptCalcHelper.checkItemDataCondition(condition);
        }
        String items = CSLServerHelper.getOrStringByMap(condition.getItemList(), "Item", "FNumber");
        StringBuffer sbSumElim = new StringBuffer();
        sbSumElim.append(" SELECT Item.Fnumber AS FItemNumber, ");
        sbSumElim.append(MnsRptCalcHelper.getSelectPartElimSQL(condition.getDebitOrCredit()));
        sbSumElim.append(" FROM ");
        if (isSupportCrossMerger) {
            sbSumElim.append(" T_CSL_ElIMINATIONENTRY ElimEntry INNER JOIN ");
            sbSumElim.append(tempElimIDTable).append(" tmp ON tmp.FID = ElimEntry.FEliminationID ");
            sbSumElim.append(" INNER JOIN T_CSL_ELIMINATION AS Elim  ");
            sbSumElim.append(" \tON tmp.FID = Elim.FID ");
            sbSumElim.append(" INNER JOIN T_CSL_RPTITEM AS Item  ");
            sbSumElim.append(" \tON ElimEntry.FItemId = Item.Fid ");
            sbSumElim.append(" WHERE ElimEntry.FDataElement = ?  ");
            params.add(new Integer(condition.getDataElement()));
            sbSumElim.append(" AND Elim.FValueType = ?  AND ").append(items);
            params.add(new Integer(condition.getValueType()));
            sbSumElim.append(" GROUP BY Item.Fnumber");
            return sbSumElim.toString();
        }
        sbSumElim.append(isQueryBudget ? T_HISELIM_ENTRY : T_ELIM_ENTRY);
        sbSumElim.append(" AS ElimEntry ").append(" INNER JOIN ");
        sbSumElim.append(isQueryBudget ? T_HISELIM : T_ELIM);
        sbSumElim.append(" AS Elim ON ElimEntry.FEliminationID = Elim.FID ");
        sbSumElim.append(" INNER JOIN T_CSL_RPTITEM AS Item  ");
        sbSumElim.append(" \tON ElimEntry.FItemId = Item.Fid ");
        sbSumElim.append(" INNER JOIN T_ORG_Tree OrgTree ");
        sbSumElim.append(" \tON OrgTree.FID = Elim.FOrgBoundID ");
        if (!StringUtils.isEmpty((String)condition.getParentOrgNumber())) {
            sbSumElim.append(" INNER JOIN T_ORG_BaseUnit OrgUnit ");
            sbSumElim.append(" \tON OrgUnit.FID = Elim.FOrgUnit ");
        }
        sbSumElim.append(" WHERE ");
        sbSumElim.append("  ElimEntry.FDataElement = ? ");
        params.add(new Integer(condition.getDataElement()));
        if (!StringUtils.isEmpty((String)condition.getParentOrgNumber())) {
            sbSumElim.append(" AND OrgUnit.FNumber = ? ");
            params.add(condition.getParentOrgNumber());
        } else {
            sbSumElim.append(" AND Elim.FOrgUnit =").append(condition.getOrgUnitString());
        }
        sbSumElim.append(" AND OrgTree.FNumber = ? ");
        params.add(condition.getOrgTreeNumber());
        if (condition.getCurrency() != null) {
            sbSumElim.append(" AND Elim.FSourceCurrencyId = ? ");
            params.add(condition.getCurrency());
        }
        sbSumElim.append(" AND Elim.FCurrencyID = ? AND Elim.FValueType = ? ");
        params.add(condition.getTargetCurrency());
        params.add(new Integer(condition.getValueType()));
        sbSumElim.append(" AND Elim.FPeriodType = ? ");
        params.add(new Integer(condition.getRptPeriodType()));
        if (condition.getRptYearStart() != -1 && condition.getRptYearStart() == condition.getRptYearEnd() && condition.getRptPeriodStart() != -1 && condition.getRptPeriodStart() == condition.getRptPeriodEnd()) {
            sbSumElim.append(" AND Elim.FYear = ? AND Elim.FPeriod = ? ");
            params.add(new Integer(condition.getRptYearStart()));
            params.add(new Integer(condition.getRptPeriodStart()));
        } else {
            if (condition.getRptYearStart() != -1) {
                sbSumElim.append(" AND (Elim.FYear > ? OR (Elim.FYear = ? ");
                params.add(new Integer(condition.getRptYearStart()));
                params.add(new Integer(condition.getRptYearStart()));
                if (condition.getRptPeriodStart() != -1) {
                    sbSumElim.append(" AND Elim.FPeriod >= ? ");
                    params.add(new Integer(condition.getRptPeriodStart()));
                }
                sbSumElim.append("))");
            }
            if (condition.getRptYearEnd() != -1) {
                sbSumElim.append(" AND (Elim.FYear < ? OR (Elim.FYear = ? ");
                params.add(new Integer(condition.getRptYearEnd()));
                params.add(new Integer(condition.getRptYearEnd()));
                if (condition.getRptPeriodEnd() != -1) {
                    sbSumElim.append(" AND Elim.FPeriod <= ? ");
                    params.add(new Integer(condition.getRptPeriodEnd()));
                }
                sbSumElim.append("))");
            }
        }
        if (!condition.isIncludeUnAuditElim()) {
            sbSumElim.append(" AND Elim.FCheckedStatus = ? ");
            params.add(new Integer(2));
        }
        String dataCollectNumber = null;
        dataCollectNumber = StringUtils.isEmpty((String)condition.getDataCollectNumber()) ? "ACTUALDATA" : condition.getDataCollectNumber();
        sbSumElim.append(" AND Elim.FDataCollectNumber = ? ");
        params.add(dataCollectNumber);
        sbSumElim.append(" AND ").append(items);
        sbSumElim.append(" GROUP BY Item.Fnumber");
        return sbSumElim.toString();
    }

    private static Map getHandElimDataByItems(Context ctx, Map paramMap, ItemDataCondition condition, boolean isQueryBudget) throws BOSException, EASBizException {
        Map customElimValueMap = (Map)paramMap.get("customElimValueMap");
        if (customElimValueMap == null || customElimValueMap.isEmpty() || customElimValueMap.size() == 0) {
            return (Map)paramMap.get("oldelimValues");
        }
        String elimIds = MnsRptCalcHelper.getElimIdSQL(condition, isQueryBudget);
        String items = CSLServerHelper.getOrStringByMap(condition.getItemList(), "Item", "FNumber");
        StringBuffer sbSumElim = new StringBuffer();
        sbSumElim.append("Select Item.Fnumber as FItemNumber,FDebit,FCredit FROM ");
        if (isQueryBudget) {
            sbSumElim.append("T_CSL_HISElIMINATIONENTRY AS ElimEntry ,T_CSL_RPTITEM AS Item");
        } else {
            sbSumElim.append("T_CSL_ElIMINATIONENTRY AS ElimEntry ,T_CSL_RPTITEM AS Item");
        }
        sbSumElim.append(" WHERE ");
        sbSumElim.append(" ElimEntry.FItemId = Item.Fid ");
        sbSumElim.append(" AND FEliminationID in (" + elimIds + ") ");
        sbSumElim.append(" AND ").append(items);
        String dataCollectNumber = condition.getDataCollectNumber();
        if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
            if (isQueryBudget) {
                sbSumElim.append(" AND EXISTS(SELECT 1 FROM T_CSL_HISElIMINATION WHERE FID=ElimEntry.FEliminationID AND FDATACOLLECTNUMBER='" + dataCollectNumber + "') ");
            } else {
                sbSumElim.append(" AND EXISTS(SELECT 1 FROM T_CSL_ElIMINATION WHERE FID=ElimEntry.FEliminationID AND FDATACOLLECTNUMBER='" + dataCollectNumber + "') ");
            }
        }
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSumElim.toString());
            String number = null;
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            while (rs.next()) {
                number = rs.getString("FItemNumber").trim();
                BigDecimal debit = rs.getBigDecimal("FDebit");
                BigDecimal credit = rs.getBigDecimal("FCredit");
                if (debit != null) {
                    if (map.get(number + "-" + 4) != null) {
                        debit = debit.add((BigDecimal)map.get(number + "-" + 4));
                    }
                    map.put(number + "-" + 4, debit);
                }
                if (credit == null) continue;
                if (map.get(number + "-" + 5) != null) {
                    credit = credit.add((BigDecimal)map.get(number + "-" + 5));
                }
                map.put(number + "-" + 5, credit);
            }
            if (map.size() == condition.getItemList().size() * 2) {
                return (Map)paramMap.get("oldelimValues");
            }
            HashMap<String, Integer> dcMap = new HashMap<String, Integer>();
            rs = DbUtil.executeQuery((Context)ctx, (String)("select fnumber,fdc from T_CSL_RPTITEM as Item where " + items));
            while (rs.next()) {
                number = rs.getString("fnumber").trim();
                int fdc = rs.getInt("fdc");
                dcMap.put(number, new Integer(fdc));
            }
            BigDecimal SumDebit = null;
            BigDecimal SumCredit = null;
            Iterator iter = condition.getItemList().keySet().iterator();
            while (iter.hasNext()) {
                BigDecimal credit;
                SumDebit = new BigDecimal("0");
                SumCredit = new BigDecimal("0");
                number = (String)iter.next();
                if (dcMap.get(number) == null) continue;
                int fdc = (Integer)dcMap.get(number);
                BigDecimal debit = (BigDecimal)map.get(number + "-" + 4);
                if (debit == null) {
                    debit = (BigDecimal)customElimValueMap.get(number + "-" + 4);
                }
                if ((credit = (BigDecimal)map.get(number + "-" + 5)) == null) {
                    credit = (BigDecimal)customElimValueMap.get(number + "-" + 5);
                }
                if (debit != null) {
                    SumDebit = SumDebit.add(debit.multiply(new BigDecimal(1 - fdc * 2)));
                }
                if (credit != null) {
                    SumCredit = SumCredit.add(credit.multiply(new BigDecimal(fdc * 2 - 1)));
                }
                result.put(number, SumDebit.add(SumCredit));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private static String getElimIdSQL(ItemDataCondition condition, boolean isQueryBudget) throws SumRptException {
        StringBuffer sbElimId = new StringBuffer();
        MnsRptCalcHelper.checkItemDataCondition(condition);
        sbElimId.append("SELECT Elim.FID FROM ");
        if (isQueryBudget) {
            sbElimId.append(T_HISELIM).append(" AS Elim ");
        } else {
            sbElimId.append(T_ELIM).append(" AS Elim ");
        }
        sbElimId.append("inner join T_ORG_Tree OrgTree on OrgTree.FID = Elim.FOrgBoundID ");
        sbElimId.append(" WHERE ");
        sbElimId.append(" Elim.FOrgUnit = " + condition.getOrgUnitString());
        sbElimId.append(" and OrgTree.FNumber = '" + condition.getOrgTreeNumber() + "'");
        if (condition.getCurrency() != null) {
            sbElimId.append(" and Elim.FSourceCurrencyId = '" + condition.getCurrency() + "'");
        }
        sbElimId.append(" and Elim.FCurrencyID = '" + condition.getTargetCurrency() + "'");
        sbElimId.append(" and Elim.FPeriodType = ").append(condition.getRptPeriodType());
        sbElimId.append(" and ElimEntry.FDataElement =").append(condition.getDataElement());
        sbElimId.append(" and Elim.FValueType = ").append(condition.getValueType());
        if (condition.getRptYearStart() != -1) {
            sbElimId.append(" AND (elim.FYear > ").append(condition.getRptYearStart()).append(" or (elim.FYear =").append(condition.getRptYearStart());
            if (condition.getRptPeriodStart() != -1) {
                sbElimId.append(" AND elim.FPeriod >= ").append(condition.getRptPeriodStart());
            }
            sbElimId.append("))");
        }
        if (condition.getRptYearEnd() != -1) {
            sbElimId.append(" AND (elim.FYear < ").append(condition.getRptYearEnd()).append(" or (elim.FYear =").append(condition.getRptYearEnd());
            if (condition.getRptPeriodEnd() != -1) {
                sbElimId.append(" AND elim.FPeriod <= ").append(condition.getRptPeriodEnd());
            }
            sbElimId.append("))");
        }
        if (!condition.isIncludeUnAuditElim()) {
            sbElimId.append(" and elim.FCheckedStatus = ").append(2);
        }
        String dataCollectNumber = null;
        dataCollectNumber = StringUtils.isEmpty((String)condition.getDataCollectNumber()) ? "ACTUALDATA" : condition.getDataCollectNumber();
        sbElimId.append(" and elim.FDataCollectNumber = '").append(dataCollectNumber).append("'");
        return sbElimId.toString();
    }

    private static void checkItemDataCondition(ItemDataCondition condition) throws SumRptException {
        if (StringUtils.isEmpty((String)condition.getOrgTreeNumber())) {
            Object[] param = new Object[]{"organization"};
            throw new SumRptException(SumRptException.ARGUMENTEXCEPTION, param);
        }
        if (StringUtils.isEmpty((String)condition.getOrgUnitString())) {
            Object[] param = new Object[]{"company"};
            throw new SumRptException(SumRptException.ARGUMENTEXCEPTION, param);
        }
        if (StringUtils.isEmpty((String)condition.getTargetCurrency())) {
            Object[] param = new Object[]{"currency"};
            throw new SumRptException(SumRptException.ARGUMENTEXCEPTION, param);
        }
    }

    public static Map _getElimDataEntryByItem(Context ctx, List params, String orgTreeID, String orgUnitID, String currencyID, int periodType, int iYear, int iPeriod, String dataCollectNumber, boolean isQueryBudget) throws BOSException, EASBizException {
        HashMap<String, Map> returnMap;
        block15: {
            ItemDataCondition condition;
            Map rptItemMap;
            boolean isIncludeUnAuditElim;
            List lstItemElimData;
            Map paramMap;
            block14: {
                String tempElimIDTable;
                block13: {
                    paramMap = (Map)params.get(0);
                    lstItemElimData = (List)paramMap.get("lstItemElimData");
                    MnsRptParamInfo mnsRptParamInfo = (MnsRptParamInfo)paramMap.get("mnsRptParamInfo");
                    boolean isSupportCrossMerger = false;
                    isIncludeUnAuditElim = mnsRptParamInfo.isIncludeUnAuditElim();
                    returnMap = new HashMap<String, Map>(4);
                    rptItemMap = MnsRptCalcHelper.getRptItemMap(lstItemElimData);
                    condition = MnsRptCalcHelper.getItemDataCondition(currencyID, periodType, iYear, iPeriod, dataCollectNumber, paramMap, isIncludeUnAuditElim, rptItemMap);
                    if (!isSupportCrossMerger) break block14;
                    tempElimIDTable = null;
                    try {
                        Object[] dataElementList = (Object[])paramMap.get("DataElement");
                        MnsColumnCollection elimColColl = new MnsColumnCollection(dataElementList.length);
                        DataElementInfo dataElement = null;
                        condition.setValueType(-100);
                        for (int deIndex = 0; deIndex < dataElementList.length; ++deIndex) {
                            dataElement = (DataElementInfo)dataElementList[deIndex];
                            elimColColl.add(-1, dataElement.getNumber(), -100);
                        }
                        condition.setValueType(-100);
                        tempElimIDTable = MnsRptCalcHelper.getTempElimIDTable(ctx, condition, elimColColl, mnsRptParamInfo, rptItemMap, orgTreeID, orgUnitID);
                        StringBuffer strSql = new StringBuffer(" SELECT Item.Fnumber AS FItemNumber,");
                        strSql.append(" elim.FValueType, elimEntry.FDataElement, elim.FNumber as FElimNumber, ");
                        strSql.append(MnsRptCalcHelper.getSelectPartElimSQL(2));
                        strSql.append(" FROM T_CSL_ElIMINATIONENTRY ElimEntry INNER JOIN ");
                        strSql.append(tempElimIDTable).append(" tmp ON tmp.FID = ElimEntry.FEliminationID ");
                        strSql.append(" INNER JOIN T_CSL_ElIMINATION AS elim  ");
                        strSql.append(" ON tmp.FID = elim.FID ");
                        strSql.append(" INNER JOIN T_CSL_RPTITEM AS Item  ");
                        strSql.append(" \tON ElimEntry.FItemId = Item.Fid ");
                        strSql.append(" GROUP BY Item.Fnumber,elim.FNumber,elimEntry.FDataElement, elim.FValueType");
                        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString());
                        Map mapResult = MnsRptCalcHelper.getMapResult(rowSet);
                        returnMap.put("mapResult", mapResult);
                        if (mapResult == null || mapResult.isEmpty()) break block13;
                        Map map4ElimData = MnsRptCalcHelper.getMap4ElimData(ctx, isQueryBudget, orgTreeID, orgUnitID, paramMap, lstItemElimData, condition, tempElimIDTable);
                        returnMap.put("map4ElimData", map4ElimData);
                    }
                    catch (SQLException e) {
                        try {
                            throw new SQLDataException(e);
                        }
                        catch (Throwable throwable) {
                            if (!StringUtils.isEmpty(tempElimIDTable)) {
                                TempTablePool.getInstance((Context)ctx).releaseTable(tempElimIDTable);
                            }
                            throw throwable;
                        }
                    }
                }
                if (!StringUtils.isEmpty((String)tempElimIDTable)) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempElimIDTable);
                }
                break block15;
            }
            StringBuffer strSql = new StringBuffer(" SELECT Item.Fnumber AS FItemNumber,");
            strSql.append(" elim.FValueType, elimEntry.FDataElement, elim.FNumber as FElimNumber, ");
            strSql.append(MnsRptCalcHelper.getSelectPartElimSQL(2));
            if (isQueryBudget) {
                strSql.append(" From T_Csl_HisElimination as elim,T_Csl_HisEliminationEntry as elimEntry,  T_Csl_RptItem as Item");
            } else {
                strSql.append(" From T_Csl_Elimination as elim,T_Csl_EliminationEntry as elimEntry,  T_Csl_RptItem as Item");
            }
            strSql.append(" WHERE ");
            strSql.append(" elimEntry.FItemId = Item.Fid ");
            strSql.append(" AND elimEntry.FEliminationID = elim.FID");
            strSql.append(" And ").append(CSLServerHelper.getOrStringByMap(rptItemMap, "Item", "FNumber"));
            strSql.append(" And elim.FOrgBoundID = '").append(orgTreeID).append("'");
            strSql.append(" And elim.FOrgUnit = '").append(orgUnitID).append("'");
            strSql.append(" And elim.FCurrencyID = '").append(currencyID).append("'");
            strSql.append(" And elim.FYear = ").append(iYear);
            strSql.append(" And elim.FPeriod = ").append(iPeriod);
            strSql.append(" And elim.FPeriodType = ").append(periodType);
            if (!isIncludeUnAuditElim) {
                strSql.append(" And elim.FCheckedStatus = ").append(2);
            }
            strSql.append(" And elim.FDataCollectNumber = '").append(dataCollectNumber).append("'");
            strSql.append(" GROUP BY Item.Fnumber,elim.FNumber,elimEntry.FDataElement, elim.FValueType");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString());
            try {
                Map mapResult = MnsRptCalcHelper.getMapResult(rowSet);
                returnMap.put("mapResult", mapResult);
                if (mapResult != null && !mapResult.isEmpty()) {
                    Map map4ElimData = MnsRptCalcHelper.getMap4ElimData(ctx, isQueryBudget, orgTreeID, orgUnitID, paramMap, lstItemElimData, condition, null);
                    returnMap.put("map4ElimData", map4ElimData);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return returnMap;
    }

    private static Map getMapResult(IRowSet rowSet) throws SQLException {
        HashMap mapResult = null;
        while (rowSet.next()) {
            Map<String, BigDecimal> mapValue;
            Map mapValueType;
            Map mapDataElement;
            BigDecimal bgValue;
            if (mapResult == null) {
                mapResult = new HashMap();
            }
            if ((bgValue = rowSet.getBigDecimal("FValue")) == null) continue;
            String strItemNumber = rowSet.getString("FItemNumber");
            String strElimNumber = rowSet.getString("FElimNumber");
            String dataElement = String.valueOf(rowSet.getInt("FDataElement"));
            String valueType = String.valueOf(rowSet.getInt("FValueType"));
            if (!mapResult.containsKey(strItemNumber)) {
                mapDataElement = new HashMap();
                mapResult.put(strItemNumber, mapDataElement);
            } else {
                mapDataElement = (Map)mapResult.get(strItemNumber);
            }
            if (!mapDataElement.containsKey(dataElement)) {
                mapValueType = new HashMap();
                mapDataElement.put(dataElement, mapValueType);
            } else {
                mapValueType = (Map)mapDataElement.get(dataElement);
            }
            if (!mapValueType.containsKey(valueType)) {
                mapValue = new HashMap();
                mapValueType.put(valueType, mapValue);
            } else {
                mapValue = (Map)mapValueType.get(valueType);
            }
            mapValue.put(strElimNumber, bgValue);
        }
        return mapResult;
    }

    private static Map getMap4ElimData(Context ctx, boolean isQueryBudget, String orgTreeID, String orgUnitID, Map paramMap, List lstItemElimData, ItemDataCondition condition, String tempElimIDTable) throws EASBizException, BOSException {
        HashSet valueTypeSet = new HashSet();
        boolean isNeedCalc = false;
        Map mapData = null;
        Map mapValue = null;
        int j = lstItemElimData.size();
        for (int i = 0; i < j; ++i) {
            mapData = (Map)lstItemElimData.get(i);
            mapValue = (Map)mapData.get("KEY_ELIM_VALUE");
            valueTypeSet.add(mapData.get("ValueType"));
            if (!mapValue.containsKey("KEY_ELIM_DATA")) continue;
            isNeedCalc = true;
        }
        if (!isNeedCalc) {
            valueTypeSet.clear();
            return null;
        }
        HashMap map4ElimData = new HashMap();
        DataElementInfo dataElement = null;
        Object[] dataElementList = (Object[])paramMap.get("DataElement");
        Iterator iter = valueTypeSet.iterator();
        if (tempElimIDTable == null) {
            ArrayList<String> orgLst = new ArrayList<String>(1);
            orgLst.add(orgUnitID);
            condition.setOrgUnit(orgLst);
            OrgTreeInfo treeinfo = (OrgTreeInfo)paramMap.get("KEY_ORGTREE_INFO");
            if (treeinfo != null) {
                condition.setOrgTreeNumber(treeinfo.getNumber());
            }
            condition.setOrgBoundID(orgTreeID);
        }
        while (iter.hasNext()) {
            int valueType = (Integer)iter.next();
            for (int deIndex = 0; deIndex < dataElementList.length; ++deIndex) {
                dataElement = (DataElementInfo)dataElementList[deIndex];
                condition.setDataElement(dataElement.getInterSeq());
                condition.setValueType(valueType);
                condition.setDebitOrCredit(1);
                Map debitValue = MnsRptCalcHelper.getElimDataByItems(ctx, tempElimIDTable, condition, isQueryBudget);
                Iterator itemIterator = debitValue.keySet().iterator();
                String key = "$" + dataElement.getNumber() + "$" + valueType + "$";
                Object rptItemNumber2 = null;
                while (itemIterator.hasNext()) {
                    rptItemNumber2 = itemIterator.next();
                    String key4DebitSum = rptItemNumber2 + key + "DebitSum";
                    if (debitValue.get(rptItemNumber2) == null) continue;
                    map4ElimData.put(key4DebitSum, debitValue.get(rptItemNumber2));
                }
                condition.setDebitOrCredit(0);
                Map creditValue = MnsRptCalcHelper.getElimDataByItems(ctx, tempElimIDTable, condition, isQueryBudget);
                for (Object rptItemNumber2 : creditValue.keySet()) {
                    String key4CreditSum = rptItemNumber2 + key + "CreditSum";
                    if (creditValue.get(rptItemNumber2) == null) continue;
                    map4ElimData.put(key4CreditSum, creditValue.get(rptItemNumber2));
                }
            }
        }
        return map4ElimData;
    }

    private static ItemDataCondition getItemDataCondition(String currencyID, int periodType, int iYear, int iPeriod, String dataCollectNumber, Map paramMap, boolean isIncludeUnAuditElim, Map rptItemMap) {
        ItemDataCondition condition = new ItemDataCondition();
        condition.setIncludeUnAuditElim(isIncludeUnAuditElim);
        condition.setTargetCurrency(currencyID);
        condition.setRptPeriodType(periodType);
        condition.setIsAdjusted(true);
        condition.setCommitStatus(3);
        condition.setDataCollectNumber(dataCollectNumber);
        condition.setItemList(rptItemMap);
        condition.setRptYearStart(iYear);
        condition.setRptYearEnd(iYear);
        condition.setRptPeriodStart(iPeriod);
        condition.setRptPeriodEnd(iPeriod);
        return condition;
    }

    private static Map getRptItemMap(List lstItemElimData) {
        HashMap<String, Object> rptItemMap = new HashMap<String, Object>();
        for (int itemIndex = 0; itemIndex < lstItemElimData.size(); ++itemIndex) {
            Map itemElimData = (Map)lstItemElimData.get(itemIndex);
            String itemNumber = (String)itemElimData.get("KEY_ITEM_NUMBER");
            rptItemMap.put(itemNumber, null);
        }
        return rptItemMap;
    }
}

