/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.dynarpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.DynaParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ElimReportUtils;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.PsSql;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynaItemDataByName {
    protected Context ctx;
    protected ItemFormula formula;
    protected boolean isTextGrade;
    protected boolean isSumByTextNotGrade;
    protected Map gradeMapping;
    protected DynaParamInfo paramInfo;
    protected DynaSumMethodEnum method;
    protected String dataCollectNumber = null;
    protected String currencyId = null;
    protected String itemNumber = null;
    protected Integer valueType = null;
    protected Integer year = null;
    protected Integer period = null;
    protected Integer periodType = null;
    protected Integer dataElement = null;
    protected String ext = null;
    protected boolean isOnlyDisplayFullName = false;
    protected String[] dynaItemTables = null;
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.dynarpt.DynaItemDataByName");
    protected boolean isSupportRpt = true;

    public boolean isSupportRpt() {
        return this.isSupportRpt;
    }

    public void setSupportRpt(boolean isSupportRpt) {
        this.isSupportRpt = isSupportRpt;
    }

    public DynaItemDataByName(Context ctx, ItemFormula formula, boolean isTextGrade, boolean isSumByTextNotGrade, DynaSumMethodEnum method, Map gradeMapping, DynaParamInfo paramInfo) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.formula = formula;
        this.isTextGrade = isTextGrade;
        this.isSumByTextNotGrade = isSumByTextNotGrade;
        this.gradeMapping = gradeMapping;
        this.paramInfo = paramInfo;
        this.method = method;
        this.dataCollectNumber = paramInfo.report.getDataCollectNumber();
        this.currencyId = paramInfo.report.getCurrency().getId().toString();
        this.itemNumber = formula.getItemNumber();
        this.valueType = new Integer(formula.getValueType());
        this.year = new Integer(formula.getYear());
        this.period = new Integer(formula.getPeriod());
        this.periodType = new Integer(paramInfo.report.getPeriodType().getValue());
        this.isOnlyDisplayFullName = CSLParamUtil.getBooleanCslParamValue(ctx, "KEY_CSLPARAM_PERFORMANCE_ISONLYDISPLAYFULLNAME");
        this.dynaItemTables = CslRptUtil.getDyItemTables(ctx, this.year, this.period, this.year, this.period);
    }

    public List calculate() throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        this.dataElement = new Integer(DataElementProvider.getDataElementInnerValue(this.ctx, this.formula.getDataElementNumber()));
        Map number_nameMapping = this.getDItemNumberNameMapping();
        if (number_nameMapping == null || number_nameMapping.isEmpty()) {
            return result;
        }
        this.ext = "_" + this.ctx.getLocale().getLanguage();
        ArrayList params = new ArrayList(42);
        String sql = this.getQuerySql(params);
        long starttime = System.currentTimeMillis();
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])params.toArray());
        this.printSql("getQuerySql()", new StringBuffer(sql), starttime, params.toArray(), this.ctx);
        try {
            if (this.isTextGrade && this.formula.getValueType() != 3 && this.method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
                return this.sumCompany(rs, this.gradeMapping);
            }
            if (this.isTextGrade && this.paramInfo.isForSave && this.formula.getValueType() == 3 && this.method.equals((Object)DynaSumMethodEnum.SUM_BY_NAME)) {
                HashMap<String, String> tmpValue = new HashMap<String, String>();
                HashMap<String, String> gradNumberValue = new HashMap<String, String>();
                String number = null;
                String value = null;
                String tmpTextValue = null;
                String name = null;
                while (rs.next()) {
                    number = rs.getString("DNumber");
                    value = rs.getString("Value");
                    if (StringUtils.isEmpty((String)value) || value.toUpperCase(Locale.ENGLISH).equals("NULL")) continue;
                    name = (String)number_nameMapping.get(number);
                    if (StringUtils.isEmpty((String)name)) {
                        number = this.getMapKeyByValue(number_nameMapping, number);
                    }
                    if (tmpValue.containsKey(number)) {
                        tmpTextValue = (String)tmpValue.get(number);
                        String addText = this.handleAddText(tmpTextValue, value);
                        if (addText != null) {
                            tmpValue.put(number, addText);
                        }
                    } else {
                        tmpValue.put(number, value);
                    }
                    if (!this.isTextGrade || this.gradeMapping == null) continue;
                    String singleNumber = rs.getString("FSINGLENUMBER");
                    String grade = (String)this.gradeMapping.get(singleNumber);
                    if (gradNumberValue.containsKey(number)) continue;
                    gradNumberValue.put(number, grade);
                }
                Iterator iter = tmpValue.keySet().iterator();
                while (iter.hasNext()) {
                    HashMap<String, String> row = new HashMap<String, String>(8);
                    number = (String)iter.next();
                    name = (String)number_nameMapping.get(number);
                    name = (String)number_nameMapping.get(number);
                    if (StringUtils.isEmpty((String)name)) {
                        name = number;
                        number = this.getMapKeyByValue(number_nameMapping, name);
                    }
                    tmpTextValue = (String)tmpValue.get(number);
                    row.put("KEY_DITEM_NUMBER", number);
                    row.put("KEY_DITEM_NAME", name);
                    row.put("KEY_DITEM_VALUE", tmpTextValue);
                    if (this.isTextGrade) {
                        row.put("GRADE_NUMBER", (String)gradNumberValue.get(number));
                    }
                    result.add(row);
                }
                return result;
            }
            if (!this.isTextGrade && this.formula.getValueType() == 3 && (this.method.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE) || this.method.equals((Object)DynaSumMethodEnum.SUM_BY_NAME))) {
                HashMap<String, String> tmpValue = new HashMap<String, String>();
                String number = null;
                String value = null;
                String tmpTextValue = null;
                String name = null;
                while (rs.next()) {
                    number = rs.getString("DNumber");
                    value = rs.getString("Value");
                    if (StringUtils.isEmpty((String)value) || value.toUpperCase(Locale.ENGLISH).equals("NULL")) continue;
                    name = (String)number_nameMapping.get(number);
                    if (StringUtils.isEmpty((String)name)) {
                        number = this.getMapKeyByValue(number_nameMapping, number);
                    }
                    if (tmpValue.containsKey(number)) {
                        tmpTextValue = (String)tmpValue.get(number);
                        String addText = this.handleAddText(tmpTextValue, value);
                        if (addText == null) continue;
                        tmpValue.put(number, addText);
                        continue;
                    }
                    tmpValue.put(number, value);
                }
                Iterator iter = tmpValue.keySet().iterator();
                while (iter.hasNext()) {
                    HashMap<String, String> row = new HashMap<String, String>(4);
                    number = (String)iter.next();
                    name = (String)number_nameMapping.get(number);
                    if (StringUtils.isEmpty((String)name) && (number = this.getMapKeyByValue(number_nameMapping, name = number)) == null) {
                        number = name;
                    }
                    tmpTextValue = (String)tmpValue.get(number);
                    row.put("KEY_DITEM_NUMBER", number);
                    row.put("KEY_DITEM_NAME", name);
                    row.put("KEY_DITEM_VALUE", tmpTextValue);
                    result.add(row);
                }
                return result;
            }
            while (rs.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>(4);
                String number = null;
                String name = null;
                if (this.formula.getValueType() != 3 && (this.method.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE) || this.method.equals((Object)DynaSumMethodEnum.SUM_BY_NAME))) {
                    number = rs.getString("DNumber");
                    name = (String)number_nameMapping.get(number);
                    if (StringUtils.isEmpty((String)name)) {
                        if (number_nameMapping.containsValue(number)) {
                            for (Map.Entry entry : number_nameMapping.entrySet()) {
                                if (!entry.getValue().equals(number)) continue;
                                number = (String)entry.getKey();
                                name = (String)entry.getValue();
                                break;
                            }
                        } else {
                            name = number;
                        }
                    }
                    if (this.gradeMapping != null) {
                        String singleNumber = rs.getString("FSingleNumber");
                        if (!StringUtils.isEmpty((String)singleNumber)) {
                            singleNumber = singleNumber.trim();
                        }
                        String grade = (String)this.gradeMapping.get(singleNumber);
                        row.put("GRADE_NUMBER", grade);
                    }
                }
                row.put("KEY_DITEM_NUMBER", number);
                row.put("KEY_DITEM_NAME", name);
                if (rs.getObject("Value") != null && rs.getObject("Value") instanceof BigDecimal) {
                    boolean isTextGradeHead = false;
                    try {
                        if (this.isTextGrade && !StringUtils.isEmpty((String)rs.getString("GNumber"))) {
                            isTextGradeHead = !"D".equalsIgnoreCase(rs.getString("GNumber").substring(rs.getString("GNumber").length() - 1));
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)"isTextGradeHead error", (Throwable)ex);
                    }
                    BigDecimal value = (BigDecimal)rs.getObject("Value");
                    if (!isTextGradeHead && this.formula.getValueType() != 3 && BigDecimal.ZERO.equals(value)) continue;
                }
                row.put("KEY_DITEM_VALUE", rs.getObject("Value"));
                result.add(row);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (DebugLogger.isDebug || logger.isDebugEnabled()) {
            logger.info((Object)("DynaItemDataListAll##DynaItemDataByName:calculate()SQL:" + sql.toString() + "$$$$$$params:" + params));
        }
        return result;
    }

    private String handleAddText(String tmpTextValue, String value) {
        int index;
        String str1 = tmpTextValue.trim();
        String str2 = value.trim();
        boolean isChange = false;
        if (str1.length() < str2.length()) {
            str2 = str1;
            str1 = value.trim();
            isChange = true;
        }
        if ((index = str1.indexOf(str2)) < 0 || index > 0 && str1.trim().charAt(index - 1) != ';' || index == 0 && str1.trim().length() != str2.length() && str1.trim().charAt(index + str2.length()) != ';') {
            return tmpTextValue + ";" + value;
        }
        if (isChange) {
            return str1;
        }
        return null;
    }

    private String getMapKeyByValue(Map number_nameMapping, String value) {
        for (Map.Entry entry : number_nameMapping.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    protected Map getDItemNumberNameMapping() throws BOSException {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            ArrayList params = new ArrayList();
            String dyReportSql = this.fetchDyReportNumberNameMappingSql(params);
            String adjystSql = this.fetchAdjustNumberNameMappingSql(params);
            String orgTreeId = this.paramInfo.report.getOrgTree().getId().toString();
            String eliminSql = this.fetchEliminationNumberNameMappingSql(orgTreeId, params);
            StringBuffer sql = new StringBuffer();
            sql.append(dyReportSql).append(" union all ").append(adjystSql);
            if (!StringUtils.isEmpty((String)eliminSql)) {
                sql.append(" union all ").append(eliminSql);
            }
            String keyNumber = null;
            String keyName = null;
            long starttime = System.currentTimeMillis();
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])params.toArray());
            this.printSql("getDItemNumberNameMapping()", sql, starttime, params.toArray(), this.ctx);
            boolean isDyRptSaveUpdateItem4CM = CSLParamUtil.isDyRptSaveUpdateItem4CM(this.ctx);
            HashMap notSameName = new HashMap();
            ArrayList<String> sameName = new ArrayList<String>();
            while (rs.next()) {
                keyNumber = rs.getString("FKeyNumber");
                keyName = rs.getString("FKeyName");
                if (keyNumber != null && keyNumber.equals(keyName)) {
                    sameName.add(keyName);
                    continue;
                }
                if (result.containsKey(keyNumber) || keyNumber == null) continue;
                result.put(keyNumber, keyName);
                notSameName.put(keyName, null);
            }
            for (String name : sameName) {
                if (notSameName.containsKey(name) || result.containsKey(name)) continue;
                result.put(name, name);
            }
            notSameName.clear();
            sameName.clear();
            return result;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void printSql(String method, StringBuffer sql, long starttime, Object[] params, Context ctx) {
        if (DebugLogger.isDebug) {
            StringBuffer printStr = new StringBuffer(1000);
            try {
                String dbType = ContextUtil.getDbType((Context)ctx);
                printStr.append("invokeMethod::" + method).append("\n");
                String tranSql = PsSql.getSqlWithParams((Object)sql, (Object[])params, (int)DbType.getValue((String)dbType), (boolean)false);
                printStr.append("executeSQL::" + TransUtil.Translate((String)tranSql.toString(), (int)DbType.getValue((String)dbType))).append("\n");
                printStr.append("executeSQLParam::");
                if (params != null && params.length > 0) {
                    for (Object object : params) {
                        printStr.append(object).append(",");
                    }
                    printStr.append("\n");
                }
                printStr.append("executeTime::" + (System.currentTimeMillis() - starttime)).append("\n");
                System.out.println(printStr.toString());
                logger.info((Object)printStr.toString());
            }
            catch (Exception e) {
                logger.error(e.getClass());
            }
        }
    }

    private String fetchDyReportNumberNameMappingSql(List params) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getNNMappingSelectSql()).append(this.getNNMappingFromSql()).append(this.getNNMappingWhereSql(params));
        if (!StringUtils.isEmpty((String)this.paramInfo.fastMergeSoluId)) {
            FastMergeUtil.initConditionByFastMergeSolu(this.ctx, null, this.paramInfo);
            if (this.paramInfo.isContainUnRecive && !StringUtils.isEmpty((String)this.paramInfo.autoItemFormualId)) {
                boolean fetchAutoItem;
                boolean bl = fetchAutoItem = !this.paramInfo.doOffset;
                if (this.paramInfo.isSupportCrossMerger) {
                    boolean bl2 = fetchAutoItem = fetchAutoItem && this.paramInfo.calcGroupKey.getOrgTree().getId().toString().equals(this.paramInfo.report.getOrgTree().getId().toString());
                }
                if (fetchAutoItem) {
                    sql.append(" union all ");
                    sql.append(this.getNNMappingSelectSql()).append(this.getNNMappingFromSql_auto()).append(this.getAutoItemWhereSql(params));
                }
            }
        }
        return sql.toString();
    }

    public String getNNMappingSelectSql() {
        return "SELECT de.FKeyNumber AS FKeyNumber,  (case when de.fgradenumber is null then de.FKeyName else replace(de.FKeyName,de.fgradenumber||'_','')   end) FKeyName \n";
    }

    public String getNNMappingFromSql() {
        StringBuffer nnmSqlFrom = new StringBuffer();
        nnmSqlFrom.append(" FROM ").append(this.dynaItemTables[1]).append(" de         \n");
        nnmSqlFrom.append(" INNER JOIN ").append(this.dynaItemTables[0]).append(" d      \n");
        nnmSqlFrom.append("    ON de.FItemDataID = d.FID                          \n");
        nnmSqlFrom.append(" inner join t_csl_rptreceived receive on d.FReportId = receive.FReportId \n");
        nnmSqlFrom.append(" inner join t_csl_cslreport r on d.FReportID = r.FId").append("\r\n");
        return nnmSqlFrom.toString();
    }

    public String getNNMappingFromSql_auto() {
        StringBuffer nnmSqlFrom = new StringBuffer();
        nnmSqlFrom.append(" FROM ").append(this.dynaItemTables[1]).append(" de         \n");
        nnmSqlFrom.append(" INNER JOIN ").append(this.dynaItemTables[0]).append(" d      \n");
        nnmSqlFrom.append("    ON de.FItemDataID = d.FID                           \n");
        return nnmSqlFrom.toString();
    }

    public String getNNMappingWhereSql(List params) throws EASBizException, BOSException, SQLException {
        StringBuffer nnmSqlWhere = new StringBuffer();
        nnmSqlWhere.append(" WHERE ( 1=1");
        nnmSqlWhere.append("    AND d.FDataCollectNumber = ?                               \n");
        nnmSqlWhere.append("    AND d.FCurrencyID = ?                               \n");
        nnmSqlWhere.append("    AND de.FItemID = ?                                  \n");
        nnmSqlWhere.append("    AND de.FDataElement = ?                             \n");
        nnmSqlWhere.append("    AND de.FValueType = ?                               \n");
        nnmSqlWhere.append("    AND de.FYear = ?                                    \n");
        nnmSqlWhere.append("    AND de.FPeriod = ?                                  \n");
        params.add(this.dataCollectNumber);
        params.add(this.currencyId);
        params.add(this.itemNumber);
        params.add(this.dataElement);
        params.add(this.valueType);
        params.add(this.year);
        params.add(this.period);
        nnmSqlWhere.append(" AND ( ");
        nnmSqlWhere.append(this.getRptFastMegerWhere(params));
        if (this.paramInfo.includeDiffTable && !this.paramInfo.isSupportCrossMerger) {
            nnmSqlWhere.append(" or (d.FOrgUnitId = '").append(this.paramInfo.report.getOrgUnit().getId().toString());
            nnmSqlWhere.append("' and r.FSourceType = ").append(8).append(")\n");
        }
        if (this.paramInfo.doOffset) {
            nnmSqlWhere.append(" or ( receive.FOrgTreeID = ? ");
            params.add(this.paramInfo.calcGroupKey.getOrgTree().getId().toString());
            nnmSqlWhere.append(" and d.FOrgUnitId = '").append(this.paramInfo.report.getOrgUnit().getId().toString());
            nnmSqlWhere.append("' and r.FSourceType in (42,43))\n");
        }
        nnmSqlWhere.append("))\n");
        if (this.paramInfo.doOffset && !CSLParamUtil.isDyRptSaveUpdateItem4CM(this.ctx)) {
            StringBuffer sql = new StringBuffer();
            sql.append("    OR (receive.FOrgTreeID = ?                          \n");
            sql.append("    AND d.FDataCollectNumber = ?                        \n");
            sql.append("    AND d.FCurrencyID = ?                               \n");
            sql.append("    AND de.FItemID = ?                                  \n");
            sql.append("    AND de.FDataElement = ?                             \n");
            sql.append("    AND de.FValueType = ?                               \n");
            sql.append("    AND de.FYear = ?                                    \n");
            sql.append("    AND de.FPeriod = ?                                  \n");
            sql.append("    AND d.FDataSource = 42                              \n");
            sql.append("    and d.FOrgUnitID =? )                               \n");
            params.add(this.paramInfo.report.getOrgTree().getId().toString());
            params.add(this.dataCollectNumber);
            params.add(this.currencyId);
            params.add(this.itemNumber);
            params.add(this.dataElement);
            params.add(this.valueType);
            params.add(this.year);
            params.add(this.period);
            params.add(this.paramInfo.report.getOrgUnit().getId().toString());
            nnmSqlWhere.append(sql.toString());
        }
        return nnmSqlWhere.toString();
    }

    private void sourceTypeAndFastSoluFilter(StringBuffer dySqlWhere, List params) {
        boolean isFromStatutory = this.paramInfo.calcGroupKey.isFromStatutory();
        if (!isFromStatutory && this.paramInfo.calcGroupKey.getSourceSoluInfo() != null && this.paramInfo.calcGroupKey.getSourceSoluInfo().getId() != null && !StringUtils.isEmpty((String)this.paramInfo.calcGroupKey.getSourceSoluInfo().getId().toString())) {
            dySqlWhere.append("  AND  (d.FfastMergeSoluid = ?  \n");
            params.add(this.paramInfo.calcGroupKey.getSourceSoluInfo().getId().toString());
            dySqlWhere.append(" and r.FSourceType=");
            if (this.paramInfo.doOffset) {
                dySqlWhere.append(isFromStatutory ? "12" : "35");
            } else {
                dySqlWhere.append(isFromStatutory ? "11" : "32");
            }
            dySqlWhere.append(" or r.FSourceType=10)");
        } else {
            dySqlWhere.append(" and r.FSourceType in(");
            dySqlWhere.append("10");
            if (this.paramInfo.doOffset) {
                dySqlWhere.append(",").append(isFromStatutory ? "12" : "35");
            } else {
                dySqlWhere.append(",").append(isFromStatutory ? "11" : "32");
            }
            dySqlWhere.append(") ");
        }
    }

    private String fetchAdjustNumberNameMappingSql(List params) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select t3.FKeyLongNumber as FKeyNumber\t\t\t\t\t\n");
        sql.append(" ,t3.FKeyName\tas \tFKeyName\n");
        sql.append(" From T_CSL_Adjust t1\t\t\t\t\t\t\t\t\t\n");
        sql.append(" inner join T_CSL_AdjustEntry t2\t\t\t\t\t\t\n");
        sql.append(" on t1.FID=t2.fadjustid\t\t\t\t\t\t\t\t\t\n");
        sql.append(" inner join t_Csl_Adjustdynamicitem t3\t\t\t\t\t\n");
        sql.append(" on t2.FID=t3.FAdjustEntryID\t\t\t\t\t\t\t\n");
        sql.append(" inner join T_CSL_RptItem rptItem\t\t\t\t\t\t\n");
        sql.append(" on t2.FItemID=rptItem.FID\t\t\t\t\t\t\t\t\n");
        sql.append(" WHERE t1.FOrgUnit IN (" + this.paramInfo.companyIDs + ")\n");
        sql.append("    and t1.FOrgBoundID = ?\t\t\t\t\t\t\t\n");
        params.add(this.paramInfo.calcGroupKey.getOrgTree().getId().toString());
        sql.append("    and t1.FCurrencyID = ?\t\t\t\t\t\t\t\t\n");
        sql.append("    and rptItem.FNumber = ?\t\t\t\t\t\t\t\t\n");
        sql.append("    and t2.FDataElement = ?                             \n");
        sql.append("    and t1.FValueType = ?                               \n");
        sql.append("    and t1.FYear = ?                                    \n");
        sql.append("    and t1.FPeriod = ?                                  \n");
        if (this.paramInfo.dynaCslRptParamInfo == null || !this.paramInfo.dynaCslRptParamInfo.isIncludeUnAuditElim()) {
            sql.append(" and t1.FCheckedStatus = ").append(2).append(" \n");
        }
        sql.append("    and t1.FDataCollectNumber = ?\t\t\t\t\t\t\n");
        params.add(this.currencyId);
        params.add(this.itemNumber);
        Integer dataElement = new Integer(DataElementProvider.getDataElementInnerValue(this.ctx, this.formula.getDataElementNumber()));
        params.add(dataElement);
        params.add(this.valueType);
        params.add(this.year);
        params.add(this.period);
        params.add(this.dataCollectNumber);
        return sql.toString();
    }

    private String fetchEliminationNumberNameMappingSql(String orgTreeId, List params) throws EASBizException, BOSException, SQLException {
        if (this.paramInfo.doOffset && this.formula.getValueType() != 3) {
            StringBuffer str = new StringBuffer();
            str.append(" SELECT de.FKeyLongNumber AS FKeyNumber, de.FKeyName as FKeyName    \n").append(" FROM t_csl_elimDynaItemEntry de                                        \n").append(" INNER JOIN t_csl_elimINatiONEntry ee ON de.FelimINatiONEntryID=ee.FID  \n").append(" INNER JOIN t_csl_elimINatiON e ON ee.FElimINatiONID = e.FID            \n").append(" INNER JOIN T_CSL_RptItem ri ON ri.FId = de.FRptItemID                  \n");
            if (this.paramInfo.isSupportCrossMerger && this.paramInfo.tempElimIDTable != null) {
                str.append(" INNER JOIN ").append(this.paramInfo.tempElimIDTable).append(" tmp ON tmp.FID = e.FID ");
                str.append(" WHERE ");
            } else {
                str.append(" WHERE e.FOrgUnit =?   \n");
                str.append(" AND ");
                params.add(this.paramInfo.report.getOrgUnit().getId().toString());
            }
            str.append(" e.FCurrencyID = ?    \n").append(" AND ri.fNumber = ?       \n").append(" AND ee.FDataElement = ?       \n").append(" AND e.FValueType = ?         \n").append(" AND e.FYear = ?         \n").append(" AND e.FPeriod= ?                 \n").append(" AND e.FOrgBoundID = ?  \n").append(" AND e.FdataCollectNumber = ?  \n");
            if (this.paramInfo.dynaCslRptParamInfo == null || !this.paramInfo.dynaCslRptParamInfo.isIncludeUnAuditElim()) {
                str.append(" AND e.FCheckedStatus = 2   \n");
            }
            params.add(this.currencyId);
            params.add(this.itemNumber);
            Integer dataElement = new Integer(DataElementProvider.getDataElementInnerValue(this.ctx, this.formula.getDataElementNumber()));
            params.add(dataElement);
            params.add(this.valueType);
            params.add(this.year);
            params.add(this.period);
            params.add(orgTreeId);
            params.add(this.dataCollectNumber);
            return str.toString();
        }
        return null;
    }

    private String getQuerySql(List params) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.paramInfo.isForSave && this.formula.getValueType() == 3) {
            sql.append("select DNumber,Fnumber as CompanyNumber,(GNumber || '**' || DNumber) as FSingleNumber, Expr1 as Value  from (\n");
        } else if (this.isSumByTextNotGrade) {
            sql.append("select  DNumber, Value from (");
        } else {
            sql.append("select GroupedTable.*, (GNumber || '**' || DNumber) as FSingleNumber from (\n");
            sql.append("select DNumber, max(GNumber) as GNumber, SUM(Expr1) as Value \n");
            if (this.isTextGrade && this.formula.getValueType() != 3 && this.method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
                sql.append(", ONumber, OName");
            }
            sql.append(" from(\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        }
        sql.append(this.fetchDyReportQuerySql(params));
        if (!(this.formula.getValueType() == 3 || this.paramInfo.isForSave && this.formula.getValueType() == 3)) {
            sql.append(" UNION ALL \n");
            sql.append(this.fetchAdjustQuerySql(params));
            if (this.paramInfo.doOffset && !this.paramInfo.isIgnoreCalcElimData) {
                sql.append(" UNION ALL \n");
                sql.append(this.fetchEliminationQuerySql(params));
            }
        }
        if (this.paramInfo.doOffset && !this.isTextGrade) {
            sql.append(" UNION ALL \n");
            sql.append(this.fetchDynaCslElimReportQuerySql(params));
        }
        if (this.paramInfo.isForSave && this.formula.getValueType() == 3) {
            sql.append(") as t order by t.fnumber\t\t\t\t\t\t\n");
        } else if (this.isSumByTextNotGrade) {
            sql.append(") as t order by t.fnumber asc\t\t\t\t    \n");
        } else {
            sql.append(") as t group by DNumber\t\t\t\t\t\t\t\n");
            if (this.isTextGrade && this.formula.getValueType() != 3 && this.method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
                sql.append(", ONumber, OName ");
            }
            sql.append(") as GroupedTable");
            sql.append(" order by GNumber, DNumber\t\t\t\t\t\t\t\t\t\n");
        }
        return sql.toString();
    }

    private String fetchDyReportQuerySql(List params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getRptSelectSql()).append(this.getRptFromSql()).append(this.getRptWhereSql(params));
        if (!StringUtils.isEmpty((String)this.paramInfo.fastMergeSoluId) && this.paramInfo.isContainUnRecive && !StringUtils.isEmpty((String)this.paramInfo.autoItemFormualId)) {
            boolean fetchAutoItem;
            boolean bl = fetchAutoItem = !this.paramInfo.doOffset;
            if (this.paramInfo.isSupportCrossMerger) {
                boolean bl2 = fetchAutoItem = fetchAutoItem && this.paramInfo.calcGroupKey.getOrgTree().getId().toString().equals(this.paramInfo.report.getOrgTree().getId().toString());
            }
            if (fetchAutoItem) {
                sql.append(" union all ");
                sql.append(this.getAutoItemSelectSql()).append(this.getAutoItemFromSql()).append(this.getAutoItemWhereSql(params));
            }
        }
        return sql.toString();
    }

    private String fetchAdjustQuerySql(List params) throws BOSException, EASBizException {
        StringBuffer adjustSql = new StringBuffer();
        adjustSql.append(" select t3.FKeyLongNumber as DNumber, to_char(null) as GNumber\t\t\n");
        adjustSql.append(" , t3.fvalue as Expr1\t\t\n");
        if (this.isTextGrade && this.formula.getValueType() != 3 && this.method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
            adjustSql.append(",o.FNumber AS ONumber," + this.getCompanyNameSql(this.isOnlyDisplayFullName, "o", this.ext));
        }
        adjustSql.append(" From T_CSL_Adjust t1\t\t\t\t\t\t\t\t\t\n");
        adjustSql.append(" inner join T_CSL_AdjustEntry t2\t\t\t\t\t\t\n");
        adjustSql.append(" on t1.FID=t2.fadjustid\t\t\t\t\t\t\t\t\t\n");
        if (this.isTextGrade && this.formula.getValueType() != 3 && this.method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
            adjustSql.append(" inner JOIN T_ORG_BaseUnit o ON t1.FOrgUnit = o.FID  \n");
        }
        adjustSql.append(" inner join t_Csl_Adjustdynamicitem t3\t\t\t\t\t\n");
        adjustSql.append(" on t2.FID=t3.FAdjustEntryID\t\t\t\t\t\t\t\n");
        adjustSql.append(" inner join T_CSL_RptItem rptItem\t\t\t\t\t\t\n");
        adjustSql.append(" on t3.FRptItemID=rptItem.FID\t\t\t\t\t\t\t\n");
        adjustSql.append(" WHERE t1.FOrgUnit IN (" + this.paramInfo.companyIDs + ")\t\n");
        adjustSql.append("    and t1.FOrgBoundID = ?\t\t\t\t\t\t\t\n");
        if (this.paramInfo.calcGroupKey.getOrgTree() != null && this.paramInfo.calcGroupKey.getOrgTree().getId() != null) {
            params.add(this.paramInfo.calcGroupKey.getOrgTree().getId().toString());
        } else {
            params.add(this.paramInfo.report.getOrgTree().getId().toString());
        }
        if (!CslRptUtil.isListEmpty(this.paramInfo.adjustTypeList)) {
            adjustSql.append("    and t1.fadjustmode in (" + CslRptUtil.changeIdList2String(this.paramInfo.adjustTypeList) + ")\t\n");
        }
        adjustSql.append("    and t1.FCurrencyID = ?\t\t\t\t\t\t\t\t\n");
        adjustSql.append("    and rptItem.FNumber = ?\t\t\t\t\t\t\t\t\n");
        adjustSql.append("    and t2.FDataElement = ?                             \n");
        adjustSql.append("    and t1.FValueType = ?                               \n");
        adjustSql.append("    and t1.FYear = ?                                    \n");
        adjustSql.append("    and t1.FPeriod = ?                                  \n");
        if (this.paramInfo.dynaCslRptParamInfo == null || !this.paramInfo.dynaCslRptParamInfo.isIncludeUnAuditElim()) {
            adjustSql.append(" and t1.FCheckedStatus = ").append(2).append(" \n");
        }
        adjustSql.append("    and t1.FDataCollectNumber = ?                       \n");
        adjustSql.append("\tAND t1.fdatasource in (1, " + (this.paramInfo.report.getReportSourceType() == RptSrcTypeEnum.DYNAMICSUMREPORT || this.paramInfo.report.getReportSourceType() == RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE ? 2 : 3) + ")");
        params.add(this.currencyId);
        params.add(this.formula.getItemNumber());
        params.add(this.dataElement);
        params.add(this.valueType);
        params.add(this.year);
        params.add(this.period);
        params.add(this.dataCollectNumber);
        return adjustSql.toString();
    }

    private String fetchEliminationQuerySql(List params) throws BOSException, EASBizException {
        StringBuffer elimSql = new StringBuffer();
        elimSql.append(" SELECT de.FKeyLongNumber AS DNumber, to_char(null) as GNumber, de.FValue AS Expr1 \n");
        if (this.isTextGrade && this.formula.getValueType() != 3 && this.method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
            elimSql.append(",o.FNumber AS ONumber," + this.getCompanyNameSql(this.isOnlyDisplayFullName, "o", this.ext));
        }
        elimSql.append(" FROM t_csl_elimDynaItemEntry de                                        \n").append(" INNER JOIN t_csl_elimINatiONEntry ee ON de.FelimINatiONEntryID=ee.FID  \n").append(" INNER JOIN t_csl_elimINatiON e ON ee.FElimINatiONID = e.FID            \n").append(" INNER JOIN T_CSL_RptItem ri ON ri.FId = de.FRptItemID                  \n");
        if (this.isTextGrade && this.formula.getValueType() != 3 && this.method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
            elimSql.append(" left JOIN T_ORG_BaseUnit o ON ee.FCompanyID = o.FID  \n");
        }
        if (this.paramInfo.isSupportCrossMerger && this.paramInfo.tempElimIDTable != null) {
            elimSql.append(" INNER JOIN ").append(this.paramInfo.tempElimIDTable).append(" tmp ON tmp.FID = e.FID ");
            elimSql.append(" WHERE ");
        } else {
            elimSql.append(" WHERE e.FOrgUnit =?   \n");
            elimSql.append(" AND ");
            params.add(this.paramInfo.report.getOrgUnit().getId().toString());
        }
        elimSql.append(" e.FCurrencyID = ?                                               \n").append(" AND ri.fNumber = ?                                                     \n").append(" AND ee.FDataElement = ?                                                \n").append(" AND e.FValueType = ?                                                   \n").append(" AND e.FYear = ?                                                        \n").append(" AND e.FPeriod= ?                                                       \n");
        if (this.paramInfo.dynaCslRptParamInfo == null || !this.paramInfo.dynaCslRptParamInfo.isIncludeUnAuditElim()) {
            elimSql.append(" AND e.FCheckedStatus = 2   \n");
        }
        elimSql.append(" AND e.FOrgBoundID = ?                                           \n").append(" AND e.FDataCollectNumber = ?                                           \n");
        if (!CslRptUtil.isListEmpty(this.paramInfo.elimTypeList)) {
            elimSql.append(" AND e.feliminationmodeid in (" + CslRptUtil.changeIdList2String(this.paramInfo.elimTypeList) + ")   \n");
        }
        params.add(this.currencyId);
        params.add(this.formula.getItemNumber());
        params.add(this.dataElement);
        params.add(this.valueType);
        params.add(this.year);
        params.add(this.period);
        params.add(this.paramInfo.report.getOrgTree().getId().toString());
        params.add(this.dataCollectNumber);
        return elimSql.toString();
    }

    private List sumCompany(IRowSet rs, Map gradeMapping) throws SQLDataException {
        HashMap<String, DItemGradeInfo> infos = new HashMap<String, DItemGradeInfo>();
        try {
            while (rs.next()) {
                String dnumber = rs.getString("ONumber");
                DItemGradeInfo o = (DItemGradeInfo)infos.get(dnumber);
                if (o == null) {
                    o = new DItemGradeInfo();
                    infos.put(dnumber, o);
                }
                String ditemKeyNumber = rs.getString("DNumber");
                String grade = (String)gradeMapping.get(ditemKeyNumber);
                MyDItemGradeEntryInfo en = new MyDItemGradeEntryInfo(grade);
                en.value = rs.getObject("Value");
                en.D_Name = rs.getString("OName");
                en.D_number = dnumber;
                o.getEntries().add(en);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        Iterator it = infos.values().iterator();
        ArrayList result = new ArrayList();
        while (it.hasNext()) {
            MyDItemGradeEntryInfo en;
            int i;
            DItemGradeInfo info = (DItemGradeInfo)it.next();
            info.reform2(true);
            MyDItemGradeEntryInfo root = new MyDItemGradeEntryInfo();
            root.setLevel(0);
            root.setLeaf(false);
            int top_level = Integer.MAX_VALUE;
            for (i = 0; i < info.getEntries().size(); ++i) {
                en = (MyDItemGradeEntryInfo)((Object)info.getEntries().get(i));
                if (top_level <= en.getLevel()) continue;
                top_level = en.getLevel();
            }
            for (i = 0; i < info.getEntries().size(); ++i) {
                en = (MyDItemGradeEntryInfo)((Object)info.getEntries().get(i));
                if (en.getChildren().size() > 0) {
                    en.value = CslConstant.BGZERO;
                }
                if (root.D_Name == null) {
                    root.D_Name = en.D_Name;
                    root.D_number = en.D_number;
                }
                if (en.getLevel() != top_level) continue;
                root.getChildren().add(en);
            }
            this.sumTextGradeChildren(root);
            HashMap<String, Object> row = new HashMap<String, Object>(4);
            row.put("KEY_DITEM_NUMBER", root.D_Name);
            row.put("KEY_DITEM_VALUE", root.value);
            row.put("KEY_DITEM_NAME", root.D_Name);
            result.add(row);
        }
        return result;
    }

    private void sumTextGradeChildren(MyDItemGradeEntryInfo en) {
        if (en.getChildren().size() < 1) {
            return;
        }
        for (MyDItemGradeEntryInfo child : en.getChildren()) {
            this.sumTextGradeChildren(child);
            if (!(child.value instanceof BigDecimal) || !(en.value instanceof BigDecimal)) continue;
            en.value = ((BigDecimal)en.value).add((BigDecimal)child.value);
        }
    }

    public String getRptSelectSql() {
        StringBuffer dySqlSelect = new StringBuffer();
        if (this.paramInfo.isForSave && this.formula.getValueType() == 3) {
            dySqlSelect.append(" SELECT de.FKeyNumber AS DNumber,bu.Fnumber as fnumber,");
            dySqlSelect.append("de.FGradeNumber AS GNumber, ");
            dySqlSelect.append("case when d.fdatatype=2 then de.FTextValue else de.FTextValue end AS Expr1 \n");
        } else if (this.isSumByTextNotGrade) {
            dySqlSelect.append("select de.FKeyNumber AS DNumber, (case when d.fdatatype = 2 ");
            dySqlSelect.append("then de.FTextValue else de.FTextValue end) AS Value, o.fnumber as fnumber ");
        } else {
            dySqlSelect.append(" SELECT de.FKeyNumber AS DNumber, de.FGradeNumber AS GNumber, ");
            dySqlSelect.append(" (case when d.fdatatype=2 then de.FValue else de.FValue end) AS Expr1 \n");
            if (this.isTextGrade && this.formula.getValueType() != 3 && this.method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
                dySqlSelect.append(",o.FNumber AS ONumber," + this.getCompanyNameSql(this.isOnlyDisplayFullName, "o", this.ext));
            }
        }
        return dySqlSelect.toString();
    }

    public String getRptFromSql() {
        StringBuffer dySqlFrom = new StringBuffer();
        dySqlFrom.append(" FROM ").append(this.dynaItemTables[1]).append(" de         \n");
        dySqlFrom.append(" INNER JOIN ").append(this.dynaItemTables[0]).append(" d      \n");
        dySqlFrom.append("    ON de.FItemDataID = d.FID                           \n");
        if (this.paramInfo.isForSave && this.formula.getValueType() == 3) {
            dySqlFrom.append(" INNER JOIN T_ORG_BaseUnit bu on d.FOrgUnitID=bu.fid  \n");
        }
        dySqlFrom.append(" inner join t_csl_rptreceived receive on d.FReportId = receive.FReportId \n");
        dySqlFrom.append(" inner join t_csl_cslreport r on d.FReportID = r.FId").append("\r\n");
        if (this.isTextGrade && this.formula.getValueType() != 3 && this.method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY) || this.isSumByTextNotGrade) {
            dySqlFrom.append(" LEFT JOIN T_ORG_BaseUnit o ON d.FOrgUnitID = o.FID  \n");
        }
        return dySqlFrom.toString();
    }

    public String getRptWhereSql(List params) throws BOSException, EASBizException {
        StringBuffer dySqlWhere = new StringBuffer();
        dySqlWhere.append(this.getRptCommWhere(params));
        dySqlWhere.append(" and ");
        if (this.paramInfo.includeDiffTable && !this.paramInfo.isSupportCrossMerger) {
            dySqlWhere.append(" ((");
        }
        dySqlWhere.append(this.getRptFastMegerWhere(params));
        if (this.paramInfo.includeDiffTable && !this.paramInfo.isSupportCrossMerger) {
            dySqlWhere.append(") or (d.FOrgUnitId = '").append(this.paramInfo.report.getOrgUnit().getId().toString());
            dySqlWhere.append("' and r.FSourceType = ").append(8).append("))\n");
        }
        dySqlWhere.append(" and d.fdynatype=").append(1).append("\r\n");
        dySqlWhere.append(" AND\tD.FDATATYPE <> ").append(2).append(" \n");
        return dySqlWhere.toString();
    }

    public String getRptFastMegerWhere(List params) throws BOSException, EASBizException {
        boolean isCommitted;
        StringBuffer dySqlWhere = new StringBuffer();
        dySqlWhere.append("  receive.FOrgTreeID = ? ");
        params.add(this.paramInfo.calcGroupKey.getOrgTree().getId().toString());
        dySqlWhere.append(" AND d.FOrgUnitID IN (").append(this.paramInfo.companyIDs).append(")  \n");
        this.sourceTypeAndFastSoluFilter(dySqlWhere, params);
        boolean bl = isCommitted = !FastMergeUtil.getIsContainUnRecive(this.ctx, this.paramInfo.fastMergeSoluId);
        if (isCommitted) {
            dySqlWhere.append(" AND d.FCommitStatus = ?\t\t\n");
            params.add(new Integer(3));
        }
        return dySqlWhere.toString();
    }

    public String getRptCommWhere(List params) throws BOSException, EASBizException {
        StringBuffer dySqlWhere = new StringBuffer();
        dySqlWhere.append("    WHERE d.FCurrencyID = ?                               \n");
        dySqlWhere.append("    AND de.FItemID = ?                                  \n");
        dySqlWhere.append("    AND de.FDataElement = ?                             \n");
        dySqlWhere.append("    AND de.FValueType = ?                               \n");
        dySqlWhere.append("    AND de.FYear = ?                                    \n");
        dySqlWhere.append("    AND de.FPeriod = ?                                  \n");
        dySqlWhere.append("    AND d.fperiodtype = ?                               \n");
        dySqlWhere.append("    AND d.FDataCollectNumber = ?                        \n");
        dySqlWhere.append("    AND r.FIsSaveAs\t = ?                               \n");
        dySqlWhere.append("    AND r.FCurrencyid\t = ?                           \n");
        params.add(this.currencyId);
        params.add(this.formula.getItemNumber());
        params.add(this.dataElement);
        params.add(this.valueType);
        params.add(this.year);
        params.add(this.period);
        params.add(this.periodType);
        params.add(this.dataCollectNumber);
        params.add(new Integer(0));
        params.add(this.currencyId);
        if (this.isTextGrade && this.formula.getValueType() != 3 && this.method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
            dySqlWhere.append("    AND de.fgradeisleaf\t = ?                       \n");
            params.add(new Integer(1));
        }
        return dySqlWhere.toString();
    }

    public String getAutoItemSelectSql() {
        return this.getRptSelectSql();
    }

    public String getAutoItemFromSql() {
        StringBuffer dySqlFrom = new StringBuffer();
        dySqlFrom.append(" FROM ").append(this.dynaItemTables[1]).append(" de         \n");
        dySqlFrom.append(" INNER JOIN ").append(this.dynaItemTables[0]).append(" d      \n");
        dySqlFrom.append("    ON de.FItemDataID = d.FID                           \n");
        if (this.paramInfo.isForSave && this.formula.getValueType() == 3) {
            dySqlFrom.append(" INNER JOIN T_ORG_BaseUnit bu on d.FOrgUnitID=bu.fid  \n");
        }
        if (this.isTextGrade && this.formula.getValueType() != 3 && this.method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY) || this.isSumByTextNotGrade) {
            dySqlFrom.append(" LEFT JOIN T_ORG_BaseUnit o ON d.FOrgUnitID = o.FID  \n");
        }
        return dySqlFrom.toString();
    }

    public String getAutoItemWhereSql(List params) throws BOSException, EASBizException {
        StringBuffer dySqlWhere = new StringBuffer();
        dySqlWhere.append(" where ");
        dySqlWhere.append("    d.FCurrencyID = ?                               \n");
        dySqlWhere.append("    AND de.FItemID = ?                                  \n");
        dySqlWhere.append("    AND de.FDataElement = ?                             \n");
        dySqlWhere.append("    AND de.FValueType = ?                               \n");
        dySqlWhere.append("    AND de.FYear = ?                                    \n");
        dySqlWhere.append("    AND de.FPeriod = ?                                  \n");
        dySqlWhere.append("    AND d.fperiodtype = ?                               \n");
        dySqlWhere.append("    AND d.FDataCollectNumber = ?                        \n");
        dySqlWhere.append("    AND d.ffastmergesoluid = ?                        \n");
        params.add(this.currencyId);
        params.add(this.formula.getItemNumber());
        params.add(this.dataElement);
        params.add(this.valueType);
        params.add(this.year);
        params.add(this.period);
        params.add(this.periodType);
        params.add(this.dataCollectNumber);
        params.add(this.paramInfo.autoItemFormualId);
        dySqlWhere.append(" AND  d.FOrgUnitID IN (" + this.paramInfo.companyIDs + ")  \n");
        dySqlWhere.append(" and  d.FDataSource=100 ");
        return dySqlWhere.toString();
    }

    public DynaParameters getDynaParameters() {
        return null;
    }

    private String fetchDynaCslElimReportQuerySql(List params) {
        StringBuffer dyReportSql = new StringBuffer(260);
        dyReportSql.append(this.getRptSelectSql()).append(this.getRptFromSql());
        dyReportSql.append(this.getDynaCslElimWhereSql(params));
        return dyReportSql.toString();
    }

    protected String getDynaCslElimWhereSql(List params) {
        StringBuffer whereSql = new StringBuffer();
        whereSql.append(" WHERE  receive.FOrgTreeID = ? ");
        params.add(this.paramInfo.report.getOrgTree().getId().toString());
        whereSql.append(" AND d.FOrgUnitID = ? ");
        params.add(this.paramInfo.report.getOrgUnit().getId().toString());
        whereSql.append(" AND d.FCurrencyID = ? ");
        whereSql.append(" AND de.FItemID = ? ");
        whereSql.append(" AND de.FDataElement = ? ");
        whereSql.append(" AND de.FValueType = ? ");
        whereSql.append(" AND de.FYear = ? ");
        whereSql.append(" AND de.FPeriod = ? ");
        whereSql.append(" AND d.fperiodtype = ? ");
        if (RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)this.paramInfo.report.getSourceType())) {
            whereSql.append(" AND r.FSourceType = 42");
        } else {
            whereSql.append(" AND r.FSourceType = 43");
            whereSql.append(" AND r.FfastMergeSoluId = '" + this.paramInfo.report.getFastMergeSoluId() + "'");
        }
        whereSql.append(" AND r.FCurrencyid\t = ? ");
        int dynaType = ElimReportUtils.isSumByName(this.method) ? 1 : 6;
        whereSql.append(" and d.fdynatype=").append(dynaType).append("\r\n");
        params.add(this.currencyId);
        params.add(this.formula.getItemNumber());
        params.add(this.dataElement);
        params.add(this.valueType);
        params.add(this.year);
        params.add(this.period);
        params.add(this.periodType);
        params.add(this.currencyId);
        return whereSql.toString();
    }

    protected String getCompanyNameSql(boolean isOnlyDisplayFullName, String alias, String ext) {
        return isOnlyDisplayFullName ? alias + ".FName" + ext + " AS OName" : " case when " + alias + ".FSimpleName is null or " + alias + ".FSimpleName='' then " + alias + ".FName" + ext + " else " + alias + ".FSimpleName end AS OName \n";
    }

    private class MyDItemGradeEntryInfo
    extends DItemGradeEntryInfo {
        Object value;
        String D_number;
        String D_Name;

        public MyDItemGradeEntryInfo() {
            this.value = CslConstant.BGZERO;
        }

        public MyDItemGradeEntryInfo(String g) {
            super(g);
            this.value = CslConstant.BGZERO;
        }
    }
}

