/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation.articulationprocessor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DiffIndexTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.OperateSymbolEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDiffIndexInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.ArticulationCheckResult;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ArticulationInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ItemDiffArticulationInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationprocessor.AbstractArticulationProcessor;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ItemDiffArticulationProcessor
extends AbstractArticulationProcessor {
    @Override
    public List getArticulationInfoList(Context ctx, CslReportInfo rptInfo, ParameterContext parameterContext) throws BOSException {
        SQLBuilder kqlBuffer = new SQLBuilder();
        kqlBuffer.append(" select diffIndex.FIsCheckByDefault, diffIndex.FID diffIndexId, diffIndex.FStandardValue defaultValue, diffIndex.FIsCheckByDefault,");
        kqlBuffer.append(" diffIndex.FDiffIndexType, diffIndex.FRange, diffIndex.FFormula, diffIndex.FOperateSymbol, diffIndex.FName,diffIndex.FIfClause,");
        kqlBuffer.append(" diffIndex.FNumber, diffIndex.FRemark, diffIndex.FIsRequestLabel, diffIndexEntry.FID diffIndexEntryId,");
        kqlBuffer.append(" diffIndexEntry.FOrgTreeID, diffIndexEntry.FOrgUnitID, diffIndexEntry.FCompanyID, diffIndexEntry.FStandardValue standardValue");
        kqlBuffer.append(" from T_CSL_FormulaDispense dispense inner join T_CSL_ItemDiffIndex diffIndex on dispense.FDiffIndexID = diffIndex.FID");
        kqlBuffer.append(" left join T_CSL_ItemDiffIndexEntry diffIndexEntry on diffIndexEntry.FDiffIndexID = diffIndex.FID");
        kqlBuffer.append(" where dispense.FFormulaType = ").append((Object)2);
        kqlBuffer.append(" and dispense.FTemplateNumber = ? ", (Object)rptInfo.getTemplate().getNumber());
        int tmpType = rptInfo.getTemplate().getTemplateType().getValue();
        if (tmpType == 2) {
            tmpType = 6;
        } else if (tmpType == 12) {
            tmpType = 10;
        }
        kqlBuffer.append("and dispense.FTemplateType = ?", (Object)tmpType);
        kqlBuffer.append(" and diffIndex.FIsFreezed = 0 and diffIndex.FCurrencyID = ?", (Object)rptInfo.getCurrency().getId().toString());
        kqlBuffer.append(" and (");
        kqlBuffer.append("     ( diffIndex.FStartYear < ? ", (Object)rptInfo.getYear()).append("and diffIndex.FEndYear > ?)", (Object)rptInfo.getYear());
        kqlBuffer.append("     or (diffIndex.FStartYear=diffIndex.FEndYear and diffIndex.FEndYear = ? ", (Object)rptInfo.getYear());
        kqlBuffer.append("         and diffIndex.FStartPeriod<=?", (Object)rptInfo.getPeriod()).append(" and diffIndex.FEndPeriod>=? ", (Object)rptInfo.getPeriod()).append(") ");
        kqlBuffer.append("     or (diffIndex.FStartYear<>diffIndex.FEndYear and diffIndex.FStartYear = ? ", (Object)rptInfo.getYear());
        kqlBuffer.append("         and diffIndex.FStartPeriod<=?", (Object)rptInfo.getPeriod()).append(" ) ");
        kqlBuffer.append("     or (diffIndex.FStartYear<>diffIndex.FEndYear and diffIndex.FEndYear = ? ", (Object)rptInfo.getYear());
        kqlBuffer.append("         and diffIndex.FEndPeriod>=?", (Object)rptInfo.getPeriod()).append(" ) ");
        kqlBuffer.append("  ) ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)kqlBuffer.getSQL(), (Object[])kqlBuffer.getParams());
        ArrayList<ItemDiffArticulationInfo> rptItemDiffIndexList = new ArrayList<ItemDiffArticulationInfo>();
        ItemDiffArticulationInfo articulationInfo = null;
        boolean isCommonReport = this.checkIsCommonReport(rptInfo);
        String compareId = null;
        BigDecimal standardValue = null;
        HashSet<String> set = new HashSet<String>();
        boolean IsCheckByDefault = false;
        try {
            String diffIndexId;
            while (rowSet.next()) {
                String string = compareId = isCommonReport ? rowSet.getString("FCompanyID") : rowSet.getString("FOrgUnitID");
                if (!rptInfo.getOrgUnit().getId().toString().equals(compareId)) continue;
                standardValue = rowSet.getBigDecimal("standardValue");
                set.add(rowSet.getString("diffIndexId") + rptInfo.getOrgUnit().getId().toString());
                diffIndexId = rowSet.getString("diffIndexId");
                IsCheckByDefault = TypeConversionUtils.objToBoolean((Object)rowSet.getObject("FIsCheckByDefault"));
                articulationInfo = this.getItemDiffArticulationInfo(rowSet, diffIndexId, standardValue, IsCheckByDefault);
                rptItemDiffIndexList.add(articulationInfo);
            }
            rowSet.beforeFirst();
            while (rowSet.next()) {
                IsCheckByDefault = TypeConversionUtils.objToBoolean((Object)rowSet.getObject("FIsCheckByDefault"));
                if (!IsCheckByDefault || set.contains((diffIndexId = rowSet.getString("diffIndexId")) + rptInfo.getOrgUnit().getId().toString())) continue;
                standardValue = rowSet.getBigDecimal("defaultValue");
                set.add(diffIndexId + rptInfo.getOrgUnit().getId().toString());
                articulationInfo = this.getItemDiffArticulationInfo(rowSet, diffIndexId, standardValue, IsCheckByDefault);
                rptItemDiffIndexList.add(articulationInfo);
            }
        }
        catch (SQLException ex) {
            throw new SQLDataException(ex);
        }
        return rptItemDiffIndexList;
    }

    private ItemDiffArticulationInfo getItemDiffArticulationInfo(IRowSet rowSet, String diffIndexId, BigDecimal standardValue, boolean IsCheckByDefault) throws SQLException {
        RPTItemDiffIndexInfo itemDiffIndexInfo = new RPTItemDiffIndexInfo();
        itemDiffIndexInfo.setId(BOSUuid.read((String)diffIndexId));
        itemDiffIndexInfo.setDefaultStandValue(standardValue);
        itemDiffIndexInfo.setIsCheckByDefault(IsCheckByDefault);
        itemDiffIndexInfo.setDiffIndexType(DiffIndexTypeEnum.getEnum(rowSet.getInt("FDiffIndexType")));
        itemDiffIndexInfo.setFormula(rowSet.getString("FFormula"));
        itemDiffIndexInfo.setOperateSymbol(OperateSymbolEnum.getEnum(rowSet.getInt("FOperateSymbol")));
        itemDiffIndexInfo.setName(rowSet.getString("FName"));
        itemDiffIndexInfo.setNumber(rowSet.getString("FNumber"));
        itemDiffIndexInfo.setPrompt(rowSet.getString("FRemark"));
        itemDiffIndexInfo.setIfClause(rowSet.getString("FIfClause"));
        itemDiffIndexInfo.setIsRequestLabel(TypeConversionUtils.objToBoolean((Object)rowSet.getObject("FIsRequestLabel")));
        if (itemDiffIndexInfo.getDiffIndexType().getValue() == 1) {
            itemDiffIndexInfo.setRange(rowSet.getBigDecimal("FRange"));
        } else {
            BigDecimal bdRange = rowSet.getBigDecimal("FRange");
            if (bdRange != null) {
                itemDiffIndexInfo.setRange(bdRange.divide(new BigDecimal("100"), 6, 4));
            } else {
                itemDiffIndexInfo.setRange(new BigDecimal("0"));
            }
        }
        return new ItemDiffArticulationInfo(itemDiffIndexInfo);
    }

    @Override
    public ArticulationInfo newArticulationInfoInstance(ArticulationInfo articulationInfo, OrgTreeInfo orgTreeInfo) {
        return new ItemDiffArticulationInfo(((ItemDiffArticulationInfo)articulationInfo).getItemDiffIndexInfo(), orgTreeInfo);
    }

    @Override
    public void fillFormulaParameter(Context ctx, ArticulationInfo articulationInfo, ParameterContext parameterContext) {
        ItemDiffArticulationInfo itemDiffArticulationInfo = (ItemDiffArticulationInfo)articulationInfo;
        Expression expression = this.processFormulaExpression(ctx, itemDiffArticulationInfo.getExpression(), parameterContext);
        itemDiffArticulationInfo.setExpression(expression);
    }

    @Override
    public void fillFormulaIntoCalculateBook(Context ctx, Sheet calculateSheet, int row, ArticulationInfo articulationInfo, CslReportInfo cslReportInfo, OrgTreeInfo orgTreeInfo) throws EASBizException {
        ItemDiffArticulationInfo itemDiffArticulationInfo = (ItemDiffArticulationInfo)articulationInfo;
        calculateSheet.getRange(row, 0).setValue(new Variant((Object)itemDiffArticulationInfo.getItemDiffIndexInfo().getId().toString()));
        BigDecimal standValue = itemDiffArticulationInfo.getDiffStandValue();
        int iDiffIndexType = itemDiffArticulationInfo.getItemDiffIndexInfo().getDiffIndexType().getValue();
        if (iDiffIndexType == 2) {
            calculateSheet.getRange(row, 2).setValue(new Variant((Object)standValue.divide(new BigDecimal("100"), 5, 4)));
        } else {
            calculateSheet.getRange(row, 2).setValue(new Variant((Object)standValue));
        }
        String lformula = itemDiffArticulationInfo.getExpression().toString();
        if (this.isFormula(lformula)) {
            this.checkFormulaAvailability(ctx, calculateSheet, itemDiffArticulationInfo, lformula);
            calculateSheet.getRange(row, 1).setFormula("=" + lformula);
        } else {
            calculateSheet.getRange(row, 1).setValue(new Variant((Object)lformula));
        }
        calculateSheet.getRange(row, 3).setValue(new Variant((Object)itemDiffArticulationInfo.getItemDiffIndexInfo().getOperateSymbol()));
        calculateSheet.getRange(row, 4).setValue(new Variant((Object)itemDiffArticulationInfo.getItemDiffIndexInfo().getRange()));
        calculateSheet.getRange(row, 6).setValue(new Variant((Object)orgTreeInfo));
        calculateSheet.getRange(row, 5).setValue(new Variant((Object)cslReportInfo));
        calculateSheet.getRange(row, 7).setValue(new Variant((Object)itemDiffArticulationInfo));
    }

    @Override
    public void compareCalculateValue(Map reportArticulationResult, Sheet calculateSheet, int row) throws EASBizException {
        ArticulationInfo articulationInfo = (ArticulationInfo)calculateSheet.getRange(row, 7).getValue().getValue();
        ItemDiffArticulationInfo itemDiffArticulationInfo = (ItemDiffArticulationInfo)articulationInfo;
        Variant objLValue = calculateSheet.getRange(row, 1).getValue();
        Object lValue = this.getCalculateValue(articulationInfo, objLValue, itemDiffArticulationInfo.getExpression().toString());
        itemDiffArticulationInfo.setValue(lValue);
        Variant objRValue = calculateSheet.getRange(row, 2).getValue();
        Object rValue = this.getCalculateValue(articulationInfo, objRValue, itemDiffArticulationInfo.getDiffStandValue().toString());
        BigDecimal range = itemDiffArticulationInfo.getRange();
        OperateSymbolEnum operateSymbol = itemDiffArticulationInfo.getItemDiffIndexInfo().getOperateSymbol();
        CslReportInfo report = (CslReportInfo)calculateSheet.getRange(row, 5).getValue().getValue();
        ArticulationCheckResult articulationCheckResult = (ArticulationCheckResult)reportArticulationResult.get(report.getId().toString());
        if (!this.isComparePass(lValue, rValue, operateSymbol, range)) {
            articulationInfo.setCheckResultCode(258);
            articulationCheckResult.addErrorArticulation(itemDiffArticulationInfo);
            this.setArticulationCheckResult(itemDiffArticulationInfo, articulationCheckResult);
        } else {
            articulationInfo.setCheckResultCode(257);
            if (articulationCheckResult.isDispenseArticulation()) {
                articulationCheckResult.setPassArticulationCheckResultCode();
            }
        }
    }

    private void setArticulationCheckResult(ItemDiffArticulationInfo itemDiffArticulationInfo, ArticulationCheckResult articulationCheckResult) {
        if (!articulationCheckResult.isDispenseArticulation()) {
            return;
        }
        boolean isRequestAnnotation = itemDiffArticulationInfo.getItemDiffIndexInfo().isIsRequestLabel();
        if (!isRequestAnnotation) {
            articulationCheckResult.setCheckResultCode(3);
        }
    }
}

