/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.Formula;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ItemFormulaInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery.DyItemLocationBatchQuery;
import com.kingdee.eas.fi.gr.cslrpt.articulation.fillformula.FillFormulaUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.AbstractSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.AbstractSortState;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.BatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.ICombineHandler;
import com.kingdee.eas.fi.rpt.batch.ICombineRowSetHandler;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.RowSetCombineHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctDyItemLocationBatchQuery {
    private static Logger logger = Logger.getLogger(AcctDyItemLocationBatchQuery.class);
    private BatchHelper batchHelper;
    private BatchSQLSorterRegister itemFormulaInfosortRegister;
    private BatchSQLSorterRegister ditemLocationsortRegister;
    private ParameterContext parameterContext;

    public AcctDyItemLocationBatchQuery(Context ctx) {
        this(ctx, null);
    }

    public AcctDyItemLocationBatchQuery(Context ctx, ParameterContext parameterContext) {
        this.parameterContext = parameterContext;
        this.batchHelper = new BatchHelper(ctx);
        this.itemFormulaInfosortRegister = new BatchSQLSorterRegister(new HashMap());
        this.itemFormulaInfosortRegister.setSortState((IBatchSQLSortState)new AcctDyItemLocationSortState());
    }

    public void setParameterContext(ParameterContext parameterContext) {
        this.parameterContext = parameterContext;
    }

    private void batchInitOrgBound(List orgBoundHistoryList, PeriodCollection periodCollection, AcctDyItem formula, CslReportInfo reportInfo, OrgTreeInfo orgTreeInfo, boolean isMergeByFiscalPeriod, Map<String, String> orgTreeMap) throws BOSException {
        int year = formula.year;
        int period = formula.period;
        String itemNumber = formula.orgTreeNumber;
        RptPeriodTypeEnum periodType = reportInfo.getPeriodType();
        Date periodDate = FiscalPeriodHelper.getPeriodLastDate(periodCollection, year, period, periodType, isMergeByFiscalPeriod);
        String key = formula.orgTreeNumber + "_" + year + "_" + period + "_" + periodType.getValue() + "_" + isMergeByFiscalPeriod;
        if (orgTreeMap.containsKey(key)) {
            formula.orgTreeId = orgTreeMap.get(key).toString();
            return;
        }
        for (int i = 0; i < orgBoundHistoryList.size(); ++i) {
            OrgTreeInfo treeInfo = (OrgTreeInfo)orgBoundHistoryList.get(i);
            Timestamp start = treeInfo.getStartDate();
            Timestamp end = treeInfo.getEndDate();
            Timestamp tmp = new Timestamp(periodDate.getTime());
            if (!itemNumber.equals(treeInfo.getNumber())) continue;
            if (start == null) {
                formula.orgTreeId = treeInfo.getId().toString();
                orgTreeMap.put(key, treeInfo.getId().toString());
                return;
            }
            if ((start.compareTo(tmp) > 0 || end != null) && (start.compareTo(tmp) > 0 || end.compareTo(tmp) < 0)) continue;
            formula.orgTreeId = treeInfo.getId().toString();
            orgTreeMap.put(key, treeInfo.getId().toString());
        }
    }

    public void init(List<Formula> formulaList) throws EASBizException, BOSException {
        List<OrgTreeInfo> orgBoundHistoryList;
        CslReportInfo reportInfo = (CslReportInfo)this.parameterContext.getAttribute("cslReportInfo");
        Boolean isMergeByFiscalPeriod = (Boolean)this.parameterContext.getAttribute("isMergeByFiscalPeriod");
        Boolean isSupport13Period = (Boolean)this.parameterContext.getAttribute("isSupport13Period");
        PeriodCollection periodCollection = (PeriodCollection)this.parameterContext.getAttribute("periodCollection");
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.parameterContext.getAttribute("orgTreeInfo");
        HashMap<String, String> orgTreeMap = new HashMap<String, String>();
        HashSet<String> treeNumberSet = new HashSet<String>();
        for (int i = 0; i < formulaList.size(); ++i) {
            Formula f = formulaList.get(i);
            List parameterList = ((FunctionExpr)f.getFunctionExpr()).parameters;
            String treeNumber = ((StringExpr)parameterList.get((int)0)).value;
            if (StringUtils.isEmpty((String)treeNumber)) continue;
            treeNumberSet.add(treeNumber);
        }
        if (treeNumberSet.size() > 0) {
            orgBoundHistoryList = this.getAllOrgTreeInfo(treeNumberSet);
        } else {
            orgBoundHistoryList = new ArrayList<OrgTreeInfo>();
            orgBoundHistoryList.add(orgTreeInfo);
        }
        if (reportInfo.getOrgTree() == null) {
            reportInfo.setOrgTree(orgTreeInfo);
        }
        for (Formula formula : formulaList) {
            AcctDyItem acctDyItem = new AcctDyItem(formula, this.batchHelper);
            acctDyItem.initAcctItemFormulaParameter(reportInfo);
            if (orgTreeInfo != null && StringUtils.isEmpty((String)acctDyItem.orgTreeNumber)) {
                acctDyItem.orgTreeNumber = orgTreeInfo.getNumber();
            }
            int[] yearAndPeriod = FillFormulaUtil.getRptYearAndPeriod(this.batchHelper.getServerContext(), reportInfo, periodCollection, acctDyItem.yearOffset, acctDyItem.periodOffset, isSupport13Period, isMergeByFiscalPeriod);
            acctDyItem.year = yearAndPeriod[0];
            acctDyItem.period = yearAndPeriod[1];
            this.batchInitOrgBound(orgBoundHistoryList, periodCollection, acctDyItem, reportInfo, orgTreeInfo, isMergeByFiscalPeriod, orgTreeMap);
            if (!this.isNeedLocation(acctDyItem)) continue;
            this.itemFormulaInfosortRegister.register((IFormulaCalculator)acctDyItem);
        }
    }

    private List<OrgTreeInfo> getAllOrgTreeInfo(Set<String> numberSet) throws BOSException {
        SQLBuilder builder = new SQLBuilder();
        builder.append("SELECT FId, FNumber, FStartDate, FEndDate ");
        builder.append("  FROM T_ORG_Tree ");
        builder.append(" WHERE FNumber IN ", numberSet);
        builder.append("   AND FStatus IN (1,2) and FType = 8");
        builder.append(" ORDER BY FNumber, FStartDate DESC, FEndDate DESC");
        IRowSet rs = DbUtil.executeQuery((Context)this.batchHelper.getServerContext(), (String)builder.getSQL(), (Object[])builder.getParams());
        ArrayList<OrgTreeInfo> list = new ArrayList<OrgTreeInfo>();
        try {
            while (rs.next()) {
                OrgTreeInfo treeInfo = new OrgTreeInfo();
                treeInfo.setId(BOSUuid.read((String)rs.getString("FId")));
                treeInfo.setNumber(rs.getString("FNumber"));
                treeInfo.setStartDate(rs.getTimestamp("FStartDate"));
                treeInfo.setEndDate(rs.getTimestamp("FEndDate"));
                list.add(treeInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return list;
    }

    private boolean isNeedLocation(AcctDyItem f) {
        if (f.periodOffset != f.endPeriodOffset) {
            return false;
        }
        return f.isDyItem || f.itemNumber.equals(f.endItemNumber);
    }

    private Set getParams(List entry) {
        HashSet result = new HashSet();
        int size = entry.size();
        for (int i = 0; i < size; ++i) {
            ArrayList<String> list = new ArrayList<String>();
            Map entryMap = (Map)entry.get(i);
            String itemNumber = String.valueOf(entryMap.get("itemNumber"));
            list.add(itemNumber);
            String dataElement = String.valueOf(entryMap.get("dataElement"));
            list.add(dataElement);
            result.add(list);
        }
        return result;
    }

    public void executeItemFormulaInfoBatchQuery() throws BOSException {
        RowSetCombineHandler combineHandler = new RowSetCombineHandler(new ICombineRowSetHandler(){

            public void processRowSet(IRowSet rs, IFormulaCalculator formula, IBatchSQLProcessor sqlBuilder) throws SQLException {
                AcctDyItemLocationSQLProcessor itemFormulaInfoSQLProcessor = (AcctDyItemLocationSQLProcessor)sqlBuilder;
                AcctDyItemLocationSortState itemFormulaInfoSortState = itemFormulaInfoSQLProcessor.getItemFormulaInfoSortState();
                AcctDyItem acctDyItem = (AcctDyItem)formula;
                ItemFormulaInfo itemFormulaInfo = new ItemFormulaInfo();
                itemFormulaInfo.setTemplateId(rs.getString("templateId"));
                itemFormulaInfo.setReportId(rs.getString("reportId"));
                itemFormulaInfo.setItemNumber(rs.getString("itemNumber"));
                if (!itemFormulaInfoSortState.isKeyNumberEmpty) {
                    itemFormulaInfo.setKeyNumber(rs.getString("keyNumber"));
                }
                itemFormulaInfo.setDataElement(rs.getInt("dataElement"));
                itemFormulaInfo.setValueType(rs.getInt("valueType"));
                itemFormulaInfo.setSheetId(rs.getString("sheetId"));
                itemFormulaInfo.setRow(rs.getInt("cellRow"));
                itemFormulaInfo.setCol(rs.getInt("cellCol"));
                Map extendedProperty = acctDyItem.formula.getExtendedProperty();
                extendedProperty.put("itemFormulaInfo", itemFormulaInfo);
            }
        });
        Object report = this.parameterContext.getAttribute("cslReportInfo");
        if (report instanceof CslReportInfo && ((CslReportInfo)report).getExtendedProperty("FROM_AUTOITEM") != null) {
            List sortStates = this.itemFormulaInfosortRegister.getSortStates();
            List formulas = null;
            for (IBatchSQLSortState sortState : sortStates) {
                formulas = sortState.getFormulaList();
                Iterator iterator = formulas.iterator();
                while (iterator.hasNext()) {
                    AcctDyItem formula;
                    AcctDyItem itemFormula = formula = (AcctDyItem)((Object)iterator.next());
                    Formula formula1 = itemFormula.formula;
                    ItemFormulaInfo itemFormulaInfo = new ItemFormulaInfo();
                    itemFormulaInfo.setTemplateId(null);
                    itemFormulaInfo.setReportId(null);
                    itemFormulaInfo.setItemNumber(itemFormula.itemNumber);
                    itemFormulaInfo.setDataElement(itemFormula.dataElement);
                    itemFormulaInfo.setValueType(itemFormula.valueType);
                    itemFormulaInfo.setSheetId(null);
                    itemFormulaInfo.setRow(-1);
                    itemFormulaInfo.setCol(-1);
                    Map extendedProperty = formula1.getExtendedProperty();
                    extendedProperty.put("itemFormulaInfo", itemFormulaInfo);
                }
            }
        }
        this.batchHelper.batchCalculateBigDecimalBySorter((IBatchSQLSorterProcessor)new AcctDyItemLocationSQLProcessor(this.parameterContext), (IBatchSQLSorterRegister)this.itemFormulaInfosortRegister, (ICombineHandler)combineHandler);
        DyItemLocationBatchQuery ditemLocationBatchQuery = new DyItemLocationBatchQuery(this.batchHelper.getServerContext(), this.batchHelper, this.parameterContext);
        this.registerDItemLocationFormula(ditemLocationBatchQuery);
        ditemLocationBatchQuery.executeDItemLocationBatchQuery();
    }

    private void registerDItemLocationFormula(DyItemLocationBatchQuery ditemLocationBatchQuery) {
        for (IBatchSQLSortState sortState : this.itemFormulaInfosortRegister.getSortStates()) {
            for (AcctDyItem itemFormula : sortState.getFormulaList()) {
                ditemLocationBatchQuery.registerFormula(itemFormula);
            }
        }
    }

    class AcctDyItemLocationSortState
    extends AbstractSortState {
        String orgBoundId;
        boolean isDyItem;
        boolean isKeyNumberEmpty;
        boolean isCaliber;
        boolean isAdjust;
        int year;
        int period;
        int periodType;
        int dataElement;
        int valueType;
        int dataSource;
        String dataCollectNumber;
        String currencyNumber;
        String targetCurrencyNumber;
        String fastMergeId = null;

        AcctDyItemLocationSortState() {
        }

        public void setState(IFormulaCalculator formula) {
            AcctDyItem f = (AcctDyItem)formula;
            FunctionExpr functionExpr = (FunctionExpr)f.formula.getFunctionExpr();
            this.orgBoundId = f.orgTreeId;
            this.isDyItem = "DItem".equalsIgnoreCase(functionExpr.funcionName) || "DyItem".equalsIgnoreCase(functionExpr.funcionName);
            this.isKeyNumberEmpty = StringUtils.isEmpty((String)f.keyNumber);
            this.isCaliber = f.isCaliber;
            this.isAdjust = f.isAdjust;
            this.year = f.year;
            this.period = f.period;
            this.periodType = f.periodType;
            this.valueType = f.valueType;
            this.dataSource = f.dataSource;
            this.dataCollectNumber = f.dataCollectNumber;
            this.currencyNumber = f.currencyNumber;
            this.targetCurrencyNumber = f.targetCurrencyNumber;
            this.fastMergeId = f.fastMergeId;
        }

        public String generateKey() {
            StringBuffer key = new StringBuffer();
            key.append("[").append(this.orgBoundId).append("]");
            key.append("[").append(this.isDyItem ? "1" : "0").append("]");
            key.append("[").append(this.isKeyNumberEmpty ? "1" : "0").append("]");
            key.append("[").append(this.year).append("]");
            key.append("[").append(this.period).append("]");
            key.append("[").append(this.valueType).append("]");
            key.append("[").append(this.dataSource).append("]");
            key.append("[").append(this.dataCollectNumber).append("]");
            key.append("[").append(this.fastMergeId).append("]");
            key.append("[").append(this.currencyNumber).append("]");
            key.append("[").append(this.targetCurrencyNumber).append("]");
            key.append("[").append(this.isCaliber || this.isAdjust ? "1" : "0").append("]");
            return key.toString();
        }

        public Object clone() {
            AcctDyItemLocationSortState sortState = new AcctDyItemLocationSortState();
            sortState.orgBoundId = this.orgBoundId;
            sortState.isDyItem = this.isDyItem;
            sortState.isKeyNumberEmpty = this.isKeyNumberEmpty;
            sortState.isAdjust = this.isAdjust;
            sortState.isCaliber = this.isCaliber;
            sortState.year = this.year;
            sortState.period = this.period;
            sortState.periodType = this.periodType;
            sortState.valueType = this.valueType;
            sortState.dataSource = this.dataSource;
            sortState.dataCollectNumber = this.dataCollectNumber;
            sortState.currencyNumber = this.currencyNumber;
            sortState.targetCurrencyNumber = this.targetCurrencyNumber;
            sortState.fastMergeId = this.fastMergeId;
            return sortState;
        }

        public void reset() {
            this.orgBoundId = null;
            this.isDyItem = false;
            this.isKeyNumberEmpty = false;
            this.isAdjust = false;
            this.isCaliber = false;
            this.year = 0;
            this.period = 0;
            this.periodType = 0;
            this.valueType = 0;
            this.dataSource = 0;
            this.dataCollectNumber = null;
            this.currencyNumber = null;
            this.targetCurrencyNumber = null;
            this.fastMergeId = null;
        }
    }

    class AcctDyItemLocationSQLProcessor
    extends AbstractSQLProcessor {
        private int maxsqlvar = 300;
        private ParameterContext parameterContext;

        AcctDyItemLocationSQLProcessor(ParameterContext parameterContext) {
            this.parameterContext = parameterContext;
            Object batchSize = parameterContext.getAttribute("KEY_CSLPARAM_CHECKFORMULA_ITEMBATCH_SIZE");
            if (batchSize != null) {
                try {
                    this.maxsqlvar = (Integer)batchSize;
                }
                catch (Exception e) {
                    this.maxsqlvar = 300;
                }
            }
        }

        public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
            AcctDyItemLocationSortState itemFormulaInfoSortState = this.getItemFormulaInfoSortState();
            AcctDyItem itemFormula = (AcctDyItem)formula;
            ArrayList<Object> fields = new ArrayList<Object>();
            fields.add(itemFormula.orgUnitNumber);
            fields.add(itemFormula.itemNumber);
            fields.add(new Integer(itemFormula.dataElement));
            Object[][] result = new Object[1][fields.size()];
            result[0] = fields.toArray();
            return result;
        }

        public String[] getIndexResultSetFields() {
            AcctDyItemLocationSortState itemFormulaInfoSortState = this.getItemFormulaInfoSortState();
            ArrayList<String> indexedFields = new ArrayList<String>();
            indexedFields.add("orgUnitNumber");
            indexedFields.add("itemNumber");
            indexedFields.add("dataElement");
            String[] result = new String[indexedFields.size()];
            indexedFields.toArray(result);
            return result;
        }

        private AcctDyItemLocationSortState getItemFormulaInfoSortState() {
            return (AcctDyItemLocationSortState)this.sortState;
        }

        public int getMaxSQLVaribleSize() {
            return this.maxsqlvar;
        }

        public void buildSelectPart(Set nullSet, StringBuffer sql) {
            sql.append(" SELECT DISTINCT t.FId templateId, r.FId reportId, l.FItemNumber itemNumber,");
            sql.append("        c1.FNumber currencyNumber, c2.FNumber targetCurrencyNumber, u.FNumber orgUnitNumber, ");
            if (!this.getItemFormulaInfoSortState().isKeyNumberEmpty) {
                sql.append(" l.FKeyNumber keyNumber, \n");
            }
            sql.append(" l.FDataElement dataElement, l.FValueType valueType, l.FSheetId sheetId, l.FPosX cellCol, l.FPosY cellRow \n");
        }

        public void buildFromPart(Set nullSet, StringBuffer sql) {
            CslReportInfo reportInfo = (CslReportInfo)this.parameterContext.getAttribute("cslReportInfo");
            String tblName = (String)this.parameterContext.getAttribute("tempTblName");
            int templateType = reportInfo.getTemplate().getTemplateType().getValue();
            int periodType = reportInfo.getPeriodType().getValue();
            sql.append(" FROM T_CSL_CslReport r");
            sql.append(" JOIN T_RPT_Template t ON (t.FId= r.FTemplateId OR r.FTemplateId = t.FGroupTemplateId)");
            sql.append(" JOIN T_CSL_TempletItemList l ON (t.FId = l.FTemplateId OR l.FTemplateId= t.FGroupTemplateId)");
            sql.append(" JOIN T_RPT_RptSheetPara sp ON sp.FReportId = r.FId AND sp.FSheetId = l.FSheetId");
            sql.append(" JOIN T_BD_Currency c1 ON c1.FId = r.FSourceCurrencyId");
            sql.append(" JOIN T_BD_Currency c2 ON c2.FId = r.FCurrencyId");
            sql.append(" JOIN T_ORG_BaseUnit u ON u.FId = r.FOrgUnitId");
            sql.append(" JOIN T_CSL_RptReceived rec ON rec.FReportId = r.FId \n");
            sql.append(" left join T_Csl_SumRptAddedPerporty added on added.freport=r.fid and added.FIsSupportGroup=2 \n");
        }

        public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
            AcctDyItemLocationSortState ss = this.getItemFormulaInfoSortState();
            sql.append(" WHERE t.FPeriodType=?\n");
            params.add(ss.periodType);
            if (ss.dataSource != 32 && ss.dataSource != 35) {
                sql.append(" and added.fid is null ");
            }
            sql.append("   AND r.FDataCollectNumber = ?\n");
            params.add(ss.dataCollectNumber);
            sql.append("   AND r.FPeriodType = ?\n");
            params.add(ss.periodType);
            if (StringUtils.isEmpty((String)ss.fastMergeId)) {
                if (ss.dataSource == 31 || ss.dataSource == 34 || ss.dataSource == 35 || ss.dataSource == 32) {
                    sql.append("   AND (r.FFastMergeSoluId IS NULL OR r.FFastMergeSoluId='')\n");
                }
            } else {
                sql.append("   AND r.FFastMergeSoluId = ?\n");
                params.add(ss.fastMergeId);
            }
            sql.append("   AND sp.FReportClass=? ");
            params.add(1);
            sql.append("   AND l.FValueType =?\n");
            params.add(ss.valueType);
            sql.append("   AND rec.FOrgTreeId = ?\n");
            params.add(ss.orgBoundId);
            if (ss.isDyItem) {
                if (ss.isKeyNumberEmpty) {
                    sql.append(" AND (l.FKeyNumber = '' OR l.FKeyNumber IS NULL)    \n");
                }
            } else {
                sql.append(" AND UCASE(l.FKeyNumber) = 'NULL' \n");
            }
            sql.append("   AND r.FAdjustStatus=0");
            if (ss.dataSource == 1 || ss.dataSource == 7) {
                sql.append("   AND r.FSourceType IN (1,7)");
            } else {
                sql.append("   AND r.FSourceType=" + ss.dataSource);
            }
            sql.append(" AND l.FValueType = ? \n");
            params.add(ss.valueType);
            sql.append(" AND r.FYear=? \n");
            params.add(ss.year);
            sql.append(" AND r.FPeriod=? \n");
            params.add(ss.period);
            sql.append(" AND c1.FNumber=? \n");
            params.add(ss.currencyNumber);
            sql.append(" AND c2.FNumber = ? \n");
            params.add(ss.targetCurrencyNumber);
            sql.append(" AND (");
        }

        public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
            AcctDyItemLocationSortState ss = this.getItemFormulaInfoSortState();
            AcctDyItem f = (AcctDyItem)formula;
            sql.append(" (u.FNumber =? ");
            params.add(f.orgUnitNumber);
            sql.append(" AND l.FDataElement = ?\n");
            params.add(f.dataElement);
            sql.append(" AND l.FItemNumber = ?\n");
            params.add(f.itemNumber);
            sql.append(")");
        }

        public void buildGroupByPart(Set nullSet, StringBuffer sql) {
            sql.append(")");
        }

        private boolean isCslReport(RptSrcTypeEnum rptSourceType) {
            return RptSrcTypeEnum.CONSOLIDATION.equals((Object)rptSourceType) || RptSrcTypeEnum.SUM.equals((Object)rptSourceType) || RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)rptSourceType) || RptSrcTypeEnum.DYNAMICSUMREPORT.equals((Object)rptSourceType) || RptSrcTypeEnum.MANUSCRIPT.equals((Object)rptSourceType);
        }
    }

    class AcctDyItem
    extends AbstractFormulaCalculator {
        BatchHelper batchHelper;
        Formula formula;
        String orgTreeNumber;
        String orgUnitNumber;
        String currencyNumber;
        String targetCurrencyNumber;
        String orgTreeId;
        String itemNumber;
        String endItemNumber;
        String keyNumber;
        int yearOffset;
        int periodOffset;
        int endPeriodOffset;
        int year;
        int period;
        int dataElement;
        int valueType;
        String dataCollectNumber;
        String fastMergeId = null;
        int periodType;
        boolean isShortNum;
        boolean isAdjust;
        int dataSource;
        boolean isGroupUnCommited;
        boolean isCaliber;
        boolean isDyItem;

        public AcctDyItem(Formula formula, BatchHelper batchHelper) {
            this.formula = formula;
            this.batchHelper = batchHelper;
        }

        private void initAcctItemFormulaParameter(CslReportInfo reportInfo) throws EASBizException, BOSException {
            FunctionExpr functionExpr = (FunctionExpr)this.formula.getFunctionExpr();
            List parameterList = functionExpr.parameters;
            this.isDyItem = "DyItem".equalsIgnoreCase(functionExpr.funcionName);
            this.orgTreeNumber = ((StringExpr)parameterList.get((int)0)).value;
            this.orgUnitNumber = ((StringExpr)parameterList.get((int)1)).value;
            this.currencyNumber = ((StringExpr)parameterList.get((int)2)).value;
            this.targetCurrencyNumber = ((StringExpr)parameterList.get((int)3)).value;
            this.itemNumber = ((StringExpr)parameterList.get((int)4)).value;
            this.periodType = RptPeriodTypeEnum.getEnum((String)((StringExpr)parameterList.get((int)6)).value).getValue();
            Object object = parameterList.get(7);
            this.yearOffset = object instanceof UnaryOperationExpr ? Integer.valueOf(object.toString()).intValue() : ((IntExpr)parameterList.get((int)7)).value.intValue();
            Object object1 = parameterList.get(8);
            this.periodOffset = object1 instanceof UnaryOperationExpr ? Integer.valueOf(object1.toString()).intValue() : ((IntExpr)parameterList.get((int)8)).value.intValue();
            Object object2 = parameterList.get(9);
            this.endPeriodOffset = object2 instanceof UnaryOperationExpr ? Integer.valueOf(object2.toString()).intValue() : ((IntExpr)parameterList.get((int)9)).value.intValue();
            this.dataSource = RptSrcTypeEnum.getEnum((String)((StringExpr)parameterList.get((int)10)).value).getValue();
            this.dataElement = DataElementProvider.getDataElementInnerValue(this.batchHelper.getServerContext(), ((StringExpr)parameterList.get((int)11)).value);
            this.valueType = ValueTypeEnum.getEnum(((StringExpr)parameterList.get((int)12)).value).getValue();
            this.isAdjust = Boolean.valueOf(((Expression)parameterList.get(13)).toString());
            this.dataCollectNumber = ((StringExpr)parameterList.get((int)15)).value;
            if ("DyItem".equalsIgnoreCase(functionExpr.funcionName)) {
                this.keyNumber = ((StringExpr)parameterList.get((int)5)).value;
                this.isShortNum = Boolean.valueOf(((Expression)parameterList.get(14)).toString());
                if (parameterList.size() > 16) {
                    this.fastMergeId = ((StringExpr)parameterList.get((int)16)).value;
                }
                if (parameterList.size() > 17) {
                    this.isGroupUnCommited = Boolean.valueOf(((Expression)parameterList.get(17)).toString());
                }
            } else {
                this.endItemNumber = ((StringExpr)parameterList.get((int)5)).value;
                this.isGroupUnCommited = Boolean.valueOf(((Expression)parameterList.get(14)).toString());
                this.isCaliber = Boolean.valueOf(((Expression)parameterList.get(16)).toString());
                if (parameterList.size() > 17) {
                    this.fastMergeId = ((StringExpr)parameterList.get((int)17)).value;
                }
            }
            if (StringUtils.isEmpty((String)this.dataCollectNumber)) {
                this.dataCollectNumber = FillFormulaUtil.getDataCollectNumber(reportInfo, this.dataCollectNumber);
            }
            if (StringUtils.isEmpty((String)this.fastMergeId)) {
                if (this.dataSource == 31 || this.dataSource == 32 || this.dataSource == 34 || this.dataSource == 35) {
                    this.fastMergeId = reportInfo.getFastMergeSoluId();
                }
            } else {
                int isAutoSum = 0;
                if (this.dataSource == 31 || this.dataSource == 11) {
                    isAutoSum = 1;
                }
                try {
                    this.fastMergeId = FastMergeSoluFactory.getLocalInstance(this.batchHelper.getServerContext()).getFastMergeSoluInfo("select id where number = '" + this.fastMergeId + "' and isAutoSum =" + isAutoSum + "").getId().toString();
                }
                catch (Exception e) {
                    logger.error((Object)"get fastMergeSolu error.", (Throwable)e);
                    throw new BOSException(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.fast.FastMergeResource", (String)(isAutoSum == 1 ? "75_sumSoluNotExist" : "76_cslSoluNotExist")), this.fastMergeId), (Throwable)e);
                }
            }
            if (StringUtils.isEmpty((String)this.orgTreeNumber) && reportInfo.getOrgTree() != null) {
                this.orgTreeNumber = reportInfo.getOrgTree().getNumber();
            }
            if (StringUtils.isEmpty((String)this.orgUnitNumber)) {
                this.orgUnitNumber = reportInfo.getOrgUnit().getNumber();
            }
            if (StringUtils.isEmpty((String)this.currencyNumber)) {
                this.currencyNumber = reportInfo.getSourceCurrency().getNumber();
            }
            if (StringUtils.isEmpty((String)this.targetCurrencyNumber)) {
                this.targetCurrencyNumber = reportInfo.getCurrency().getNumber();
            }
        }
    }
}

