/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.Formula;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ItemFormulaInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery.AcctDyItemLocationBatchQuery;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.rpt.batch.AbstractSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.AbstractSortState;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.BatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.ICombineHandler;
import com.kingdee.eas.fi.rpt.batch.ICombineRowSetHandler;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.RowSetCombineHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class DyItemLocationBatchQuery {
    private BatchHelper batchHelper;
    private BatchSQLSorterRegister sortRegister;
    private ParameterContext parameterContext;

    private void initSortRegister() {
        this.sortRegister = new BatchSQLSorterRegister(new HashMap());
        this.sortRegister.setSortState((IBatchSQLSortState)new DyItemLocationSortState());
    }

    public DyItemLocationBatchQuery(Context ctx, BatchHelper batchHelper, ParameterContext parameterContext) {
        this.batchHelper = new BatchHelper(ctx);
        this.parameterContext = parameterContext;
        this.initSortRegister();
    }

    public void registerFormula(AcctDyItemLocationBatchQuery.AcctDyItem f) {
        Formula formula1 = f.formula;
        Map extendedProperty = formula1.getExtendedProperty();
        FunctionExpr functionExpr = (FunctionExpr)formula1.getFunctionExpr();
        String formulaName = functionExpr.funcionName;
        if (formulaName.equalsIgnoreCase("DYITEM") && !StringUtils.isEmpty((String)f.keyNumber) && extendedProperty.get("itemFormulaInfo") != null) {
            this.sortRegister.register((IFormulaCalculator)f);
        }
    }

    public void executeDItemLocationBatchQuery() throws BOSException {
        RowSetCombineHandler combineHandler = new RowSetCombineHandler(new ICombineRowSetHandler(){

            public void processRowSet(IRowSet rs, IFormulaCalculator formula, IBatchSQLProcessor sqlBuilder) throws SQLException {
                AcctDyItemLocationBatchQuery.AcctDyItem f = (AcctDyItemLocationBatchQuery.AcctDyItem)formula;
                Formula formula1 = f.formula;
                Map extendedProperty = formula1.getExtendedProperty();
                ItemFormulaInfo itemFormulaInfo = (ItemFormulaInfo)extendedProperty.get("itemFormulaInfo");
                itemFormulaInfo.setRow(rs.getInt("cellRow"));
                itemFormulaInfo.setCol(rs.getInt("cellCol"));
                extendedProperty.put("itemFormulaInfo", itemFormulaInfo);
            }
        });
        this.batchHelper.batchCalculateBigDecimalBySorter((IBatchSQLSorterProcessor)new DyItemLocationSQLProcessor(), (IBatchSQLSorterRegister)this.sortRegister, (ICombineHandler)combineHandler);
    }

    class DyItemLocationSQLProcessor
    extends AbstractSQLProcessor {
        private int maxsqlvar = 300;

        public DyItemLocationSQLProcessor() {
            this.initMaxSQLVaribleSize();
        }

        public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
            AcctDyItemLocationBatchQuery.AcctDyItem f = (AcctDyItemLocationBatchQuery.AcctDyItem)formula;
            ArrayList<Object> fields = new ArrayList<Object>();
            fields.add(f.itemNumber);
            fields.add(f.keyNumber);
            fields.add(new Integer(f.dataElement));
            Object[][] result = new Object[1][fields.size()];
            result[0] = fields.toArray();
            return result;
        }

        public String[] getIndexResultSetFields() {
            ArrayList<String> indexedFields = new ArrayList<String>();
            indexedFields.add("itemNumber");
            indexedFields.add("keyNumber");
            indexedFields.add("dataElement");
            String[] result = new String[indexedFields.size()];
            indexedFields.toArray(result);
            return result;
        }

        public int getMaxSQLVaribleSize() {
            return this.maxsqlvar;
        }

        private void initMaxSQLVaribleSize() {
            Object batchSize = DyItemLocationBatchQuery.this.parameterContext.getAttribute("KEY_CSLPARAM_CHECKFORMULA_DITEMBATCH_SIZE");
            if (batchSize != null) {
                try {
                    this.maxsqlvar = (Integer)batchSize;
                }
                catch (Exception e) {
                    this.maxsqlvar = 300;
                }
            }
        }

        public void buildSelectPart(Set nullSet, StringBuffer sql) {
            sql.append(" SELECT entry.FRow cellRow, entry.FCol cellCol, entry.FSheetId sheetId,");
            sql.append(" entry.FItemId itemNumber, entry.FKeyNumber keyNumber, entry.FDataelement dataElement");
        }

        public void buildFromPart(Set nullSet, StringBuffer sql) {
            sql.append(" FROM T_CSL_DynaitemDataEntry entry \n");
            sql.append(" JOIN T_CSL_DynaitemData dyItemData on entry.FItemDataID = dyItemData.FID \n");
        }

        public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
            DyItemLocationSortState ss = (DyItemLocationSortState)this.sortState;
            sql.append(" WHERE entry.FYear=? \n");
            sql.append("   AND entry.FPeriod=? \n");
            sql.append("   AND entry.FValueType=? \n");
            sql.append("   AND dyItemData.FReportID=? \n");
            sql.append("   AND dyItemData.FPeriodType=? \n");
            sql.append("   AND (");
            params.add(ss.year);
            params.add(ss.period);
            params.add(ss.valueType);
            params.add(ss.reportId);
            params.add(((CslReportInfo)DyItemLocationBatchQuery.this.parameterContext.getAttribute("cslReportInfo")).getPeriodType().getValue());
        }

        public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
            sql.append("(entry.FItemID = ? AND entry.FkeyNumber = ? AND entry.FDataElement = ?)");
            AcctDyItemLocationBatchQuery.AcctDyItem f = (AcctDyItemLocationBatchQuery.AcctDyItem)formula;
            params.add(f.itemNumber);
            params.add(f.keyNumber);
            params.add(f.dataElement);
        }

        public void buildGroupByPart(Set nullSet, StringBuffer sql) {
            sql.append(")");
        }
    }

    class DyItemLocationSortState
    extends AbstractSortState {
        String reportId;
        int year;
        int period;
        int valueType;

        DyItemLocationSortState() {
        }

        public void setState(IFormulaCalculator formula) {
            AcctDyItemLocationBatchQuery.AcctDyItem f = (AcctDyItemLocationBatchQuery.AcctDyItem)formula;
            this.year = f.year;
            this.period = f.period;
            this.valueType = f.valueType;
            Formula formula1 = f.formula;
            Map extendedProperty = formula1.getExtendedProperty();
            ItemFormulaInfo itemFormulaInfo = (ItemFormulaInfo)extendedProperty.get("itemFormulaInfo");
            this.reportId = itemFormulaInfo.getReportId();
        }

        public String generateKey() {
            StringBuffer sortKey = new StringBuffer();
            sortKey.append("[").append(this.year).append("]");
            sortKey.append("[").append(this.period).append("]");
            sortKey.append("[").append(this.valueType).append("]");
            sortKey.append("[").append(this.reportId).append("]");
            return sortKey.toString();
        }

        public Object clone() {
            DyItemLocationSortState sortState = new DyItemLocationSortState();
            sortState.year = this.year;
            sortState.period = this.period;
            sortState.valueType = this.valueType;
            sortState.reportId = this.reportId;
            return sortState;
        }

        public void reset() {
            this.year = 0;
            this.period = 0;
            this.valueType = 0;
            this.reportId = null;
        }
    }
}

