/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.OperateSymbolEnum;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.Formula;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ItemFormulaInfo;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MessageDisplayUtil {
    static String setItemFormulaInformation(String item, Map<String, Formula> detailFormulaMap, CslReportInfo report, Book book, Map itemFormulaPointMap) {
        if (StringUtils.isEmpty((String)item)) {
            return "";
        }
        StringBuffer replaceItem = new StringBuffer();
        if (item.indexOf(",") == -1) {
            return item;
        }
        replaceItem.append(item.replaceAll("\\\"", "\\\\\"").replaceAll(" ", ""));
        for (String formula : detailFormulaMap.keySet()) {
            Formula formulaInfo;
            Map extendedProperty;
            StringBuffer replaceFormula = new StringBuffer();
            StringBuffer replaceFormulaFormal = new StringBuffer();
            if (formula.indexOf(",") != -1) {
                replaceFormula.append(formula.replaceAll("\\\"", "\\\\\"").replaceAll(" ", ""));
                replaceFormulaFormal.append(formula.replaceAll(" ", ""));
            }
            if (StringUtils.isEmpty((String)replaceFormula.toString()) || (extendedProperty = (formulaInfo = detailFormulaMap.get(formula)).getExtendedProperty()).get("itemFormulaInfo") == null) continue;
            ItemFormulaInfo itemFormulaInfo = (ItemFormulaInfo)extendedProperty.get("itemFormulaInfo");
            int row = itemFormulaInfo.getRow();
            int col = itemFormulaInfo.getCol();
            String reportId = itemFormulaInfo.getReportId();
            String sheetId = itemFormulaInfo.getSheetId();
            String link = "<a href=" + reportId + "," + sheetId + "," + row + "," + col + "," + (MessageDisplayUtil.isDItem(formula) ? formula.replace(" ", "").replaceAll(",", "@").replaceAll("\"", "##") : null) + ">" + formula.toString() + "</a>";
            String tempFormula = replaceFormulaFormal.toString();
            tempFormula = tempFormula.replaceAll("\\(", "\\\\(");
            tempFormula = tempFormula.replaceAll("\\)", "\\\\)");
            tempFormula = tempFormula.replaceAll("\\|", "\\\\|");
            tempFormula = tempFormula.replaceAll("\\*", "\\\\*");
            item = item.trim().replaceAll(tempFormula, link);
        }
        return item;
    }

    private static CslReportInfo getReportTyppe(String id) throws EASBizException, BOSException, UuidException {
        SelectorItemCollection select = new SelectorItemCollection();
        select.add(new SelectorItemInfo("sourceType"));
        select.add(new SelectorItemInfo("data"));
        return CslReportFactory.getLocalInstance(ContextUtils.getContextFromSession()).getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), select);
    }

    private static boolean isDItem(String item) {
        return item.startsWith("DITEM") || item.startsWith("=DITEM") || item.startsWith("DYITEM") || item.startsWith("=DYITEM");
    }

    private static ItemFormula getItemFormula(String item) {
        if (MessageDisplayUtil.isDItem(item)) {
            return MessageDisplayUtil.getDItemFormula(item);
        }
        if (item.startsWith("ITEM") || item.startsWith("=ITEM")) {
            if (item.charAt(0) == '=') {
                return new ItemFormula(item.replaceFirst("ITEM", "Item"));
            }
            return new ItemFormula(item.replaceFirst("ITEM", "=Item"));
        }
        if (item.startsWith("ACCTITEM") || item.startsWith("=ACCTITEM")) {
            try {
                Expression exp;
                if (item.charAt(0) == '=') {
                    item = item.substring(1);
                }
                if ((exp = ExcelFormulaPaserHelper.parse((String)item)) instanceof FunctionExpr) {
                    FunctionExpr foo = (FunctionExpr)exp;
                    List params = foo.parameters;
                    String rptItem = params.get(4).toString();
                    if (!StringUtils.isEmpty((String)rptItem) && rptItem.trim().equals(params.get(5).toString())) {
                        rptItem = rptItem.trim();
                        rptItem = rptItem.substring(1, rptItem.length() - 1);
                        ItemFormula curItem = new ItemFormula();
                        curItem.setItemNumber(rptItem);
                        String year = params.get(7).toString();
                        if ("0".equals(year) && params.get(8).toString().equals("0") && params.get(9).toString().equals("0")) {
                            curItem.putExt("1", "0");
                            curItem.putExt("2", "0");
                            String dataElement = params.get(11).toString();
                            curItem.putExt("3", dataElement.substring(1, dataElement.length() - 1));
                            curItem.putExt("4", "1");
                            return curItem;
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.error((Throwable)e, (String)"");
            }
        }
        return null;
    }

    private static ItemFormula getDItemFormula(String item) {
        if (item.charAt(0) == '=') {
            return new ItemFormula(item.replaceFirst("DITEM", "DItem"));
        }
        return new ItemFormula(item.replaceFirst("DITEM", "=DItem"));
    }

    public static Book getBook(CslReportInfo report) {
        Book book;
        try {
            book = report.getBook();
        }
        catch (Exception e) {
            book = null;
        }
        return book;
    }

    static String getItemFormulaCellPostil(Map detailFormulaMap, Locale locale) {
        StringBuffer postilBuffer = new StringBuffer();
        for (String formula : detailFormulaMap.keySet()) {
            ItemFormulaInfo itemFormulaInfo;
            Formula formulaInfo = (Formula)detailFormulaMap.get(formula);
            Map extendedProperty = formulaInfo.getExtendedProperty();
            if (extendedProperty.get("itemFormulaInfo") == null || StringUtils.isEmpty((String)(itemFormulaInfo = (ItemFormulaInfo)extendedProperty.get("itemFormulaInfo")).getPostil())) continue;
            postilBuffer.append(itemFormulaInfo.getPostil()).append("\n");
        }
        if (postilBuffer.length() == 0) {
            return null;
        }
        String tempStr = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CheckFormula", (String)"CHECK_MESSAGE_48", (Locale)locale);
        return tempStr + postilBuffer.toString();
    }

    static String getOperateSymbolStr(OperateSymbolEnum operateSymbol, Locale locale) {
        StringBuffer sb = new StringBuffer();
        if (operateSymbol == OperateSymbolEnum.LESS) {
            sb.append("&lt;");
        } else if (operateSymbol == OperateSymbolEnum.MORE) {
            sb.append("&gt;");
        } else if (operateSymbol == OperateSymbolEnum.MOREANDEQUAL) {
            sb.append("&gt;").append("=");
        } else if (operateSymbol == OperateSymbolEnum.LESSANDEQUAL) {
            sb.append("&lt;").append("=");
        } else if (operateSymbol == OperateSymbolEnum.UNEQUAL) {
            sb.append("&lt;").append("&gt;");
        } else {
            sb.append(operateSymbol.getAlias(locale));
        }
        return sb.toString();
    }
}

