/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.assist;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.HandleWhenNoValueFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.IHandleReferenceExpr;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.EmptyArgExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import org.apache.log4j.Logger;

public class BookExpressionHandler
implements IEditableExpressionHandler {
    private static final Logger log = Logger.getLogger(BookExpressionHandler.class);
    protected Sheet sheet;
    private IHandleReferenceExpr handleReferenceExpr;

    public BookExpressionHandler(Sheet sheet) {
        this.sheet = sheet;
    }

    public Expression handle(Expression expr) {
        return this.handle(expr, this.sheet);
    }

    public Expression handle(Expression expr, Sheet currSheet) {
        if (!(expr instanceof FunctionExpr)) {
            if (expr instanceof Ref3DExpr) {
                String sheetName = ((Ref3DExpr)expr).sheetName;
                Sheet otherSheet = currSheet.getBook().getSheet(sheetName);
                if (otherSheet == null) {
                    log.error((Object)("error sheetName:" + sheetName));
                    return expr;
                }
                ReferenceExpr ref = ((Ref3DExpr)expr).ref;
                Cell cell = otherSheet.getCell(ref.row, ref.col, false);
                return this.handleReferenceExpr(ref, cell);
            }
            if (expr instanceof ReferenceExpr) {
                Cell cell = currSheet.getCell(((ReferenceExpr)expr).row, ((ReferenceExpr)expr).col, true);
                return this.handleReferenceExpr((ReferenceExpr)expr, cell);
            }
            if (expr instanceof BinaryOperationExpr) {
                // empty if block
            }
        }
        return expr;
    }

    protected Expression handleReferenceExpr(ReferenceExpr expr, Cell cell) {
        Expression exprAfterHandle;
        Sheet currSheet = cell.getSheet();
        if (this.handleReferenceExpr != null && (exprAfterHandle = this.handleReferenceExpr.exec(expr, cell)) != null) {
            return exprAfterHandle;
        }
        Expression retExpr = new HandleWhenNoValueFormula().exec(cell);
        if (retExpr != null) {
            return retExpr;
        }
        try {
            Expression exp = ExcelFormulaPaserHelper.parse((String)cell.getFormula());
            if (exp instanceof ReferenceExpr && exp.toString().equals(expr.toString())) {
                return new EmptyArgExpr();
            }
            return this.handle(exp, currSheet);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return expr;
        }
    }

    public void setHandleReferenceExpr(IHandleReferenceExpr handleReferenceExpr) {
        this.handleReferenceExpr = handleReferenceExpr;
    }
}

