/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz;

import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynFormulaDefineCollection;
import com.kingdee.eas.fi.gr.cslrpt.DynFormulaDefineInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ICreateFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CombineFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.DynaItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.SingleFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ReplaceValueFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.dynamic.fill.AsstActObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class CreateBaseLevelDynaFormula
implements ICreateFormula {
    @Override
    public boolean isMeet(OrgUnitInfo company, FormulaSchemeInfo schemeInfo) {
        boolean isMeet = !schemeInfo.getDynFormulaDefine().isEmpty() && "DITEM".equalsIgnoreCase(schemeInfo.getItemFormula().getName());
        DynFormulaDefineCollection dynDefines = schemeInfo.getDynFormulaDefine();
        DynFormulaDefineInfo dynDefine = null;
        int defineSize = dynDefines.size();
        for (int defineIndex = 0; defineIndex < defineSize; ++defineIndex) {
            dynDefine = dynDefines.get(defineIndex);
            isMeet = isMeet && !dynDefine.isIsLevelManualSum() && dynDefine.isIsLevelSum();
        }
        return isMeet;
    }

    @Override
    public Map<IFormula, IFormula> exec(OrgUnitInfo company, FormulaSchemeInfo schemeInfo, List<AsstActObject> asstObjs) {
        HashMap<IFormula, IFormula> itemFormulas = new HashMap<IFormula, IFormula>();
        DynaItemFormula dynaItemFormula = new DynaItemFormula(schemeInfo.getItemFormula());
        IFormula dynaValueFormula = schemeInfo.getValueFormulaInfo();
        Stack<SumFormula> formulaStack = new Stack<SumFormula>();
        ArrayList<SumFormula> formulas = new ArrayList<SumFormula>(asstObjs.size());
        SumFormula formula = null;
        SumFormula stackFormula = null;
        IFormula valueFormula = null;
        ReplaceValueFormula replaceValueFormula = ActionFactory.get(ReplaceValueFormula.class);
        for (AsstActObject asstObj : asstObjs) {
            if (!asstObj.isLeaf()) continue;
            formula = new SumFormula();
            dynaItemFormula.setDynaItem(asstObj.getLongNumber());
            formula.item = (IFormula)dynaItemFormula.getFormulaInfo().clone();
            formula.item.putExtendProperty("AssistName", asstObj.getName());
            formula.longNumber = asstObj.getLongNumber();
            if (dynaValueFormula != null) {
                valueFormula = (IFormula)dynaValueFormula.clone();
                replaceValueFormula.exec("\\@", valueFormula, asstObj.getNumber());
            }
            formula.formula = valueFormula;
            while (!formulaStack.isEmpty()) {
                stackFormula = (SumFormula)formulaStack.peek();
                if (!formula.longNumber.startsWith(stackFormula.longNumber + "!")) {
                    formulaStack.pop();
                    continue;
                }
                stackFormula.addSub(formula);
                break;
            }
            formulas.add(formula);
            formulaStack.add(formula);
        }
        for (SumFormula f : formulas) {
            itemFormulas.put(f.item, f.getFormula());
        }
        return itemFormulas;
    }

    private static class SumFormula {
        IFormula item;
        IFormula formula;
        String longNumber;
        List<SumFormula> subFormulas = new ArrayList<SumFormula>(1);

        private SumFormula() {
        }

        void addSub(SumFormula sub) {
            this.subFormulas.add(sub);
        }

        IFormula getFormula() {
            if (this.subFormulas.isEmpty()) {
                return this.formula;
            }
            this.formula = new CombineFormula(new ArrayList<SingleFormula>(0), "");
            for (SumFormula subFormula : this.subFormulas) {
                ((CombineFormula)this.formula).addFunc(subFormula.getFormula(), "+");
            }
            return this.formula;
        }
    }
}

