/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.PutReportSheetParam2Sheet;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.IReportEntity;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ConvertReportType2TemplateType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QuerySheetParams;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import java.io.IOException;

public class ReportEntityForReport
implements IReportEntity {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", ReportEntityForReport.class);
    private ReportInfo report;
    private QuerySheetParams querySheetParams;

    public ReportEntityForReport(ReportInfo report, QuerySheetParams querySheetParams) {
        this.report = report;
        this.querySheetParams = querySheetParams;
    }

    @Override
    public Book getBook() throws BOSException {
        try {
            return this.report.getBook();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public Object get(String attribute) {
        return null;
    }

    @Override
    public RptTmpTypeEnum getType() {
        return new ConvertReportType2TemplateType().exec(this.report.getSourceType());
    }

    @Override
    public void setBook(Book book) throws BOSException {
        try {
            this.report.setBook(book);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public RptSheetParamInfo getSheetParam(String sheetId) {
        Object sheetParam = this.report.get("sheet" + sheetId);
        if (!(sheetParam instanceof RptSheetParamInfo)) {
            this.reQuerySheetParams();
            sheetParam = this.report.get("sheet" + sheetId);
            if (!(sheetParam instanceof RptSheetParamInfo)) {
                sheetParam = null;
            }
        }
        if (sheetParam == null && this.querySheetParams != null) {
            try {
                Book book = this.getBook();
                sheetParam = this.querySheetParams.exec(book, book.getSheetByID(sheetId), (VirtualSheetParamInfo)this.report);
            }
            catch (Exception e) {
                LOG.warn("", e);
            }
        }
        return (RptSheetParamInfo)sheetParam;
    }

    @Override
    public RptSheetParamCollection getSheetParams() {
        RptSheetParamCollection sheetParams = this.report.getSheetParam();
        if (sheetParams.isEmpty()) {
            this.reQuerySheetParams();
            return this.report.getSheetParam();
        }
        return sheetParams;
    }

    @Override
    public void put(String sheetId, RptSheetParamInfo sheetParam) {
        this.report.put("sheet" + sheetId, (Object)sheetParam);
    }

    public void reQuerySheetParams() {
        try {
            if (this.report.getSheetParam().isEmpty()) {
                if (this.querySheetParams == null) {
                    LOG.error("need report QuerySheetParam for IReportEntity");
                    return;
                }
                this.querySheetParams.exec((VirtualSheetParamInfo)this.report);
            }
            ActionFactory.get(PutReportSheetParam2Sheet.class).put(this, this.report.getSheetParam());
        }
        catch (BOSException e) {
            LOG.error("", e);
        }
    }

    public ReportInfo getReportInfo() {
        return this.report;
    }
}

