/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FormulaParameter;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ChangeInt;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ChangeIntWrap;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.GeneralUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.IChangeIntWrap;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractFormula
implements IFormula {
    private static final long serialVersionUID = 9035286545722667643L;
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", AbstractFormula.class);
    protected String name;
    protected List<Object> params = new ArrayList<Object>();
    protected List<String> paramNames = new ArrayList<String>();
    protected Set<FormulaParameter> formulaParams = new HashSet<FormulaParameter>();
    private IChangeIntWrap level = new ChangeIntWrap(new ChangeInt(0));
    protected Map<Object, Object> extendedProps = new HashMap<Object, Object>(2);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<Object> getParams() {
        return this.params;
    }

    public void setParams(List<Object> params) {
        this.params = params;
    }

    @Override
    public void addParam(String paramName, Object paramValue) {
        int paramIndex = this.paramNames.indexOf(paramName);
        if (!"".equals(paramName) && paramIndex != -1) {
            if (this.paramNames.size() > this.params.size()) {
                this.params.add(paramIndex, paramValue);
            } else {
                this.params.set(paramIndex, paramValue);
            }
            return;
        }
        this.params.add(paramValue);
        this.paramNames.add(paramName);
    }

    @Override
    public void setParamNames(String[] paramNames) {
        this.paramNames = GeneralUtil.asList(paramNames);
    }

    @Override
    public Object getParam(String paramName) {
        int paramIndex = this.paramNames.indexOf(paramName);
        if (paramIndex == -1 || paramIndex >= this.params.size()) {
            return null;
        }
        return this.params.get(paramIndex);
    }

    @Override
    public boolean isValid() {
        return this.name != null && !"".equals(this.name);
    }

    @Override
    public boolean isRealFormula() {
        if (!this.isValid()) {
            return false;
        }
        if ("NUMBER".equals(this.name)) {
            return false;
        }
        if (!"BLOCK".equals(this.name)) {
            return true;
        }
        if (this.params.isEmpty()) {
            return false;
        }
        for (Object param : this.params) {
            if (!(param instanceof IFormula) || !((IFormula)param).isRealFormula()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.formulaString(true);
    }

    @Override
    public String formulaString(boolean displayNestedFormula) {
        try {
            StringBuffer paramStr = new StringBuffer();
            boolean first = true;
            for (Object param : this.params) {
                if (first) {
                    first = false;
                } else {
                    paramStr.append(',');
                }
                if (param == null) {
                    paramStr.append("");
                    continue;
                }
                if (param instanceof IFormula) {
                    if (displayNestedFormula || ((IFormula)param).getResult() == null) {
                        paramStr.append(((IFormula)param).formulaString(true));
                        continue;
                    }
                    paramStr.append(StringUtil.toString(((IFormula)param).getResult()));
                    continue;
                }
                paramStr.append(StringUtil.toString(param));
            }
            return MessageFormat.format("{0}({1})", this.name, paramStr);
        }
        catch (Exception e) {
            LOG.warn("", e);
            return super.toString();
        }
    }

    @Override
    public void setResult(Map<String, Object> paramResults) {
        String key = null;
        for (FormulaParameter param : this.formulaParams) {
            if (!paramResults.containsKey(param.getParamKey()) && !paramResults.containsKey(param.getFormula())) continue;
            if (paramResults.containsKey(param.getParamKey())) {
                key = param.getParamKey();
            } else if (paramResults.containsKey(param.getFormula())) {
                key = param.getFormula();
            }
            param.directSetValue(paramResults.get(key));
        }
    }

    @Override
    public Collection<FormulaParameter> getParameters() {
        return this.formulaParams;
    }

    @Override
    public Object clone() {
        AbstractFormula formula = (AbstractFormula)this.newInstance();
        if (formula == null) {
            LOG.info("clone abstractFormula occur error", ILog.EMPTY_PARAMS);
            return null;
        }
        formula.name = this.name;
        formula.params = new ArrayList<Object>();
        formula.params.addAll(this.params);
        formula.paramNames = new ArrayList<String>();
        formula.paramNames.addAll(this.paramNames);
        formula.formulaParams = new HashSet<FormulaParameter>(this.formulaParams);
        formula.extendedProps = new HashMap<Object, Object>(this.extendedProps);
        return formula;
    }

    @Override
    public void setLevel(IChangeIntWrap formulaLevel) {
        this.level = formulaLevel;
    }

    @Override
    public IChangeIntWrap getLevel() {
        return this.level;
    }

    @Override
    public void putExtendProperty(Object name, Object value) {
        this.extendedProps.put(name, value);
    }

    @Override
    public Object getExtendProperty(Object name) {
        return this.extendedProps.get(name);
    }

    @Override
    public List<IFormula> getFormula(String formulaName) {
        ArrayList<IFormula> formulas = new ArrayList<IFormula>(1);
        if (formulaName == null) {
            return formulas;
        }
        if (formulaName.equalsIgnoreCase(this.getName())) {
            formulas.add(this);
        }
        for (Object param : this.getParams()) {
            if (!(param instanceof IFormula)) continue;
            formulas.addAll(((IFormula)param).getFormula(formulaName));
        }
        return formulas;
    }

    @Override
    public boolean replace(Object oldParam, Object newParam) {
        if (oldParam == null || newParam == null) {
            return false;
        }
        List<Object> formulaParams = this.getParams();
        Object param = null;
        for (int i = 0; i < formulaParams.size(); ++i) {
            param = formulaParams.get(i);
            if (oldParam != param) {
                if (!(param instanceof IFormula)) continue;
                ((IFormula)param).replace(oldParam, newParam);
                continue;
            }
            formulaParams.set(i, newParam);
        }
        return true;
    }

    @Override
    public boolean existSubFormula(IFormula formula) {
        if (formula == null) {
            return false;
        }
        List<Object> formulaParams = this.getParams();
        Object param = null;
        for (int i = 0; i < formulaParams.size(); ++i) {
            param = formulaParams.get(i);
            if (formula != param) {
                if (!(param instanceof IFormula) || !((IFormula)param).existSubFormula(formula)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public abstract IFormula newInstance();
}

