/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.BatchCalculator;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ContextKey;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.InvokeFormulaExecutor;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ParameterType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.SheetParam;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.CalculateFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.DateUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class BatchCalculatorFactory {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", BatchCalculatorFactory.class);

    public static BatchCalculator create(ParameterType type, Set<SheetParam> sheetParams, OrgType orgType) throws EASBizException, BOSException {
        return BatchCalculatorFactory.create(type, sheetParams, new ArrayList<String>(0), orgType);
    }

    public static BatchCalculator create(ParameterType type, Set<SheetParam> sheetParams, List<String> executorTypes, OrgType orgType) throws EASBizException, BOSException {
        ContextKey context = type.getContextKey();
        int year = context.getYear();
        int period = context.getPeriod();
        RptPeriodTypeEnum periodType = context.getPeriodType();
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setNumber(context.getCompany().getNumber());
        company.setId(context.getCompany().getId());
        CslReportInfo report = new CslReportInfo();
        report.setPeriodType(periodType);
        report.setSourceType(RptSrcTypeEnum.COMMITREPORT);
        Date startDate = DateUtil.getStartDate(periodType, year, period);
        Date endDate = DateUtil.getEndDate(periodType, year, period);
        report.setYear(year);
        report.setPeriod((short)period);
        report.setStartDate(startDate);
        report.setEndDate(endDate);
        report.setOrgType(orgType);
        CurrencyInfo currency = new CurrencyInfo();
        currency.setNumber(context.getCurrency().getNumber());
        currency.setId(context.getCurrency().getId());
        CalcContext calcContext = new CalcContext((OrgUnitInfo)company, report, currency, sheetParams);
        InvokeFormulaExecutor executor = new InvokeFormulaExecutor();
        for (String executorType : executorTypes) {
            executor.addFormulaExecutor(executorType, 1);
        }
        CalculateFormula calculateFormula = new CalculateFormula(calcContext, executor);
        return new BatchCalculator(calculateFormula);
    }
}

