/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CellFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FormulaParameter;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.CalculateFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import java.util.Collection;
import java.util.HashMap;

public class CalcuateAndFillCellFormula {
    private DBHandler dao;

    public CalcuateAndFillCellFormula(DBHandler dao) {
        this.dao = dao;
    }

    public void exec(Collection<CellFormula> valueFormulas, CalcContext calcContext) throws EASBizException, BOSException {
        if (valueFormulas.isEmpty()) {
            return;
        }
        this.calcuateFormula(valueFormulas, calcContext);
        this.fillResultToCell(valueFormulas);
    }

    protected void calcuateFormula(Collection<CellFormula> valueFormulas, CalcContext calcContext) throws EASBizException, BOSException {
        HashMap<String, SortedParameterArray> methods = new HashMap<String, SortedParameterArray>();
        for (CellFormula formula : valueFormulas) {
            Collection<FormulaParameter> params = formula.getParameters();
            for (FormulaParameter param : params) {
                if (!methods.containsKey(param.getFormulaName())) {
                    methods.put(param.getFormulaName(), new SortedParameterArray());
                }
                ((SortedParameterArray)methods.get(param.getFormulaName())).append((Object)param);
            }
        }
        if (methods.isEmpty()) {
            return;
        }
        CalculateFormula calculateFormula = this.newCalculateFormula(calcContext);
        calculateFormula.calc(this.dao.getContext(), methods);
    }

    protected CalculateFormula newCalculateFormula(CalcContext calcContext) throws EASBizException, BOSException {
        return new CalculateFormula(calcContext);
    }

    protected void fillResultToCell(Collection<CellFormula> valueFormulas) {
        Book book = null;
        boolean isAutoCalculate = false;
        Object result = null;
        for (CellFormula formula : valueFormulas) {
            book = formula.getCell().getSheet().getBook();
            isAutoCalculate = book.isAutoCalculate();
            book.setAutoCalculate(false);
            result = formula.getResult();
            if (!(result instanceof Variant)) {
                result = new Variant(result);
            }
            formula.getCell().setValue((Variant)result);
            book.setAutoCalculate(isAutoCalculate);
        }
    }
}

