/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.INeedSheetInfo;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AutoItemException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.AutoItemBizException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IOne2OneMatch;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ReflectUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class FormulaExecutor
implements Cloneable,
Comparable<FormulaExecutor> {
    public static final String BAD_FUNCTION = "#BAD FUNCTION!:";
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", FormulaExecutor.class);
    private Object executor;
    private Collection<Method> methods = new HashSet<Method>(1);
    private Collection<String> methodNames = new HashSet<String>(1);
    private Map<String, Collection<Method>> findMethods = new HashMap<String, Collection<Method>>(1);
    private int grade;
    private boolean one2oneMatch = false;

    public FormulaExecutor(String clazz) throws EASBizException {
        this(clazz, 0);
    }

    public FormulaExecutor(String clazz, int grade) throws EASBizException {
        this.grade = grade;
        boolean success = this.instance(clazz);
        this.one2oneMatch = success && this.executor instanceof IOne2OneMatch;
    }

    public void addMethod(Method method) {
        this.methods.add(method);
        String methodName = method.getName().toUpperCase();
        this.methodNames.add(methodName);
        Collection<Object> sameNameMethods = null;
        if (!this.findMethods.containsKey(methodName)) {
            sameNameMethods = new HashSet(1);
            this.findMethods.put(methodName, sameNameMethods);
        } else {
            sameNameMethods = this.findMethods.get(methodName);
        }
        sameNameMethods.add(method);
    }

    public boolean meet(String methodName) {
        if (methodName == null) {
            return false;
        }
        boolean methodIsRight = this.methodNames.contains(methodName.toUpperCase());
        if (!methodIsRight) {
            return false;
        }
        if (this.one2oneMatch) {
            // empty if block
        }
        return methodIsRight;
    }

    protected boolean instance(String clazz) throws EASBizException {
        try {
            this.executor = Class.forName(clazz).newInstance();
            return true;
        }
        catch (InstantiationException e) {
            LOG.error("", e);
            throw new AutoItemException(AutoItemException.CLASS_INIT_ERROR);
        }
        catch (IllegalAccessException e) {
            LOG.error("", e);
            throw new AutoItemException(AutoItemException.CLASS_INIT_ERROR);
        }
        catch (ClassNotFoundException e) {
            LOG.error("", e);
            throw new AutoItemException(AutoItemException.CLASS_INIT_ERROR);
        }
    }

    public boolean exec(Map<String, SortedParameterArray> methods, String sheetName, ICalculateContextProvider context) throws EASBizException {
        if (this.executor instanceof ICalculator) {
            ((ICalculator)this.executor).initCalculateContext(context);
        }
        if (this.executor instanceof INeedSheetInfo) {
            ((INeedSheetInfo)this.executor).setSheetName(sheetName);
        }
        try {
            if (this.executor instanceof IMethodBatchQuery) {
                try {
                    return ((IMethodBatchQuery)this.executor).batchQuery(methods);
                }
                catch (Exception e) {
                    LOG.error("", e);
                    for (SortedParameterArray params : methods.values()) {
                        for (int i = 0; i < params.size(); ++i) {
                            params.getParameter(i).setValue((Object)e);
                        }
                    }
                    return false;
                }
            }
            SortedParameterArray params = null;
            for (String methodName : methods.keySet()) {
                params = methods.get(methodName);
                for (int paramIndex = 0; paramIndex < params.size(); ++paramIndex) {
                    Object result = this.runMethod(methodName, params.getParameter(paramIndex));
                    params.getParameter(paramIndex).setValue(result);
                }
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("", e);
            return false;
        }
    }

    protected Object runMethod(String methodName, Parameter parameter) throws EASBizException {
        Object[] paramValues = FormulaExecutor.convertParamValues(parameter);
        Method method = ReflectUtil.getMethod(methodName, paramValues, this.findMethods.get(methodName.toUpperCase()), true);
        if (method == null) {
            LOG.error("method is empty", new Exception());
            return new AutoItemBizException(ResourceDebugUtil.res("fail.to.execute.formula.for.some.reasons.with.format", new Object[]{methodName}));
        }
        try {
            return method.invoke(this.executor, paramValues);
        }
        catch (IllegalArgumentException e) {
            LOG.error("", e);
            return e;
        }
        catch (IllegalAccessException e) {
            LOG.error("", e);
            return e;
        }
        catch (InvocationTargetException e) {
            LOG.error("", e);
            return e;
        }
        catch (Exception e) {
            LOG.error("", e);
            return e;
        }
    }

    protected static Object[] convertParamValues(Parameter parameter) {
        Object[] values = new Object[parameter.getArgs().length];
        for (int i = 0; i < parameter.getArgs().length; ++i) {
            values[i] = ((Variant)parameter.getArgs()[i]).getValue();
        }
        return values;
    }

    public void setGrade(int grade) {
        this.grade = grade;
    }

    public Object clone() {
        FormulaExecutor executor = null;
        try {
            if (this.executor == null) {
                return null;
            }
            executor = new FormulaExecutor(this.executor.getClass().getName());
        }
        catch (EASBizException e) {
            LOG.error("", e);
            return null;
        }
        executor.findMethods = new HashMap<String, Collection<Method>>(this.findMethods);
        executor.methods = new HashSet<Method>(this.methods);
        executor.methodNames = new HashSet<String>(this.methodNames);
        return executor;
    }

    @Override
    public int compareTo(FormulaExecutor o) {
        if (o == null) {
            return -1;
        }
        return this.grade > o.grade ? -1 : 1;
    }
}

