/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.ConvertCellFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.HandleReferExprForItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.BizFormulaDefine;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IsItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CellUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringFormulaParser;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.util.List;

public class GetBookFormulaFromCsRef {
    private DBHandler dao;
    private boolean onlyFindItemFormula;

    public GetBookFormulaFromCsRef(DBHandler dao, boolean onlyFindItemFormula) {
        this.dao = dao;
        this.onlyFindItemFormula = onlyFindItemFormula;
    }

    public IFormula exec(IFormula formula) throws BOSException, EASBizException {
        int col;
        List<IFormula> formulsList = formula.getFormula("CSREF");
        if (formula == null || formulsList.isEmpty()) {
            return formula;
        }
        if (!formula.getName().equals("CSREF")) {
            for (IFormula curFormula : formulsList) {
                if (!curFormula.getName().equals("CSREF")) continue;
                formula = curFormula;
                break;
            }
            if (!formula.getName().equals("CSREF")) {
                return formula;
            }
        }
        String sheetName = (String)formula.getParam("sheetName");
        String cellName = (String)formula.getParam("cellName");
        TemplateInfo templateInfo = this.queryTemplate(formula);
        Book book = null;
        try {
            book = templateInfo.getBook();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (book == null) {
            return null;
        }
        Sheet sheet = book.getSheet(sheetName);
        if (sheet == null) {
            return null;
        }
        int row = CellUtil.getRow(cellName);
        Cell cell = sheet.getCell(row, col = CellUtil.getCol(cellName), false);
        if (cell == null) {
            return null;
        }
        ItemFormula itemFormulaInfo = CellUtil.getItemFormula(cell);
        String itemFormula = null;
        if (itemFormulaInfo != null && itemFormulaInfo.getFormula() != null) {
            itemFormula = itemFormulaInfo.getFormula();
        } else {
            ConvertCellFormula convertCellFormula = ActionFactory.get(ConvertCellFormula.class);
            convertCellFormula.registerHandle(ActionFactory.get(HandleReferExprForItemFormula.class));
            itemFormula = convertCellFormula.exec(cell, false);
        }
        StringFormulaParser stringFormulaParser = ActionFactory.get(StringFormulaParser.class);
        stringFormulaParser.setFormulaDefine(ActionFactory.get(BizFormulaDefine.class));
        IFormula cellFormula = stringFormulaParser.parse(itemFormula);
        if (this.onlyFindItemFormula && !ActionFactory.get(IsItemFormula.class).exec(cellFormula)) {
            return null;
        }
        return cellFormula;
    }

    protected TemplateInfo queryTemplate(IFormula formula) throws BOSException, EASBizException {
        String template = (String)formula.getParam("tempCode");
        String templateType = (String)formula.getParam("groupTempType");
        RptTmpTypeEnum templateTypeInfo = RptTmpTypeEnum.getEnum((String)templateType);
        TemplateCollection templateInfos = this.dao.get(ITemplate.class).getTemplateCollection(" select id,data where number = '" + template + "' and templateType = " + templateTypeInfo.getValue() + " and versionStatus = " + 1);
        if (templateInfos.size() != 1) {
            return null;
        }
        return templateInfos.get(0);
    }
}

