/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextCompanyInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextTemplateInfo;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaCalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ctx.CheckValidFormulaCalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CheckValidException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.List;

public class SaveFormulaCalcContext {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", SaveFormulaCalcContext.class);
    protected DBHandler dao;

    public SaveFormulaCalcContext(DBHandler dao) {
        this.dao = dao;
    }

    public FormulaCalcContextInfo exec(FormulaCalcContextInfo editData, String id, String number, String name, int year, int period, RptPeriodTypeEnum periodType, String[] templateIds, List<OrgUnitInfo> companys, String currentOrg, String description, boolean isDoCheckAfterCalc, OrgType orgType) throws EASBizException, BOSException, CheckValidException {
        FormulaCalcContextInfo info = (FormulaCalcContextInfo)editData.clone();
        if (id != null) {
            info.setId(BOSUuid.read((String)id));
        }
        info.setOffYear(year);
        info.setOffPeriod(period);
        info.setPeriodType(periodType);
        info.setOrgType(orgType);
        info.setDescription(description);
        FullOrgUnitInfo currentOrgInfo = new FullOrgUnitInfo();
        currentOrgInfo.setId(BOSUuid.read((String)currentOrg));
        info.setCurrentOrg(currentOrgInfo);
        FormulaCalcContextTemplateInfo templateEntry = null;
        TemplateInfo template = null;
        int templateOrderIndex = 0;
        info.getTemplates().clear();
        for (String templateId : templateIds) {
            templateEntry = new FormulaCalcContextTemplateInfo();
            template = new TemplateInfo();
            template.setId(BOSUuid.read((String)templateId));
            templateEntry.setTemplate(template);
            templateEntry.setOrderIndex(templateOrderIndex++);
            info.getTemplates().add(templateEntry);
        }
        FormulaCalcContextCompanyInfo companyEntry = null;
        info.getCompanys().clear();
        for (OrgUnitInfo company : companys) {
            companyEntry = new FormulaCalcContextCompanyInfo();
            companyEntry.setCompany(company.castToFullOrgUnitInfo());
            info.getCompanys().add(companyEntry);
        }
        info.setIsDoCheckAfterCalc(isDoCheckAfterCalc);
        new CheckValidFormulaCalcContext(this.dao).exec(info);
        IObjectPK pk = this.dao.get(IFormulaCalcContext.class).save((CoreBaseInfo)info);
        info.setId(BOSUuid.read((String)pk.toString()));
        LOG.debug("save info : {0}", new Object[]{info});
        return info;
    }
}

