/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ctx;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.DynFormulaDefineInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueFormulaExtendInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;

public class QueryFormulaScheme {
    protected DBHandler dao;

    public QueryFormulaScheme(DBHandler dao) {
        this.dao = dao;
    }

    public FormulaSchemeCollection exec(TemplateInfo template, OrgUnitInfo company) throws BOSException {
        int i;
        FormulaSchemeCollection bigVersionSchemes = null;
        bigVersionSchemes = this.query(template, company, false);
        if (company == null || company.getId() == null) {
            return bigVersionSchemes;
        }
        FormulaSchemeCollection smallVersionSchemes = null;
        smallVersionSchemes = this.query(template, company, true);
        if (smallVersionSchemes.isEmpty()) {
            return bigVersionSchemes;
        }
        HashSet<String> itemKeyAndNumber = new HashSet<String>();
        for (i = 0; i < smallVersionSchemes.size(); ++i) {
            itemKeyAndNumber.add(smallVersionSchemes.get(i).getItemFormula().toString());
        }
        i = 0;
        while (i < bigVersionSchemes.size()) {
            if (!itemKeyAndNumber.contains(bigVersionSchemes.get(i).getItemFormula().toString())) {
                ++i;
                continue;
            }
            bigVersionSchemes.removeObject(i);
        }
        smallVersionSchemes.addCollection(bigVersionSchemes);
        return smallVersionSchemes;
    }

    protected FormulaSchemeCollection query(TemplateInfo template, OrgUnitInfo company, boolean isSmallVersion) throws BOSException {
        FormulaSchemeCollection bigVersionSchemes = new FormulaSchemeCollection();
        StringBuffer sql = new StringBuffer();
        sql.append("    select fs.*,t.fnumber template_number    ");
        sql.append("    ,def.FAssistNum def_AssistNum    ");
        sql.append("    ,def.FIsLevelSum def_IsLevelSum    ");
        sql.append("    ,def.FID def_ID    ");
        sql.append("    ,def.FIsLevelManualSum def_IsLevelManualSum    ");
        sql.append("    ,def.FLevelOrderNum def_LevelOrderNum    ");
        sql.append("    ,def.FLevelName def_LevelName    ");
        sql.append("    ,def.FSumFormula def_SumFormula    ");
        sql.append("    ,extend.fid ext_formula_id    ");
        sql.append("    ,extend.fPartIndex ext_formula_PartIndex    ");
        sql.append("    ,extend.fValueFormulaPart ext_formula_value    ");
        sql.append("    ,sheetParam.FSheetID sheet_sheetid    ");
        sql.append("    ,sheetParam.FSheetName sheet_SheetName    ");
        sql.append("    ,sheetParam.FStartYear sheet_StartYear    ");
        sql.append("    ,sheetParam.FEndYear sheet_EndYear    ");
        sql.append("    ,sheetParam.FStartPeriod sheet_StartPeriod    ");
        sql.append("    ,sheetParam.FEndPeriod sheet_EndPeriod    ");
        sql.append("    ,sheetParam.FStartDate sheet_StartDate    ");
        sql.append("    ,sheetParam.FEndDate sheet_EndDate    ");
        sql.append("    ,sheetParam.FISIncludingUnposted sheet_IsIncludeUnposted    ");
        sql.append("    ,sheetParam.FCurrencyID sheet_CurrencyId    ");
        sql.append("    ,sheetParam.FReportID sheet_ReportId    ");
        sql.append("    ,sheetParam.FRelaType sheet_RelaType    ");
        sql.append("    ,sheetParam.FReportClass sheet_ReportClass    ");
        sql.append("    ,sheetParam.FAcctParam sheet_AcctParam    ");
        sql.append("    from t_csl_FormulaScheme fs    ");
        sql.append("    inner join t_rpt_template t    ");
        sql.append("    on t.fid = fs.ftemplateid    ");
        sql.append("    left outer join t_csl_ValueFormulaExtend extend    ");
        sql.append("    on extend.formulaSchemeid = fs.fid    ");
        sql.append("    left outer join t_csl_dynFormulaDefine def    ");
        sql.append("    on def.formulaSchemeid = fs.fid    ");
        sql.append("    inner join t_rpt_RptSheetPara sheetParam    ");
        sql.append("    on sheetParam.fid = fs.FEnvParamID   ");
        sql.append("    where t.fnumber = ? ");
        Object[] sqlParams = null;
        if (!isSmallVersion) {
            sql.append("    and t.fgroupTemplateid is null ");
            sql.append("    and fs.fcompanyid is null ");
            sqlParams = new Object[]{template.getNumber()};
        } else {
            sql.append("    and t.fgroupTemplateid is not null ");
            sql.append("    and fs.fcompanyid = ? ");
            sqlParams = new Object[]{template.getNumber(), company.getId().toString()};
        }
        IRowSet rs = this.dao.getExecuteSQL().executeQuery(sql.toString(), sqlParams);
        try {
            HashMap<String, FormulaSchemeInfo> cacheFormulaScheme = new HashMap<String, FormulaSchemeInfo>(rs.size());
            HashSet<String> excludeDup = new HashSet<String>(10);
            while (rs.next()) {
                FormulaSchemeInfo info = null;
                TemplateInfo templateParam = null;
                if (!cacheFormulaScheme.containsKey(rs.getString("FID"))) {
                    info = new FormulaSchemeInfo();
                    info.setId(BOSUuid.read((String)rs.getString("FID")));
                    info.setItemKey(rs.getString("FItemKey"));
                    info.setItemNumber(rs.getString("FItemNumber"));
                    info.setValueFormula(rs.getString("FValueFormula"));
                    if (BOSUuid.isValid((String)rs.getString("FCompanyID"), (boolean)true)) {
                        info.setCompany(company.castToFullOrgUnitInfo());
                    }
                    templateParam = new TemplateInfo();
                    templateParam.setId(BOSUuid.read((String)rs.getString("FTemplateID")));
                    templateParam.setNumber(rs.getString("template_number"));
                    info.setTemplate(templateParam);
                    info.setItemOffYear(rs.getInt("FItemOffYear"));
                    info.setItemOffPeriod(rs.getInt("FItemOffPeriod"));
                    try {
                        info.setItemValueType(ValueTypeEnum.getEnum(rs.getInt("FItemValueType")));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    info.setItemDataType(rs.getString("FItemDataType"));
                    info.setItemDynaItem(rs.getString("FItemDynaItem"));
                    RptSheetParamInfo sheetParam = new RptSheetParamInfo();
                    sheetParam.setId(BOSUuid.read((String)rs.getString("FEnvParamID")));
                    sheetParam.setSheetID(rs.getString("sheet_sheetid"));
                    sheetParam.setSheetName(rs.getString("sheet_SheetName"));
                    sheetParam.setStartYear(rs.getInt("sheet_StartYear"));
                    sheetParam.setEndYear(rs.getInt("sheet_EndYear"));
                    sheetParam.setStartPeriod(rs.getInt("sheet_StartPeriod"));
                    sheetParam.setEndPeriod(rs.getInt("sheet_EndPeriod"));
                    sheetParam.setStartDate((Date)rs.getDate("sheet_StartDate"));
                    sheetParam.setEndDate((Date)rs.getDate("sheet_EndDate"));
                    sheetParam.setIsIncludingUnposted(rs.getInt("sheet_IsIncludeUnposted") == 1);
                    sheetParam.setAcctParam(rs.getString("sheet_AcctParam"));
                    if (BOSUuid.isValid((String)rs.getString("sheet_CurrencyId"), (boolean)true)) {
                        CurrencyInfo currency = new CurrencyInfo();
                        currency.setId(BOSUuid.read((String)rs.getString("sheet_CurrencyId")));
                        sheetParam.setCurrency(currency);
                    }
                    sheetParam.setReport((VirtualSheetParamInfo)templateParam);
                    rs.getString("sheet_ReportId");
                    try {
                        sheetParam.setRelaType(ReportTypeEnum.getEnum((int)rs.getInt("sheet_RelaType")));
                        sheetParam.setReportClass(CSLReportGroupEnum.getEnum(rs.getInt("sheet_ReportClass")));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    info.setEnvParam(sheetParam);
                    info.setIsExtendValueFormula(rs.getInt("FIsExtendValueFormula") == 1);
                    UserInfo user = new UserInfo();
                    user.setId(BOSUuid.read((String)rs.getString("FCreatorID")));
                    UserInfo updateUser = new UserInfo();
                    updateUser.setId(BOSUuid.read((String)rs.getString("FLastUpdateUserID")));
                    info.setCreator(user);
                    info.setCreateTime(rs.getTimestamp("FCreateTime"));
                    info.setLastUpdateTime(rs.getTimestamp("FLastUpdateTime"));
                    CtrlUnitInfo cu = new CtrlUnitInfo();
                    cu.setId(BOSUuid.read((String)rs.getString("FControlUnitID")));
                    info.setCU(cu);
                    info.setDynaAsstType(rs.getString("FDynaAsstType"));
                    info.setItemDynaGrade(rs.getString("FItemDynaGrade"));
                    if (BOSUuid.isValid((String)rs.getString("def_ID"), (boolean)true)) {
                        DynFormulaDefineInfo def = new DynFormulaDefineInfo();
                        def.setAssistNum(rs.getString("def_AssistNum"));
                        def.setIsLevelSum(rs.getInt("def_IsLevelSum") == 1);
                        def.setId(BOSUuid.read((String)rs.getString("def_ID")));
                        def.setIsLevelManualSum(rs.getInt("def_IsLevelManualSum") == 1);
                        def.setLevelOrderNum(rs.getString("def_LevelOrderNum"));
                        def.setLevelName(rs.getString("def_LevelName"));
                        def.setSumFormula(rs.getString("def_SumFormula"));
                        info.getDynFormulaDefine().add(def);
                    }
                    cacheFormulaScheme.put(rs.getString("FID"), info);
                    bigVersionSchemes.add(info);
                } else {
                    info = (FormulaSchemeInfo)cacheFormulaScheme.get(rs.getString("FID"));
                    templateParam = info.getTemplate();
                }
                if (!BOSUuid.isValid((String)rs.getString("ext_formula_id"), (boolean)true)) continue;
                if (!excludeDup.contains(info.getId().toString() + "," + rs.getString("ext_formula_id"))) {
                    ValueFormulaExtendInfo extFormula = new ValueFormulaExtendInfo();
                    extFormula.setId(BOSUuid.read((String)rs.getString("ext_formula_id")));
                    extFormula.setPartIndex(rs.getInt("ext_formula_PartIndex"));
                    extFormula.setValueFormulaPart(rs.getString("ext_formula_value"));
                    extFormula.setFormulaScheme(info);
                    info.getExtendValueFormula().add(extFormula);
                    continue;
                }
                excludeDup.add(info.getId().toString() + "," + rs.getString("ext_formula_id"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bigVersionSchemes;
    }
}

