/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ctx;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextFactory;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QueryFormulaSchemeTemplate {
    protected DBHandler dao;

    public QueryFormulaSchemeTemplate(DBHandler dao) {
        this.dao = dao;
    }

    public List<TemplateInfo> exec(RptPeriodTypeEnum periodType, Collection<RptTmpTypeEnum> tmpTypes, OrgType orgType) throws BOSException {
        ArrayList<TemplateInfo> templates = new ArrayList<TemplateInfo>();
        if (periodType == null) {
            return templates;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("periodType", periodType);
        params.put("tmpTypes", tmpTypes);
        params.put("orgType", orgType);
        TemplateCollection temps = new TemplateCollection();
        try {
            temps = FormulaCalcContextFactory.getRemoteInstance().getFormulaSchemeTemplate(params);
        }
        catch (EASBizException e1) {
            Log.error((Object)"GetFormulaSchemeTemplate", (Exception)((Object)e1));
            e1.printStackTrace();
        }
        int size = temps.size();
        for (int i = 0; i < size; ++i) {
            templates.add(temps.get(i));
        }
        return templates;
    }

    public List<TemplateInfo> execForScheme(RptPeriodTypeEnum periodType) throws BOSException {
        ArrayList<TemplateInfo> templates = new ArrayList<TemplateInfo>();
        if (periodType == null) {
            return templates;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("template.id");
        view.getSelector().add("template.number");
        view.getSelector().add("template.name");
        view.getSelector().add("template.periodType");
        view.getSelector().add("template.templateType");
        SorterItemInfo templateNumberSorter = new SorterItemInfo("template.number");
        templateNumberSorter.setSortType(SortType.ASCEND);
        view.getSorter().add(templateNumberSorter);
        view.setFilter(new FilterInfo());
        view.getFilter().appendFilterItem("template.periodType", (Object)periodType.getValue());
        view.getFilter().appendFilterItem("template.versionStatus", (Object)1);
        view.getFilter().appendFilterItem("template.auditedStatus", (Object)2);
        view.getFilter().appendFilterItem("template.isFreezed", (Object)new Integer(0));
        FormulaSchemeCollection schemes = this.dao.get(IFormulaScheme.class).getFormulaSchemeCollection(view);
        ExcludeDuplication excludeDup = new ExcludeDuplication();
        int size = schemes.size();
        for (int i = 0; i < size; ++i) {
            if (excludeDup.isDup(schemes.get(i).getTemplate())) continue;
            excludeDup.add(schemes.get(i).getTemplate());
            templates.add(schemes.get(i).getTemplate());
        }
        return templates;
    }

    private static class ExcludeDuplication {
        protected Set<String> ids = new HashSet<String>();

        private ExcludeDuplication() {
        }

        public boolean isDup(TemplateInfo template) {
            return this.ids.contains(template.getNumber());
        }

        public void add(TemplateInfo template) {
            this.ids.add(template.getNumber());
        }
    }
}

