/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextTemplateCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogStatus;
import com.kingdee.eas.fi.gr.cslrpt.IClientDBQuery;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaCalcContextTemplate;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaCalcLog;
import com.kingdee.eas.fi.gr.cslrpt.TemplateProcess;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.FailLogTask;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.FinishLogTask;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.FormulaCalcSimpleReport;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.IsAnyExecuteTask;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.ProcessingLogTask;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.ReadyLogTask;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.StatusDescription;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.SuccessLogTask;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.thread.ILogThread;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.BizFormulaDefine;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class AutoItemLog
implements Serializable {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", AutoItemLog.class);
    private DBHandler dao;
    private FormulaCalcContextInfo calcContext;
    private IFormulaCalcLog formulaCalcLogDao;
    private String executeTaskId;
    private ILogThread thread;

    public AutoItemLog(DBHandler dao, FormulaCalcContextInfo calcContext, String executeTaskId, ILogThread thread) throws BOSException {
        this(dao, calcContext, dao.get(IFormulaCalcLog.class), executeTaskId, thread);
    }

    public AutoItemLog(DBHandler dao, FormulaCalcContextInfo calcContext, IFormulaCalcLog formulaCalcLogDao, String executeTaskId, ILogThread thread) throws BOSException {
        this.dao = dao;
        this.calcContext = calcContext;
        this.formulaCalcLogDao = formulaCalcLogDao;
        this.executeTaskId = executeTaskId;
        this.thread = thread;
    }

    public void ready() throws EASBizException, BOSException {
        ReadyLogTask task = new ReadyLogTask();
        task.setParams(this.executeTaskId, this.calcContext, this.formulaCalcLogDao, this.dao);
        this.thread.addList(task);
    }

    public void processing(int templateLevelPartSize, int templatePreLevelPart, int templateLevelSize, Uuid currentCalcFlag, Uuid previousCalcFlag) throws EASBizException, BOSException {
        ProcessingLogTask task = new ProcessingLogTask();
        task.setParams(this.executeTaskId, this.calcContext, templateLevelPartSize, templatePreLevelPart, templateLevelSize, currentCalcFlag, previousCalcFlag, this.formulaCalcLogDao, this.dao);
        this.thread.addList(task);
    }

    public void success(TemplateInfo template, OrgUnitInfo company, String description, String itemKey) throws EASBizException, BOSException {
        SuccessLogTask task = new SuccessLogTask();
        task.setParams(this.executeTaskId, this.calcContext, template, company, description, itemKey, this.formulaCalcLogDao);
        this.thread.addForBatch(task);
    }

    public void fail(TemplateInfo template, OrgUnitInfo company, String errorDetail, String itemKey) throws EASBizException, BOSException {
        FailLogTask task = new FailLogTask();
        task.setParams(this.executeTaskId, this.calcContext, template, company, errorDetail, itemKey, this.formulaCalcLogDao);
        this.thread.addForBatch(task);
    }

    public void finish() throws EASBizException, BOSException {
        FinishLogTask task = new FinishLogTask();
        task.setParams(this.executeTaskId, this.calcContext, this.formulaCalcLogDao);
        this.thread.execBatch();
        this.thread.addList(task);
        this.thread.end();
    }

    public void finish(String Description) throws EASBizException, BOSException {
        FinishLogTask task = new FinishLogTask();
        task.setParams(this.executeTaskId, this.calcContext, this.formulaCalcLogDao, Description);
        this.thread.execBatch();
        this.thread.addList(task);
        this.thread.end();
    }

    public FormulaCalcSimpleReport getReport(boolean simpleReport) throws EASBizException, BOSException {
        FormulaCalcLogCollection statusInfos = this.queryLogs();
        if (statusInfos.isEmpty()) {
            return new FormulaCalcSimpleReport(null, -1, -1, null);
        }
        int[] failureCount = this.queryFailureCount(statusInfos.get(0));
        int failureTemplate = failureCount[0];
        int failureCompany = failureCount[1];
        if (simpleReport) {
            if (FormulaCalcLogStatus.PROCESSING.equals((Object)statusInfos.get(0).getStatus())) {
                // empty if block
            }
            return new FormulaCalcSimpleReport(statusInfos, failureCompany, failureTemplate, new ArrayList<String>(0));
        }
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("context", (Object)this.calcContext.getId().toString());
        if (!IsAnyExecuteTask.exec(this.executeTaskId)) {
            filter.appendFilterItem("executeTaskId", (Object)this.executeTaskId);
        }
        filter.getFilterItems().add(new FilterItemInfo("template", null, CompareType.NOTEQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("context");
        view.getSelector().add("template.id");
        view.getSelector().add("template.number");
        view.getSelector().add("template.name");
        view.getSelector().add("company.*");
        view.getSelector().add("status");
        view.getSelector().add("description");
        view.getSelector().add("createTime");
        view.getSelector().add("lastUpdateTime");
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("template"));
        view.getSorter().add(new SorterItemInfo("company"));
        view.getSorter().add(new SorterItemInfo("description"));
        FormulaCalcLogCollection errorInfos = this.formulaCalcLogDao.getFormulaCalcLogCollection(view);
        FormulaCalcLogCollection allLogs = new FormulaCalcLogCollection();
        allLogs.addCollection(statusInfos);
        allLogs.addCollection(errorInfos);
        ArrayList<String> templateOrder = new ArrayList<String>(0);
        if (statusInfos.size() == 1) {
            TemplateProcess templatesProcess = this.buildTemplateProcess(statusInfos.get(0));
            statusInfos.get(0).setTemplatesProcess(templatesProcess);
            FormulaCalcContextTemplateCollection templates = this.queryTemplateEntity(statusInfos.get(0));
            templateOrder = new ArrayList(templates.size());
            int size = templates.size();
            for (int i = 0; i < size; ++i) {
                templateOrder.add(templates.get(i).getTemplate().getNumber());
            }
        }
        return new FormulaCalcSimpleReport(allLogs, failureCompany, failureTemplate, templateOrder);
    }

    protected FormulaCalcLogCollection queryLogs() throws BOSException {
        FilterInfo statusFilter = new FilterInfo();
        if (!IsAnyExecuteTask.exec(this.executeTaskId)) {
            statusFilter.appendFilterItem("executeTaskId", (Object)this.executeTaskId);
        }
        statusFilter.appendFilterItem("context", (Object)this.calcContext.getId().toString());
        statusFilter.appendFilterItem("template", null);
        statusFilter.appendFilterItem("company", null);
        HashSet<Integer> totalStatus = new HashSet<Integer>();
        totalStatus.add(0);
        totalStatus.add(1);
        totalStatus.add(4);
        statusFilter.getFilterItems().add(new FilterItemInfo("status", totalStatus, CompareType.INCLUDE));
        EntityViewInfo statusView = new EntityViewInfo();
        statusView.getSelector().add("context");
        statusView.getSelector().add("status");
        statusView.getSelector().add("description");
        statusView.getSelector().add("createTime");
        statusView.getSelector().add("lastUpdateTime");
        statusView.setFilter(statusFilter);
        statusView.getSorter().add(new SorterItemInfo("company"));
        statusView.getSorter().add(new SorterItemInfo("description"));
        FormulaCalcLogCollection statusInfos = this.formulaCalcLogDao.getFormulaCalcLogCollection(statusView);
        return statusInfos;
    }

    public boolean existLogStatus(FormulaCalcLogStatus[] logStatuses, boolean orAnd) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statuses = new HashSet<Integer>(logStatuses.length);
        for (FormulaCalcLogStatus status : logStatuses) {
            statuses.add(status.getValue());
        }
        if (!IsAnyExecuteTask.exec(this.executeTaskId)) {
            filter.appendFilterItem("executeTaskId", (Object)this.executeTaskId);
        }
        filter.appendFilterItem("context", (Object)this.calcContext.getId().toString());
        filter.getFilterItems().add(new FilterItemInfo("status", statuses, CompareType.INCLUDE));
        if (orAnd) {
            return this.formulaCalcLogDao.exists(filter);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().add("id");
        view.getSelector().add("status");
        FormulaCalcLogCollection logs = this.formulaCalcLogDao.getFormulaCalcLogCollection(view);
        for (int i = 0; i < logs.size(); ++i) {
            statuses.remove(logs.get(i).getStatus().getValue());
        }
        return statuses.isEmpty();
    }

    private TemplateProcess buildTemplateProcess(FormulaCalcLogInfo headLog) throws BOSException {
        StatusDescription statusDesc = null;
        String currentCalcFlag = "";
        int currentTemplatePercent = 0;
        HashMap<String, Integer> currentFinished = new HashMap<String, Integer>(2);
        if (FormulaCalcLogStatus.FINISH.equals((Object)headLog.getStatus())) {
            currentTemplatePercent = 100;
            LOG.error("headLog's status is finish,percent be setted 100");
        } else {
            IRowSet percent = this.queryCalcUnitPercent(currentCalcFlag);
            try {
                if (percent.next()) {
                    int finish = percent.getInt("finish");
                    int total = percent.getInt("total");
                    currentFinished.put("FINISH", percent.getInt("finish"));
                    currentFinished.put("TOTAL", percent.getInt("total"));
                    LOG.error("percent:{0},finist/total:{1}/{2}", new Object[]{currentTemplatePercent, finish, total});
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return new TemplateProcess(statusDesc, headLog.getStatus(), currentFinished);
    }

    protected IRowSet queryCalcUnitPercent(String currentCalcFlag) throws BOSException {
        String queryCurrentCalcPercentSql = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/biz/log/queryCurrentCalcPercent.sql");
        IRowSet percent = this.dao.get(IClientDBQuery.class).executeQuery(queryCurrentCalcPercentSql, new Object[]{currentCalcFlag});
        return percent;
    }

    private int[] queryFailureCount(FormulaCalcLogInfo formulaCalcLogInfo) throws BOSException {
        String queryFailureTCCount = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/biz/log/queryFailureTCCount.sql");
        IRowSet failureCount = this.dao.get(IClientDBQuery.class).executeQuery(queryFailureTCCount, new Object[]{formulaCalcLogInfo.getContext().getId().toString(), 3});
        try {
            if (failureCount.next()) {
                int template = failureCount.getInt("template");
                int company = failureCount.getInt("company");
                return new int[]{template, company};
            }
            return new int[]{-1, -1};
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public String convertItemKey(IFormula formula) {
        if (formula == null || !BizFormulaDefine.isItemType(formula.getName())) {
            return "";
        }
        if (!ActionFactory.get(BizFormulaDefine.class).fillWhole(formula)) {
            return "";
        }
        return formula.formulaString(false);
    }

    public FormulaCalcContextTemplateCollection queryTemplateEntity(FormulaCalcLogInfo headLog) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("template.id");
        view.getSelector().add("template.number");
        view.getSelector().add("template.name");
        view.getSelector().add("template.group");
        view.getSelector().add("orderIndex");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.appendFilterItem("context", (Object)headLog.getContext().getId().toString());
        view.getSorter().add(new SorterItemInfo("orderIndex"));
        FormulaCalcContextTemplateCollection templates = this.dao.get(IFormulaCalcContextTemplate.class).getFormulaCalcContextTemplateCollection(view);
        return templates;
    }
}

