/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.CreateFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IInfoHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class NormalInfoHandler
implements IInfoHandler<FormulaSchemeInfo> {
    private static final ILog log = LogFactory.getLog("AUTOITEM", NormalInfoHandler.class);
    private DBHandler dao;
    final Collection<FormulaSchemeInfo> schemes = new ArrayList<FormulaSchemeInfo>();
    private IBasePoint basePoint;

    public NormalInfoHandler(DBHandler dao, IBasePoint basePoint) {
        this.dao = dao;
        this.basePoint = basePoint;
    }

    @Override
    public Collection<FormulaSchemeInfo> infos() {
        return this.schemes;
    }

    @Override
    public boolean checkItemFormula(ItemFormula itemFormula) {
        return true;
    }

    @Override
    public boolean checkValueFormula(String valueItemFormula) {
        return true;
    }

    @Override
    public void put(ItemFormula itemFormula, String valueFormula, Cell itemCell, Map<?, ?> others) {
        FormulaSchemeInfo scheme = this.create(itemCell, itemFormula);
        if (scheme == null) {
            return;
        }
        scheme.setEnvParam(this.basePoint.getEnvParam());
        this.schemes.add(scheme);
    }

    protected FormulaSchemeInfo create(Cell cell, Object itemFormula) {
        FormulaSchemeInfo scheme;
        try {
            scheme = new CreateFormulaScheme(this.dao).by(cell);
        }
        catch (EASBizException e) {
            log.error("", e);
            return null;
        }
        catch (BOSException e) {
            log.error("", e);
            return null;
        }
        if (scheme == null) {
            return null;
        }
        return scheme;
    }
}

