/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringFormat;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CreateReportNumber {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", CreateReportNumber.class);
    private DBHandler dao;
    private StringFormat format;

    public CreateReportNumber(DBHandler dao, StringFormat format) {
        this.dao = dao;
        this.format = format;
    }

    public String exec(String templateNumber, int year, int period, CurrencyInfo currency) throws BOSException {
        BigDecimal orderNumber = this.getCurrentMaxNumberVauleFromDb(templateNumber, year, period, currency);
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("template", templateNumber);
        param.put("year", year);
        param.put("period", period);
        param.put("orderNum", orderNumber);
        return this.format.exec(param);
    }

    private BigDecimal getCurrentMaxNumberVauleFromDb(String templateNumber, int year, int period, CurrencyInfo currency) throws BOSException {
        BigDecimal number;
        block8: {
            HashMap<String, Object> param = new HashMap<String, Object>(4);
            param.put("template", templateNumber);
            param.put("year", year);
            param.put("period", period);
            param.put("orderNum", StringUtil.prefix("%", '%', this.format.getKeepLength("orderNum")));
            String numberLike = this.format.exec(param);
            numberLike = numberLike.replaceAll("(\\%)+", "%");
            number = new BigDecimal("1");
            ArrayList<Object> parmas = new ArrayList<Object>(5);
            StringBuffer sbSQL = new StringBuffer(" SELECT a.fnumber As Fmaxnumber From \r\n");
            sbSQL.append("T_RPT_Report").append(" a   INNER JOIN  T_RPT_Template  b on a.ftemplateid= b.fid  \r\n");
            sbSQL.append("\tWHERE b.fnumber = ?  \r\n");
            parmas.add(templateNumber);
            sbSQL.append("  and a.fyear = ? \r\n");
            parmas.add(year);
            sbSQL.append("  and a.fperiod = ? \r\n");
            parmas.add(period);
            sbSQL.append("  and a.fNumber like ? escape '\\' \r\n");
            parmas.add(numberLike);
            try {
                IRowSet rs = this.dao.getExecuteSQL().executeQuery(sbSQL.toString(), parmas.toArray());
                boolean emptyRecord = rs.size() == 0;
                boolean bl = emptyRecord = rs.size() == 0;
                while (rs.next()) {
                    Map<String, Object> values;
                    if (rs.getString("Fmaxnumber") == null || !((values = this.format.parse(rs.getString("Fmaxnumber"))).get("orderNum") instanceof String)) continue;
                    try {
                        int orderNum = Integer.parseInt((String)values.get("orderNum"));
                        return new BigDecimal(++orderNum);
                    }
                    catch (NumberFormatException e) {
                        LOG.error("", e);
                    }
                }
                if (emptyRecord) break block8;
                rs.beforeFirst();
                while (rs.next()) {
                    String findNumber = rs.getString("Fmaxnumber");
                    int keepLen = this.format.getKeepLength("orderNum");
                    if (keepLen == -1 || findNumber.length() < keepLen) break;
                    String orderNum = findNumber.substring(findNumber.length() - keepLen);
                    try {
                        number = new BigDecimal(orderNum).add(new BigDecimal("1"));
                        break;
                    }
                    catch (Exception e) {
                        LOG.error("", e);
                    }
                }
            }
            catch (SQLException exc) {
                throw new SQLDataException(exc);
            }
        }
        return number;
    }
}

