/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.IFillValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryAllItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IItemSourceType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.AutoItemItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FillItemValue
implements IFillValue {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", FillItemValue.class);
    private DBHandler dao;

    public FillItemValue(DBHandler dao) {
        this.dao = dao;
    }

    @Override
    public void exec(ItemContext context, Map<AutoItemItemFormula, Cell> formulas, boolean existNotFill, OrgType orgType) throws BOSException {
        if (formulas.isEmpty()) {
            LOG.debug("no itemformula be found in current report.", new Object[0]);
            return;
        }
        if (formulas.isEmpty()) {
            return;
        }
        Set<AutoItemItemFormula> items = formulas.keySet();
        HashSet<IItemQueryUnit> queryUnits = new HashSet<IItemQueryUnit>(items.size());
        HashMap<IItemQueryUnit, Cell> cells = new HashMap<IItemQueryUnit, Cell>();
        QueryAllItem queryAllItem = new QueryAllItem(this.dao);
        IItemQueryUnit queryUnit = null;
        for (AutoItemItemFormula item : items) {
            queryUnit = queryAllItem.register(context, item);
            queryUnits.add(queryUnit);
            cells.put(queryUnit, formulas.get(item));
        }
        Map<IItemQueryUnit, ItemResult> values = queryAllItem.queryItemValues(IItemSourceType.SUPPORTED_SOURCE_TYPE, orgType);
        if (values.isEmpty()) {
            LOG.debug("no item value not be found!");
            return;
        }
        Cell cell = null;
        for (IItemQueryUnit itemQueryUnit : cells.keySet()) {
            cell = (Cell)cells.get(itemQueryUnit);
            if (values.get(itemQueryUnit) == null) {
                LOG.debug("cell({0},{1})' item value not be found!", new Object[]{cell.getRow(), cell.getCol()});
                continue;
            }
            LOG.debug("fill cell({0},{1}) by value {2}", new Object[]{cell.getRow(), cell.getCol(), values.get(itemQueryUnit).getResult()});
            if (existNotFill && cell.getValue() != null) continue;
            if (cell.getSheet() != null && cell.getSheet().getBook() != null && cell.getSheet().getBook().isAutoCalculate()) {
                cell.getSheet().getBook().setAutoCalculate(false);
                cell.setValue(new Variant(values.get(itemQueryUnit).getResult()));
                cell.getSheet().getBook().setAutoCalculate(true);
                continue;
            }
            cell.setValue(new Variant(values.get(itemQueryUnit).getResult()));
        }
    }
}

