/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextCompanyCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextTemplateCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.GeneralUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class GetNewVersionTemplate {
    private DBHandler dao;

    public GetNewVersionTemplate(DBHandler dao) {
        this.dao = dao;
    }

    public TemplateInfo exec(TemplateInfo template, OrgUnitInfo company, SelectorItemCollection selector) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("hasExtrItem", (Object)Boolean.TRUE);
        HashSet<RptTmpTypeEnum> tmpTypes = new HashSet<RptTmpTypeEnum>(FormulaSchemeInfo.supportTemplateTypeForCalc());
        tmpTypes.add(RptTmpTypeEnum.GROUPREPORT);
        filter.getFilterItems().add(new FilterItemInfo("templateType", new HashSet<Integer>(GeneralUtil.toIntCollection(tmpTypes)), CompareType.INCLUDE));
        return this.exec(template, company, selector, filter);
    }

    public TemplateInfo exec(TemplateInfo template, OrgUnitInfo company, SelectorItemCollection selector, FilterInfo filter) throws BOSException {
        TemplateCollection templateInfos;
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(selector);
        view.getSelector().add("versionNumber");
        view.setFilter(new FilterInfo());
        view.getFilter().appendFilterItem("periodType", (Object)template.getPeriodType().getValue());
        view.getFilter().appendFilterItem("group", (Object)template.getGroup());
        view.getFilter().appendFilterItem("versionStatus", (Object)1);
        view.getFilter().appendFilterItem("auditedStatus", (Object)2);
        view.getFilter().appendFilterItem("isFreezed", (Object)new Integer(0));
        if (company != null) {
            view.getFilter().appendFilterItem("templateType", (Object)RptTmpTypeEnum.GROUPREPORT.getValue());
            view.getFilter().appendFilterItem("company", (Object)company.getId().toString());
        }
        view.getFilter().getFilterItems().add(new FilterItemInfo("templateType", (Object)RptTmpTypeEnum.GROUPREPORT.getValue(), CompareType.NOTEQUALS));
        if (company != null) {
            view.getFilter().setMaskString("#0 and #1 and #2 and #3 and #4 and ((#5 and #6) or #7)");
        } else {
            view.getFilter().setMaskString("#0 and #1 and #2 and #3 and #4 and #5");
        }
        if (!filter.isNull()) {
            view.getFilter().mergeFilter(filter, "and");
        }
        if ((templateInfos = this.dao.get(ITemplate.class).getTemplateCollection(view)).isEmpty()) {
            return null;
        }
        if (templateInfos.size() == 1) {
            return templateInfos.get(0);
        }
        TemplateInfo maxTemplate = null;
        String maxVersion = "0.0";
        for (int i = 0; i < templateInfos.size(); ++i) {
            if (this.compareVersion(templateInfos.get(i).getVersionNumber(), maxVersion) <= 0) continue;
            maxVersion = templateInfos.get(i).getVersionNumber();
            maxTemplate = templateInfos.get(i);
        }
        return maxTemplate;
    }

    public Map<String, String> getSmallVersionTemplate(TemplateInfo template, FormulaCalcContextCompanyCollection companys) throws BOSException {
        HashMap<String, String> companyId2templateId = new HashMap<String, String>(companys.size());
        StringBuffer sql = new StringBuffer();
        sql.append("    select t.fcompanyid company,t.fid template   ");
        sql.append("    from t_rpt_template t    ");
        sql.append("    inner join t_org_baseunit c    ");
        sql.append("    on c.fid = t.fcompanyid    ");
        sql.append("    where t.ftemplateType = 2 and FIsFreezed = 0 and FauditedStatus = 2     ");
        sql.append("    and FversionStatus = 1 and FhasExtrItem = 1     ");
        sql.append("    and FGroupTemplateId = ?     ");
        sql.append("    and FperiodType = ?    ");
        sql.append("    and t.fcompanyid in (");
        String companyFieldCondition = StringUtil.getSQLVariable(companys.size());
        sql.append(companyFieldCondition);
        sql.append(')');
        Object[] params = new Object[companys.size() + 2];
        params[0] = template.getId().toString();
        params[1] = template.getPeriodType().getValue();
        for (int i = 0; i < companys.size(); ++i) {
            params[2 + i] = companys.get(i).getCompany().getId().toString();
        }
        IRowSet rs = this.dao.getExecuteSQL().executeQuery(sql.toString(), params);
        try {
            while (rs.next()) {
                companyId2templateId.put(rs.getString("company"), rs.getString("template"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return companyId2templateId;
    }

    public Map<String, String> getSmallVersionTemplate(RptPeriodTypeEnum periodType, FormulaCalcContextTemplateCollection templates, FormulaCalcContextCompanyCollection companys) throws BOSException {
        HashMap<String, String> companyId2templateId = new HashMap<String, String>(companys.size());
        StringBuffer sql = new StringBuffer();
        sql.append("    select t.fcompanyid company,t.fnumber template,t.fid small_template   ");
        sql.append("    from t_rpt_template t    ");
        sql.append("    inner join t_org_baseunit c    ");
        sql.append("    on c.fid = t.fcompanyid    ");
        sql.append("    where t.ftemplateType = 2 and FIsFreezed = 0 and FauditedStatus = 2     ");
        sql.append("    and FversionStatus = 1 and FhasExtrItem = 1     ");
        sql.append("    and FperiodType = ?    ");
        sql.append("    and t.fcompanyid in (");
        String companyFieldCondition = StringUtil.getSQLVariable(companys.size());
        sql.append(companyFieldCondition);
        sql.append(')');
        sql.append("    and FGroupTemplateId in (     ");
        String templateFieldCondition = StringUtil.getSQLVariable(templates.size());
        sql.append(templateFieldCondition);
        sql.append(')');
        Object[] params = new Object[companys.size() + 1 + templates.size()];
        params[0] = periodType.getValue();
        for (int i = 0; i < companys.size(); ++i) {
            params[1 + i] = companys.get(i).getCompany().getId().toString();
        }
        int preLen = 1 + companys.size();
        for (int i = 0; i < templates.size(); ++i) {
            params[preLen + i] = templates.get(i).getTemplate().getId().toString();
        }
        IRowSet rs = this.dao.getExecuteSQL().executeQuery(sql.toString(), params);
        try {
            while (rs.next()) {
                companyId2templateId.put(rs.getString("company") + "," + rs.getString("template"), rs.getString("small_template"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return companyId2templateId;
    }

    public int compareVersion(String version1, String version2) {
        String[] v1s = version1.split("\\.");
        String[] v2s = version2.split("\\.");
        for (int i = 0; i < v1s.length; ++i) {
            if (v2s.length <= i) {
                return 1;
            }
            if (Integer.parseInt(v1s[i]) == Integer.parseInt(v2s[i])) continue;
            return Integer.parseInt(v1s[i]) > Integer.parseInt(v2s[i]) ? 1 : -1;
        }
        return 0;
    }
}

