/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IItemDao;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemFieldMappedDao;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemKeyTable;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.NItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryNItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IItemSourceType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemSource;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValueSet;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.ExecuteSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.IsExistTable;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ItemDao
implements IItemDao {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", ItemDao.class);
    protected DBHandler dao;

    public ItemDao(DBHandler dao) {
        this.dao = dao;
    }

    @Override
    public void saveItemData(ItemSource itemSource, int calcLevelInOneProcess, OrgType orgType) throws BOSException {
        String entryId;
        NItemQueryUnit rptQueryInfo = new NItemQueryUnit(itemSource.getCompany(), null, null, itemSource.getYear(), itemSource.getPeriod(), itemSource.getPeriodType(), itemSource.getDataElement(), itemSource.getValueType(), itemSource.getCurrency());
        Collection<ItemSource> existedItemSources = new QueryNItem(this.dao).queryItemSource(rptQueryInfo, orgType);
        ExecuteSQL executeSQL = this.dao.getExecuteSQL();
        int rptSourceType = 0;
        if (existedItemSources.isEmpty()) {
            this.newItemData(itemSource, executeSQL, orgType);
            rptSourceType = 100;
        } else {
            boolean mustReturn = false;
            boolean needNewItemData = true;
            for (ItemSource existedItemSource : existedItemSources) {
                BOSUuid id;
                if (existedItemSource.getSourceType() instanceof ReportBaseInfo) {
                    LOG.info("repeat item context(type:{2},id:{0},entryid:{1}) be found!it will be deleted", new Object[]{existedItemSource.getId(), existedItemSource.getEntrys(), IItemSourceType.SOURCE_TYPE_REPORT});
                    this.excludeItemValues(existedItemSource, itemSource);
                    if (itemSource.getItemValues().isEmpty()) {
                        mustReturn = true;
                    }
                    ReportBaseInfo info = (ReportBaseInfo)existedItemSource.getSourceType();
                    rptSourceType = info.getSourceType().getValue();
                    continue;
                }
                if (!(existedItemSource.getSourceType() instanceof FormulaCalcContextInfo) || (id = ((FormulaCalcContextInfo)existedItemSource.getSourceType()).getItemSourceId()) == null) continue;
                if (itemSource.getSourceType().getItemSourceType() == 100 && id.equals((Object)itemSource.getSourceType().getItemSourceId())) {
                    LOG.info("repeat item context(type:{2},id:{0},entryid:{1}) be found!it will be deleted", new Object[]{existedItemSource.getId(), existedItemSource.getEntrys(), 100});
                    if (calcLevelInOneProcess <= 1) {
                        this.deleteItemSource(existedItemSource, calcLevelInOneProcess);
                    }
                    itemSource.setId(existedItemSource.getId());
                    rptSourceType = ((FormulaCalcContextInfo)existedItemSource.getSourceType()).getItemSourceType();
                    needNewItemData = false;
                    continue;
                }
                this.deleteItemValues(existedItemSource, itemSource);
            }
            if (mustReturn) {
                return;
            }
            if (needNewItemData) {
                this.newItemData(itemSource, executeSQL, orgType);
            }
        }
        String insertItemDataEntry = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/insertItemDataEntry.sql");
        String queryItemDataEntry = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryItemDataEntry.sql");
        IRowSet existedEntry = executeSQL.executeQuery(queryItemDataEntry, new Object[]{itemSource.getId(), itemSource.getDataElement(), itemSource.getValueType().getValue(), itemSource.getYear(), itemSource.getPeriod(), itemSource.getCompany().getId().toString(), itemSource.getCurrency().getId().toString(), itemSource.getCurrency().getId().toString(), rptSourceType});
        try {
            if (existedEntry.next()) {
                entryId = existedEntry.getString("ENTRY_ID");
                for (String tableName : itemSource.getItemValues().getItemValueTables()) {
                    itemSource.addEntry(entryId, tableName);
                }
                return;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        entryId = Uuid.create().toString();
        for (String tableName : itemSource.getItemValues().getItemValueTables()) {
            itemSource.addEntry(entryId, tableName);
        }
        executeSQL.execute(insertItemDataEntry.toString(), new Object[]{entryId, itemSource.getId(), itemSource.getDataElement(), itemSource.getValueType().getValue(), itemSource.getYear(), itemSource.getPeriod(), new Timestamp(System.currentTimeMillis()), itemSource.getCompany().getId().toString(), itemSource.getCurrency().getId().toString(), itemSource.getCurrency().getId().toString(), rptSourceType});
    }

    protected void deleteItemValues(ItemSource itemSourceForDuplicItemValue, ItemSource currentItemSource) throws BOSException {
        Map<String, Collection<String>> entrys = itemSourceForDuplicItemValue.getEntrys();
        ItemValueSet currentItemValues = currentItemSource.getItemValues();
        ExecuteSQL executeSql = this.dao.getExecuteSQL();
        HashMap canDeleteField = new HashMap(2);
        Collection<String> fieldNames = null;
        for (ItemValue currentItemValue : currentItemValues) {
            if (!canDeleteField.containsKey(currentItemValue.getTableName())) {
                fieldNames = new HashSet(10);
                canDeleteField.put(currentItemValue.getTableName(), fieldNames);
            } else {
                fieldNames = (Collection)canDeleteField.get(currentItemValue.getTableName());
            }
            fieldNames.add(currentItemValue.getFieldName());
        }
        StringBuffer updateSql = new StringBuffer();
        Object[] sqlParamsForEntrys = entrys.keySet().toArray();
        String formatCondition = StringUtil.getSQLVariable(sqlParamsForEntrys.length);
        for (String table : canDeleteField.keySet()) {
            updateSql.setLength(0);
            updateSql.append("update " + table + " set ");
            updateSql.append(StringUtil.toSql((Collection)canDeleteField.get(table), false, ",", " {0} = null "));
            updateSql.append(" where fid in( ");
            updateSql.append(formatCondition);
            updateSql.append(" ) ");
            executeSql.execute(updateSql.toString(), sqlParamsForEntrys);
        }
    }

    protected void excludeItemValues(ItemSource itemSourceForReport, ItemSource currentItemSource) throws BOSException {
        Map<String, Collection<String>> entrys = itemSourceForReport.getEntrys();
        Set<ItemValue> existedItemValues = this.queryItem(entrys.keySet());
        if (existedItemValues.isEmpty()) {
            return;
        }
        ItemValueSet currentItemValues = currentItemSource.getItemValues();
        HashSet itemValuesForWantToSetNullValue = new HashSet(8);
        for (ItemValue existedItemValue : existedItemValues) {
            existedItemValue.setResult(null);
            Iterator it = currentItemValues.iterator();
            while (it.hasNext()) {
                ItemValue itemValue = (ItemValue)it.next();
                if (!itemValue.getNumber().equals(existedItemValue.getNumber()) || !itemValue.getTableName().equals(existedItemValue.getTableName()) || !itemValue.getFieldName().equals(existedItemValue.getFieldName())) continue;
                it.remove();
            }
        }
        if (itemValuesForWantToSetNullValue.isEmpty()) {
            return;
        }
        ExecuteSQL executeSql = this.dao.getExecuteSQL();
        for (ItemValue itemValue : itemValuesForWantToSetNullValue) {
            executeSql.execute("update " + itemValue.getTableName() + " set " + itemValue.getFieldName() + " = null where fid = ?", new Object[]{itemValue.getItemDataEntryId()});
        }
    }

    protected void newItemData(ItemSource itemSource, ExecuteSQL executeSQL, OrgType orgType) throws BOSException {
        String insertItemData = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/insertItemData.sql");
        itemSource.setId(Uuid.create().toString());
        executeSQL.execute(insertItemData, new Object[]{itemSource.getId(), itemSource.getCompany().getId().toString(), itemSource.getCurrency().getId().toString(), itemSource.getCurrency().getId().toString(), itemSource.getPeriodType().getValue(), orgType.getValue(), 100, itemSource.getSourceType().getItemSourceId().toString(), 0});
    }

    @Override
    public void saveItemValue(ItemSource itemSource, Map<String, ItemKeyTable> itemKeyTables, int calcLevelInOneProcess) throws BOSException {
        ItemValueSet itemValues = itemSource.getItemValues();
        itemValues = new ItemValueSet(itemValues);
        Map<String, Collection<String>> entryTables = itemSource.getEntrys();
        String entryId = null;
        Collection<String> entryTable = null;
        ItemValue itemValue = null;
        ExecuteSQL executeSQL = this.dao.getExecuteSQL();
        for (Map.Entry<String, Collection<String>> entry2Table : entryTables.entrySet()) {
            entryId = entry2Table.getKey();
            entryTable = entry2Table.getValue();
            String tableName = null;
            for (String table : entryTable) {
                ArrayList<String> fieldNames = new ArrayList<String>(itemValues.size());
                ArrayList<Object> values = new ArrayList<Object>(itemValues.size());
                ItemKeyTable itemKeyTable = null;
                Iterator it = itemValues.iterator();
                while (it.hasNext()) {
                    itemValue = (ItemValue)it.next();
                    itemKeyTable = itemKeyTables.get(itemValue.getNumber());
                    tableName = itemValue.getTableName();
                    if (tableName == null) {
                        tableName = itemKeyTable.getTableName();
                        itemValue.setTableName(tableName);
                    }
                    if (!table.equalsIgnoreCase(tableName)) continue;
                    if (itemValue.getFieldName() == null) {
                        itemValue.setFieldName(itemKeyTable.getFieldName());
                    }
                    if (!fieldNames.contains(itemValue.getFieldName())) {
                        fieldNames.add(itemValue.getFieldName());
                        if (itemValue.getResult() instanceof BigDecimal) {
                            values.add(itemValue.getResult());
                        } else if (itemValue.getResult() instanceof Number) {
                            values.add(new BigDecimal(itemValue.getResult() + ""));
                        } else {
                            values.add(itemValue.getResult());
                        }
                    }
                    it.remove();
                }
                if (fieldNames.isEmpty()) continue;
                String queryItemValueFormatSql = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryExistItemValueWithFormat.sql");
                String insertItemValueFormatSql = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/insertItemValueWithFormat.sql");
                String updateItemValueFormatSql = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/updateItemValueWithFormat.sql");
                String insertItemValueSql = null;
                String updateItemValueSql = null;
                String queryItemValueSql = null;
                IRowSet entryValues = null;
                queryItemValueSql = new MessageFormat(queryItemValueFormatSql).format(new Object[]{table});
                entryValues = executeSQL.executeQuery(queryItemValueSql, new Object[]{entryId});
                if (entryValues.size() == 0) {
                    insertItemValueSql = new MessageFormat(insertItemValueFormatSql).format(new Object[]{table, StringUtil.toSql(fieldNames, false), StringUtil.getSQLVariable(values.size())});
                    LOG.info("{0}.{1} will add {2}", new Object[]{table, fieldNames, values});
                    values.add(0, entryId);
                    executeSQL.execute(insertItemValueSql, values.toArray());
                    continue;
                }
                updateItemValueSql = new MessageFormat(updateItemValueFormatSql).format(new Object[]{table, StringUtil.toSql(fieldNames, false, ",", "{0} = ? ")});
                LOG.info("{0}.{1} will add {2}", new Object[]{table, fieldNames, values});
                values.add(entryId);
                executeSQL.execute(updateItemValueSql, values.toArray());
            }
        }
    }

    public void existItemData(ItemSource source) {
    }

    public Set<ItemValue> queryItem(Set<String> entryIds) throws BOSException {
        String queryItemDataFormatSql = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryItemValueWithFormat.sql");
        String queryItemDataSql = null;
        HashSet<ItemValue> itemValues = new HashSet<ItemValue>();
        HashSet<String> queryIds = new HashSet<String>(entryIds);
        int fieldIndexAdd = 0;
        HashSet<String> tableFieldNames = new HashSet<String>();
        String tableName = null;
        String fieldName = null;
        IsExistTable existTable = new IsExistTable(this.dao);
        int size = 10000;
        for (int i = 1; i < size && !queryIds.isEmpty(); ++i) {
            String entryTableIndex = StringUtil.prefix(i + "", '0', 3);
            if (!existTable.exec("t_csl_itemdataEntry" + entryTableIndex)) break;
            queryItemDataSql = new MessageFormat(queryItemDataFormatSql).format(new Object[]{entryTableIndex, StringUtil.toSql(queryIds, true)});
            IRowSet itemDatas = null;
            try {
                itemDatas = this.dao.getExecuteSQL().executeQuery(queryItemDataSql, new Object[0]);
            }
            catch (Exception e) {
                break;
            }
            try {
                fieldIndexAdd = (i - 1) * 300;
                BigDecimal itemValue = null;
                ItemValue item = null;
                while (itemDatas.next()) {
                    queryIds.remove(itemDatas.getString("FID"));
                    int fieldMax = 301;
                    for (int fieldIndex = 2; fieldIndex <= fieldMax; ++fieldIndex) {
                        itemValue = itemDatas.getBigDecimal(fieldIndex);
                        if (itemValue == null) continue;
                        tableName = "T_CSL_ItemDataEntry" + entryTableIndex;
                        fieldName = "F" + (fieldIndex - 1 + fieldIndexAdd);
                        item = new ItemValue(tableName, fieldName, itemValue);
                        item.setItemDataEntryId(itemDatas.getString("FID"));
                        itemValues.add(item);
                        itemValues.add(item);
                        tableFieldNames.add(tableName + "." + fieldName);
                    }
                }
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        Map<String, String> table2Number = new ItemFieldMappedDao(this.dao).queryItemNumber(tableFieldNames);
        String match = null;
        for (ItemValue itemValue : itemValues) {
            match = itemValue.getTableName() + "." + itemValue.getFieldName();
            if (!table2Number.containsKey(match)) continue;
            itemValue.setNumber(table2Number.get(match));
        }
        return itemValues;
    }

    @Override
    public void deleteItemSource(ItemSource itemSource, int calcLevelInOneProcess) throws BOSException {
        String deleteItemValueFormatSql = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/deleteItemValueWithFormat.sql");
        String deleteItemValueSql = null;
        HashSet<String> deleteIds = new HashSet<String>(1);
        deleteIds.addAll(itemSource.getEntrys().keySet());
        LOG.info("delete item context.ids:{0}", new Object[]{deleteIds});
        ExecuteSQL executeSQL = this.dao.getExecuteSQL();
        String itemDataTableName = null;
        IsExistTable isExistTable = new IsExistTable(this.dao);
        int size = 10000;
        for (int i = 1; i < size && isExistTable.exec(itemDataTableName = "T_CSL_ITEMDATAENTRY" + StringUtil.prefix(i + "", '0', 3)); ++i) {
            deleteItemValueSql = new MessageFormat(deleteItemValueFormatSql).format(new Object[]{StringUtil.prefix(i + "", '0', 3), StringUtil.toSql(deleteIds, true)});
            LOG.debug("delete item value sql is {0}", new Object[]{deleteItemValueSql});
            executeSQL.execute(deleteItemValueSql, new Object[0]);
        }
        String deleteItemDataFormatSql = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/deleteItemData.sql");
        String deleteItemData = new MessageFormat(deleteItemDataFormatSql).format(new Object[]{StringUtil.getSQLVariable(deleteIds.size())});
        LOG.debug("delete item context sql is {0}", new Object[]{deleteItemData});
        executeSQL.execute(deleteItemData, deleteIds.toArray());
    }
}

