/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ItemFieldMappedDao {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", ItemFieldMappedDao.class);
    protected DBHandler dao;

    public ItemFieldMappedDao(DBHandler dao) {
        this.dao = dao;
    }

    public Map<String, String> queryItemNumber(Set<String> tableFieldNames) throws BOSException {
        HashMap<String, String> field2Number = new HashMap<String, String>(tableFieldNames.size());
        if (tableFieldNames.isEmpty()) {
            return field2Number;
        }
        String sql = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryItemNumByTableField.sql");
        StringBuffer where = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        String[] tableFieldNameArray = null;
        for (String tableField : tableFieldNames) {
            where.append(" or ");
            where.append(" ( ");
            where.append(" Map.FTableName = ? ");
            where.append(" and ");
            where.append(" Map.FFieldName = ? ");
            where.append(" ) ");
            tableFieldNameArray = tableField.split("\\.");
            params.add(tableFieldNameArray[0]);
            params.add(tableFieldNameArray[1]);
        }
        sql = sql + " where ( " + where.substring(" or ".length()) + " ) ";
        LOG.info(" query item number's sql is {0}", new Object[]{sql});
        IRowSet rs = this.dao.getExecuteSQL().executeQuery(sql, params.toArray());
        try {
            while (rs.next()) {
                field2Number.put(rs.getString("TableName") + "." + rs.getString("FieldName"), rs.getString("Number"));
            }
            return field2Number;
        }
        catch (SQLException e) {
            LOG.error("", e);
            throw new SQLDataException(e);
        }
    }
}

