/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.DItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.EItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.NItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryDItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryEItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryNItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.AutoItemItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.OffYearPeriod;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QueryAllItem {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", QueryAllItem.class);
    private Set<NItemQueryUnit> nitemQueryUnits = new HashSet<NItemQueryUnit>();
    private Set<DItemQueryUnit> ditemQueryUnits = new HashSet<DItemQueryUnit>();
    private Set<EItemQueryUnit> eitemQueryUnits = new HashSet<EItemQueryUnit>();
    private DBHandler dao;
    private QueryNItem queryNItem = null;
    private QueryDItem queryDItem = null;
    private QueryEItem queryEItem = null;

    public QueryAllItem(DBHandler dao) {
        this.dao = dao;
        this.queryNItem = new QueryNItem(dao);
        this.queryDItem = new QueryDItem(dao);
        this.queryEItem = new QueryEItem(dao);
    }

    public IItemQueryUnit register(ItemContext context, AutoItemItemFormula item) throws BOSException {
        OffYearPeriod offYearPeriod = ActionFactory.get(OffYearPeriod.class);
        IItemQueryUnit queryUnit = null;
        if ("ITEM".equals(item.getType())) {
            queryUnit = new NItemQueryUnit(context.getCompany(), item.getType(), item.getNumber(), offYearPeriod.year(context.getYear(), item.getYear()), offYearPeriod.period(context.getPeriod(), item.getPeriod()), context.getPeriodType(), item.getDataElement(), item.getValueType(), context.getCurrency());
            this.nitemQueryUnits.add((NItemQueryUnit)queryUnit);
        } else if ("DITEM".equals(item.getType())) {
            queryUnit = new DItemQueryUnit(context.getCompany(), item.getType(), item.getNumber(), offYearPeriod.year(context.getYear(), item.getYear()), offYearPeriod.period(context.getPeriod(), item.getPeriod()), context.getPeriodType(), item.getDataElement(), item.getValueType(), context.getCurrency(), item.getDynaItem());
            this.ditemQueryUnits.add((DItemQueryUnit)queryUnit);
        } else if ("CEITEM".equals(item.getType()) || "LEITEM".equals(item.getType()) || "REITEM".equals(item.getType())) {
            queryUnit = new EItemQueryUnit(context.getCompany(), item.getType(), item.getNumber(), offYearPeriod.year(context.getYear(), item.getYear()), offYearPeriod.period(context.getPeriod(), item.getPeriod()), context.getPeriodType(), item.getDataElement(), context.getCurrency(), item.getDynaItem());
            this.eitemQueryUnits.add((EItemQueryUnit)queryUnit);
        }
        return queryUnit;
    }

    public Map<IItemQueryUnit, ItemResult> queryItemValues(Collection<Integer> fixedSourceTypes, OrgType orgType) throws BOSException {
        HashMap<IItemQueryUnit, ItemResult> values = new HashMap<IItemQueryUnit, ItemResult>(this.nitemQueryUnits.size() + this.ditemQueryUnits.size() + this.eitemQueryUnits.size());
        if (this.isEmptyItem()) {
            LOG.debug("queryed item is empty.", new Object[0]);
            return values;
        }
        if (!this.nitemQueryUnits.isEmpty()) {
            values.putAll(this.queryNItem.queryValues(this.nitemQueryUnits, fixedSourceTypes, orgType));
        }
        if (!this.ditemQueryUnits.isEmpty()) {
            values.putAll(this.queryDItem.queryValues(this.ditemQueryUnits, fixedSourceTypes, orgType));
        }
        if (!this.eitemQueryUnits.isEmpty()) {
            values.putAll(this.queryEItem.queryValues(this.eitemQueryUnits, fixedSourceTypes, orgType));
        }
        return values;
    }

    public <T extends IItemQueryUnit> Map<IItemQueryUnit, ItemResult> queryItemValues(Collection<T> queryUnits, Collection<Integer> fixedSourceTypes, OrgType orgType) throws BOSException {
        HashMap<IItemQueryUnit, ItemResult> values = new HashMap<IItemQueryUnit, ItemResult>(queryUnits.size());
        if (queryUnits.isEmpty()) {
            LOG.debug("queryed item is empty.", new Object[0]);
            return values;
        }
        HashSet<NItemQueryUnit> thisNItemQueryUnits = new HashSet<NItemQueryUnit>();
        HashSet<DItemQueryUnit> thisDItemQueryUnits = new HashSet<DItemQueryUnit>();
        HashSet<EItemQueryUnit> thisEItemQueryUnits = new HashSet<EItemQueryUnit>();
        for (IItemQueryUnit unit : queryUnits) {
            if (unit instanceof EItemQueryUnit) {
                thisEItemQueryUnits.add((EItemQueryUnit)unit);
                continue;
            }
            if (unit instanceof DItemQueryUnit) {
                thisDItemQueryUnits.add((DItemQueryUnit)unit);
                continue;
            }
            if (!(unit instanceof NItemQueryUnit)) continue;
            thisNItemQueryUnits.add((NItemQueryUnit)unit);
        }
        values.putAll(this.queryNItem.queryValues((Set<NItemQueryUnit>)thisNItemQueryUnits, fixedSourceTypes, orgType));
        values.putAll(this.queryDItem.queryValues((Set<DItemQueryUnit>)thisDItemQueryUnits, fixedSourceTypes, orgType));
        values.putAll(this.queryEItem.queryValues((Set<EItemQueryUnit>)thisEItemQueryUnits, fixedSourceTypes, orgType));
        return values;
    }

    public boolean isEmptyItem() {
        return this.nitemQueryUnits.isEmpty() && this.ditemQueryUnits.isEmpty() && this.eitemQueryUnits.isEmpty();
    }

    public void unRegisterAll() {
        this.nitemQueryUnits.clear();
        this.ditemQueryUnits.clear();
        this.eitemQueryUnits.clear();
    }
}

