/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.IItemFieldMapped;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ItemFormulaSaveUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IItemDao;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemDaoFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemKeyTable;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemSource;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemSourceBuilder;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.util.Uuid;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SaveItem {
    protected DBHandler dao;

    public SaveItem(DBHandler dao) {
        this.dao = dao;
    }

    public void exec(Set<ItemFormulaSaveUnit> itemUnits, int calcLevelInOneProcess, OrgType orgType) throws EASBizException, BOSException {
        if (itemUnits.isEmpty()) {
            return;
        }
        HashSet<String> itemNumbers = new HashSet<String>();
        for (ItemFormulaSaveUnit item : itemUnits) {
            itemNumbers.add(item.getItemInfo().getNumber());
        }
        Map<String, ItemKeyTable> itemKeyTable = this.queryItemKeyTable(itemNumbers);
        Set<ItemSource> itemSources = new ItemSourceBuilder().create(itemUnits, itemKeyTable);
        IItemDao itemDao = null;
        for (ItemSource itemSource : itemSources) {
            itemDao = ItemDaoFactory.getDao(itemSource, this.dao);
            itemDao.saveItemData(itemSource, calcLevelInOneProcess, orgType);
            if (itemSource.getItemValues().isEmpty()) continue;
            itemDao.saveItemValue(itemSource, itemKeyTable, calcLevelInOneProcess);
            itemSource.getItemValues().clear();
        }
        itemSources.clear();
    }

    protected Map<String, ItemKeyTable> queryItemKeyTable(Set<String> items) throws EASBizException, BOSException {
        HashMap<String, ItemKeyTable> itemMap = new HashMap<String, ItemKeyTable>(items.size());
        if (items.isEmpty()) {
            return itemMap;
        }
        Map itemMapInfo = this.dao.get(IItemFieldMapped.class).getFlatMapInfoByItemNumbers(new ArrayList<String>(items));
        String[] tableAndField = null;
        for (String number : itemMapInfo.keySet()) {
            tableAndField = ((String)itemMapInfo.get(number)).split("\\.");
            if (tableAndField.length != 2) continue;
            itemMap.put(number, new ItemKeyTable(number, tableAndField[0], tableAndField[1]));
        }
        return itemMap;
    }

    protected String saveItemData(ItemFormulaSaveUnit item) throws BOSException {
        StringBuffer queryFieldInfoSql = new StringBuffer();
        queryFieldInfoSql.append("\tinsert into t_csl_itemdata\t\n");
        queryFieldInfoSql.append("\t(fid,fcompanyid,fcurrencyid,ftargetCurrencyId,FPeriodType,FDataSource,FReportId)\t\n");
        queryFieldInfoSql.append("\tvalues(?,?,?,?,?,?,?)\t\n");
        String itemDataId = Uuid.create().toString();
        DbUtil.execute((Context)this.dao.getContext(), (String)queryFieldInfoSql.toString(), (Object[])new Object[]{itemDataId, item.getItemContext().getCompany().getId().toString(), item.getItemContext().getCurrency().getId().toString(), item.getItemContext().getCurrency().getId().toString(), item.getItemContext().getPeriodType().getValue(), 100, "schemeSaveId"});
        return itemDataId;
    }

    protected String saveItemDataEntry(ItemFormulaSaveUnit itemUnit, String itemDataId) throws BOSException {
        StringBuffer insertItemDataEntry = new StringBuffer();
        insertItemDataEntry.append("\tinsert into t_csl_itemdataentry\t\n");
        insertItemDataEntry.append("\t(fid,fitemdataId,fdataElement,fvalueType,fyear,fperiod,fDay,fcompanyid,fcurrencyid,ftargetCurrencyId,FPeriodType,FDataSource,FReportId)\t\n");
        insertItemDataEntry.append("\tvalues(?,?,?,?,?,?,?,?,?,?,?,?,?)\t\n");
        String itemDataEntryId = Uuid.create().toString();
        DbUtil.execute((Context)this.dao.getContext(), (String)insertItemDataEntry.toString(), (Object[])new Object[]{itemDataEntryId, itemDataId, itemUnit.getItemContext().getDataElement(), itemUnit.getItemContext().getValueType().getValue(), itemUnit.getItemContext().getYear(), itemUnit.getItemContext().getPeriod(), new Timestamp(System.currentTimeMillis()), itemUnit.getItemContext().getCompany().getId().toString(), itemUnit.getItemContext().getCurrency().getId().toString(), itemUnit.getItemContext().getCurrency().getId().toString(), itemUnit.getItemContext().getPeriodType().getValue(), 100, "schemeSaveId"});
        return itemDataEntryId;
    }

    protected void saveItemEntryValue(ItemFormulaSaveUnit itemUnit, String entryId, Map<String, ItemKeyTable> itemKeyTable) throws BOSException {
        StringBuffer insertItemDataEntry = new StringBuffer();
        insertItemDataEntry.append("\tinsert into {0}\t\n");
        insertItemDataEntry.append("\t(fid,{1})\t\n");
        insertItemDataEntry.append("\tvalues(?,?)\t\n");
        String tableName = itemKeyTable.get(itemUnit.getItemInfo().getNumber()).getTableName();
        String fieldName = itemKeyTable.get(itemUnit.getItemInfo().getNumber()).getFieldName();
        String insertSql = new MessageFormat(insertItemDataEntry.toString()).format(new Object[]{tableName, fieldName});
        DbUtil.execute((Context)this.dao.getContext(), (String)insertSql, (Object[])new Object[]{entryId, itemUnit.getResult()});
    }
}

