/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.trigger;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IOne2OneMatch;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.NItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryAllItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryDataElement;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryNItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IItemSourceType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.trigger.ItemFormulaParameter;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.AutoItemItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FormulaForQueryItemResult
implements IMethodBatchQuery,
ICalculator,
IOne2OneMatch {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", FormulaForQueryItemResult.class);
    public static final String FORMULA_NAME = "defineQueryItemResult";
    private DBHandler dao;
    private ICalculateContextProvider context;

    public FormulaForQueryItemResult() {
    }

    public FormulaForQueryItemResult(DBHandler dao) {
        this();
        this.dao = dao;
    }

    public boolean batchQuery(Map methods) {
        for (Object methodName : methods.keySet()) {
            if (!(methodName instanceof String)) continue;
            if ("ITEM".equalsIgnoreCase((String)methodName)) {
                this.query("ITEM", (SortedParameterArray)methods.get(methodName));
                continue;
            }
            if (!"DITEM".equalsIgnoreCase((String)methodName)) continue;
            this.query("DITEM", (SortedParameterArray)methods.get(methodName));
        }
        this.defineQueryItemResult((SortedParameterArray)methods.get(FORMULA_NAME));
        return false;
    }

    protected void query(String itemKey, SortedParameterArray params) {
        Map<IItemQueryUnit, ItemResult> results;
        Map<String, Integer> dataElementStr2Number;
        if (params == null) {
            return;
        }
        QueryAllItem query = new QueryAllItem(this.dao);
        ItemContext itemContext = this.createdFrom();
        Parameter param = null;
        try {
            dataElementStr2Number = new QueryDataElement(this.dao).exec();
        }
        catch (BOSException e) {
            LOG.error("", e);
            for (int i = 0; i < params.size(); ++i) {
                param = params.getParameter(i);
                param.setValue((Object)e);
            }
            return;
        }
        HashMap<IItemQueryUnit, Parameter> unit2Params = new HashMap<IItemQueryUnit, Parameter>(params.size());
        IItemQueryUnit queryUnit2 = null;
        AutoItemItemFormula itemFormula = null;
        for (int i = 0; i < params.size(); ++i) {
            param = params.getParameter(i);
            itemFormula = this.create(param, itemKey, dataElementStr2Number);
            try {
                queryUnit2 = query.register(itemContext, itemFormula);
            }
            catch (BOSException e) {
                LOG.error("", e);
                param.setValue((Object)e);
            }
            unit2Params.put(queryUnit2, param);
        }
        try {
            results = query.queryItemValues(IItemSourceType.SUPPORTED_SOURCE_TYPE, this.getOrgType());
        }
        catch (BOSException e) {
            LOG.error("", e);
            for (int i = 0; i < params.size(); ++i) {
                param = params.getParameter(i);
                param.setValue((Object)e);
            }
            return;
        }
        for (IItemQueryUnit queryUnit2 : results.keySet()) {
            if (!unit2Params.containsKey(queryUnit2)) continue;
            ((Parameter)unit2Params.get(queryUnit2)).setValue(results.get(queryUnit2).getResult());
        }
    }

    private AutoItemItemFormula create(Parameter param, String itemKey, Map<String, Integer> dataElementStr2Number) {
        int i = 0;
        String number = (String)((Variant)param.getArgs()[i++]).getValue();
        String dynaItem = null;
        if (!"ITEM".equalsIgnoreCase(itemKey)) {
            dynaItem = (String)((Variant)param.getArgs()[i++]).getValue();
        }
        Integer year = (Integer)((Variant)param.getArgs()[i++]).getValue();
        Integer period = (Integer)((Variant)param.getArgs()[i++]).getValue();
        String dataElement = (String)((Variant)param.getArgs()[i++]).getValue();
        String valueType = (String)((Variant)param.getArgs()[i++]).getValue();
        return new AutoItemItemFormula(itemKey, number, dynaItem, year, period, dataElement, valueType, dataElementStr2Number);
    }

    private ItemContext createdFrom() {
        IReportPropertyAdapter reportAdapter = this.context.getReportAdapter();
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        String companyId = (String)reportAdapter.getReportProperty("Company.ID");
        String companyNumber = (String)reportAdapter.getReportProperty("Company.Number");
        String companyName = (String)reportAdapter.getReportProperty("Company.Name");
        String currencyId = (String)reportAdapter.getReportProperty("Currency.ID");
        String currenyNum = (String)reportAdapter.getReportProperty("SourceCurrency.Number");
        Integer year = (Integer)reportAdapter.getReportProperty("Report.Year");
        Integer period = (Integer)reportAdapter.getReportProperty("Report.Period");
        Integer periodType = (Integer)reportAdapter.getReportProperty("PeriodType");
        if (BOSUuid.isValid((String)companyId, (boolean)true)) {
            company.setId(BOSUuid.read((String)companyId));
        }
        if (companyNumber != null) {
            company.setNumber(currenyNum);
        }
        if (companyName != null) {
            company.setName(companyName);
        }
        CurrencyInfo currency = new CurrencyInfo();
        if (currenyNum != null) {
            currency.setNumber(currenyNum);
        }
        if (BOSUuid.isValid((String)currencyId, (boolean)true)) {
            currency.setId(BOSUuid.read((String)currencyId));
        }
        return new ItemContext((OrgUnitInfo)company, currency, periodType != null ? RptPeriodTypeEnum.getEnum((int)periodType) : null, year != null ? year : 0, period != null ? period : 0);
    }

    protected void defineQueryItemResult(SortedParameterArray params) {
        if (params == null) {
            return;
        }
        Parameter param = null;
        ItemFormulaParameter item = null;
        ItemContext context = null;
        HashSet<NItemQueryUnit> queryUnits = new HashSet<NItemQueryUnit>(params.size());
        HashMap<Object, Parameter> unit2Param = new HashMap<Object, Parameter>(params.size());
        for (int i = 0; i < params.size(); ++i) {
            param = params.getParameter(i);
            item = new ItemFormulaParameter(param);
            context = item.getItemContext();
            NItemQueryUnit queryUnit = new NItemQueryUnit(context.getCompany(), "ITEM", item.getItemNumber(), context.getYear(), context.getPeriod(), context.getPeriodType(), context.getDataElement(), context.getValueType(), context.getCurrency());
            queryUnits.add(queryUnit);
            unit2Param.put(queryUnit, param);
        }
        try {
            Map<NItemQueryUnit, ItemResult> results = new QueryNItem(this.dao).queryValues((Set<NItemQueryUnit>)queryUnits, (Collection<Integer>)new HashSet<Integer>(0), this.getOrgType());
            for (NItemQueryUnit queryUnit : queryUnits) {
                if (!results.containsKey(queryUnit)) continue;
                ((Parameter)unit2Param.get(queryUnit)).setValue(results.get(queryUnit).getResult());
            }
        }
        catch (BOSException e) {
            LOG.error("", e);
            for (int i = 0; i < params.size(); ++i) {
                param = params.getParameter(i);
                param.setValue((Object)("#BAD FUNCTION!:" + e.getMessage()));
            }
        }
    }

    private OrgType getOrgType() {
        if (this.context == null || this.context.getReportAdapter() == null || !(this.context.getReportAdapter().getReportProperty("orgType") instanceof OrgType)) {
            return OrgType.Company;
        }
        return (OrgType)this.context.getReportAdapter().getReportProperty("orgType");
    }

    public BigDecimal defineQueryItemResult(String itemNumber, ItemContext itemContext) {
        return null;
    }

    public BigDecimal item(String itemNumber, int year, int period, String dataElement, String valueType) {
        return null;
    }

    public BigDecimal ditem(String itemNumber, String dynaItem, int year, int period, String dataElement, String valueType) {
        return null;
    }

    public void initCalculateContext(ICalculateContextProvider context) {
        if (context == null) {
            return;
        }
        this.dao = new DBHandler(context.getServerContext());
        this.context = context;
    }
}

