/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.elimreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICSLReportCalculator;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.BuildElimRptBookInfo;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ElimReportUtils;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ICatchDataSource;
import com.kingdee.eas.fi.gr.dynamic.MultiDynaSumTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CatchMultiCslElimRptDataSource
implements ICatchDataSource {
    @Override
    public void catchDataSource(BuildElimRptBookInfo buildInfo) throws Exception {
        this.convertSrcReportToElimReport(buildInfo);
        this.execCatchDataSource(buildInfo);
    }

    private void execCatchDataSource(BuildElimRptBookInfo buildInfo) throws Exception {
        DynaSumMethodEnum multiSumTypeEnum = DynaSumMethodEnum.LIST_COMPANY_NAME;
        CslReportInfo srcReportInfo = buildInfo.getSrcCslRptInfo();
        Book book = buildInfo.getElimRptInfo().getBook();
        boolean onlyList = true;
        boolean isShowTotal = true;
        boolean isOnlyListCompany = true;
        Map<Object, Object> tableValues = ElimReportUtils.getTableMap(multiSumTypeEnum, onlyList, isShowTotal, isOnlyListCompany, book);
        buildInfo.setTableScanValues(tableValues);
        List<Object> companyList = this.getCompanyIDsList(srcReportInfo, buildInfo);
        buildInfo.setCompanyList(companyList);
        Map queryResult = this.calcMultiDynaSumRpt(srcReportInfo.getId().toString(), companyList, isOnlyListCompany, tableValues, buildInfo);
        buildInfo.setQueryResult(queryResult);
    }

    private List<Object> getCompanyIDsList(CslReportInfo srcReportInfo, BuildElimRptBookInfo buildInfo) throws EASBizException, BOSException {
        OrgUnitCollection units = DynamicTemplateUtility.getOrgUnits((Context)buildInfo.getCtx(), (OrgTreeInfo)srcReportInfo.getOrgTree(), (OrgUnitInfo)srcReportInfo.getOrgUnit());
        ArrayList<Object> ids = new ArrayList<Object>(units.size());
        Iterator it = units.iterator();
        while (it.hasNext()) {
            ids.add(((OrgUnitInfo)it.next()).getId().toString());
        }
        return ids;
    }

    protected Map calcMultiDynaSumRpt(String reportID, List companyList, boolean isOnlyListCompany, Map tableValues, BuildElimRptBookInfo buildInfo) throws Exception {
        Map<String, AsstActTypeCollection> asstActTypeMap = ElimReportUtils.collectAsstActTypeMap(buildInfo.getCtx(), buildInfo.getElimRptInfo().getBook());
        buildInfo.setSheetAsstActTypeMap(asstActTypeMap);
        MultiDynaSumTypeEnum sumType = MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT;
        ICSLReportCalculator iCalculator = buildInfo.getCtx() == null ? CSLReportCalculatorFactory.getRemoteInstance() : CSLReportCalculatorFactory.getLocalInstance(buildInfo.getCtx());
        return iCalculator.calculateMultiDynaElimCslRpt(reportID, companyList, asstActTypeMap, tableValues, sumType, isOnlyListCompany);
    }

    private void convertSrcReportToElimReport(BuildElimRptBookInfo buildInfo) {
        if (buildInfo.getSrcCslRptInfo() == null) {
            throw new RuntimeException("Source CslReportInfo is Null for Build ElimReport!");
        }
        if (buildInfo.getElimRptInfo() != null) {
            return;
        }
        CslReportInfo srcCslRptInfo = buildInfo.getSrcCslRptInfo();
        CslReportInfo elimRptInfo = (CslReportInfo)srcCslRptInfo.clone();
        elimRptInfo.setId(BOSUuid.create((BOSObjectType)srcCslRptInfo.getBOSType()));
        elimRptInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        elimRptInfo.setSourceType(ElimReportUtils.getElimRptSrcTypeBySrcReportInfo(srcCslRptInfo));
        buildInfo.setElimRptInfo(elimRptInfo);
    }
}

