/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.excel.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.AlignmentInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.BordersInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.CellInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.ColStyleInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.CommentInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.DynaInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.FontInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.HyperLinkInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.InteriorInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.KmlStyleParser;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.MergeInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.ProtectionInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.RowStyleInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.SheetOptionInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.StyleInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.utils.DynaRangeProvider;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StyleUtils {
    public static CellInfo[] getCellContent(Sheet sheet, boolean isInit) {
        ItemFormula tmpItemFormula = null;
        String cellValue = null;
        String formula = null;
        String itemFormula = null;
        String ext = null;
        String formulaExp = null;
        CommentInfo comment = null;
        HyperLinkInfo hyperLink = null;
        ArrayList<CellInfo> cells = null;
        CellInfo cellInfo = null;
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), false, false);
        while (iter.hasNext()) {
            Cell cell = iter.next();
            if (cell == null) continue;
            cellValue = isInit && !cell.isHasValue() ? "" : (cell.getValue() == null ? null : cell.getValue().toString());
            formula = cell.getFormula();
            tmpItemFormula = UserObjectHelper.getItemFormula((Cell)cell);
            String string = itemFormula = tmpItemFormula == null ? null : tmpItemFormula.toString();
            if (tmpItemFormula != null) {
                ext = null;
                String kv = "";
                Map map = tmpItemFormula.getExt();
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    String key = it.next().toString();
                    String value = map.get(key).toString();
                    kv = key + "#_#" + value;
                    ext = ext == null ? kv : ext + "#:#" + kv;
                }
            } else {
                ext = null;
            }
            if (cell.getUserObject("FormulaExp") != null) {
                formulaExp = cell.getUserObject("FormulaExp").getValue().toString();
            }
            boolean isBuildCell = false;
            if (isInit) {
                if (StyleUtils.isRptFormula(formula) || !StringUtils.isEmpty((String)itemFormula) || cell.getComment() != null || !StringUtils.isEmpty(ext)) {
                    isBuildCell = true;
                }
            } else if (!(StringUtils.isEmpty((String)cellValue) && StringUtils.isEmpty((String)formula) && StringUtils.isEmpty((String)itemFormula) && StringUtils.isEmpty(ext) && cell.getComment() == null)) {
                isBuildCell = true;
            }
            if (!isBuildCell) continue;
            cellInfo = new CellInfo();
            cellInfo.setCol(cell.getCol());
            cellInfo.setRow(cell.getRow());
            int isLocked = cell.isLocked() ? 0 : 1;
            int isHidden = cell.getStyle().isHided() ? 0 : 1;
            cellInfo.setIsLocked(isLocked);
            cellInfo.setIsHidden(isHidden);
            if (!StringUtils.isEmpty((String)cellValue)) {
                cellInfo.setCellValue(cellValue);
            }
            if (!StringUtils.isEmpty((String)formula) && formula.trim().startsWith("=")) {
                cellInfo.setFormula(formula);
            }
            if (!StringUtils.isEmpty((String)itemFormula)) {
                cellInfo.setItemformula(itemFormula);
            }
            if (!StringUtils.isEmpty((String)formulaExp)) {
                cellInfo.setFormulaExp(formulaExp);
            }
            if (cell.getComment() != null) {
                comment = new CommentInfo();
                comment.setAuthor(cell.getComment().getAuthor());
                comment.setText(cell.getComment().getText());
                cellInfo.setComment(comment);
            }
            if (cell.getHyperLink() != null) {
                hyperLink = new HyperLinkInfo();
                hyperLink.setText(cell.getHyperLink().getText());
                String linkTo = cell.getHyperLink().getLinkTo();
                if (!StringUtils.isEmpty((String)linkTo)) {
                    linkTo = linkTo.replaceFirst("#", "");
                }
                hyperLink.setLinkTo(linkTo);
                cellInfo.setHyperLink(hyperLink);
            }
            if (ext != null) {
                cellInfo.setExt(ext);
            }
            if (cell.getSSA2() != null) {
                cellInfo.setStyleId(StyleUtils.numToLetter(String.valueOf(cell.getSSA2().getUID())));
            }
            if (cells == null) {
                cells = new ArrayList<CellInfo>();
            }
            cells.add(cellInfo);
        }
        if (cells != null) {
            CellInfo[] cellArray = new CellInfo[cells.size()];
            return cells.toArray(cellArray);
        }
        return null;
    }

    public static MergeInfo[] buildMergeBlock(Sheet sheet) {
        MergeBlocks mergeBlocks = sheet.getMerger(false);
        ArrayList<MergeInfo> mergeBlockList = new ArrayList<MergeInfo>();
        if (mergeBlocks != null && mergeBlocks.size() > 0) {
            CellBlock cellBlock = null;
            MergeInfo mergeInfo = null;
            for (int i = 0; i < mergeBlocks.size(); ++i) {
                cellBlock = mergeBlocks.getBlock(i);
                if (cellBlock == null) continue;
                mergeInfo = new MergeInfo();
                mergeInfo.setStartRow(cellBlock.getRow());
                mergeInfo.setEndRow(cellBlock.getRow() + cellBlock.getHeight() - 1);
                mergeInfo.setStartCol(cellBlock.getCol());
                mergeInfo.setEndCol(cellBlock.getCol() + cellBlock.getWidth() - 1);
                mergeBlockList.add(mergeInfo);
            }
        }
        if (mergeBlockList.size() > 0) {
            MergeInfo[] mergeArray = new MergeInfo[mergeBlockList.size()];
            return mergeBlockList.toArray(mergeArray);
        }
        return null;
    }

    public static StyleInfo getSheetStyle(Sheet sheet) {
        ArrayList<BordersInfo> borderList = new ArrayList<BordersInfo>();
        StyleInfo styleInfo = null;
        ShareStyleAttributes ssa = sheet.getSSA();
        if (ssa != null) {
            styleInfo = StyleUtils.buildStyleInfo(ssa, borderList);
        }
        return styleInfo;
    }

    public static StyleInfo[] getCellsStyle(Sheet sheet) {
        HashMap<String, StyleInfo> styles = new HashMap<String, StyleInfo>();
        ShareStyleAttributes ssa = null;
        StyleInfo styleInfo = null;
        ArrayList<BordersInfo> borderList = new ArrayList<BordersInfo>();
        Object curBorderInfo = null;
        Object curColor = null;
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), false, false);
        while (iter.hasNext()) {
            Cell cell = iter.next();
            if (cell == null || (ssa = cell.getSSA2()) == null) continue;
            styleInfo = StyleUtils.buildStyleInfo(ssa, borderList);
            styles.put(StyleUtils.numToLetter(String.valueOf(ssa.getUID())), styleInfo);
        }
        if (styles.size() > 0) {
            StyleInfo[] styleArray = new StyleInfo[styles.values().size()];
            return styles.values().toArray(styleArray);
        }
        return null;
    }

    public static StyleInfo buildStyleInfo(ShareStyleAttributes ssa, List<BordersInfo> borderList) {
        Styles.Position[] position;
        StyleInfo styleInfo = new StyleInfo();
        BordersInfo curBorderInfo = null;
        Color curColor = null;
        styleInfo.setId(StyleUtils.numToLetter(String.valueOf(ssa.getUID())));
        borderList.clear();
        for (Styles.Position curPosision : position = new Styles.Position[]{Styles.Position.LEFT, Styles.Position.TOP, Styles.Position.RIGHT, Styles.Position.BOTTOM, Styles.Position.DIAGONALLEFT, Styles.Position.DIAGONALRIGHT}) {
            curBorderInfo = StyleUtils.buildBorderInfo(ssa, curPosision);
            if (curBorderInfo == null) continue;
            borderList.add(curBorderInfo);
        }
        if (borderList != null && borderList.size() > 0) {
            BordersInfo[] borderArray = new BordersInfo[borderList.size()];
            styleInfo.setBorders(borderList.toArray(borderArray));
        }
        styleInfo.setFont(StyleUtils.buildFontInfo(ssa));
        curColor = ssa.getBackground();
        if (ssa.getPattern() != null && !Pattern.None.equals(ssa.getPattern())) {
            InteriorInfo interior = new InteriorInfo();
            if (curColor != null && curColor.getRGB() != -1) {
                interior.setColor(curColor.getRed() + ";" + curColor.getGreen() + ";" + curColor.getBlue());
            }
            interior.setPattern(InteriorInfo.toKmlPatternName(ssa.getPattern()));
            curColor = ssa.getPatternColor();
            if (curColor != null && curColor.getRGB() != -1) {
                interior.setPatternColor(curColor.getRed() + ";" + curColor.getGreen() + ";" + curColor.getBlue());
            }
            styleInfo.setInterior(interior);
        }
        styleInfo.setAlignment(StyleUtils.buildAlignment(ssa));
        return styleInfo;
    }

    public static FontInfo buildFontInfo(ShareStyleAttributes ssa) {
        int[] fontAttrIndex = new int[]{ShareStyleAttributes.FONT_NAME, ShareStyleAttributes.FONT_SIZE, ShareStyleAttributes.FONT_COLOR, ShareStyleAttributes.FONT_BOLD};
        Object obj = null;
        FontInfo fontInfo = null;
        for (int index : fontAttrIndex) {
            if (!ssa.hasAttributes(index) || (obj = ssa.get(index)) == null) continue;
            if (fontInfo == null) {
                fontInfo = new FontInfo();
            }
            if (index == ShareStyleAttributes.FONT_NAME) {
                fontInfo.setName(obj.toString());
                continue;
            }
            if (index == ShareStyleAttributes.FONT_SIZE) {
                fontInfo.setSize(obj.toString());
                continue;
            }
            if (index == ShareStyleAttributes.FONT_COLOR) {
                Color color = (Color)obj;
                if (color.getAlpha() == 255) continue;
                fontInfo.setColor(color.getRed() + ";" + color.getGreen() + ";" + color.getBlue());
                continue;
            }
            if (index != ShareStyleAttributes.FONT_BOLD || !Boolean.TRUE.equals(obj)) continue;
            fontInfo.setBold("1");
        }
        return fontInfo;
    }

    public static AlignmentInfo buildAlignment(ShareStyleAttributes ssa) {
        AlignmentInfo alignmentInfo = null;
        if (ssa.hasAlignmentAttributes()) {
            Object obj;
            Styles.VerticalAlignment va;
            String verticalAlignment = null;
            String horizontalAlignment = null;
            alignmentInfo = new AlignmentInfo();
            if (ssa.hasAttributes(ShareStyleAttributes.VERTICAL_ALIGN)) {
                va = ssa.getVerticalAlign();
                if (Styles.VerticalAlignment.MIDDLE.equals(va)) {
                    verticalAlignment = "-4108";
                } else if (Styles.VerticalAlignment.TOP.equals(va)) {
                    verticalAlignment = "-4160";
                } else if (Styles.VerticalAlignment.BOTTOM.equals(va)) {
                    verticalAlignment = "-4107";
                }
                alignmentInfo.setVertical(verticalAlignment);
            }
            if (ssa.hasAttributes(ShareStyleAttributes.HORIZONTAL_ALIGN)) {
                va = ssa.getHorizontalAlign();
                if (Styles.HorizontalAlignment.CENTER.equals(va)) {
                    horizontalAlignment = "-4108";
                } else if (Styles.HorizontalAlignment.RIGHT.equals(va)) {
                    horizontalAlignment = "-4152";
                } else if (Styles.HorizontalAlignment.LEFT.equals(va)) {
                    horizontalAlignment = "-4131";
                }
                alignmentInfo.setHorizontal(horizontalAlignment);
            }
            if (ssa.hasAttributes(ShareStyleAttributes.WRAP_TEXT) && Boolean.TRUE.equals(obj = ssa.get(ShareStyleAttributes.WRAP_TEXT))) {
                alignmentInfo.setWrapText("1");
            }
        }
        return alignmentInfo;
    }

    public static BordersInfo buildBorderInfo(ShareStyleAttributes ssa, Styles.Position pos) {
        LineStyle lineStyle;
        if (ssa.hasBorderAttributes(pos) && (lineStyle = ssa.getBorderLineStyle(pos)) != null && lineStyle != LineStyle.NULL_LINE) {
            PenStyle penStyle = ssa.getBorderPenStyle(pos);
            if (penStyle == null) {
                penStyle = Styles.getDefaultSSA().getBorderPenStyle(pos);
            }
            BordersInfo borderInfo = KmlStyleParser.toKmlBorder(lineStyle, penStyle);
            borderInfo.setPosition(KmlStyleParser.firstCharToUpper(pos.getName()));
            int colorIndex = ShareStyleAttributes.getBorderColorIndex((Styles.Position)pos);
            if (ssa.hasAttributes(colorIndex)) {
                Color curColor = (Color)ssa.get(colorIndex);
                if (curColor.getAlpha() != 255) {
                    curColor = new Color(curColor.getRed(), curColor.getGreen(), curColor.getBlue());
                }
                borderInfo.setColor(String.valueOf(curColor.getRGB()));
            }
            return borderInfo;
        }
        return null;
    }

    public static RowStyleInfo[] buildRowStyle(Sheet sheet) {
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        SortedAttributeSpanArray.AttributeSpan attr = null;
        RowStyleInfo rowStyle = null;
        ArrayList<RowStyleInfo> rowStyles = null;
        for (int i = 0; i < rowSpans.size(); ++i) {
            attr = rowSpans.getAttributeSpan(i);
            if (attr == null) continue;
            if (rowStyles == null) {
                rowStyles = new ArrayList<RowStyleInfo>();
            }
            rowStyle = new RowStyleInfo();
            rowStyle.setHeigth(String.valueOf(attr.getOriginalLength() * 3 / 4));
            rowStyle.setStartIndex(String.valueOf(i + attr.getStart()));
            rowStyle.setEndIndex(String.valueOf(i + attr.getEnd()));
            rowStyles.add(rowStyle);
        }
        if (rowStyles != null) {
            RowStyleInfo[] rowStyleArray = new RowStyleInfo[rowStyles.size()];
            return rowStyles.toArray(rowStyleArray);
        }
        return null;
    }

    public static ColStyleInfo[] buildColStyle(Sheet sheet) {
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        SortedAttributeSpanArray.AttributeSpan attr = null;
        ColStyleInfo colStyle = null;
        ArrayList<ColStyleInfo> colStyles = null;
        for (int i = 0; i < colSpans.size(); ++i) {
            attr = colSpans.getAttributeSpan(i);
            if (attr == null) continue;
            if (colStyles == null) {
                colStyles = new ArrayList<ColStyleInfo>();
            }
            colStyle = new ColStyleInfo();
            colStyle.setWidth(String.valueOf(attr.getOriginalLength() * 3 / 4 * 12 / 72));
            colStyle.setStartIndex(String.valueOf(attr.getStart()));
            colStyle.setEndIndex(String.valueOf(attr.getStart() + attr.getExtent() - 1));
            colStyles.add(colStyle);
        }
        if (colStyles != null) {
            ColStyleInfo[] ColStyleArray = new ColStyleInfo[colStyles.size()];
            return colStyles.toArray(ColStyleArray);
        }
        return null;
    }

    public static String numToLetter(String input) {
        StringBuffer sb = new StringBuffer();
        for (byte b : input.getBytes()) {
            sb.append((char)(b + 48));
        }
        return sb.toString();
    }

    public static SheetOptionInfo buildSheetOption(Sheet sheet) {
        SheetOptionInfo sheetOption = null;
        Protection pro = sheet.getSheetOption().getProtection(false);
        if (pro != null) {
            sheetOption = new SheetOptionInfo();
            ProtectionInfo protection = new ProtectionInfo();
            protection.setOpers(pro.getOperations());
            protection.setEncryptPW(pro.getEncryptedPassword());
            protection.setIsProtected(pro.isProtected() ? 0 : 1);
            sheetOption.setProtection(protection);
        }
        return sheetOption;
    }

    public static DynaInfo[] buildDynaInfo(Sheet sheet) {
        DynaInfo[] infos = null;
        ArrayList bplist = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
        if (bplist != null) {
            infos = new DynaInfo[bplist.size()];
            for (int i = 0; i < bplist.size(); ++i) {
                DynaInfo dynaInfo = new DynaInfo();
                Point p = (Point)bplist.get(i);
                dynaInfo.setlRow(p.y);
                dynaInfo.setlCol(p.x);
                DynaRangeProvider dynaRangeProvider = new DynaRangeProvider();
                Point p2 = dynaRangeProvider.getDynaRange(sheet, p);
                dynaInfo.setrRow(p2.y);
                dynaInfo.setrCol(p2.x);
                DynaParameters param = DynamicTemplateUtility.getDynaParametersFromCell((Sheet)sheet, (int)p.y, (int)p.x);
                DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, p, sheet, true, true);
                int sumFormulaCount = indexHandle.getSumRangeCount();
                if (param.isIncludeSum()) {
                    boolean isHorizon = param.getSpreadStyle() == 1;
                    boolean isLeftUp = param.getPosition() == 1;
                    int minimum = isHorizon ? p.x + 1 : p.y + 1;
                    int maximum = minimum + param.getDefaultCounter() + sumFormulaCount - 1;
                    if (isLeftUp) {
                        if (isHorizon) {
                            dynaInfo.setIncludeSumRow(maximum);
                            dynaInfo.setIncludeSumCol(p.x);
                        } else {
                            dynaInfo.setIncludeSumRow(p.y);
                            dynaInfo.setIncludeSumCol(minimum);
                        }
                    } else if (isHorizon) {
                        dynaInfo.setIncludeSumRow(p.y);
                        dynaInfo.setIncludeSumCol(maximum);
                    } else {
                        dynaInfo.setIncludeSumRow(maximum);
                        dynaInfo.setIncludeSumCol(p.x);
                    }
                }
                if (param.isGrade()) {
                    dynaInfo.setGradeInfo(StyleUtils.buildGradeInfo(sheet.getRange(p.y, p.x)));
                }
                infos[i] = dynaInfo;
            }
        }
        return infos;
    }

    public static String buildGradeInfo(Range range) {
        Object obj = range.getUserObject("DItemGradeInfo");
        if (obj instanceof DItemGradeInfo) {
            DItemGradeInfo digi = (DItemGradeInfo)obj;
            try {
                return digi.toSerialString();
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    private static boolean isRptFormula(String formula) {
        String[] ar;
        if (StringUtils.isEmpty((String)formula)) {
            return false;
        }
        for (String s : ar = new String[]{"AGE", "ACCT", "ACCTAC", "ACCTCASH", "ACCTCASHEXT", "ACCTEXT", "INCASHFLOW", "RACCT", "ACCTITEM", "ADJUSTDATA", "AREF", "DYITEM", "ESP", "ELIMDATA", "ELIMRPT", "EQTDATA", "HISRATEDATA", "INVDATA", "REFDM", "ACCTNAME", "BASICCURRENCY", "CSREF", "CUSEXCHANGERATE", "DHOLDING", "EXCHANGERATE", "GETCREATOR", "GETCURRENCY", "GETORGENAME", "GETORGMESSAGE", "GETORGNAME", "GETORGNUM", "GETORGTREE", "KPGETSQL", "REF", "REFM", "REPORTCURRENCY", "RPTDATE", "RPTNAME", "RPTSHEETDATE"}) {
            if (formula.toUpperCase().indexOf(s) == -1) continue;
            return true;
        }
        return false;
    }
}

