/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.inspect.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RptReceivedInfo;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectFixDataCollection;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectFixDataInfo;
import com.kingdee.eas.fi.gr.cslrpt.inspect.app.AbstractInspectExe;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RepairDataRepeat
extends AbstractInspectExe {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.inspect.app.RepairDataRepeat");

    @Override
    public Map<String, Object> executeFix(Map<String, Object> filters, Context ctx) {
        HashMap<String, Object> result = new HashMap<String, String>();
        try {
            result = this.clearRptReceivedForDuplicateItem(filters, ctx);
        }
        catch (Exception e) {
            result.put("UIResult", ResourceBase.getString((String)this.RES_PATH, (String)"reDataRepeatExRpt", (Locale)ctx.getOriginLocale()) + RepairDataRepeat.getExpMessage(e));
        }
        return result;
    }

    private Map<String, Object> clearRptReceivedForDuplicateItem(Map<String, Object> filters, Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuffer sqlQuery = new StringBuffer();
        this.repairRptReceived(ctx, ((OrgTreeInfo)filters.get("orgBound")).getId().toString());
        sqlQuery.append(" select t1.fid, t2.fname, t2.fid \r\n");
        sqlQuery.append(" from t_csl_rptreceived t1 \r\n");
        sqlQuery.append(" join t_csl_cslreport t2 on t1.freportid=t2.fid \r\n");
        sqlQuery.append(" join t_org_tree t3 on t1.forgtreeid=t3.fid \r\n");
        sqlQuery.append(" where (t2.freportdate<t3.fstartdate or t2.freportdate>isnull(t3.fenddate,CONVERT(DATETIME,'2100-01-01'))) \r\n");
        sqlQuery.append(" and t2.fyear=? \r\n");
        sqlQuery.append(" and t2.FPERIOD =? \r\n");
        sqlQuery.append(" and t2.FPERIODTYPE=? \r\n");
        sqlQuery.append(" and t2.FORGTREEID=? \r\n");
        Object[] params = new Object[]{(Integer)filters.get("year"), (Integer)filters.get("month"), (Integer)filters.get("periodType"), ((OrgTreeInfo)filters.get("orgBound")).getId().toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlQuery.toString(), (Object[])params);
        String UIResult = "";
        CslInspectFixDataCollection fixDatas = new CslInspectFixDataCollection();
        if (rs.size() > 0) {
            StringBuffer sqlBuff = new StringBuffer("delete from t_csl_rptreceived where fid IN (");
            try {
                while (rs.next()) {
                    sqlBuff.append(rs.getString(1)).append(",");
                    CslInspectFixDataInfo fixDateInfo = new CslInspectFixDataInfo();
                    fixDateInfo.setId(BOSUuid.read((String)rs.getString(3)));
                    fixDatas.add(fixDateInfo);
                    UIResult = UIResult + rs.getString(2) + ";";
                }
            }
            catch (SQLException e) {
                logger.error((Object)" db result get next error:", (Throwable)e);
            }
            sqlBuff.deleteCharAt(sqlBuff.length() - 1);
            sqlBuff.append(")");
            DbUtil.execute((Context)ctx, (String)sqlBuff.toString());
        }
        if (UIResult.length() > 0) {
            UIResult = UIResult.substring(UIResult.length() - 1);
        }
        if (rs.size() > 0) {
            UIResult = UIResult + ResourceBase.getString((String)this.RES_PATH, (String)"dataEntryTip", (Locale)ctx.getOriginLocale());
        }
        UIResult = MessageFormat.format(ResourceBase.getString((String)this.RES_PATH, (String)"reDataRepeatRpt", (Locale)ctx.getOriginLocale()), rs.size()) + UIResult;
        result.put("UIResult", UIResult);
        result.put("resultEntry", (Object)fixDatas);
        return result;
    }

    private void repairRptReceived(Context ctx, String treeId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO T_CSL_RptReceived (FID,FReportID,forgtreeid,FCREATORID,FCREATETIME) ");
        String bosType = new RptReceivedInfo().getBOSType().toString();
        sql.append(" SELECT newbosid('").append(bosType).append("') as FID,  ");
        sql.append(" rpt.fid as FReportID, '").append(treeId).append("' AS forgtreeid,");
        sql.append(" rpt.FCREATORID,rpt.FCREATETIME ");
        sql.append(" FROM t_csl_cslreport rpt ");
        sql.append(" INNER JOIN t_org_structure struct ON struct.funitid = rpt.forgunitid ");
        sql.append(" WHERE struct.ftreeid = '" + treeId + "'  ");
        sql.append(" AND NOT EXISTS( SELECT 1 FROM T_CSL_RptReceived WHERE FReportID = rpt.fid)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

