/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.reportcalc;

import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.ReportCalcGroupKey;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCslReportParamInfo
implements Serializable {
    private Map<OrgTreeInfo, Set<String>> companyMap;
    private Map<String, OrgTreeInfo> orgTreeIdMap;
    private Map excludeCompanyMap;
    private Map backCompanyMap;
    private Map unionMap;
    private Map excludeUnionMap;
    private Map<ReportCalcGroupKey, Set<String>> companyGroupMap;
    private Map<ReportCalcGroupKey, Set<String>> backCompanyGroupMap;

    public void setCompanyMap(Map companyMap) {
        this.companyMap = companyMap;
    }

    public final void initMap(AbstractCslReportParamInfo info) {
        this.companyMap = info.companyMap;
        this.unionMap = info.unionMap;
        this.excludeCompanyMap = info.excludeCompanyMap;
        this.excludeUnionMap = info.excludeUnionMap;
    }

    public final void addCompany(OrgTreeInfo orgTree, String companyId) {
        this.addCompanyByOrgTreeId(orgTree, companyId);
    }

    public final void addCompanyByOrgTreeId(OrgTreeInfo orgTree, String companyId) {
        if (this.companyMap == null) {
            this.companyMap = new HashMap<OrgTreeInfo, Set<String>>();
        }
        Set companyIdSet = this.getCompanyIdSet(orgTree, this.companyMap);
        companyIdSet.add(companyId);
    }

    public void addCompanyGroupMap(ReportCalcGroupKey calcGroupKey, String companyId) {
        if (this.companyGroupMap == null) {
            this.companyGroupMap = new HashMap<ReportCalcGroupKey, Set<String>>();
        }
        Set companyIdSet = this.getCompanyIdSet(calcGroupKey, this.companyGroupMap);
        companyIdSet.add(companyId);
    }

    public Set getCompanyIdSet(Object key, Map companyMap) {
        HashSet companyIdSet;
        if (key instanceof OrgTreeInfo) {
            OrgTreeInfo info;
            if (this.orgTreeIdMap == null) {
                this.orgTreeIdMap = new HashMap<String, OrgTreeInfo>();
            }
            if ((info = this.orgTreeIdMap.get(((OrgTreeInfo)key).getId().toString())) != null) {
                key = info;
            } else {
                this.orgTreeIdMap.put(((OrgTreeInfo)key).getId().toString(), (OrgTreeInfo)key);
            }
        }
        if ((companyIdSet = (HashSet)companyMap.get(key)) == null) {
            companyIdSet = new HashSet();
            companyMap.put(key, companyIdSet);
        }
        return companyIdSet;
    }

    public final void addExcludeCompany(OrgTreeInfo orgTree, String companyId) {
        HashSet<String> companyIdSet;
        if (this.excludeCompanyMap == null) {
            this.excludeCompanyMap = new HashMap();
        }
        if ((companyIdSet = (HashSet<String>)this.excludeCompanyMap.get(orgTree)) == null) {
            companyIdSet = new HashSet<String>();
            this.excludeCompanyMap.put(orgTree, companyIdSet);
        }
        companyIdSet.add(companyId);
    }

    public final void addUnion(OrgTreeInfo orgTree, String companyId) {
        HashSet<String> set;
        if (this.unionMap == null) {
            this.unionMap = new HashMap();
        }
        if ((set = (HashSet<String>)this.unionMap.get(orgTree)) == null) {
            set = new HashSet<String>();
            this.unionMap.put(orgTree, set);
        }
        set.add(companyId);
    }

    public final void addExcludeUnion(OrgTreeInfo orgTree, String companyId) {
        HashSet<String> set;
        if (this.excludeUnionMap == null) {
            this.excludeUnionMap = new HashMap();
        }
        if ((set = (HashSet<String>)this.excludeUnionMap.get(orgTree)) == null) {
            set = new HashSet<String>();
            this.excludeUnionMap.put(orgTree, set);
        }
        set.add(companyId);
    }

    public final Map<OrgTreeInfo, Set<String>> getCompanyMap() {
        if ((this.companyMap == null || this.companyMap.isEmpty()) && this.companyGroupMap != null && !this.companyGroupMap.isEmpty()) {
            this.companyMap = new HashMap<OrgTreeInfo, Set<String>>();
            Set companyIdSet = null;
            for (ReportCalcGroupKey key : this.companyGroupMap.keySet()) {
                companyIdSet = this.getCompanyIdSet(key.getOrgTree(), this.companyMap);
                companyIdSet.addAll((Collection)this.companyGroupMap.get(key));
            }
        }
        return this.companyMap;
    }

    public final Map getExcludeCompanyMap() {
        return this.excludeCompanyMap;
    }

    public Map<ReportCalcGroupKey, Set<String>> getSrcCompanyGroupMap() {
        return this.companyGroupMap;
    }

    public Map<ReportCalcGroupKey, Set<String>> getCompanyGroupMap() {
        if (this.companyGroupMap == null) {
            this.companyGroupMap = new HashMap<ReportCalcGroupKey, Set<String>>();
        }
        if (this.companyGroupMap.isEmpty() && this.companyMap != null) {
            ReportCalcGroupKey key = null;
            Set companyIdSet = null;
            for (OrgTreeInfo obj : this.companyMap.keySet()) {
                key = new ReportCalcGroupKey();
                key.setOrgTree(obj);
                key.setFromStatutory(true);
                companyIdSet = this.getCompanyIdSet(key, this.companyGroupMap);
                companyIdSet.addAll(this.companyMap.get(obj));
            }
        }
        return this.companyGroupMap;
    }

    public final void backCompanyMap() {
        this.getCompanyMap();
        if (this.companyMap != null) {
            this.backCompanyMap = new HashMap();
            this.copyMap(this.companyMap, this.backCompanyMap);
        }
        this.getCompanyGroupMap();
        if (this.companyGroupMap != null) {
            this.backCompanyGroupMap = new HashMap<ReportCalcGroupKey, Set<String>>();
            this.copyMap(this.companyGroupMap, this.backCompanyGroupMap);
        }
    }

    public final void reSetCompanyMap() {
        if (this.backCompanyMap != null && this.companyMap != null) {
            this.companyMap.clear();
            this.copyMap(this.backCompanyMap, this.companyMap);
        }
        if (this.backCompanyGroupMap != null && this.companyGroupMap != null) {
            this.companyGroupMap.clear();
            this.copyMap(this.backCompanyGroupMap, this.companyGroupMap);
        }
    }

    public void copyMap(Map fromMap, Map toMap) {
        for (Object key : fromMap.keySet()) {
            if (fromMap.get(key) == null) continue;
            if (fromMap.get(key) instanceof Set) {
                toMap.put(key, new HashSet((Set)fromMap.get(key)));
                continue;
            }
            toMap.put(key, fromMap.get(key));
        }
    }

    public final Map getUnionMap() {
        return this.unionMap;
    }

    public final Map getExcludeUnionMap() {
        return this.excludeUnionMap;
    }

    public final void clearCompanyMap() {
        if (this.companyMap != null) {
            this.companyMap.clear();
        }
        if (this.companyGroupMap != null) {
            this.companyGroupMap.clear();
        }
    }

    public final void clearExcludeCompanyMap() {
        if (this.excludeCompanyMap != null) {
            this.excludeCompanyMap.clear();
        }
    }

    public final void clearUnionMap() {
        if (this.unionMap != null) {
            this.unionMap.clear();
        }
    }

    public final void clearExcludeUnionMap() {
        if (this.excludeUnionMap != null) {
            this.excludeUnionMap.clear();
        }
    }

    public final String unitMap2SerialString() {
        StringBuffer str = new StringBuffer();
        str.append(this.map2SerialString(this.companyMap, false));
        str.append("#&&&#").append(this.map2SerialString(this.unionMap, false));
        str.append("#&&&#").append(this.map2SerialString(this.companyGroupMap, true));
        return str.toString();
    }

    public final void parseStr2UnitMap(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return;
        }
        String[] ss = str.split("#&&&#");
        if (ss != null && ss.length > 0) {
            this.parseStr2Map(ss[0], 1);
            if (ss.length >= 2) {
                this.parseStr2Map(ss[1], 2);
            }
            if (ss.length >= 3) {
                this.parseStr2Map(ss[2], 3);
            }
        }
    }

    private String map2SerialString(Map map, boolean isCompanyGroupMap) {
        StringBuffer str = new StringBuffer();
        if (map != null) {
            OrgTreeInfo orgTreeInfo = null;
            ReportCalcGroupKey reportCalcGroupKey = null;
            Set companyIdSet = null;
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                if (isCompanyGroupMap) {
                    reportCalcGroupKey = (ReportCalcGroupKey)iter.next();
                    companyIdSet = (Set)map.get(reportCalcGroupKey);
                    str.append(reportCalcGroupKey.toString());
                } else {
                    orgTreeInfo = (OrgTreeInfo)iter.next();
                    companyIdSet = (Set)map.get(orgTreeInfo);
                    str.append(orgTreeInfo.getId().toString());
                }
                str.append("&&");
                if (companyIdSet != null) {
                    Iterator iterator = companyIdSet.iterator();
                    while (iterator.hasNext()) {
                        str.append(iterator.next());
                        str.append(",");
                    }
                }
                str.append("##");
            }
        }
        return str.toString();
    }

    private void parseStr2Map(String str, int companyMapType) {
        if (StringUtils.isEmpty((String)str)) {
            return;
        }
        String[] ss = str.split("##");
        OrgTreeInfo orgTreeInfo = null;
        ReportCalcGroupKey reportCalcGroupKey = null;
        for (int i = 0; i < ss.length; ++i) {
            String[] split;
            if (StringUtils.isEmpty((String)ss[i]) || (split = ss[i].split("&&")).length != 2) continue;
            if (companyMapType == 3) {
                reportCalcGroupKey = ReportCalcGroupKey.parse2ReportCalcGroupKey(split[0]);
            } else {
                orgTreeInfo = new OrgTreeInfo();
                orgTreeInfo.put("id", (Object)split[0]);
            }
            String[] ids = split[1].split(",");
            for (int m = 0; m < ids.length; ++m) {
                if (StringUtils.isEmpty((String)ids[m])) continue;
                if (companyMapType == 1) {
                    this.addCompany(orgTreeInfo, ids[m]);
                    continue;
                }
                if (companyMapType == 2) {
                    this.addUnion(orgTreeInfo, ids[m]);
                    continue;
                }
                if (companyMapType != 3) continue;
                this.addCompanyGroupMap(reportCalcGroupKey, ids[m]);
            }
        }
    }
}

