/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CheckIfClauseException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.newrpt.formula.FormulaRuntimeFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CheckFormulaIfClauseUtil {
    private static Logger logger = Logger.getLogger(CheckFormulaIfClauseUtil.class);
    private static String like = null;
    private static String llike = null;
    private static String rlike = null;
    private static String orgTree = null;
    private static String company = null;
    private static String unit = null;
    private static String sourceCurrency = null;
    private static String currency = null;
    private static String year = null;
    private static String period = null;
    private static String sourceType = null;

    private static void initResource() {
        like = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Similarity");
        llike = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"LeftSimilarity");
        rlike = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"RightSimilarity");
        orgTree = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"CombBound");
        company = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Company");
        unit = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"77MnsRptGuideUnit");
        sourceCurrency = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"OrigCurrency");
        currency = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"ConvCurrency");
        year = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Year");
        period = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Period");
        sourceType = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SourceType");
    }

    public static boolean checkIfClause(String formula) throws EASBizException {
        CheckFormulaIfClauseUtil.initResource();
        if (StringUtils.isEmpty((String)formula)) {
            return false;
        }
        formula = CheckFormulaIfClauseUtil.replaceItemFormula(formula);
        String pattern = " and| or";
        String pattern1 = "\\) and|\\) or";
        Pattern patt = Pattern.compile(pattern, 2);
        Matcher matcher = patt.matcher(formula);
        formula = matcher.replaceAll("&");
        patt = Pattern.compile(pattern1, 2);
        matcher = patt.matcher(formula);
        formula = matcher.replaceAll("&");
        String[] fs = formula.split("\\(|\\)|&");
        for (int i = 0; i < fs.length; ++i) {
            String f = fs[i].trim();
            if (f.equals("")) continue;
            if (!CheckFormulaIfClauseUtil.isCompareFormula(f)) {
                return false;
            }
            formula = formula.replaceAll(f, "#");
        }
        formula = formula.replaceAll(" ", "");
        logger.info((Object)formula);
        if (formula.startsWith("&") || formula.startsWith("\\)") || formula.endsWith("&")) {
            throw new CheckIfClauseException(CheckIfClauseException.ARITHMETICRULE_ERROR);
        }
        if (formula.length() == 1 && formula.equals("#")) {
            return true;
        }
        char pre = formula.charAt(0);
        int deep = 0;
        switch (pre) {
            case '(': {
                ++deep;
                break;
            }
            case ')': {
                --deep;
            }
        }
        for (int i = 1; i < formula.length(); ++i) {
            char c = formula.charAt(i);
            block4 : switch (c) {
                case '&': {
                    switch (pre) {
                        case '#': 
                        case ')': {
                            break block4;
                        }
                    }
                    throw new CheckIfClauseException(CheckIfClauseException.ARITHMETICRULE_ERROR);
                }
                case '(': {
                    ++deep;
                    switch (pre) {
                        case '&': 
                        case '(': {
                            break block4;
                        }
                    }
                    throw new CheckIfClauseException(CheckIfClauseException.ARITHMETICRULE_ERROR);
                }
                case ')': {
                    if (--deep < 0) {
                        throw new CheckIfClauseException(CheckIfClauseException.BRACKET_NOMATCHING);
                    }
                    switch (pre) {
                        case '#': 
                        case ')': {
                            break block4;
                        }
                    }
                    throw new CheckIfClauseException(CheckIfClauseException.ARITHMETICRULE_ERROR);
                }
                case '#': {
                    if (pre == '&' || pre == '(') break;
                }
                default: {
                    throw new CheckIfClauseException(CheckIfClauseException.INVALID_CHARACTER);
                }
            }
            pre = c;
        }
        if (deep > 0) {
            throw new CheckIfClauseException(CheckIfClauseException.BRACKET_NOMATCHING);
        }
        return true;
    }

    private static boolean isCompareFormula(String f) throws CheckIfClauseException {
        String lf = null;
        String op = null;
        String rv = null;
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add(llike + "|" + rlike);
        patterns.add(like);
        patterns.add("<>|>=|<=");
        patterns.add("=|>|<");
        for (int i = 0; i < patterns.size(); ++i) {
            String pattern = (String)patterns.get(i);
            Pattern patt = Pattern.compile(pattern);
            Matcher m = patt.matcher(f);
            if (!m.find()) continue;
            op = m.group();
            String[] strs = patt.split(f);
            if (strs.length != 2) {
                throw new CheckIfClauseException(CheckIfClauseException.INVALID_COMPAREFORMULA);
            }
            lf = strs[0].trim();
            rv = strs[1].trim();
            if (lf.equals("") || rv.equals("")) {
                throw new CheckIfClauseException(CheckIfClauseException.INVALID_COMPAREFORMULA);
            }
            if (!CheckFormulaIfClauseUtil.checkCompareFormulaClause(f, lf, op, rv)) {
                throw new CheckIfClauseException(CheckIfClauseException.INVALID_COMPAREFORMULA);
            }
            return true;
        }
        if (f.equals("0") || f.equals("1")) {
            return true;
        }
        throw new CheckIfClauseException(CheckIfClauseException.INVALID_COMPAREFORMULA);
    }

    private static boolean checkCompareFormulaClause(String formula, String lf, String op, String rv) throws CheckIfClauseException {
        if (lf.equals(orgTree)) {
            if (op.equals(">") || op.equals(">=") || op.equals("<") || op.equals("<=")) {
                throw new CheckIfClauseException(CheckIfClauseException.OPERATOR_ERROR, new Object[]{formula, lf, op});
            }
            if (!CheckFormulaIfClauseUtil.isString(rv)) {
                throw new CheckIfClauseException(CheckIfClauseException.VALUE_SHOWBE_STRING, new Object[]{formula});
            }
        } else if (lf.equals(company)) {
            if (op.equals(">") || op.equals(">=") || op.equals("<") || op.equals("<=")) {
                throw new CheckIfClauseException(CheckIfClauseException.OPERATOR_ERROR, new Object[]{formula, lf, op});
            }
            if (!CheckFormulaIfClauseUtil.isString(rv)) {
                throw new CheckIfClauseException(CheckIfClauseException.VALUE_SHOWBE_STRING, new Object[]{formula});
            }
        } else if (lf.equals(unit)) {
            if (op.equals(">") || op.equals(">=") || op.equals("<") || op.equals("<=")) {
                throw new CheckIfClauseException(CheckIfClauseException.OPERATOR_ERROR, new Object[]{formula, lf, op});
            }
            if (!CheckFormulaIfClauseUtil.isString(rv)) {
                throw new CheckIfClauseException(CheckIfClauseException.VALUE_SHOWBE_STRING, new Object[]{formula});
            }
        } else if (lf.equals(sourceCurrency)) {
            if (op.equals(">") || op.equals(">=") || op.equals("<") || op.equals("<=")) {
                throw new CheckIfClauseException(CheckIfClauseException.OPERATOR_ERROR, new Object[]{formula, lf, op});
            }
            if (!CheckFormulaIfClauseUtil.isString(rv)) {
                throw new CheckIfClauseException(CheckIfClauseException.VALUE_SHOWBE_STRING, new Object[]{formula});
            }
        } else if (lf.equals(currency)) {
            if (op.equals(">") || op.equals(">=") || op.equals("<") || op.equals("<=")) {
                throw new CheckIfClauseException(CheckIfClauseException.OPERATOR_ERROR, new Object[]{formula, lf, op});
            }
            if (!CheckFormulaIfClauseUtil.isString(rv)) {
                throw new CheckIfClauseException(CheckIfClauseException.VALUE_SHOWBE_STRING, new Object[]{formula});
            }
        } else if (lf.equals(sourceType)) {
            if (op.equals(">") || op.equals(">=") || op.equals("<") || op.equals("<=")) {
                throw new CheckIfClauseException(CheckIfClauseException.OPERATOR_ERROR, new Object[]{formula, lf, op});
            }
            if (!CheckFormulaIfClauseUtil.isString(rv)) {
                throw new CheckIfClauseException(CheckIfClauseException.VALUE_SHOWBE_STRING, new Object[]{formula});
            }
        } else if (lf.equals(year)) {
            if (op.equals(like) || op.equals(llike) || op.equals(rlike)) {
                throw new CheckIfClauseException(CheckIfClauseException.OPERATOR_ERROR, new Object[]{formula, lf, op});
            }
            if (!CheckFormulaIfClauseUtil.isNumeric(rv)) {
                throw new CheckIfClauseException(CheckIfClauseException.VALUE_SHOWBE_NUMERIC, new Object[]{formula});
            }
        } else if (lf.equals(period)) {
            if (op.equals(like) || op.equals(llike) || op.equals(rlike)) {
                throw new CheckIfClauseException(CheckIfClauseException.OPERATOR_ERROR, new Object[]{formula, lf, op});
            }
            if (!CheckFormulaIfClauseUtil.isNumeric(rv)) {
                throw new CheckIfClauseException(CheckIfClauseException.VALUE_SHOWBE_NUMERIC, new Object[]{formula});
            }
        } else if (lf.equals("0")) {
            if (op.equals(like) || op.equals(llike) || op.equals(rlike)) {
                throw new CheckIfClauseException(CheckIfClauseException.OPERATOR_ERROR2, new Object[]{op});
            }
            if (!CheckFormulaIfClauseUtil.isNumeric(rv)) {
                throw new CheckIfClauseException(CheckIfClauseException.VALUE_SHOWBE_NUMERIC2);
            }
        } else if (lf.equals("1")) {
            if (op.equals(">") || op.equals(">=") || op.equals("<") || op.equals("<=")) {
                throw new CheckIfClauseException(CheckIfClauseException.OPERATOR_ERROR2, new Object[]{op});
            }
            if (!CheckFormulaIfClauseUtil.isString(rv)) {
                throw new CheckIfClauseException(CheckIfClauseException.VALUE_SHOWBE_NUMERIC2);
            }
        } else if (!lf.equals("2")) {
            throw new CheckIfClauseException(CheckIfClauseException.INVALID_PARAM, new Object[]{lf});
        }
        return true;
    }

    private static boolean isNumeric(String rv) {
        try {
            new BigDecimal(rv);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isString(String rv) {
        int amount = 0;
        if (rv.startsWith("\"") && rv.endsWith("\"")) {
            for (int i = 0; i < rv.length(); ++i) {
                if (rv.charAt(i) != '\"') continue;
                ++amount;
            }
            return amount <= 2;
        }
        return false;
    }

    private static String replaceItemFormula(String formula) throws EASBizException {
        String f;
        String formulaTemp = "";
        String pattern = "AcctItem\\([^\\)]{1,}\\)";
        Pattern patt = Pattern.compile(pattern, 2);
        Matcher m = patt.matcher(formula);
        HashMap<String, String> itemFormulas = new HashMap<String, String>();
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 14) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"AcctItem"});
            }
            itemFormulas.put(f, "0");
        }
        pattern = "HisRateData\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        itemFormulas = new HashMap();
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 7) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"HisRateData"});
            }
            itemFormulas.put(f, "0");
        }
        pattern = "AdjustData\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 15) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"AdjustData"});
            }
            itemFormulas.put(f, "0");
        }
        pattern = "DyItem\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 13) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"DyItem"});
            }
            itemFormulas.put(f, "0");
        }
        pattern = "ElimData\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 14) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"ElimData"});
            }
            itemFormulas.put(f, "0");
        }
        pattern = "Acct\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 8) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"Acct"});
            }
            itemFormulas.put(f, "0");
        }
        pattern = "AcctAC\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 9) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"AcctAC"});
            }
            itemFormulas.put(f, "0");
        }
        pattern = "AcctCash\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 7) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"AcctCash"});
            }
            itemFormulas.put(f, "0");
        }
        pattern = "AcctExt\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 8) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"AcctExt"});
            }
            itemFormulas.put(f, "0");
        }
        pattern = "Cash\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 7) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"Cash"});
            }
            itemFormulas.put(f, "0");
        }
        pattern = "BasicCurrency\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 1) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"BasicCurrency"});
            }
            itemFormulas.put(f, "1");
        }
        pattern = "CsRef\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 8 && f.split("\\,").length != 10) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"CsRef"});
            }
            itemFormulas.put(f, "2");
        }
        pattern = "Dholding\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 3) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"Dholding"});
            }
            itemFormulas.put(f, "0");
        }
        pattern = "ExchangeRate\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 3) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"ExchangeRate"});
            }
            itemFormulas.put(f, "0");
        }
        pattern = "GetCurrency\\([^\\)]*\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.indexOf("\\,") > 0) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"GetCurrency"});
            }
            itemFormulas.put(f, "2");
        }
        pattern = "GetOrgEName\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.indexOf("\\,") > 0) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"GetOrgEName"});
            }
            itemFormulas.put(f, "1");
        }
        pattern = "GetOrgName\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.indexOf("\\,") > 0) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"GetOrgName"});
            }
            itemFormulas.put(f, "2");
        }
        pattern = "GetOrgTree\\([^\\)]*\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.indexOf("\\,") > 0) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"GetOrgTree"});
            }
            itemFormulas.put(f, "2");
        }
        pattern = "KeyWord\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.indexOf("\\,") > 0) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"KeyWord"});
            }
            itemFormulas.put(f, "2");
        }
        pattern = "Ref\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 4) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"Ref"});
            }
            itemFormulas.put(f, "2");
        }
        pattern = "Refm\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 8) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"Refm"});
            }
            itemFormulas.put(f, "2");
        }
        pattern = "RefDM\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.split("\\,").length != 9) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"RefDM"});
            }
            itemFormulas.put(f, "2");
        }
        pattern = "RptDate\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.indexOf("\\,") > 0) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"RptDate"});
            }
            itemFormulas.put(f, "2");
        }
        pattern = "RptName\\([^\\)]*\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.indexOf("\\,") > 0) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"RptName"});
            }
            itemFormulas.put(f, "2");
        }
        pattern = "StdCur\\([^\\)]{1,}\\)";
        patt = Pattern.compile(pattern, 2);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            if (f.indexOf("\\,") > 0) {
                throw new CheckIfClauseException(CheckIfClauseException.ITEMFORMULA_PARAM_ERROR, new Object[]{"StdCur"});
            }
            itemFormulas.put(f, "1");
        }
        if (!itemFormulas.isEmpty()) {
            for (String key : itemFormulas.keySet()) {
                String value = (String)itemFormulas.get(key);
                key = key.replaceAll("\\(", "\\\\(");
                key = key.replaceAll("\\)", "\\\\)");
                key = key.replaceAll("\\|", "\\\\|");
                if (!formulaTemp.equals("")) {
                    formula = formulaTemp.replaceAll(key, value);
                    continue;
                }
                formula = formula.replaceAll(key, value);
            }
        }
        return formula;
    }

    public static boolean computeIfClause(Context ctx, String formula, ParameterContext parameterContext) {
        block11: {
            ICalculateContextProvider calculateContextProvider = (ICalculateContextProvider)parameterContext.getAttribute("calculateContextProvider");
            formula = CheckFormulaIfClauseUtil.replaceParam(ctx, formula, parameterContext);
            Pattern patt = Pattern.compile(" and ", 2);
            Matcher m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\*\\(");
            patt = Pattern.compile("\\)and ", 2);
            m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\)\\*\\(");
            patt = Pattern.compile(" and\\(", 2);
            m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\*\\(\\(");
            patt = Pattern.compile(" or ", 2);
            m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\+\\(");
            patt = Pattern.compile("\\)or ", 2);
            m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\)\\+\\(");
            patt = Pattern.compile(" or\\(", 2);
            m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\+\\(\\(");
            formula = "(" + formula + ")";
            FormulaRuntimeFactory.FormulaRuntimeEnv formulaRuntimeEnv = null;
            try {
                formulaRuntimeEnv = FormulaRuntimeFactory.getInstance().getFormulaRuntime(calculateContextProvider);
            }
            catch (Exception e1) {
                logger.error((Object)e1);
                return false;
            }
            Book calculateBook = formulaRuntimeEnv.getCalculateBook();
            Sheet calculateSheet = formulaRuntimeEnv.getCalculateSheet();
            calculateBook.setCalculate(false);
            Range rg = calculateSheet.getRange(0, 0);
            rg.setFormula("=" + formula);
            calculateBook.calc();
            Variant obj = rg.getValue();
            if (obj != null) {
                if (obj.getVt() == 8) {
                    try {
                        if (obj.booleanValue()) {
                            return true;
                        }
                        break block11;
                    }
                    catch (SyntaxErrorException e) {
                        return false;
                    }
                }
                if (obj.isNumeric()) {
                    try {
                        if (obj.toBigDecimal().compareTo(new BigDecimal(0)) > 0) {
                            return true;
                        }
                    }
                    catch (SyntaxErrorException e) {
                        return false;
                    }
                }
            }
        }
        return false;
    }

    private static String replaceParam(Context ctx, String formula, ParameterContext parameterContext) {
        Locale locale = ctx.getLocale();
        CslReportInfo rptInfo = (CslReportInfo)parameterContext.getAttribute("cslReportInfo");
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)parameterContext.getAttribute("orgTreeInfo");
        String orgUnitNumber = parameterContext.getAttribute("orgUnitNumber").toString();
        String orgTree = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"CombBound", (Locale)locale);
        Pattern pattern = Pattern.compile(orgTree);
        Matcher matcher = pattern.matcher(formula);
        String orgTreeNumber = "\"" + orgTreeInfo.getNumber() + "\"";
        formula = matcher.replaceAll(orgTreeNumber);
        String company = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Company", (Locale)locale);
        pattern = Pattern.compile(company);
        matcher = pattern.matcher(formula);
        String companyNumber = "\"" + rptInfo.getOrgUnit().getNumber() + "\"";
        formula = matcher.replaceAll(companyNumber);
        String unit = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"77MnsRptGuideUnit", (Locale)locale);
        pattern = Pattern.compile(unit);
        matcher = pattern.matcher(formula);
        String unitNumber = "\"" + orgUnitNumber + "\"";
        formula = matcher.replaceAll(unitNumber);
        String sourceCurrency = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"OrigCurrency", (Locale)locale);
        pattern = Pattern.compile(sourceCurrency);
        matcher = pattern.matcher(formula);
        String scurrencyNumber = "\"" + rptInfo.getSourceCurrency().getNumber() + "\"";
        formula = matcher.replaceAll(scurrencyNumber);
        String currency = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"ConvCurrency", (Locale)locale);
        pattern = Pattern.compile(currency);
        matcher = pattern.matcher(formula);
        String currencyNumber = "\"" + rptInfo.getCurrency().getNumber() + "\"";
        formula = matcher.replaceAll(currencyNumber);
        String year = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Year", (Locale)locale);
        pattern = Pattern.compile(year);
        matcher = pattern.matcher(formula);
        String syear = String.valueOf(rptInfo.getYear());
        formula = matcher.replaceAll(syear);
        String period = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Period", (Locale)locale);
        pattern = Pattern.compile(period);
        matcher = pattern.matcher(formula);
        String speriod = String.valueOf(rptInfo.getPeriod());
        formula = matcher.replaceAll(speriod);
        String sourceType = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SourceType", (Locale)locale);
        pattern = Pattern.compile(sourceType);
        matcher = pattern.matcher(formula);
        RptSrcTypeEnum stype = rptInfo.getSourceType();
        if (stype.equals((Object)RptSrcTypeEnum.NORMAL) || stype.equals((Object)RptSrcTypeEnum.COMMITREPORT)) {
            String type = "\"" + RptSrcTypeEnum.NORMAL.getAlias(locale) + "\"";
            formula = matcher.replaceAll(type);
        } else {
            String type = "\"" + stype.getAlias(locale) + "\"";
            formula = matcher.replaceAll(type);
        }
        pattern = Pattern.compile(RptSrcTypeEnum.COMMITREPORT.getAlias(locale));
        matcher = pattern.matcher(formula);
        formula = matcher.replaceAll(RptSrcTypeEnum.NORMAL.getAlias(locale));
        formula = CheckFormulaIfClauseUtil.computeLike(ctx, formula);
        return formula;
    }

    public static boolean computeIfClause(Context ctx, String formula, Map param, IObjectValue vo) {
        block11: {
            formula = CheckFormulaIfClauseUtil.replaceParam(ctx, formula, param);
            Pattern patt = Pattern.compile(" and ", 2);
            Matcher m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\*\\(");
            patt = Pattern.compile("\\)and ", 2);
            m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\)\\*\\(");
            patt = Pattern.compile(" and\\(", 2);
            m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\*\\(\\(");
            patt = Pattern.compile(" or ", 2);
            m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\+\\(");
            patt = Pattern.compile("\\)or ", 2);
            m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\)\\+\\(");
            patt = Pattern.compile(" or\\(", 2);
            m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\+\\(\\(");
            formula = "(" + formula + ")";
            Book book = Book.Manager.getNewBook(null, (int)1);
            try {
                CheckFormulaIfClauseUtil.initFormulaRuntimeEnv(ctx, book, vo);
            }
            catch (Exception e1) {
                return false;
            }
            book.setCalculate(false);
            Sheet sheet = book.getSheet(0);
            Range rg = sheet.getRange(0, 0);
            rg.setFormula("=" + formula);
            book.calc();
            Variant obj = rg.getValue();
            if (obj != null) {
                if (obj.getVt() == 8) {
                    try {
                        if (obj.booleanValue()) {
                            return true;
                        }
                        break block11;
                    }
                    catch (SyntaxErrorException e) {
                        return false;
                    }
                }
                if (obj.isNumeric()) {
                    try {
                        if (obj.toBigDecimal().compareTo(new BigDecimal(0)) > 0) {
                            return true;
                        }
                    }
                    catch (SyntaxErrorException e) {
                        return false;
                    }
                }
            }
        }
        return false;
    }

    private static String replaceParam(Context ctx, String f, Map param) {
        Locale l = ctx.getLocale();
        String orgTree = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"CombBound", (Locale)l);
        Pattern patt = Pattern.compile(orgTree);
        Matcher m = patt.matcher(f);
        String orgTreeNumber = "\"" + (String)param.get("KeyOrgTree") + "\"";
        f = m.replaceAll(orgTreeNumber);
        String company = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Company", (Locale)l);
        patt = Pattern.compile(company);
        m = patt.matcher(f);
        String companyNumber = "\"" + (String)param.get("KEY_COMPANY") + "\"";
        f = m.replaceAll(companyNumber);
        String unit = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"77MnsRptGuideUnit", (Locale)l);
        patt = Pattern.compile(unit);
        m = patt.matcher(f);
        String unitNumber = "\"" + (String)param.get("KEY_COMPANY") + "\"";
        f = m.replaceAll(unitNumber);
        String sourceCurrency = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"OrigCurrency", (Locale)l);
        patt = Pattern.compile(sourceCurrency);
        m = patt.matcher(f);
        String scurrencyNumber = "\"" + (String)param.get("KEY_SOURCECURRENCY") + "\"";
        f = m.replaceAll(scurrencyNumber);
        String currency = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"ConvCurrency", (Locale)l);
        patt = Pattern.compile(currency);
        m = patt.matcher(f);
        String currencyNumber = "\"" + (String)param.get("KEY_CURRENCY") + "\"";
        f = m.replaceAll(currencyNumber);
        String year = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Year", (Locale)l);
        patt = Pattern.compile(year);
        m = patt.matcher(f);
        String syear = ((Integer)param.get("Year")).toString();
        f = m.replaceAll(syear);
        String period = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Period", (Locale)l);
        patt = Pattern.compile(period);
        m = patt.matcher(f);
        String speriod = ((Integer)param.get("Period")).toString();
        f = m.replaceAll(speriod);
        String sourceType = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SourceType", (Locale)l);
        patt = Pattern.compile(sourceType);
        m = patt.matcher(f);
        RptSrcTypeEnum stype = (RptSrcTypeEnum)param.get("KEY_SOURCETYPE");
        if (stype.equals((Object)RptSrcTypeEnum.NORMAL) || stype.equals((Object)RptSrcTypeEnum.COMMITREPORT)) {
            String type = "\"" + RptSrcTypeEnum.NORMAL.getAlias(l) + "\"";
            f = m.replaceAll(type);
        } else {
            String type = "\"" + stype.getAlias(l) + "\"";
            f = m.replaceAll(type);
        }
        patt = Pattern.compile(RptSrcTypeEnum.COMMITREPORT.getAlias(l));
        m = patt.matcher(f);
        f = m.replaceAll(RptSrcTypeEnum.NORMAL.getAlias(l));
        f = CheckFormulaIfClauseUtil.computeLike(ctx, f);
        return f;
    }

    private static String computeLike(Context ctx, String formula) {
        String rv;
        String lf;
        String[] strs;
        String f;
        Locale l = ctx.getLocale();
        String llike = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"LeftSimilarity", (Locale)l);
        String rlike = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"RightSimilarity", (Locale)l);
        String like = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Similarity", (Locale)l);
        HashMap<String, String> likeResult = new HashMap<String, String>();
        String pattern = "\\\"[^\\\"]{1,}\\\"\\s{1,}(" + llike + ")\\s{1,}\\\"[^\\\"]{1,}\\\"";
        Pattern patt = Pattern.compile(pattern);
        Matcher m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            strs = f.split(llike);
            lf = strs[0].trim().replaceAll("\\\"", "");
            if (lf.startsWith(rv = strs[1].trim().replaceAll("\\\"", ""))) {
                likeResult.put(f, "1");
                continue;
            }
            likeResult.put(f, "0");
        }
        pattern = "\\\"[^\\\"]{1,}\\\"\\s{1,}(" + rlike + ")\\s{1,}\\\"[^\\\"]{1,}\\\"";
        patt = Pattern.compile(pattern);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            strs = f.split(rlike);
            lf = strs[0].trim().replaceAll("\\\"", "");
            if (lf.endsWith(rv = strs[1].trim().replaceAll("\\\"", ""))) {
                likeResult.put(f, "1");
                continue;
            }
            likeResult.put(f, "0");
        }
        pattern = "\\\"[^\\\"]{1,}\\\"\\s{1,}(" + like + ")\\s{1,}\\\"[^\\\"]{1,}\\\"";
        patt = Pattern.compile(pattern);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            strs = f.split(like);
            lf = strs[0].trim().replaceAll("\\\"", "");
            if (lf.indexOf(rv = strs[1].trim().replaceAll("\\\"", "")) >= 0) {
                likeResult.put(f, "1");
                continue;
            }
            likeResult.put(f, "0");
        }
        for (String key : likeResult.keySet()) {
            String value = (String)likeResult.get(key);
            formula = formula.replaceAll(key, value);
        }
        return formula;
    }

    protected static void initFormulaRuntimeEnv(final Context ctx, Book book, final IObjectValue vo) throws Exception {
        FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)new ICalculateContextProvider(){

            public Context getServerContext() {
                return ctx;
            }

            public IReportPropertyAdapter getReportAdapter() {
                CSLPropertyAdapter propertyAdapter = null;
                propertyAdapter = vo instanceof CslReportInfo ? new CSLPropertyAdapter() : new RptReportPropertyAdapter();
                propertyAdapter.initReportProperties(vo, ctx);
                return propertyAdapter;
            }

            public ReportVariables getReportVariables() {
                return new ReportVariables();
            }

            public IErrorProvider getErrorProvider() {
                return null;
            }

            public IErrorResultProvider getErrorResultProvider() {
                return null;
            }
        });
    }
}

