/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsxReader;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ITempletDispense;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.cslrpt.util.PropertyItem;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;

public class DispensePropertyHelper {
    public static final String DISPENSE_RESOURCE = "com.kingdee.eas.fi.gr.cslrpt.RptSpecialResource";
    public static final String CSLRPTAutoGenerate_Resource = "com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource";
    public static final int NO_DATA = 0;
    public static final int NUMBER = 1;
    public static final int STRING = 2;
    HashMap map = new HashMap();

    public DispensePropertyHelper() {
        Color bc = Color.WHITE;
        int w = 50;
        int h = 12;
        Font f = new Font(DispensePropertyHelper.getString("Dispense_DefaultFont"), 0, 12);
        this.map.put("caption", new PropertyItem("caption", DispensePropertyHelper.getString("Dispense_Caption"), new Location(0, 0, 0), f, w, h, bc, null, null, 0, false, false, false));
        this.map.put("description", new PropertyItem("description", DispensePropertyHelper.getString("Dispense_Description"), new Location(0, 1, 0), f, w, h, bc, null, null, 0, false, false, false));
        this.map.put("reportCaption", new PropertyItem("reportCaption", DispensePropertyHelper.getString("Dispense_ReportArea_Caption"), new Location(0, 3, 1), f, w, h, bc, null, null, 0, false, false, false));
        this.map.put("reportDescription", new PropertyItem("reportDescription", DispensePropertyHelper.getString("Dispense_ReportArea_Description"), new Location(0, 4, 1), f, w, h, bc, null, null, 0, false, false, false));
        this.map.put("company", new PropertyItem("company", DispensePropertyHelper.getString("Dispense_ReportArea_Field_Company"), new Location(0, 6, 2), f, w, h, bc, null, "company", 2, true, false, false));
        this.map.put("year", new PropertyItem("year", DispensePropertyHelper.getString("Dispense_ReportArea_Field_Year"), new Location(0, 7, 2), f, w, h, bc, null, "year", 1, true, false, false));
        this.map.put("period", new PropertyItem("period", DispensePropertyHelper.getString("Dispense_ReportArea_Field_Period"), new Location(0, 8, 2), f, w, h, bc, null, "period", 1, true, false, false));
        this.map.put("currency", new PropertyItem("currency", DispensePropertyHelper.getString("Dispense_ReportArea_Field_Currency"), new Location(0, 9, 2), f, w, h, bc, null, "currency", 2, true, false, false));
        this.map.put("createTime", new PropertyItem("createTime", DispensePropertyHelper.getString("Dispense_ReportArea_Field_CreateTime"), new Location(0, 10, 2), f, w, h, bc, null, "lastUpdateTime", 2, true, false, false));
        this.map.put("templateCaption", new PropertyItem("templateCaption", DispensePropertyHelper.getString("Dispense_TemplateArea_Caption"), new Location(0, 3, 5), f, w, h, bc, null, null, 0, false, true, false));
        this.map.put("templateDescription", new PropertyItem("templateDescription", DispensePropertyHelper.getString("Dispense_TemplateArea_Description"), new Location(0, 4, 5), f, w, h, bc, null, null, 0, false, true, false));
        this.map.put("t_id", new PropertyItem("t_id", DispensePropertyHelper.getString("Dispense_TemplateArea_Field_ID"), new Location(0, 6, 6), f, w, h, bc, "id", null, 2, false, true, false));
        this.map.put("t_number", new PropertyItem("t_number", DispensePropertyHelper.getString("Dispense_TemplateArea_Field_Number"), new Location(0, 7, 6), f, w, h, bc, "number", null, 2, false, true, false));
        this.map.put("t_name", new PropertyItem("t_name", DispensePropertyHelper.getString("Dispense_TemplateArea_Field_Name"), new Location(0, 8, 6), f, w, h, bc, "name", null, 2, false, true, false));
        this.map.put("t_description", new PropertyItem("t_description", DispensePropertyHelper.getString("Dispense_TemplateArea_Field_Description"), new Location(0, 9, 6), f, w, h, bc, "description", null, 2, false, true, false));
        this.map.put("t_periodType", new PropertyItem("t_periodType", DispensePropertyHelper.getString("Dispense_TemplateArea_Field_PeriodType"), new Location(0, 10, 6), f, w, h, bc, "periodType", null, 2, false, true, false));
        this.map.put("t_versionNumber", new PropertyItem("t_versionNumber", DispensePropertyHelper.getString("Dispense_TemplateArea_Field_VersionNumber"), new Location(0, 11, 6), f, w, h, bc, "versionNumber", null, 2, false, true, false));
        this.map.put("t_company", new PropertyItem("t_company", DispensePropertyHelper.getString("Dispense_TemplateArea_Field_Company"), new Location(0, 12, 6), f, w, h, bc, "company", null, 2, false, true, false));
        this.map.put("t_lastUpdateTime", new PropertyItem("t_lastUpdateTime", DispensePropertyHelper.getString("Dispense_TemplateArea_Field_LastUpdateTime"), new Location(0, 13, 6), f, w, h, bc, "lastUpdateTime", null, 2, false, true, false));
        this.map.put("t_currency", new PropertyItem("t_currency", DispensePropertyHelper.getString("Dispense_TemplateArea_Field_Currency"), new Location(0, 14, 6), f, w, h, bc, "currency", null, 2, false, true, false));
        this.map.put("tips", new PropertyItem("tips", DispensePropertyHelper.getString("configTableTips"), new Location(0, 16, 0), f, w, h, bc, null, null, 0, false, false, true));
    }

    private Location getDimension() {
        Iterator iterator = this.map.keySet().iterator();
        int[] rows = new int[this.map.size()];
        int[] cols = new int[this.map.size()];
        int i = 0;
        while (iterator.hasNext()) {
            PropertyItem item = (PropertyItem)this.map.get(iterator.next());
            rows[i] = item.getLocation().getRowIndex();
            cols[i] = item.getLocation().getColIndex();
            ++i;
        }
        Arrays.sort(rows);
        Arrays.sort(cols);
        return new Location(0, rows[rows.length - 1], cols[cols.length - 1]);
    }

    public String _output(InputStream stream, CslReportInfo cslReport, Context ctx) throws Exception {
        return this._outputByFileType(null, stream, cslReport, ctx);
    }

    public String _outputByFileType(String fileType, InputStream stream, CslReportInfo cslReport, Context ctx) throws Exception {
        Object createdate;
        block92: {
            KDSBook book = null;
            try {
                if (fileType == null || ".xls".equals(fileType)) {
                    book = POIXlsReader.parse((InputStream)stream);
                } else if (".xlsx".equals(fileType)) {
                    book = POIXlsxReader.parse((InputStream)stream);
                }
                stream.close();
            }
            catch (Exception e) {
                return EASResource.getString((String)CSLRPTAutoGenerate_Resource, (String)"763_DispensePropertyHelper");
            }
            if (book == null) {
                return DispensePropertyHelper.getString("Dispense_Import_Error_CreateKDF");
            }
            KDSSheet sheetParam = book.getSheet((Object)"Config Table");
            if (sheetParam == null) {
                return DispensePropertyHelper.getString("Dispense_Import_Error_NoParamSheet");
            }
            Object vPK = this.getData(sheetParam, (PropertyItem)this.map.get("t_id"));
            ObjectUuidPK pk = null;
            try {
                pk = new ObjectUuidPK((String)vPK);
            }
            catch (IllegalArgumentException e) {
                return DispensePropertyHelper.getString("Dispense002");
            }
            TemplateInfo template = null;
            try {
                TemplateInfo templateInfo = template = ctx == null ? TemplateFactory.getRemoteInstance().getTemplateInfo((IObjectPK)pk, this.getSelectors()) : TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo((IObjectPK)pk, this.getSelectors());
                if (template == null) {
                    return MessageFormat.format(DispensePropertyHelper.getString("Dispense003", ctx), vPK);
                }
            }
            catch (Exception e) {
                return MessageFormat.format(DispensePropertyHelper.getString("Dispense003", ctx), vPK);
            }
            Book templateBook = template.getBook();
            String tableName = null;
            KDSSheet sheetTemp = null;
            RptSheetParamCollection paramTemplate = template.getSheetParam();
            int size = templateBook.getSheetCount();
            int sizeParam = paramTemplate.size();
            if (size != sizeParam) {
                return DispensePropertyHelper.getString("Dispense009", ctx);
            }
            for (int i = 0; i < size; ++i) {
                tableName = templateBook.getSheet(i).getSheetName();
                sheetTemp = book.getSheet((Object)tableName);
                if (sheetTemp != null) continue;
                String str = DispensePropertyHelper.getString("Dispense010", ctx);
                return MessageFormat.format(str, tableName);
            }
            boolean isDynDynTemplate = false;
            boolean isDynTemplate = false;
            if (template.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT) && template.getDynaRptType().equals((Object)DynaEnumRptTypeEnum.DYNAMIC)) {
                isDynDynTemplate = true;
            }
            if (template.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT)) {
                isDynTemplate = true;
            }
            UserInfo user = null;
            if (ctx == null) {
                user = SysContext.getSysContext().getCurrentUserInfo();
            } else {
                user = new UserInfo();
                user.setId((BOSUuid)ctx.get((Object)"userID"));
            }
            createdate = this.getData(sheetParam, (PropertyItem)this.map.get("createTime"));
            String vOrgUnit = ((String)this.getData(sheetParam, (PropertyItem)this.map.get("company"))).trim();
            FullOrgUnitInfo orgUnit = null;
            try {
                orgUnit = ctx == null ? FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo("select id, name, number where number = '" + vOrgUnit + "'") : FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo("select id, name, number where number = '" + vOrgUnit + "'");
            }
            catch (Exception e) {
                return DispensePropertyHelper.getString("Dispense004");
            }
            CompanyOrgUnitInfo company = null;
            try {
                company = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select id, name, number where number = '" + vOrgUnit + "'") : CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id, name, number where number = '" + vOrgUnit + "'");
            }
            catch (Exception e) {
                return DispensePropertyHelper.getString("Dispense004");
            }
            Object vCurrency = this.getData(sheetParam, (PropertyItem)this.map.get("currency"));
            CurrencyInfo currency = null;
            CurrencyCollection currencyCollection = null;
            try {
                CurrencyCollection currencyCollection2 = currencyCollection = ctx == null ? CurrencyFactory.getRemoteInstance().getCurrencyCollection("select id, name where number = '" + vCurrency + "'") : CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("select id, name where number = '" + vCurrency + "'");
                if (currencyCollection.size() != 1) {
                    return DispensePropertyHelper.getString("Dispense005");
                }
                currency = currencyCollection.get(0);
            }
            catch (Exception e) {
                return DispensePropertyHelper.getString("Dispense005");
            }
            Object vYear = this.getData(sheetParam, (PropertyItem)this.map.get("year"));
            int year = -1;
            try {
                year = Integer.parseInt((String)vYear);
            }
            catch (RuntimeException e) {
                return DispensePropertyHelper.getString("Dispense006");
            }
            Object vPeriod = this.getData(sheetParam, (PropertyItem)this.map.get("period"));
            short period = -1;
            try {
                period = Short.parseShort((String)vPeriod);
            }
            catch (RuntimeException e) {
                return DispensePropertyHelper.getString("Dispense007");
            }
            switch (template.getPeriodType().getValue()) {
                case 1: {
                    if (period >= 1 && period <= 366) break;
                    return DispensePropertyHelper.getString("Dispense012");
                }
                case 3: {
                    if (period >= 1 && period <= 13) break;
                    return DispensePropertyHelper.getString("Dispense012");
                }
                case 4: {
                    if (period >= 1 && period <= 4) break;
                    return DispensePropertyHelper.getString("Dispense012");
                }
                case 5: {
                    if (period >= 1 && period <= 2) break;
                    return DispensePropertyHelper.getString("Dispense012");
                }
                case 2: {
                    if (period >= 1 && period <= 52) break;
                    return DispensePropertyHelper.getString("Dispense012");
                }
                case 6: {
                    if (period >= 1 && period <= 1) break;
                    return DispensePropertyHelper.getString("Dispense012");
                }
            }
            CtrlUnitInfo cu = null;
            try {
                cu = ctx == null ? CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4")) : CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"));
            }
            catch (EASBizException e1) {
                throw e1;
            }
            catch (BOSException e1) {
                throw e1;
            }
            ITempletDispense ie = ctx == null ? TempletDispenseFactory.getRemoteInstance() : TempletDispenseFactory.getLocalInstance(ctx);
            String rptId = ie.getReportByTmpVersion(null, orgUnit.getId().toString(), currency.getId().toString(), template.getId().toString(), 7, template.getPeriodType().getValue(), year, period, null, "ACTUALDATA");
            if (rptId != null) {
                return DispensePropertyHelper.getString("Dispense008");
            }
            Book book2 = null;
            RptSheetParamCollection paramCollection = new RptSheetParamCollection();
            int rowCount = 0;
            int colCount = 0;
            boolean rowDiff = false;
            boolean colDiff = false;
            boolean isCommonPage = true;
            HashMap basePoint = null;
            int rowBase = 0;
            int colBase = 0;
            Object value = null;
            String companyNameNumber = null;
            int leftBracket = -1;
            int rightBracket = -1;
            int bracket = -1;
            String companyName = null;
            String companyNumber = null;
            ItemFormula formula = null;
            IFullOrgUnit iou = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx);
            FullOrgUnitInfo ou = null;
            StringBuffer errorLog = new StringBuffer();
            boolean hasError = false;
            errorLog.append(company.getName() + "." + template.getName() + "." + currency.getName() + " ");
            book2 = KDSBookToBook.traslate((KDSBook)book);
            Sheet sheetExcel = null;
            Sheet sheetTemplate = null;
            Cell cell = null;
            Cell cellTmp = null;
            Variant cellF = null;
            book2.setCalculate(false);
            for (int sheetIndex = 0; sheetIndex < book2.getSheetCount(); ++sheetIndex) {
                sheetExcel = book2.getSheet(sheetIndex);
                tableName = sheetExcel.getSheetName();
                sheetTemplate = templateBook.getSheet(tableName);
                if ("Config Table".equalsIgnoreCase(tableName)) continue;
                Sheet.ICellsIterator cellsIterator = sheetExcel.getCellsIterator(null, false, true);
                while (cellsIterator.hasNext()) {
                    cell = cellsIterator.next();
                    if (!cell.hasFormula()) continue;
                    cellF = cell.getValue();
                    cell.setFormula(cellF != null ? cellF.toString() : "");
                    cell.setValue(cellF);
                }
                if (sheetTemplate == null) continue;
                cellsIterator = sheetTemplate.getCellsIterator(null, false, true);
                while (cellsIterator.hasNext()) {
                    cell = cellsIterator.next();
                    if (!cell.hasFormula()) continue;
                    cellTmp = sheetExcel.getCell(cell.getRow(), cell.getCol(), true);
                    cellF = cellTmp.getValue();
                    cellTmp.setFormula(cell.getFormula());
                    cellTmp.setValue(cellF);
                }
            }
            book2.removeSheet("Config Table");
            book = null;
            for (int i = 0; i < templateBook.getSheetCount(); ++i) {
                Sheet tempSheet = templateBook.getSheet(i);
                Sheet newSheet = book2.getSheet(tempSheet.getSheetName());
                newSheet.setID(tempSheet.getID());
                if (tempSheet.getUserObjects() == null) continue;
                for (int j = 0; j < tempSheet.getUserObjects().size(); ++j) {
                    newSheet.setUserObject(tempSheet.getUserObjects().getUserObject(j).getKey(), tempSheet.getUserObjects().getUserObject(j).getValue());
                }
            }
            if (templateBook.getUserObjects() != null) {
                for (int j = 0; j < templateBook.getUserObjects().size(); ++j) {
                    book2.setUserObject(templateBook.getUserObjects().getUserObject(j).getKey(), templateBook.getUserObjects().getUserObject(j).getValue());
                }
            }
            book2.activeSheet(0);
            for (int i = 0; i < book2.getSheetCount(); ++i) {
                Cell cell2;
                Sheet sheet2 = book2.getSheet(i);
                tableName = sheet2.getSheetName();
                Sheet sheet3 = templateBook.getSheet(tableName);
                if (sheet3 == null) continue;
                ArrayList<Cell> basePointList = new ArrayList<Cell>();
                rowCount = sheet2.getMaxRowIndex() + 1;
                colCount = sheet2.getMaxColIndex() + 1;
                if (isDynDynTemplate) {
                    for (int row = 0; row < rowCount; ++row) {
                        for (int col = 0; col < colCount; ++col) {
                            Variant v;
                            cell2 = sheet2.getCell(row, col, false);
                            if (cell2 == null || (v = cell2.getValue()) == null || v.toString().trim().indexOf(EASResource.getString((String)CSLRPTAutoGenerate_Resource, (String)"755_DispensePropertyHelper")) < 0) continue;
                            basePointList.add(sheet2.getCell(row, col, true));
                        }
                    }
                }
                if (!isDynDynTemplate) {
                    for (int colindex = 0; colindex <= sheet3.getMaxColIndex(); ++colindex) {
                        for (int rowIndex = 0; rowIndex <= sheet3.getMaxRowIndex(); ++rowIndex) {
                            ItemFormula dItem;
                            cell2 = sheet3.getCell(rowIndex, colindex, false);
                            if (cell2 == null || (dItem = (ItemFormula)sheet3.getRange(rowIndex, colindex).getUserObject("ITEM")) == null) continue;
                            sheet2.getRange(rowIndex, colindex).setUserObject("ITEM", (Object)dItem);
                        }
                    }
                }
                if (isDynDynTemplate) {
                    Sheet templateSheet = templateBook.getSheet(tableName);
                    ArrayList list = DynamicTemplateUtility.getBasePointList((Sheet)templateSheet);
                    if (list.size() != basePointList.size()) {
                        hasError = true;
                        String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"125_DispensePropertyHelper");
                        errorLog.append("\r\n").append(MessageFormat.format(msg, templateSheet.getSheetName()));
                    }
                    for (int k = 0; k < basePointList.size(); ++k) {
                        ItemFormula cldItem;
                        String vtNumber;
                        ValueTypeEnum vt;
                        StringBuffer sf;
                        int f;
                        String itemNumber;
                        Variant v;
                        boolean isError;
                        Cell cell22;
                        Cell cell1;
                        ArrayList<ItemFormula> headFormula;
                        String msg;
                        int basePointY;
                        int basePointX;
                        int tagertY;
                        int tagertX;
                        Cell cell3 = (Cell)basePointList.get(k);
                        String basePointXY = "(" + TableToolkit.xy2range((int)cell3.getCol(), (int)cell3.getRow()) + ")";
                        try {
                            StringTokenizer tok = new StringTokenizer(cell3.getValue().toString(), "$#");
                            String[] basePointInfo = new String[5];
                            for (int h = 0; h < 5; ++h) {
                                basePointInfo[h] = tok.nextToken();
                            }
                            String svalue = basePointInfo[0].trim();
                            if (svalue.indexOf("[") == 0 && svalue.indexOf("]") == svalue.length() - 1) {
                                if (svalue.length() == 2) {
                                    cell3.setValue(new Variant(Variant.nullVariant));
                                } else {
                                    cell3.setValue(new Variant((Object)svalue.substring(1, svalue.length() - 1)));
                                }
                            } else {
                                throw new Exception();
                            }
                            tagertX = cell3.getRow();
                            tagertY = cell3.getCol();
                            basePointX = Integer.parseInt(basePointInfo[2]);
                            basePointY = Integer.parseInt(basePointInfo[3]);
                        }
                        catch (Throwable a) {
                            hasError = true;
                            msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"123_DispensePropertyHelper");
                            errorLog.append("\r\n").append(MessageFormat.format(msg, templateSheet.getSheetName(), basePointXY));
                            continue;
                        }
                        ItemFormula dItem = (ItemFormula)templateSheet.getRange(basePointX, basePointY).getUserObject("ITEM");
                        if (dItem == null || !dItem.isBasePoint()) {
                            hasError = true;
                            msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"124_DispensePropertyHelper");
                            errorLog.append("\r\n").append(MessageFormat.format(msg, templateSheet.getSheetName(), basePointXY));
                            continue;
                        }
                        DynaParameters paramer = DynamicTemplateUtility.getDynaParametersFromCell((Sheet)templateSheet, (int)basePointX, (int)basePointY);
                        int counter = paramer.getDefaultCounter();
                        if (paramer.getSpreadStyle() == 1) {
                            headFormula = new ArrayList<ItemFormula>();
                            int headRowIndex = 0;
                            dItem = (ItemFormula)templateSheet.getRange(basePointX, basePointY).getUserObject("ITEM");
                            cell1 = templateSheet.getCell(basePointX, basePointY, false);
                            cell22 = null;
                            isError = false;
                            do {
                                if (headRowIndex != 0) {
                                    headFormula.add(dItem);
                                }
                                sheet2.getCell(tagertX + headRowIndex, tagertY, true).setUserObject("ITEM", (Object)dItem);
                                cell22 = sheet2.getCell(tagertX + headRowIndex, tagertY, true);
                                if (headRowIndex != 0 && !this.compHeadCell(cell1, cell22)) {
                                    String errorPointXY = "(" + TableToolkit.xy2range((int)cell22.getCol(), (int)cell22.getRow()) + ")";
                                    isError = true;
                                    hasError = true;
                                    String msg2 = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"122_DispensePropertyHelper");
                                    errorLog.append("\r\n").append(MessageFormat.format(msg2, templateSheet.getSheetName(), basePointXY, errorPointXY));
                                    break;
                                }
                                if (cell1 == null || cell22 != null) {
                                    // empty if block
                                }
                                dItem = (ItemFormula)templateSheet.getRange(basePointX + ++headRowIndex, basePointY).getUserObject("ITEM");
                                cell1 = templateSheet.getCell(basePointX + headRowIndex, basePointY, true);
                            } while (dItem != null);
                            if (isError) continue;
                            int forTimes = counter + tagertY + 1;
                            for (int colIndex = tagertY + 1; colIndex < forTimes && !this.hasBasePointMark(sheet2, tagertX, colIndex) && !this.hasItemFomula(sheet2, tagertX, colIndex); ++colIndex) {
                                v = sheet2.getCell(tagertX, colIndex, true).getValue();
                                if (v == null || v.toString().trim().length() == 0 || v.toString().trim().equalsIgnoreCase("SUM") || v.toString().trim().equalsIgnoreCase(EASResource.getString((String)CSLRPTAutoGenerate_Resource, (String)"316_AfterElimReportUI")) || v.toString().trim().equalsIgnoreCase("??")) continue;
                                itemNumber = v.toString().trim();
                                itemNumber = itemNumber.replaceAll("\\\"", "\\\\\"");
                                for (f = 0; f < headFormula.size(); ++f) {
                                    dItem = (ItemFormula)headFormula.get(f);
                                    sf = new StringBuffer();
                                    vt = ValueTypeEnum.getEnum(dItem.getValueType());
                                    vtNumber = null;
                                    if (vt != null) {
                                        vtNumber = vt.getName();
                                    }
                                    sf.append("=DItem(\"").append(dItem.getItemNumber()).append("\",\"").append(itemNumber).append("\",").append(dItem.getYearOffSet()).append(",").append(dItem.getPeriodOffSet()).append(",\"").append(dItem.getDataElementNumber()).append("\",\"").append(vtNumber).append("\")");
                                    cldItem = new ItemFormula(sf.toString());
                                    cldItem.setDItemNumber(itemNumber);
                                    sheet2.getRange(tagertX + f + 1, colIndex).setUserObject("ITEM", (Object)cldItem);
                                }
                            }
                            continue;
                        }
                        headFormula = new ArrayList();
                        int headColIndex = 0;
                        dItem = (ItemFormula)templateSheet.getRange(basePointX, basePointY).getUserObject("ITEM");
                        cell1 = templateSheet.getCell(basePointX, basePointY, false);
                        cell22 = null;
                        isError = false;
                        do {
                            if (headColIndex != 0) {
                                headFormula.add(dItem);
                            }
                            sheet2.getCell(tagertX, tagertY + headColIndex, true).setUserObject("ITEM", (Object)dItem);
                            cell22 = sheet2.getCell(tagertX, tagertY + headColIndex, true);
                            if (headColIndex != 0 && !this.compHeadCell(cell1, cell22)) {
                                String errorPointXY = "(" + TableToolkit.xy2range((int)cell22.getCol(), (int)cell22.getRow()) + ")";
                                isError = true;
                                hasError = true;
                                String msg3 = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"122_DispensePropertyHelper");
                                errorLog.append("\r\n").append(MessageFormat.format(msg3, templateSheet.getSheetName(), basePointXY, errorPointXY));
                                break;
                            }
                            if (cell1 == null || cell22 != null) {
                                // empty if block
                            }
                            dItem = (ItemFormula)templateSheet.getRange(basePointX, basePointY + ++headColIndex).getUserObject("ITEM");
                            cell1 = templateSheet.getCell(basePointX, basePointY + headColIndex, true);
                        } while (dItem != null);
                        if (isError) continue;
                        int forTimes = counter + tagertX + 1;
                        for (int rowIndex = tagertX + 1; rowIndex < forTimes && !this.hasBasePointMark(sheet2, rowIndex, tagertY) && !this.hasItemFomula(sheet2, rowIndex, tagertY); ++rowIndex) {
                            v = sheet2.getCell(rowIndex, tagertY, true).getValue();
                            if (v == null || v.toString().trim().length() == 0 || v.toString().trim().equalsIgnoreCase("SUM") || v.toString().trim().equalsIgnoreCase(EASResource.getString((String)CSLRPTAutoGenerate_Resource, (String)"316_AfterElimReportUI")) || v.toString().trim().equalsIgnoreCase("??")) continue;
                            itemNumber = v.toString().trim();
                            itemNumber = itemNumber.replaceAll("\\\"", "\\\\\"");
                            for (f = 0; f < headFormula.size(); ++f) {
                                dItem = (ItemFormula)headFormula.get(f);
                                sf = new StringBuffer();
                                vt = ValueTypeEnum.getEnum(dItem.getValueType());
                                vtNumber = null;
                                if (vt != null) {
                                    vtNumber = vt.getName();
                                }
                                sf.append("=DItem(\"").append(dItem.getItemNumber()).append("\",\"").append(itemNumber).append("\",").append(dItem.getYearOffSet()).append(",").append(dItem.getPeriodOffSet()).append(",\"").append(dItem.getDataElementNumber()).append("\",\"").append(vtNumber).append("\")");
                                cldItem = new ItemFormula(sf.toString());
                                cldItem.setDItemNumber(itemNumber);
                                sheet2.getRange(rowIndex, tagertY + f + 1).setUserObject("ITEM", (Object)cldItem);
                            }
                        }
                    }
                }
                for (int k = 0; k < paramTemplate.size(); ++k) {
                    String tmpSheetName = paramTemplate.get(k).getSheetName();
                    if (!tmpSheetName.equals(tableName)) continue;
                    isCommonPage = CSLReportGroupEnum.COMMON.equals((Object)paramTemplate.get(k).getReportClass());
                }
                if (isCommonPage || (basePoint = CslRptUtil.getBasePosition(sheet2)) == null || !basePoint.containsKey("left") || !basePoint.containsKey("top")) continue;
                rowBase = (Integer)basePoint.get("top");
                colBase = (Integer)basePoint.get("left");
                if (rowBase < 0 || rowBase >= rowCount || colBase < 0 || colBase >= colCount) continue;
                for (int row = rowBase + 1; row < rowCount; ++row) {
                    Range range = sheet2.getRange(row, colBase);
                    Variant var = range.getValue();
                    Object object = value = var.isEmpty() ? null : var.getValue();
                    if (value == null || !(value instanceof String) || (companyNameNumber = (String)value) == null || companyNameNumber.length() == 0 || (companyNameNumber = companyNameNumber.trim()).trim().length() == 0) continue;
                    bracket = companyNameNumber.indexOf("-");
                    if (bracket > 0) {
                        companyNumber = companyNameNumber.substring(0, bracket);
                        companyName = companyNameNumber.substring(bracket + 1, companyNameNumber.length() - 1);
                        if (companyNumber.equals(company.getNumber())) continue;
                        try {
                            ou = iou.getFullOrgUnitInfo("select id where number = '" + companyNumber + "'");
                        }
                        catch (Exception e) {
                            String str = DispensePropertyHelper.getString("Dispense011", ctx);
                            return MessageFormat.format(str, companyName);
                        }
                        if (ou == null) continue;
                        formula = new ItemFormula();
                        formula.putExt("16", ou.getId().toString());
                        range.setUserObject("ITEM", (Object)formula);
                        continue;
                    }
                    String str = DispensePropertyHelper.getString("Dispense_CompanyNameFormat_Error", ctx);
                    return str;
                }
            }
            if (hasError) {
                return errorLog.toString();
            }
            RptSheetParamInfo paramInfo = null;
            int n = paramTemplate.size();
            for (int i = 0; i < n; ++i) {
                paramInfo = paramTemplate.get(i);
                paramCollection.add(paramInfo);
            }
            cslReport.setOrgUnit((OrgUnitInfo)orgUnit);
            cslReport.setCompany(company);
            cslReport.setSourceCurrency(currency);
            cslReport.setReportDate(RPTDateUtil.getPeriodLastDate(year, period, template.getPeriodType()));
            cslReport.setIsCommitReport(false);
            cslReport.setYear(year);
            cslReport.setPeriod(period);
            cslReport.setStartDate(new Date());
            cslReport.setEndDate(new Date());
            cslReport.setTemplate(template);
            cslReport.setPeriodType(template.getPeriodType());
            cslReport.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
            cslReport.setCommittedStatus(CommittedStatusEnum.COMMITTED);
            cslReport.setSourceType(RptSrcTypeEnum.NORMAL);
            cslReport.setOrgTree(null);
            cslReport.setCurrency(currency);
            cslReport.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
            cslReport.setBook(book2);
            cslReport.setCommittedStatus(CommittedStatusEnum.COMMITTED);
            cslReport.getSheetParam().addCollection(paramCollection);
            cslReport.setName(template.getName());
            cslReport.setNumber(template.getNumber());
            cslReport.setDescription(template.getDescription());
            cslReport.setDataCollect(DataCollectConstant.getActualDC());
            cslReport.setDataCollectNumber("ACTUALDATA");
            cslReport.setCreator(user);
            cslReport.setLastUpdateUser(user);
            cslReport.setCU(cu);
            if (isDynDynTemplate || isDynTemplate) {
                cslReport.setSourceType(RptSrcTypeEnum.DYNAMICNORMALREPORT);
            }
            ICslReport icr = ctx == null ? CslReportFactory.getRemoteInstance() : CslReportFactory.getLocalInstance(ctx);
            byte[] data = cslReport.getData();
            cslReport.setData(null);
            boolean isDispense = ctx != null ? RPTDataServiceFactory.getLocalInstance(ctx).checkTempDispense(cslReport) : RPTDataServiceFactory.getRemoteInstance().checkTempDispense(cslReport);
            cslReport.setData(data);
            if (!isDispense) {
                errorLog.append(EASResource.getString((String)CSLRPTAutoGenerate_Resource, (String)"762_DispensePropertyHelper"));
                return errorLog.toString();
            }
            try {
                IObjectPK reportPk = icr.importReport(cslReport);
                cslReport.setId(BOSUuid.read((String)reportPk.toString()));
            }
            catch (Exception ee) {
                if (!(ee instanceof EASBizException)) break block92;
                cslReport.put("EXCEL_DATE", createdate);
                return ee.getMessage();
            }
        }
        cslReport.put("EXCEL_DATE", createdate);
        return null;
    }

    public String output(File file, CslReportInfo cslReport) throws Exception {
        String[] filePatch = file.getAbsolutePath().split("\\.");
        String fileType = "." + filePatch[filePatch.length - 1];
        if (new File(file.getAbsolutePath()).exists()) {
            return this._outputByFileType(fileType, new FileInputStream(file.getAbsolutePath()), cslReport, null);
        }
        return DispensePropertyHelper.getString("downtemplate.has.not.file") + "(" + file.getAbsolutePath() + ")";
    }

    private StyleAttributes getStyleAttributes(Sheet s, Cell c) {
        StyleAttributes tsa = Styles.getEmptySA();
        s.getRange(c).getStyle(tsa);
        tsa.setDirty(ShareStyleAttributes.getAllBits());
        return tsa;
    }

    private void copyCellStyle(Sheet froms, Cell fromc, Sheet tos, Cell toc) {
        StyleAttributes tsa = Styles.getEmptySA();
        froms.getRange(fromc).getStyle(tsa);
        tsa.setDirty(ShareStyleAttributes.getAllBits());
        tos.getRange(toc).setStyle(tsa, Styles.getEmptySA());
    }

    private boolean compHeadCell(Cell cell, Cell cell2) {
        Variant o;
        String v1 = "";
        String v2 = "";
        if (cell != null && (o = cell.getValue()) != null) {
            v1 = o.toString().trim();
        }
        if (cell2 != null && (o = cell2.getValue()) != null) {
            v2 = o.toString().trim();
        }
        return v2.equals(v1);
    }

    private boolean hasBasePointMark(Sheet sheet, int r, int c) {
        ItemFormula dItem = (ItemFormula)sheet.getRange(r, c).getUserObject("ITEM");
        if (dItem != null && dItem.isBasePoint()) {
            return true;
        }
        Variant v = sheet.getCell(r, c, true).getValue();
        return v != null && v.toString().startsWith("BasePoint");
    }

    private boolean hasItemFomula(Sheet sheet, int r, int c) {
        ItemFormula dItem = (ItemFormula)sheet.getRange(r, c).getUserObject("ITEM");
        return dItem != null;
    }

    public Sheet output(TemplateInfo template, Sheet table) throws Exception {
        Iterator iterator = this.map.keySet().iterator();
        PropertyItem item = null;
        String alias = null;
        Range cellLabel = null;
        Range cellValue = null;
        Method method = null;
        Object invokeResult = null;
        String value = null;
        while (iterator.hasNext()) {
            item = (PropertyItem)this.map.get(iterator.next());
            alias = item.getAlias();
            item.toString();
            if (item.isRequired()) {
                alias = alias + "*";
            }
            if (item.getType() != 0 || item.getFieldOutput() != null) {
                cellLabel = table.getRange(item.getLocation().getRowIndex(), item.getLocation().getColIndex() - 1);
                cellValue = table.getRange(item.getLocation().getRowIndex(), item.getLocation().getColIndex());
                if (item.isHidden()) {
                    DispensePropertyHelper.setHiddenCellFormat(cellLabel);
                    DispensePropertyHelper.setHiddenCellFormat(cellValue);
                }
                cellLabel.setValue(new Variant((Object)alias));
                if (item.getFieldInput() != null) {
                    DispensePropertyHelper.setInputCellFormat(cellValue, Color.BLACK);
                }
                if (item.getFieldOutput() == null) continue;
                method = template.getClass().getMethod("get" + DispensePropertyHelper.capitalize(item.getFieldOutput()), new Class[0]);
                invokeResult = method.invoke((Object)template, new Object[0]);
                value = invokeResult == null ? null : invokeResult.toString();
                cellValue.setValue(new Variant((Object)value));
                continue;
            }
            cellLabel = table.getRange(item.getLocation().getRowIndex(), item.getLocation().getColIndex());
            if (item.isHidden()) {
                DispensePropertyHelper.setHiddenCellFormat(cellLabel);
            }
            if (item.needSetRedFontColor()) {
                DispensePropertyHelper.setInputCellFormat(cellLabel, Color.RED);
            }
            cellLabel.setValue(new Variant((Object)alias));
        }
        return table;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("dynaRptType"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        return sic;
    }

    private String replaceString(String formatedString, String replacement) {
        int index = formatedString.indexOf(123);
        StringBuffer sb = new StringBuffer();
        sb.append(formatedString.substring(0, index));
        sb.append(replacement);
        sb.append(formatedString.substring(index + 3));
        return sb.toString();
    }

    private Object getData(KDSSheet sheet, PropertyItem item) {
        Location location = item.getLocation();
        KDSCell cell = sheet.getCell(location.getRowIndex(), location.getColIndex(), true);
        return cell.getValue();
    }

    private String getDatas(KDSSheet sheet) {
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            PropertyItem item = (PropertyItem)this.map.get(iterator.next());
            if (item.getType() == 0 || item.getFieldInput() == null) continue;
            String o = (String)this.getData(sheet, item);
            item.setData(o);
            if (o == null || o.trim().length() == 0) {
                return MessageFormat.format(DispensePropertyHelper.getString("Dispense_Import_Error_FieldNotFound"), item.getAlias());
            }
            if (item.getType() != 1) continue;
        }
        return null;
    }

    public static void setInputCellFormat(Range range, Color fontColor) {
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBackground(new Color(200, 200, 200));
        sa.setFontColor(fontColor);
        range.setStyle(sa, Styles.getEmptySA());
    }

    public static void setBasePointFormat(Range range) {
    }

    public static void lockHeadCell(Sheet sheet, int r, int c) {
    }

    public static boolean hasItemFormula(Sheet sheet, int r, int c) {
        Cell cell = sheet.getCell(r, c, false);
        if (cell != null) {
            ItemFormula itemFormula = (ItemFormula)cell.getUserObjectValue("ITEM");
            return itemFormula != null && !StringUtils.isEmpty((String)itemFormula.getFormula());
        }
        return false;
    }

    public static void setHiddenCellFormat(Range cell) {
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBackground(Color.WHITE);
        sa.setFontColor(Color.WHITE);
        cell.setStyle(sa, Styles.getEmptySA());
    }

    public static String getString(String resName) {
        return EASResource.getString((String)DISPENSE_RESOURCE, (String)resName);
    }

    public static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String getString(String resName, Context ctx) {
        if (ctx == null) {
            return EASResource.getString((String)DISPENSE_RESOURCE, (String)resName);
        }
        return ResourceBase.getString((String)DISPENSE_RESOURCE, (String)resName, (Locale)ctx.getOriginLocale());
    }

    public static String getCSLRPTAutoGenerateResource(String resName, Context ctx) {
        if (ctx == null) {
            return EASResource.getString((String)CSLRPTAutoGenerate_Resource, (String)resName);
        }
        return ResourceBase.getString((String)CSLRPTAutoGenerate_Resource, (String)resName, (Locale)ctx.getOriginLocale());
    }
}

