/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslParamFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICslParam;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;

public class SendMail {
    private static Logger logger = Logger.getLogger(SendMail.class);
    private String host = ".kdsv";
    private String user = "";
    private String pwd = "";
    private String from = "";
    private String to = "";
    private String subject = "test";
    private boolean getDbInfo = false;
    private boolean isSSL = false;

    public void setAddress(String from, String to, String subject) {
        this.from = from;
        this.to = to;
        this.subject = subject;
    }

    public SendMail() {
    }

    public SendMail(boolean getDbInfo, Context ctx) throws BOSException, EASBizException {
        this.getDbInfo = getDbInfo;
        if (getDbInfo && DebugLogger.isDebug) {
            try {
                ICslParam cslParam = null;
                cslParam = ctx == null ? CslParamFactory.getRemoteInstance() : CslParamFactory.getLocalInstance(ctx);
                String oql = " select key ,value where key in ('email_Host','email_user_password','email_from','email_to','email_isSSL')";
                CoreBaseCollection collection = cslParam.getCollection(oql);
                if (collection == null || collection.isEmpty()) {
                    getDbInfo = false;
                } else {
                    for (int i = 0; i < collection.size(); ++i) {
                        CoreBaseInfo baseInfo = collection.get(i);
                        if (baseInfo.getString("key").equals("email_Host")) {
                            this.host = baseInfo.getString("value");
                            continue;
                        }
                        if (baseInfo.getString("key").equals("email_user_password")) {
                            String email_user_password = baseInfo.getString("value");
                            this.user = email_user_password.split("\\|")[0];
                            this.pwd = email_user_password.split("\\|")[1];
                            continue;
                        }
                        if (baseInfo.getString("key").equals("email_from")) {
                            this.from = baseInfo.getString("value");
                            continue;
                        }
                        if (baseInfo.getString("key").equals("email_to")) {
                            this.to = baseInfo.getString("value");
                            continue;
                        }
                        if (!baseInfo.getString("key").equals("email_isSSL")) continue;
                        try {
                            this.isSSL = Boolean.valueOf(baseInfo.getString("value"));
                            continue;
                        }
                        catch (Exception ex) {
                            logger.error((Object)"isSSL error.", (Throwable)ex);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"SendMail error.", (Throwable)e);
                throw new BOSException("SendMail error.", (Throwable)e);
            }
        }
    }

    public void sendEmail(String title, String content) throws BOSException, EASBizException {
        if (DebugLogger.isDebug && this.getDbInfo) {
            this.subject = title;
            this.send(content);
        }
    }

    public void send(String txt) throws BOSException, EASBizException {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.host);
        props.put("mail.smtp.auth", "true");
        if (this.isSSL) {
            props.put("mail.smtp.ssl.enable", "true");
        }
        Session session = Session.getDefaultInstance((Properties)props);
        session.setDebug(true);
        MimeMessage message = new MimeMessage(session);
        try {
            message.setFrom((Address)new InternetAddress(this.from));
            message.addRecipients(Message.RecipientType.TO, this.to);
            message.setSubject(this.subject);
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart contentPart = new MimeBodyPart();
            contentPart.setText(txt);
            multipart.addBodyPart((BodyPart)contentPart);
            message.setContent((Multipart)multipart);
            message.saveChanges();
            Transport transport = session.getTransport("smtp");
            if (this.pwd.equals("")) {
                throw new Exception("pwd is null.");
            }
            transport.connect(this.host, this.user, this.pwd);
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            SendMail cn = new SendMail();
            cn.setAddress("chunkai_zhang@kdsv.kingdee.com", "chunkai_zhang@kdsv.kingdee.com", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"846_SendMail"));
            cn.send("testing");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

