/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.CslOrgTreeUtil;
import com.kingdee.eas.fi.gr.fast.app.AbstractMergeReportCenterFacadeControllerBean;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.gr.fast.util.MergeReportCenterFilterCondition;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.jdbc.statement.CslPreparedStatement;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MergeReportCenterFacadeControllerBean
extends AbstractMergeReportCenterFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.fast.app.MergeReportCenterFacadeControllerBean");

    @Override
    protected List _getReportsStatByOrg(Context ctx, List list, MergeReportCenterFilterCondition condition) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _buildTreeModelInfo(Context ctx, IObjectPK userPK, String treeID, String cuID) throws BOSException, EASBizException {
        try {
            if (treeID == null || userPK == null) {
                return new HashMap(2);
            }
            HashMap map = new HashMap(4);
            Map displayOrgIDs = CslOrgTreeUtil.getAuthorizedOrgs(ctx, null, userPK, (IObjectPK)new ObjectUuidPK(treeID), true);
            StringBuffer sql = new StringBuffer();
            String language = ctx.getLocale().getLanguage();
            sql.append(" SELECT ORGSTRUCTURE.FID       \"ID\", \t\t\t\r\n");
            sql.append("   ORGSTRUCTURE.FLongNumber    \"LONGNUMBER\",\t\r\n");
            sql.append("   ORGSTRUCTURE.FLevel         \"LEVEL\",\t\t\r\n");
            sql.append("   ORGSTRUCTURE.FIsLeaf        \"ISLEAF\",\t\t\r\n");
            sql.append("   ORGSTRUCTURE.FIsValid       \"ISVALID\",\t\t\r\n");
            sql.append("   ORGSTRUCTURE.FParentID      \"PARENT.ID\",\t\r\n");
            sql.append("   UNIT.FID                    \"UNIT.ID\",\t\t\r\n");
            sql.append("   UNIT.FNumber                \"UNIT.NUMBER\",\t\r\n");
            sql.append("   UNIT.FName_").append(language).append(" \"UNIT.NAME\",\r\n");
            sql.append("   UNIT.FLongNumber            \"UNIT.LONGNUMBER\",\t\t\r\n");
            sql.append("   UNIT.FIsGrouping            \"UNIT.ISGROUPING\",\t\t\r\n");
            sql.append("   UNIT.FIsUnion               \"UNIT.ISUNION\",\t\t\r\n");
            sql.append("   UNIT.FIsCompanyOrgUnit      \"UNIT.ISCOMPANYORGUNIT\",\r\n");
            sql.append("   UNIT.FIsProfitOrgUnit      \"UNIT.IsProfitOrgUnit\",\r\n");
            sql.append("   UNIT.FOrgTypeStr      \t  \"UNIT.orgTypeStr\",\r\n");
            sql.append("   UNIT.FIsFreeze              \"UNIT.ISFREEZE\"\t\t\r\n");
            sql.append(" \tFROM T_ORG_Structure ORGSTRUCTURE\t\t\t\r\n");
            sql.append("\tINNER JOIN T_ORG_BaseUnit UNIT\t\t\t\t\r\n");
            sql.append(" \t\tON ORGSTRUCTURE.FUnitId = UNIT.FID\t\t\r\n");
            sql.append(" \tINNER JOIN T_ORG_Tree TREE\t\t\t\t\t\r\n");
            sql.append(" \t\tON ORGSTRUCTURE.FTreeId = TREE.FID\t\t\r\n");
            sql.append("\tLEFT OUTER JOIN T_ORG_Structure PARENT\t\t\r\n");
            sql.append(" \t\t ON ORGSTRUCTURE.FParentID = PARENT.FID\t\r\n");
            sql.append(" \tLEFT OUTER JOIN T_ORG_OUPartCtrl CTRL\t\t\r\n");
            sql.append("  \t\tON UNIT.FID = CTRL.FUnitID\t\t\t\t\r\n");
            sql.append(" \tWHERE UNIT.FID <> '11111111-1111-1111-1111-111111111111CCE7AED4' \r\n");
            sql.append("     AND TREE.FID = '").append(treeID).append("'\t\t\t\t\t \r\n");
            sql.append("     AND UNIT.FIsGrouping = 1 \r\n");
            sql.append(" ORDER BY ORGSTRUCTURE.FLongNumber ASC");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            OrgStructureCollection collection = MergeReportCenterFacadeControllerBean.createOrgStructureCol(rowSet, treeID);
            map.put("permOrgs", displayOrgIDs);
            map.put("orgStructureCollection", collection);
            return map;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static OrgStructureCollection createOrgStructureCol(IRowSet row, String treeID) throws EASBizException, BOSException, SQLException {
        OrgStructureCollection orgStrCol = new OrgStructureCollection();
        OrgTreeInfo treeInfo = new OrgTreeInfo();
        treeInfo.setId(BOSUuid.read((String)treeID));
        while (row.next()) {
            OrgStructureInfo structInfo = new OrgStructureInfo();
            structInfo.setId(BOSUuid.read((String)row.getString("id")));
            structInfo.setLongNumber(row.getString("longNumber"));
            structInfo.setLevel(row.getInt("level"));
            structInfo.setIsLeaf(row.getBoolean("isLeaf"));
            structInfo.setIsValid(row.getBoolean("isValid"));
            FullOrgUnitInfo fullUnitInfo = new FullOrgUnitInfo();
            fullUnitInfo.setId(BOSUuid.read((String)row.getString("unit.id")));
            fullUnitInfo.setNumber(row.getString("unit.number"));
            fullUnitInfo.setName(row.getString("unit.name"));
            fullUnitInfo.setIsGrouping(row.getBoolean("unit.isGrouping"));
            fullUnitInfo.setIsFreeze(row.getBoolean("unit.isFreeze"));
            fullUnitInfo.setLongNumber(row.getString("unit.longNumber"));
            fullUnitInfo.setIsUnion(row.getBoolean("unit.isunion"));
            fullUnitInfo.setIsCompanyOrgUnit(row.getBoolean("unit.isCompanyOrgUnit"));
            fullUnitInfo.setIsProfitOrgUnit(row.getBoolean("unit.IsProfitOrgUnit"));
            fullUnitInfo.setOrgTypeStr(row.getString("unit.orgTypeStr"));
            structInfo.setUnit(fullUnitInfo);
            OrgStructureInfo parentStructInfo = null;
            if (row.getString("parent.id") != null && !row.getString("parent.id").equals("")) {
                parentStructInfo = new OrgStructureInfo();
                parentStructInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
            }
            structInfo.setParent(parentStructInfo);
            structInfo.setTree(treeInfo);
            orgStrCol.add(structInfo);
        }
        return orgStrCol;
    }

    @Override
    protected Map _getReportsByOrg(Context ctx, MergeReportCenterFilterCondition condition, String sortFiledName, boolean isDescSort) throws BOSException, EASBizException {
        if (condition == null || condition.getOrgBoundId() == null || condition.getOrgUnitId() == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        Map map = this.getRowSetMainByOrgIncludeSub(ctx, condition, sortFiledName, isDescSort);
        IRowSet rs = (IRowSet)map.get("rowSet");
        int audited = 0;
        int unAudited = 0;
        if (rs != null) {
            try {
                while (rs.next()) {
                    int auditedStatus = rs.getInt("AUDITEDSTATUS");
                    if (auditedStatus == 2) {
                        ++audited;
                        continue;
                    }
                    ++unAudited;
                }
                rs.beforeFirst();
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        int total = audited + unAudited;
        Object[] stats = new Object[]{new Integer(total), new Integer(audited), new Integer(unAudited)};
        result.put("KEY_RCV_ROWSET", rs);
        result.put("KEY_RCV_STAT", stats);
        return result;
    }

    @Override
    protected CslReportCollection _getReportsByOrg(Context ctx, String treeId, String orgUnitId, int year, int period, int periodType, boolean isAudited, boolean isUnaudited) throws BOSException {
        return null;
    }

    @Override
    protected Map _getReportsByOrg(Context ctx, MergeReportCenterFilterCondition condition, int level, String sortFiledName, boolean isDescSort) throws BOSException, EASBizException {
        return this._getReportsByOrg(ctx, condition, sortFiledName, isDescSort);
    }

    @Override
    protected OrgTreeInfo _translateOrgTreeVersion(Context ctx, OrgTreeInfo orgTree, Date reportDate, String userId) throws BOSException, EASBizException {
        OrgTreeCollection orgTrees;
        OrgTreeInfo rtnOrgTree = null;
        String sourceNumber = orgTree.getNumber();
        if (orgTree != null && !StringUtils.isEmpty((String)sourceNumber) && (orgTrees = CslRptUtil.getAllUnionTrees(ctx, userId, reportDate)) != null) {
            OrgTreeInfo orgTreeInfo = null;
            for (int i = 0; i < orgTrees.size(); ++i) {
                orgTreeInfo = orgTrees.get(i);
                if (!sourceNumber.equals(orgTreeInfo.getNumber())) continue;
                rtnOrgTree = orgTreeInfo = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo("select id,name,number,IsHide,IsForBudget,status,basic where id='" + orgTreeInfo.getId() + "'");
                break;
            }
        }
        return rtnOrgTree;
    }

    private Map getRowSetMainByOrgIncludeSub(Context ctx, MergeReportCenterFilterCondition condition, String sortFiledName, boolean isDescSort) throws BOSException, EASBizException {
        HashMap<String, String> returnMap = new HashMap<String, String>(4);
        String tableName = condition.getTempTable();
        Set idSet = null;
        idSet = condition.getIsFromMergeReportCenterListUI() != false ? condition.getOrgIds() : this.getOrgUnitIdAndOrgUnitId(ctx, condition);
        Set<String> noPermissionUnitSet = condition.getNoPermissionUnitSet();
        if (idSet != null && noPermissionUnitSet != null && !noPermissionUnitSet.isEmpty()) {
            idSet.removeAll(noPermissionUnitSet);
        }
        if (idSet != null && !idSet.isEmpty()) {
            tableName = this.insertData2TempTable(ctx, condition, idSet);
            IRowSet rowSet = this.getRowSetMainByOrgIncludeSub(ctx, sortFiledName, isDescSort, tableName, condition);
            this.releaseTempTable(tableName, ctx);
            returnMap.put("tempTable", tableName);
            returnMap.put("rowSet", (String)rowSet);
        }
        return returnMap;
    }

    private Set getOrgUnitIdAndOrgUnitId(Context ctx, MergeReportCenterFilterCondition condition) throws BOSException, EASBizException {
        Set<String> idSet = new HashSet<String>();
        idSet.add(condition.getOrgUnitId());
        if (!condition.isIncludeSub() && !condition.isIsIncludeAllSub()) {
            return idSet;
        }
        ObjectUuidPK orgTreepk = new ObjectUuidPK(condition.getOrgBoundId());
        IOrgUnitCommon orgUtil = OrgUnitCommonFactory.getLocalInstance((Context)ctx);
        OrgTreeInfo orgTree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)orgTreepk);
        OrgUnitInfo curOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectStringPK(condition.getOrgUnitId()));
        if (condition.isIncludeSub()) {
            OrgUnitCollection units = null;
            units = orgUtil.getUnionDebtChildren(curOrgUnit, orgTree);
            if (units != null) {
                for (Object obj : units) {
                    if (obj == null || !(obj instanceof OrgUnitInfo)) continue;
                    OrgUnitInfo org = (OrgUnitInfo)obj;
                    idSet.add(org.getId().toString());
                }
            }
        }
        if (condition.isIsIncludeAllSub()) {
            idSet = this.getAllChildrenUnitsByUnit(ctx, orgTree, curOrgUnit);
            idSet.add(condition.getOrgUnitId());
        }
        return idSet;
    }

    private Set getAllChildrenUnitsByUnit(Context ctx, OrgTreeInfo tree, OrgUnitInfo unit) throws BOSException {
        ArrayList<String> params = new ArrayList<String>(2);
        StringBuffer sql = new StringBuffer(100);
        sql.append(" Select unit.Fid from t_Org_Tree tree \t\t\t\t\t\t\t\t\t\n").append(" join t_Org_Structure s on tree.Fid = s.FTreeId \t\t\t\t\t\t\n").append(" join t_Org_BaseUnit unit on unit.Fid = s.FUnitId \t\t\t\t\t\t\n").append(" where tree.Fid = ? and unit.Fid <> ?  and unit.FIsGrouping = 1 \t\t\n").append(" and s.FLongNumber like '").append(unit.getLongNumber()).append("!%' \t\n").append(" order by s.FLevel \t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        params.add(tree.getId().toString());
        params.add(unit.getId().toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        HashSet<String> result = new HashSet<String>();
        try {
            while (rs.next()) {
                result.add(rs.getString("Fid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private String insertData2TempTable(Context ctx, MergeReportCenterFilterCondition condition, Set idSet) throws BOSException, EASBizException {
        String tempOrgUnitIDTable = null;
        if (idSet.size() > 20) {
            tempOrgUnitIDTable = this.insertIdSet2TempTable(ctx, idSet);
        }
        String tableName = this.createTempTable(ctx);
        this.insertMergeReportDataTempTable(ctx, condition, tableName, tempOrgUnitIDTable, idSet);
        this.releaseTempTable(tempOrgUnitIDTable, ctx);
        return tableName;
    }

    private String insertIdSet2TempTable(Context ctx, Set idSet) throws EASBizException, BOSException {
        String string;
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        Connection cn = null;
        CslPreparedStatement ps = null;
        try {
            cn = super.getConnection(ctx);
            String tempOrgUnitIDTable = this.createTempOrgUnitIDTable(ctx);
            String insert = " insert into " + tempOrgUnitIDTable + " values( ? )";
            ps = CslPreparedStatement.prepareStatement((Connection)cn, (String)insert);
            Iterator iter = idSet.iterator();
            while (iter.hasNext()) {
                ps.setString(1, iter.next().toString());
                ps.addBatch();
            }
            ps.executeBatch();
            ps.clearBatch();
            string = tempOrgUnitIDTable;
            SQLUtils.cleanup((Statement)(ps != null ? ps.getStatement() : null), (Connection)cn);
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Statement)(ps != null ? ps.getStatement() : null), (Connection)cn);
                throw throwable;
            }
        }
        return string;
    }

    private String createTempOrgUnitIDTable(Context ctx) throws BOSException {
        String tableName;
        StringBuffer create = new StringBuffer();
        create.append("create table Tmp_TempOrgUnitIDTable");
        create.append("(FCompanyId varchar(44))");
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tableName = pool.createTempTable(create.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private String createTempTable(Context ctx) throws BOSException {
        String tableName;
        StringBuffer create = new StringBuffer();
        create.append("create table Tmp_MergeReport_Table");
        create.append(" (FFid VARCHAR(44), FFName NVARCHAR(80),");
        create.append(" FFNumber NVARCHAR(80),");
        create.append(" FFCurrencyId varchar(44), FFCurrency2Id varchar(44),");
        create.append(" FFconvertStatus int,");
        create.append(" FFSourceType int, FFYear int, FFPeriod int,");
        create.append(" FFAuditedStatus int,");
        create.append(" FFCommittedStatus int,");
        create.append(" FFPeriodType int,");
        create.append(" FFCompanyId varchar(44),");
        create.append(" ttnumber NVARCHAR(80),");
        create.append(" ttname NVARCHAR(80),");
        create.append(" ttTemplateType int,");
        create.append(" ttReportDate DateTime ,");
        create.append(" tempid VARCHAR(44) ,");
        create.append(" tversion NVARCHAR(80),");
        create.append(" ttemplatenumber NVARCHAR(80),");
        create.append(" ttemplatename NVARCHAR(80),");
        create.append(" ffauditor NVARCHAR(255),");
        create.append(" ffcreateTime DATETIME,");
        create.append(" fflastUpdateTime DATETIME,");
        create.append(" flastUpdateUser NVARCHAR(80),");
        create.append(" fcommitor NVARCHAR(80),");
        create.append(" fcommitTime DATETIME,");
        create.append(" fcreator NVARCHAR(80)");
        create.append(" )");
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tableName = pool.createTempTable(create.toString());
            pool.createIndex(tableName, "tempid", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private void insertMergeReportDataTempTable(Context ctx, MergeReportCenterFilterCondition condition, String tableName, String tempCompanyIDTable, Set idSet) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String subSql_2 = this.getWeaveReportsSql(ctx, condition, tempCompanyIDTable, idSet);
        sql.append("INSERT INTO ").append(tableName).append(" \r\n");
        sql.append(subSql_2);
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getWeaveReportsSql(Context ctx, MergeReportCenterFilterCondition condition, String tempCompanyIDTable, Set idSet) {
        String language = ctx.getLocale().getLanguage();
        StringBuffer subSql_2 = new StringBuffer();
        subSql_2.append("SELECT r.FID AS ffid, r.FName AS ffname,r.FNumber AS ffnumber, r.FCurrencyID AS ffcurrencyid \n");
        subSql_2.append("   ,r.FSourceCurrencyID AS ffcurrency2id, r.FConvertStatus as FFconvertStatus, r.FSourceType AS ffsourcetype\n");
        subSql_2.append("   ,r.FYear AS ffyear, r.FPeriod AS ffperiod           \n");
        subSql_2.append("   ,r.FAuditedStatus AS ffauditedstatus                \n");
        subSql_2.append("   ,r.FCommittedStatus AS ffcommittedstatus            \n");
        subSql_2.append("   ,t.FPeriodType AS ffperiodtype, r.FOrgUnitID AS ffcompanyid \n");
        subSql_2.append(" \t,t.FNumber AS ttnumber, t.FName AS ttname   \n");
        subSql_2.append("   ,t.FTemplateType   AS    ttTemplateType     \n");
        subSql_2.append(" \t,r.FReportDate  AS ttReportDate            \t\n");
        subSql_2.append(" \t,t.FID  AS tempid   ,t.FVersionNumber as tversion,t.fnumber as ttemplatenumber,t.Fname AS ttemplatename           \n");
        subSql_2.append("   ,u2.FName_").append(language).append("  AS ffauditor\t\t\n");
        subSql_2.append(" \t,r.FCreateTime  AS ffcreateTime            \n");
        subSql_2.append(" \t,r.FLastUpdateTime  AS fflastUpdateTime    \n");
        subSql_2.append("   ,u3.FName_").append(language).append("  AS flastUpdateUser\t\t\n");
        subSql_2.append("   ,u4.FName_").append(language).append("  AS fcommitor    \n");
        subSql_2.append(" \t,r.FcommitTime  AS fcommitTime    \n");
        subSql_2.append("   ,u5.FName_").append(language).append("  AS fcreator    \n");
        subSql_2.append("FROM T_CSL_CslReport r                        \n");
        if (!StringUtils.isEmpty((String)tempCompanyIDTable)) {
            subSql_2.append(" INNER JOIN ").append(tempCompanyIDTable).append(" tmptable on tmptable.FCompanyID=r.FOrgUnitID");
        }
        subSql_2.append("    INNER JOIN T_RPT_Template t ON r.FTemplateid = t.fid   \r\n");
        subSql_2.append("    Left JOIN T_PM_User u2 ON u2.fid = r.FAuditorID        \r\n");
        subSql_2.append("    Left JOIN T_PM_User u3 ON u3.fid = r.flastUpdateUserId     \r\n");
        subSql_2.append("    Left JOIN T_PM_User u4 ON u4.fid = r.fcommitorID     \r\n");
        subSql_2.append("    Left JOIN T_PM_User u5 ON u5.fid = r.fcreatorID     \r\n");
        subSql_2.append("WHERE 1=1 \r\n");
        if (condition.getFastMergeSoluId() != null) {
            subSql_2.append(" \tAND r.FFastMergeSoluId = '").append(condition.getFastMergeSoluId()).append("'\r\n");
        }
        if (condition.getOrgBoundId() != null) {
            subSql_2.append(" \tAND r.FOrgTreeID = '").append(condition.getOrgBoundId()).append("'\r\n");
        }
        if (condition.getReportType() != null) {
            subSql_2.append(" \tAND r.fsourceType = ").append(condition.getReportType().getValue()).append("\r\n");
        } else if (condition.isAutoSum()) {
            subSql_2.append(" \tAND r.fsourceType in (").append(31).append(",").append(2).append(",").append(11).append(",").append(32).append(") \r\n");
        } else {
            subSql_2.append(" \tAND r.fsourceType in (").append(33).append(",").append(4).append(",").append(3).append(",").append(12).append(",").append(34).append(",").append(42).append(",").append(43).append(",").append(35).append(") \r\n");
        }
        if (condition.getCurrentyId() != null) {
            subSql_2.append(" \tAND r.FCurrencyID = '").append(condition.getCurrentyId()).append("' \r\n");
        }
        if (condition.getYear() > 0) {
            subSql_2.append(" \tAND r.FYear = ").append(condition.getYear()).append("\r\n");
        }
        if (condition.getPeriods() != null) {
            subSql_2.append(" \tAND r.FPeriod in (").append(condition.getPeriods()).append(")\r\n");
        } else if (condition.getPeriod() > 0) {
            subSql_2.append(" \tAND r.FPeriod = ").append(condition.getPeriod()).append("\r\n");
        }
        if (condition.getAuditedStatus() != null) {
            subSql_2.append(" \tAND r.FAuditedStatus = ").append(condition.getAuditedStatus().getValue()).append("\r\n");
        }
        if (condition.getPeriodType() != null) {
            subSql_2.append("    AND r.FPeriodType = ").append(condition.getPeriodType().getValue()).append("\r\n");
        }
        if (StringUtils.isEmpty((String)tempCompanyIDTable)) {
            subSql_2.append("    AND r.FOrgUnitID in(").append(CslRptUtil.changeIdSet2String(idSet)).append(") \r\n");
        }
        return subSql_2.toString();
    }

    private IRowSet getRowSetMainByOrgIncludeSub(Context ctx, String sortFiledName, boolean isDescSort, String tableName, MergeReportCenterFilterCondition condition) throws BOSException {
        String sc;
        CSLServerHelper serverHelper = new CSLServerHelper(ctx);
        String ext = serverHelper.getFieldNameExtend();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ffid AS \"ID\",                                         \n");
        sql.append("    o.FName").append(ext).append(" AS \"ORGUNIT.NAME\",         \n");
        sql.append("    o.FNumber AS \"ORGUNIT.NUMBER\",                      \t\t\n");
        sql.append("    ffname AS \"NAME\",                                         \n");
        sql.append("    ffnumber AS \"NUMBER\",\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("    c.FName").append(ext).append(" AS \"CURRENCY.NAME\",        \n");
        sql.append("    c2.FName").append(ext).append(" AS \"SOURCECURRENCY.NAME\", \n");
        sql.append("    ffconvertStatus as \"CONVERTSTATUS\", \t\t\t\t\t\t\n");
        sql.append("    ffsourcetype AS \"SOURCETYPE\",                             \n");
        sql.append("    ffperiodtype AS \"PERIODTYPE\",                             \n");
        sql.append("    ffyear AS \"YEAR\",                                         \n");
        sql.append("    ffperiod AS \"PERIOD\",                                     \n");
        sql.append("    ffauditedstatus AS \"AUDITEDSTATUS\",                       \n");
        sql.append("    ffcommittedstatus AS \"COMMITTEDSTATUS\",                   \n");
        sql.append("    '' AS \"CURRENCY.ID\",                                      \n");
        sql.append("    '' AS \"REPORTDATE\",                                     \n");
        sql.append("    tempid AS \"TEMPLATE.ID\",                                  \n");
        sql.append("    o.FID AS \"ORGUNIT.ID\",                                    \n");
        sql.append("    -1 AS \"TEMPLATE.TEMPLATETYPE\" ,                           \n");
        sql.append("    '' AS \"TREE.ID\",                                          \n");
        sql.append(" \tttemplatenumber AS \"TEMPLATE.NUMBER\",                     \n");
        sql.append(" \tttemplatename AS \"TEMPLATE.NAME\",                         \n");
        sql.append(" \ttversion AS \"TEMPLATE.VERSIONNUMBER\",       \t\t\t  \t\n");
        sql.append("    '' AS \"STRUCTURE.LONGNUMBER\",                             \n");
        sql.append(" \tffauditor AS \"AUDITOR.NAME\",                              \n");
        sql.append(" \tffcreateTime AS \"CREATETIME\",                             \n");
        sql.append(" \tfflastUpdateTime AS \"LASTUPDATETIME\",                     \n");
        sql.append("    '' AS \"PARENTSTRUCTURE.ID\",\t\t\t\t\t\t\t\t\n");
        sql.append("    tempTable.flastUpdateUser AS \"lastUpdateUser.name\",\t\t\n");
        sql.append("    tempTable.fcommitor AS \"commitor.name\",\t\t\t\t\t\n");
        sql.append("    tempTable.fcommitTime AS \"commitTime\",\t\t\t\t\t\n");
        sql.append("    tempTable.fcreator AS \"creator.name\"\t\t\t\t\t\t\n");
        sql.append(" FROM ").append(tableName).append(" AS tempTable                \n");
        sql.append(" INNER JOIN T_ORG_BaseUnit o                                    \n");
        sql.append("    ON tempTable.ffcompanyid = o.FID                            \n");
        sql.append(" LEFT OUTER JOIN T_BD_Currency c                                \n");
        sql.append("    ON tempTable.ffcurrencyid = c.fid                           \n");
        sql.append(" LEFT OUTER JOIN T_BD_Currency c2                               \n");
        sql.append("    ON tempTable.ffcurrency2id = c2.fid  ");
        String string = sc = isDescSort ? " desc" : " asc";
        if (sortFiledName == null || "".equals(sortFiledName.trim())) {
            sql.append(" order by o.FNumber, ttemplatenumber\t\t\t\n");
        } else if ((sortFiledName = this.getRealMapFieldString(sortFiledName.trim().toUpperCase(), ext)) != null) {
            sql.append(" order by ").append(sortFiledName).append(sc);
        } else {
            sql.append(" order by o.FNumber, ttemplatenumber\t\t\n");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rowSet;
    }

    private void releaseTempTable(String tableName, Context ctx) {
        if (!StringUtils.isEmpty((String)tableName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
        }
    }

    private String getRealMapFieldString(String queryString, String language) {
        HashMap<String, String> map = new HashMap<String, String>(32);
        map.put("ORGUNIT.NAME", "o.FName" + language);
        map.put("ORGUNIT.NUMBER", "o.FNumber");
        map.put("NAME", "ffname");
        map.put("NUMBER", "ffnumber");
        map.put("CURRENCY.NAME", "c.FName" + language);
        map.put("SOURCECURRENCY.NAME", "c2.FName" + language);
        map.put("CONVERTSTATUS", "ffconvertStatus");
        map.put("SOURCETYPE", "ffsourcetype");
        map.put("PERIODTYPE", "ffperiodtype");
        map.put("YEAR", "ffyear");
        map.put("PERIOD", "ffperiod");
        map.put("AUDITEDSTATUS", "ffauditedstatus");
        map.put("COMMITTEDSTATUS", "ffcommittedStatus");
        map.put("TEMPLATE.ID", "tempid");
        map.put("ORGUNIT.ID", "o.FID");
        map.put("TEMPLATE.NUMBER", "ttemplatenumber");
        map.put("TEMPLATE.NAME", "ttemplatename");
        map.put("TEMPLATE.VERSIONNUMBER", "tversion");
        map.put("AUDITOR.NAME", "ffauditor");
        map.put("CREATETIME", "ffcreateTime");
        map.put("LASTUPDATETIME", "fflastUpdateTime");
        return (String)map.get(queryString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _auditOrUnAuditReport(Context ctx, IObjectValue cslReportInfo, boolean isAudit) throws BOSException, EASBizException {
        boolean isSuccess = true;
        String msg = null;
        try {
            boolean isManusript;
            ctx.put((Object)"RETURNMSG", (Object)true);
            CslReportInfo cslRptInfo = (CslReportInfo)cslReportInfo;
            boolean bl = isManusript = cslRptInfo.getSourceType().equals((Object)RptSrcTypeEnum.MANUSCRIPT) || cslRptInfo.getSourceType().equals((Object)RptSrcTypeEnum.MANUSCRIPT_FASTMERGE);
            if (isAudit) {
                if (cslRptInfo.getAuditedStatus().equals((Object)AuditedStatusEnum.UNAUDITED)) {
                    if (isManusript) {
                        CslReportFactory.getLocalInstance(ctx).audit((IObjectPK)new ObjectUuidPK(cslRptInfo.getId()));
                    } else {
                        msg = FastMergeUtil.cslrptAduit(ctx, cslRptInfo);
                    }
                }
                if (!isManusript) {
                    if (cslRptInfo.getCommittedStatus().equals((Object)CommittedStatusEnum.UNCOMMITTED)) {
                        FastMergeUtil.cslrptCommit(ctx, cslRptInfo);
                    }
                    if (cslRptInfo.getCommittedStatus().equals((Object)CommittedStatusEnum.COMMITTED)) {
                        String curMsg = FastMergeUtil.cslReceive(ctx, cslRptInfo);
                        if (StringUtils.isEmpty((String)msg)) {
                            msg = curMsg;
                        }
                    }
                }
            } else if (cslRptInfo.getAuditedStatus().equals((Object)AuditedStatusEnum.AUDITED) && cslRptInfo.getCommittedStatus().equals((Object)CommittedStatusEnum.UNCOMMITTED)) {
                CslReportFactory.getLocalInstance(ctx).unAudit((IObjectPK)new ObjectUuidPK(cslRptInfo.getId()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"_auditOrUnAuditReport error", (Throwable)e);
            isSuccess = false;
            if (e != null) {
                msg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            }
        }
        finally {
            ctx.remove((Object)"RETURNMSG");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("isSuccess", isSuccess);
        result.put("msg", msg);
        return result;
    }
}

