/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleCollection;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IAdjust;
import com.kingdee.eas.fi.gr.cslrpt.app.AdjustEntryCopy;
import com.kingdee.eas.fi.gr.cslrpt.app.BatchImportAdjust;
import com.kingdee.eas.fi.gr.fast.AdjustEntiresSoluInfo;
import com.kingdee.eas.fi.gr.fast.AdjustTypeEntriesCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.SolutionExecuteParam;
import com.kingdee.eas.fi.gr.fast.biz.ISoluExecute;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdjustSoluExecute
implements ISoluExecute {
    private static Logger LOGGER = Logger.getLogger(AdjustSoluExecute.class);
    protected SolutionExecuteParam soluExecuteParam;
    protected Context ctx;
    private IAdjust iAdjust;
    private FullOrgUnitInfo curOrgUnit = null;

    public AdjustSoluExecute(SolutionExecuteParam soluExecuteParam, Context ctx, FullOrgUnitInfo curOrgUnit) throws BOSException {
        this(soluExecuteParam, ctx);
        this.curOrgUnit = curOrgUnit;
    }

    public AdjustSoluExecute(SolutionExecuteParam soluExecuteParam, Context ctx) throws BOSException {
        this.soluExecuteParam = soluExecuteParam;
        this.ctx = ctx;
        if (soluExecuteParam != null && soluExecuteParam.getCurOrgUnit() != null) {
            this.curOrgUnit = soluExecuteParam.getCurOrgUnit();
        }
        this.init();
    }

    private boolean isCanExecute() {
        FastMergeSoluInfo soluInfo = this.soluExecuteParam.getSoluInfo();
        AdjustEntiresSoluInfo adjustSolu = soluInfo.getAdjustEntrySolu();
        return adjustSolu != null && adjustSolu.getId() != null;
    }

    @Override
    public void execute() throws Exception {
        if (!this.isCanExecute()) {
            return;
        }
        this.copyFixedAdjustData();
        this.copyHisAdjustData();
        this.importFromBaseOrgBound();
        this.createAdjustByAdjTmpAndAudit();
    }

    private void init() throws BOSException {
        this.iAdjust = AdjustFactory.getLocalInstance(this.ctx);
    }

    private void copyFixedAdjustData() throws BOSException, EASBizException {
        if (!this.soluExecuteParam.getAdjustSolu().isIsAutoCreateEntries()) {
            return;
        }
        if (!this.soluExecuteParam.getAdjustSolu().isIsCopyFixedEntries()) {
            return;
        }
        try {
            AdjustEntryCopy adjustCopy = new AdjustEntryCopy();
            List<IObjectPK> pks = adjustCopy.copyFixedAdjustData(this.ctx, this.soluExecuteParam.getSoluInfo().getOrgBound().getId().toString(), this.soluExecuteParam.getPeriodType(), this.soluExecuteParam.getYear(), this.soluExecuteParam.getPeriod(), (IObjectValue)this.soluExecuteParam.getDataCollInfo(), this.curOrgUnit.getId().toString());
            if (pks == null || pks.size() == 0) {
                return;
            }
            this.iAdjust.audit(pks);
        }
        catch (EASBizException e) {
            if (e instanceof AdjustException) {
                LOGGER.info((Object)"FIX adjust NOT_EXIST ");
            }
        }
        catch (BOSException e) {
            LOGGER.info((Object)"copyFixedAdjustData is error!");
        }
    }

    private void copyHisAdjustData() throws BOSException, EASBizException {
        if (!this.soluExecuteParam.getAdjustSolu().isIsAutoCreateEntries()) {
            return;
        }
        if (!this.soluExecuteParam.getAdjustSolu().isIsCopyShiftEntries()) {
            return;
        }
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt.AdjustQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)queryPK);
        int[] yearAndPeriod = null;
        int periodOff = this.soluExecuteParam.getAdjustSolu().getShiftValue();
        PeriodCollection periods = null;
        if (this.soluExecuteParam.isMergeByFiscalPeriod()) {
            periods = FiscalPeriodHelper.getPeriodCollection(this.ctx, this.soluExecuteParam.getSoluInfo().getOrgBound());
        }
        yearAndPeriod = periodOff == -1 ? FastMergeUtil.getPrePeriod(this.ctx, this.soluExecuteParam.isMergeByFiscalPeriod(), this.soluExecuteParam.getSoluInfo().getOrgBound(), this.soluExecuteParam.getYear(), this.soluExecuteParam.getPeriod(), RptPeriodTypeEnum.getEnum((int)this.soluExecuteParam.getPeriodType())) : FiscalPeriodHelper.getRptFormualYearAndPeriod(periods, this.soluExecuteParam.getYear(), this.soluExecuteParam.getPeriod(), this.soluExecuteParam.getPeriodType(), 0, periodOff, this.soluExecuteParam.isMergeByFiscalPeriod(), true);
        FullOrgUnitCollection orgUnits = null;
        if (orgUnits == null) {
            orgUnits = FastMergeUtil.getAdjustOrgUnits(this.ctx, (IObjectValue)this.curOrgUnit, (IObjectValue)this.soluExecuteParam.getSoluInfo().getOrgBound(), this.soluExecuteParam.isDisplayAdjustRPTMByOrg(), this.soluExecuteParam.getCurUser().getId());
        }
        HashSet<String> orgIds = new HashSet<String>(orgUnits.size());
        for (int i = 0; i < orgUnits.size(); ++i) {
            orgIds.add(orgUnits.get(i).getId().toString());
        }
        orgIds.add(this.curOrgUnit.getId().toString());
        EntityViewInfo view = FastMergeUtil.getCopyHisDataDefaultSolu(this.ctx, this.soluExecuteParam.getSoluInfo().getOrgBound(), yearAndPeriod, this.soluExecuteParam.getPeriodType(), this.soluExecuteParam.isDisplayAdjustRPTMByOrg(), orgIds, this.soluExecuteParam.getAdjustBoundMergeMode().getValue(), (OrgUnitInfo)this.curOrgUnit, this.soluExecuteParam.isSupportOtherDS());
        SelectorItemCollection scoll = new SelectorItemCollection();
        scoll.add(new SelectorItemInfo("id"));
        view.setSelector(scoll);
        exec.setObjectView(view);
        IRowSet rowSet = exec.executeQuery();
        HashSet<String> idSet = new HashSet<String>();
        try {
            while (rowSet.next()) {
                idSet.add(rowSet.getString("id"));
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"copyHisAdjustData()", (Throwable)e);
            throw new SQLDataException(e);
        }
        if (idSet.size() == 0) {
            LOGGER.info((Object)"copyHisAdjustData:Size is 0!");
            return;
        }
        LOGGER.info((Object)("copyHisAdjustData:Size is" + idSet.size()));
        AdjustEntryCopy adjustCopy = new AdjustEntryCopy();
        List<IObjectPK> pks = adjustCopy.copyHisData(this.ctx, this.soluExecuteParam.getSoluInfo().getOrgBound().getId().toString(), this.curOrgUnit.getId().toString(), this.soluExecuteParam.getPeriodType(), this.soluExecuteParam.getYear(), this.soluExecuteParam.getPeriod(), "t_csl_adjust", new ArrayList(idSet), false, (IObjectValue)this.soluExecuteParam.getDataCollInfo());
        if (pks == null || pks.size() == 0) {
            return;
        }
        this.iAdjust.audit(pks);
    }

    private void importFromBaseOrgBound() throws BOSException, EASBizException {
        AdjustCollection adjustCollection;
        if (!this.soluExecuteParam.getAdjustSolu().isIsAutoCreateEntries()) {
            return;
        }
        if (!this.soluExecuteParam.getAdjustSolu().isIsImportFromBase()) {
            return;
        }
        if (this.soluExecuteParam.getSoluInfo().getOrgBound().isBasic()) {
            return;
        }
        String mids = null;
        String adjustModeIds = this.soluExecuteParam.getAdjustSolu().getAdjustModeIds();
        if (!StringUtils.isEmpty((String)adjustModeIds)) {
            mids = "";
            String[] arr = adjustModeIds.split(";");
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    mids = mids + ",";
                }
                mids = mids + "'" + arr[i] + "'";
            }
        }
        if ((adjustCollection = (AdjustCollection)this.iAdjust.getAdjustRecordByBasicBound(this.soluExecuteParam.getPeriod(), this.soluExecuteParam.getYear(), this.soluExecuteParam.getPeriodType(), this.soluExecuteParam.getSoluInfo().getOrgBound().getId().toString(), this.curOrgUnit.getId().toString(), false, mids)) == null || adjustCollection.size() == 0) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < adjustCollection.size(); ++i) {
            ids.add(adjustCollection.get(i).getId().toString());
        }
        AdjustEntryCopy adjustCopy = new AdjustEntryCopy();
        adjustCopy.reSetCopyList(this.ctx, this.soluExecuteParam.getSoluInfo().getOrgBound().getId().toString(), this.curOrgUnit.getId().toString(), this.soluExecuteParam.getPeriodType(), this.soluExecuteParam.getYear(), this.soluExecuteParam.getPeriod(), ids);
        if (!ids.isEmpty()) {
            ids.add("yes");
            List<IObjectPK> pks = adjustCopy.doImportAdjustRecords(this.ctx, ids, this.soluExecuteParam.getSoluInfo().getOrgBound().getId().toString(), (IObjectValue)this.soluExecuteParam.getDataCollInfo());
            this.iAdjust.audit(pks);
        }
    }

    private void createAdjustByAdjTmpAndAudit() throws Exception {
        if (!this.soluExecuteParam.getAdjustSolu().isIsAutoCreateEntries()) {
            return;
        }
        if (this.soluExecuteParam.getAdjustSolu().getAdjustTmpEntries() == null || this.soluExecuteParam.getAdjustSolu().getAdjustTmpEntries().size() == 0) {
            return;
        }
        HashMap<String, Object> valueMap = new HashMap<String, Object>(4);
        valueMap.put("orgBoundId", this.soluExecuteParam.getAdjustSolu().getOrgBound().getId().toString());
        ArrayList<String> tmpIds = new ArrayList<String>();
        for (int i = 0; i < this.soluExecuteParam.getAdjustSolu().getAdjustTmpEntries().size(); ++i) {
            tmpIds.add(this.soluExecuteParam.getAdjustSolu().getAdjustTmpEntries().get(i).getAdjustTmp().getId().toString());
        }
        valueMap.put("adjustTmpTypeIds", tmpIds);
        HashMap paramMap = new HashMap(16);
        RptSrcTypeEnum dataSource = RptSrcTypeEnum.NORMAL;
        FullOrgUnitCollection orgUnits = null;
        if (orgUnits == null) {
            orgUnits = FastMergeUtil.getAdjustOrgUnits(this.ctx, (IObjectValue)this.curOrgUnit, (IObjectValue)this.soluExecuteParam.getAdjustSolu().getOrgBound(), this.soluExecuteParam.isDisplayAdjustRPTMByOrg(), this.soluExecuteParam.getCurUser().getId());
        }
        orgUnits.add(this.curOrgUnit);
        orgUnits = this.getFullOrgUnitAllProperty(orgUnits);
        ArrayList<String> ids = new ArrayList<String>();
        for (int k = 0; k < orgUnits.size(); ++k) {
            BatchImportAdjust ajd = new BatchImportAdjust();
            FullOrgUnitInfo unitInfo = orgUnits.get(k);
            valueMap.put("orgUnitID", unitInfo.getId().toString());
            AdjustTempleCollection templetCollection = this.iAdjust.getCurrentAdjustTemplate(valueMap);
            if (templetCollection == null || templetCollection.size() == 0) continue;
            dataSource = unitInfo.isIsGrouping() ? (this.soluExecuteParam.getSoluInfo().isIsAutoSum() ? RptSrcTypeEnum.SUM : RptSrcTypeEnum.CONSOLIDATION) : RptSrcTypeEnum.NORMAL;
            this.getParamAdjustByAdjTmp(paramMap, unitInfo, dataSource);
            ServiceManagerFactory.getServiceManager().disableService("PERMISSION_SERVICE");
            ArrayList<IObjectPK> idpks = new ArrayList<IObjectPK>();
            for (int s = 0; s < templetCollection.size(); ++s) {
                String templateId = templetCollection.get(s).getId().toString();
                String orgTreeId = this.soluExecuteParam.getAdjustSolu().getOrgBound().getId().toString();
                int year = this.soluExecuteParam.getYear();
                int period = this.soluExecuteParam.getPeriod();
                int periodType = this.soluExecuteParam.getPeriodType();
                String currency = this.soluExecuteParam.getSoluInfo().getCurrency().getId().toString();
                if (this.iAdjust.isHaveAdjustDataByTemp(templateId, orgTreeId, periodType, year, period, unitInfo.getId().toString(), currency, currency)) continue;
                this.iAdjust.delUnAuditAdjustDataByTemp(templateId, orgTreeId, periodType, year, period, unitInfo.getId().toString(), currency, currency);
                ids.clear();
                ids.add(templetCollection.get(s).getId().toString());
                idpks.addAll(ajd.doTemplateBatchImportAdjustRecords(this.ctx, ids, paramMap));
            }
            if (idpks.size() == 0) {
                LOGGER.info((Object)" no create Adjust Record");
                continue;
            }
            this.iAdjust.audit(idpks);
        }
        paramMap.clear();
        paramMap = null;
        valueMap.clear();
    }

    private FullOrgUnitCollection getFullOrgUnitAllProperty(FullOrgUnitCollection orgUnits) throws BOSException, EASBizException {
        if (orgUnits == null || orgUnits.size() == 0) {
            return new FullOrgUnitCollection();
        }
        HashSet<String> idSet = new HashSet<String>(orgUnits.size());
        for (int i = 0; i < orgUnits.size(); ++i) {
            idSet.add(orgUnits.get(i).getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItem0 = new FilterItemInfo("id", idSet, CompareType.INCLUDE);
        filterInfo.getFilterItems().add(filterItem0);
        evi.setFilter(filterInfo);
        evi.getSelector().add(new SelectorItemInfo("*"));
        return FullOrgUnitFactory.getLocalInstance((Context)this.ctx).getFullOrgUnitCollection(evi);
    }

    private void getParamAdjustByAdjTmp(Map paramMap, FullOrgUnitInfo fullOrgUnit, RptSrcTypeEnum dataSource) {
        paramMap.put("orgTreeID", this.soluExecuteParam.getAdjustSolu().getOrgBound().getId().toString());
        paramMap.put("fullOrgUnit", fullOrgUnit);
        paramMap.put("companyOrgUnit", fullOrgUnit);
        paramMap.put("sourceCurrency", this.soluExecuteParam.getSoluInfo().getCurrency());
        paramMap.put("currency", this.soluExecuteParam.getSoluInfo().getCurrency());
        paramMap.put("dpkAdjustDate", this.soluExecuteParam.getReportDate());
        paramMap.put("dpkCreateTime", new Date());
        paramMap.put("comboDataSource", dataSource);
        paramMap.put("periodType", this.soluExecuteParam.getPeriodType());
        paramMap.put("year", this.soluExecuteParam.getYear());
        paramMap.put("period", this.soluExecuteParam.getPeriod());
        paramMap.put("OrgBound", this.soluExecuteParam.getAdjustSolu().getOrgBound());
    }

    public IObjectCollection getExistAdjustData() throws BOSException, EASBizException {
        AdjustTypeEntriesCollection typeColl;
        if (this.soluExecuteParam.getAdjustSolu() == null) {
            return null;
        }
        if (!this.soluExecuteParam.getAdjustSolu().isIsRelateExistData()) {
            return null;
        }
        String importTreeId = this.soluExecuteParam.getSoluInfo().getOrgBound().getId().toString();
        String sourceTreeId = this.soluExecuteParam.getAdjustSolu().getOrgBound().getId().toString();
        int period = this.soluExecuteParam.getPeriod();
        int year = this.soluExecuteParam.getYear();
        int periodType = this.soluExecuteParam.getPeriodType();
        String orgUnitId = this.curOrgUnit.getId().toString();
        boolean isForBugetBound = this.soluExecuteParam.getAdjustSolu().getOrgBound().isIsForBudget();
        String adjustModeIds = null;
        if (this.soluExecuteParam.getAdjustSolu().isIsRelateExistData() && (typeColl = this.soluExecuteParam.getAdjustSolu().getAdjustTypeEntries()).size() > 0) {
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < typeColl.size(); ++i) {
                String typeId = typeColl.get(i).getAdjustType().getId().toString();
                sbuf.append("'").append(typeId).append("'").append(",");
            }
            sbuf.deleteCharAt(sbuf.lastIndexOf(","));
            adjustModeIds = sbuf.toString();
        }
        return this.iAdjust.getAdjustRecordByBasicBound(period, year, periodType, sourceTreeId, importTreeId, orgUnitId, isForBugetBound, adjustModeIds);
    }
}

