/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.util;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptQuerySoluInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.report.CslReportProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeTemplateCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeTemplateInfo;
import com.kingdee.eas.fi.gr.fast.biz.AutoCslRptExecute;
import com.kingdee.eas.fi.gr.fast.biz.AutoMnsRptExecute;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.enums.IntEnum;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MergeReportCenterBatchCalcHelper {
    private static Logger logger = Logger.getLogger(MergeReportCenterBatchCalcHelper.class);
    private KDTree treeMain = null;
    private KDTable tblMain = null;
    private String solutId = null;
    private FastMergeSoluInfo soluInfo = null;
    private DynaSumMethodEnum defaultDySumMethod = DynaSumMethodEnum.SUM_BY_NAME;
    private List<Integer> calSoluType = new ArrayList<Integer>();
    private Map<String, CslRptQuerySoluInfo[]> orgUnit_querySoluInfo = new HashMap<String, CslRptQuerySoluInfo[]>();
    private List<IRow> sortReportRowList = null;
    private int curWorkIndex = 0;
    private String curCalcReportInfo = "";
    private StringBuffer failReportInfoStr = new StringBuffer();
    private int workCount = 0;
    private int failWorkCount = 0;
    private boolean isSumRpt = false;

    public MergeReportCenterBatchCalcHelper(KDTree treeMain, KDTable tblMain, String solutId) {
        this.treeMain = treeMain;
        this.tblMain = tblMain;
        this.solutId = solutId;
    }

    public int getWorkCount() throws Exception {
        Map<String, Integer> orgUnitLevelMap = null;
        try {
            orgUnitLevelMap = this.getOrgUnitLevel();
            this.sortReportRowList = this.getSortReportRowList(orgUnitLevelMap);
            int n = this.workCount = this.sortReportRowList.size();
            return n;
        }
        catch (Exception e) {
            logger.error((Object)"initWorkParam error", (Throwable)e);
            throw e;
        }
        finally {
            if (orgUnitLevelMap != null) {
                orgUnitLevelMap.clear();
            }
        }
    }

    public void batchCalc() throws Exception {
        try {
            if (this.sortReportRowList != null) {
                this.initFastMergeSoluInfo();
                int batchSize = 15;
                LinkedHashMap<String, CslReportInfo> cslReportMap = new LinkedHashMap<String, CslReportInfo>();
                for (IRow row : this.sortReportRowList) {
                    if (cslReportMap.size() >= batchSize) {
                        this.batchCalcReports(cslReportMap);
                        cslReportMap.clear();
                    }
                    cslReportMap.put((String)row.getCell("id").getValue(), null);
                }
                if (cslReportMap.size() > 0) {
                    this.batchCalcReports(cslReportMap);
                    cslReportMap.clear();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"batchCalc error", (Throwable)e);
            throw e;
        }
    }

    private void batchCalcReports(Map<String, CslReportInfo> cslReportMap) throws Exception {
        if (!cslReportMap.isEmpty()) {
            this.initCslReportMap(cslReportMap);
            long startTime = 0L;
            for (String id : cslReportMap.keySet()) {
                startTime = System.currentTimeMillis();
                this.calcReport(cslReportMap.get(id));
                if (!DebugLogger.isDebug) continue;
                logger.info((Object)("report[number:" + cslReportMap.get(id).getNumber() + ";name:" + cslReportMap.get(id).getName() + ";time:" + (System.currentTimeMillis() - startTime)));
            }
        }
    }

    private void initCslReportMap(Map<String, CslReportInfo> cslReportMap) throws Exception {
        if (!cslReportMap.isEmpty()) {
            SelectorItemCollection selector = new CslReportProvider().getSelectors();
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(cslReportMap.keySet()), CompareType.INCLUDE));
            view.setSelector(selector);
            CslReportCollection coll = CslReportFactory.getRemoteInstance().getCslReportCollection(view);
            CslReportInfo info = null;
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                cslReportMap.put(info.getId().toString(), info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcReport(CslReportInfo cslReportInfo) throws Exception {
        try {
            this.curCalcReportInfo = "[" + cslReportInfo.getName() + "(" + cslReportInfo.getOrgUnit().getName() + ")]";
            String orgUnitNumber = cslReportInfo.getOrgUnit().getNumber();
            CslRptQuerySoluInfo[] querySoluInfoArr = this.orgUnit_querySoluInfo.get(orgUnitNumber);
            if (querySoluInfoArr == null) {
                FastMergeOrgUnitInfo fastMergeOrgUnitInfo = FastMergeUtil.getCslRptFastMergeOrgUnitInfo(this.soluInfo, cslReportInfo);
                int[] type = new int[this.calSoluType.size()];
                for (int i = 0; i < this.calSoluType.size(); ++i) {
                    type[i] = this.calSoluType.get(i);
                }
                querySoluInfoArr = FastMergeUtil.getCslRptQuerySoluInfos(null, this.soluInfo.getOrgBound(), cslReportInfo.getOrgUnit().getId().toString(), fastMergeOrgUnitInfo, this.defaultDySumMethod, type);
                this.orgUnit_querySoluInfo.clear();
                this.orgUnit_querySoluInfo.put(orgUnitNumber, querySoluInfoArr);
            }
            FastMergeUtil.requestBizObjIDForUpdate(null, cslReportInfo.getId().toString());
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            if (cslReportInfo.getSourceType().equals((Object)RptSrcTypeEnum.MANUSCRIPT) || cslReportInfo.getSourceType().equals((Object)RptSrcTypeEnum.MANUSCRIPT_FASTMERGE)) {
                AutoMnsRptExecute mnsRptExecute = new AutoMnsRptExecute();
                mnsRptExecute.initForCalAndSave(cslReportInfo, this.soluInfo, querySoluInfoArr[this.calSoluType.indexOf(1)], querySoluInfoArr[this.calSoluType.indexOf(3)], userId);
                mnsRptExecute.calcAndSave();
            }
            CslRptQuerySoluInfo querySoluInfo = null;
            if (cslReportInfo.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION) || cslReportInfo.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION_FASTMERGE)) {
                querySoluInfo = querySoluInfoArr[this.calSoluType.indexOf(1)];
            } else if (cslReportInfo.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || cslReportInfo.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE)) {
                querySoluInfo = querySoluInfoArr[this.calSoluType.indexOf(2)];
            }
            if (querySoluInfo != null) {
                AutoCslRptExecute cslRptExecute = new AutoCslRptExecute(null);
                cslRptExecute.initForCalAndSave(cslReportInfo, this.soluInfo, querySoluInfo, this.defaultDySumMethod, userId);
                cslRptExecute.calcAndSave();
            }
        }
        catch (Exception e) {
            logger.error((Object)("report [OrgUnitnumber:" + cslReportInfo.getOrgUnit().getNumber() + ";name:" + cslReportInfo.getName() + "] error."), (Throwable)e);
            this.failReportInfoStr.append(cslReportInfo.getOrgUnit().getName()).append("[").append(cslReportInfo.getName()).append("] \n");
            ++this.failWorkCount;
        }
        finally {
            FastMergeUtil.releaseObjIDForUpdate(null, cslReportInfo.getId().toString());
            ++this.curWorkIndex;
        }
    }

    private List<IRow> getSortReportRowList(final Map<String, Integer> orgUnitLevelMap) throws Exception {
        ArrayList<IRow> reportRowList = new ArrayList<IRow>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            Boolean chooseValue = (Boolean)row.getCell("select").getValue();
            IntEnum auditedStatusEnum = (IntEnum)row.getCell("auditedStatus").getValue();
            IntEnum committedStatus = (IntEnum)row.getCell("committedStatus").getValue();
            if (!chooseValue.booleanValue() || 1 != auditedStatusEnum.getValue() || 1 != committedStatus.getValue()) continue;
            reportRowList.add(row);
        }
        if (!reportRowList.isEmpty()) {
            Collections.sort(reportRowList, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    IRow info1 = (IRow)arg0;
                    IRow info2 = (IRow)arg1;
                    Integer level1 = (Integer)orgUnitLevelMap.get((String)info1.getCell("companyNumber").getValue());
                    Integer level2 = (Integer)orgUnitLevelMap.get((String)info2.getCell("companyNumber").getValue());
                    int result = level2.compareTo(level1);
                    if (result == 0) {
                        RptSrcTypeEnum srcType1 = (RptSrcTypeEnum)info1.getCell("sourceType").getValue();
                        RptSrcTypeEnum srcType2 = (RptSrcTypeEnum)info2.getCell("sourceType").getValue();
                        if (RptSrcTypeEnum.MANUSCRIPT.equals((Object)srcType2) || RptSrcTypeEnum.MANUSCRIPT_FASTMERGE.equals((Object)srcType2)) {
                            return 1;
                        }
                        if (RptSrcTypeEnum.MANUSCRIPT.equals((Object)srcType1) || RptSrcTypeEnum.MANUSCRIPT_FASTMERGE.equals((Object)srcType1)) {
                            return -1;
                        }
                    }
                    return result;
                }
            });
        }
        return reportRowList;
    }

    private Map<String, Integer> getOrgUnitLevel() {
        HashMap<String, Integer> orgUnitLevelMap = new HashMap<String, Integer>();
        DefaultKingdeeTreeNode currentNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        OrgStructureInfo orgStructure = null;
        if (currentNode == null) {
            return orgUnitLevelMap;
        }
        if (currentNode != null && currentNode.getUserObject() != null && currentNode.getUserObject() instanceof OrgStructureInfo) {
            orgStructure = (OrgStructureInfo)currentNode.getUserObject();
            if (orgStructure != null) {
                orgUnitLevelMap.put(orgStructure.getUnit().getNumber(), orgStructure.getLevel());
            }
            this.getChildOrgUnitLevel(currentNode, orgUnitLevelMap);
        }
        return orgUnitLevelMap;
    }

    private void getChildOrgUnitLevel(DefaultKingdeeTreeNode parentNode, Map<String, Integer> orgUnitLevelMap) {
        DefaultKingdeeTreeNode currentNode = null;
        OrgStructureInfo orgStructure = null;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            currentNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            if (currentNode == null || currentNode.getUserObject() == null || !(currentNode.getUserObject() instanceof OrgStructureInfo)) continue;
            orgStructure = (OrgStructureInfo)currentNode.getUserObject();
            if (orgStructure != null) {
                orgUnitLevelMap.put(orgStructure.getUnit().getNumber(), orgStructure.getLevel());
            }
            this.getChildOrgUnitLevel(currentNode, orgUnitLevelMap);
        }
    }

    private void initFastMergeSoluInfo() throws Exception {
        Object[] dynaSumMethods;
        this.soluInfo = FastMergeUtil.getFastMergeSoluInfo(null, this.solutId, true);
        FastMergeTemplateCollection coll = this.soluInfo.getTemplates();
        FastMergeTemplateInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (RptTmpTypeEnum.MANUSCRIPT.equals((Object)info.getTemplate().getTemplateType())) {
                if (!this.calSoluType.contains(3)) {
                    this.calSoluType.add(3);
                }
                if (this.calSoluType.contains(1)) continue;
                this.calSoluType.add(1);
                continue;
            }
            if (RptTmpTypeEnum.DYNAMICCSLREPORT.equals((Object)info.getTemplate().getTemplateType())) {
                if (this.calSoluType.contains(2)) continue;
                this.calSoluType.add(2);
                continue;
            }
            if (RptTmpTypeEnum.CSLREPORT.equals((Object)info.getTemplate().getTemplateType())) {
                if (this.calSoluType.contains(1)) continue;
                this.calSoluType.add(1);
                continue;
            }
            if (!RptTmpTypeEnum.SUMREPORT.equals((Object)info.getTemplate().getTemplateType())) continue;
            this.isSumRpt = true;
            SysUtil.abort();
        }
        if (this.calSoluType.contains(2) && (dynaSumMethods = CSLParamUtil.getDynaSumMethod(null)) != null && dynaSumMethods.length > 0 && dynaSumMethods[0] instanceof DynaSumMethodEnum) {
            this.defaultDySumMethod = (DynaSumMethodEnum)((Object)dynaSumMethods[0]);
        }
    }

    public int getCurWorkIndex() {
        return this.curWorkIndex;
    }

    public String getCurCalcReportInfo() {
        return this.curCalcReportInfo;
    }

    public String getTotleResultInfo() {
        return MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.fast.FastMergeResource", (String)"66_calcReportResult"), this.workCount - this.failWorkCount, this.failWorkCount);
    }

    public String getErrorResultInfo() {
        StringBuffer sb = new StringBuffer();
        if (this.failWorkCount > 0) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.fast.FastMergeResource", (String)"67_failedReportList")).append("\n");
            sb.append(this.failReportInfoStr);
        }
        return sb.toString();
    }

    public boolean isSumRpt() {
        return this.isSumRpt;
    }

    public void setSumRpt(boolean isSumRpt) {
        this.isSumRpt = isSumRpt;
    }

    public void setWorkCount(int workCount) {
        this.workCount = workCount;
    }

    public StringBuffer getFailReportInfoStr() {
        return this.failReportInfoStr;
    }

    public void setFailReportInfoStr(StringBuffer failReportInfoStr) {
        this.failReportInfoStr = failReportInfoStr;
    }

    public int getFailWorkCount() {
        return this.failWorkCount;
    }

    public void setFailWorkCount(int failWorkCount) {
        this.failWorkCount = failWorkCount;
    }
}

