/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslParamFactory;
import com.kingdee.eas.fi.gr.mobile.DCAmountEnum;
import com.kingdee.eas.fi.gr.mobile.DCCurYearCumulative;
import com.kingdee.eas.fi.gr.mobile.DCEndingBalance;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class MobileUtil {
    public static boolean isDebug = false;
    public static final String MOBILE_COMMON_RESOURCE_PATH = "com.kingdee.eas.fi.gr.mobile.MobileCommonResource";
    private String isDemo = null;

    private String getDemoParamValue(Context ctx) {
        if (this.isDemo == null) {
            try {
                this.isDemo = ctx == null ? CslParamFactory.getRemoteInstance().getParam("KEY_CSLPARAM_ISDEMO") : CslParamFactory.getLocalInstance(ctx).getParam("KEY_CSLPARAM_ISDEMO");
                if (StringUtils.isEmpty((String)this.isDemo)) {
                    this.isDemo = "false";
                }
            }
            catch (Exception e) {
                return "false";
            }
        }
        return this.isDemo;
    }

    public boolean isDemo(Context ctx) {
        return "true".equalsIgnoreCase(this.getDemoParamValue(ctx));
    }

    public static void debugLog(Logger logger, Object message) {
        if (logger.isDebugEnabled() || isDebug) {
            logger.error(message);
        }
    }

    public static List<String> getSimpleColumnNameList(Context ctx, String[] dtNos) {
        ArrayList<String> result = new ArrayList<String>();
        if (dtNos == null) {
            return result;
        }
        for (int i = 0; i < dtNos.length; ++i) {
            String dtNumber = dtNos[i];
            String simpleName = "";
            if ("currentAmount".equals(dtNumber)) {
                simpleName = MobileUtil.getMultiResourceByName("17_currentNumber");
            } else if ("priorPeriodAmount".equals(dtNumber)) {
                simpleName = MobileUtil.getMultiResourceByName("18_sequentialNumber");
            } else if ("theSamePeriodLastYear".equals(dtNumber)) {
                simpleName = MobileUtil.getMultiResourceByName("19_sameRateNumber");
            } else if ("yearBeginAmount".equals(dtNumber)) {
                simpleName = MobileUtil.getMultiResourceByName("20_yearInitNumber");
            } else if ("budgetAmount".equals(dtNumber)) {
                simpleName = MobileUtil.getMultiResourceByName("21_budgetNumber");
            } else if ("yoyGrowthRate".equals(dtNumber)) {
                simpleName = MobileUtil.getMultiResourceByName("22_sameRateIncre");
            } else if ("momGrowthRate".equals(dtNumber)) {
                simpleName = MobileUtil.getMultiResourceByName("23_sequentialIncre");
            } else if ("bgCompletionRate".equals(dtNumber)) {
                simpleName = MobileUtil.getMultiResourceByName("24_budgetFinish");
            } else if ("changeAmount".equals(dtNumber)) {
                simpleName = MobileUtil.getMultiResourceByName("25_yearInitChange");
            } else if ("yoyChangeAmount".equals(dtNumber)) {
                simpleName = MobileUtil.getMultiResourceByName("26_sameRateChange");
            } else if ("momChangeAmount".equals(dtNumber)) {
                simpleName = MobileUtil.getMultiResourceByName("27_sequentialChange");
            }
            result.add(simpleName);
        }
        return result;
    }

    public String getFormatDataTypeName(Context ctx, int dataElement, String dataType) {
        String result = "";
        switch (dataElement) {
            case 1: {
                if (DCAmountEnum.currentAmount.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("17_currentNumber");
                    break;
                }
                if (DCAmountEnum.priorPeriodAmount.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("18_sequentialNumber");
                    break;
                }
                if (DCAmountEnum.theSamePeriodLastYear.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("19_sameRateNumber");
                    break;
                }
                if (DCAmountEnum.budgetAmount.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("21_budgetNumber");
                    break;
                }
                if (DCAmountEnum.yoyGrowthRate.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("22_sameRateIncre");
                    break;
                }
                if (DCAmountEnum.momGrowthRate.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("23_sequentialIncre");
                    break;
                }
                if (DCAmountEnum.bgCompletionRate.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("24_budgetFinish");
                    break;
                }
                if (DCAmountEnum.yoyChangeAmount.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("26_sameRateChange");
                    break;
                }
                if (!DCAmountEnum.momChangeAmount.getName().equals(dataType)) break;
                result = MobileUtil.getMultiResourceByName("27_sequentialChange");
                break;
            }
            case 2: {
                if (DCCurYearCumulative.currentAmount.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("17_currentNumber");
                    break;
                }
                if (DCCurYearCumulative.theSamePeriodLastYear.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("19_sameRateNumber");
                    break;
                }
                if (DCCurYearCumulative.budgetAmount.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("21_budgetNumber");
                    break;
                }
                if (DCCurYearCumulative.yoyGrowthRate.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("22_sameRateIncre");
                    break;
                }
                if (DCCurYearCumulative.bgCompletionRate.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("24_budgetFinish");
                    break;
                }
                if (!DCCurYearCumulative.yoyChangeAmount.getName().equals(dataType)) break;
                result = MobileUtil.getMultiResourceByName("26_sameRateChange");
                break;
            }
            case 3: {
                if (DCEndingBalance.currentAmount.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("17_currentNumber");
                    break;
                }
                if (DCEndingBalance.priorPeriodAmount.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("18_sequentialNumber");
                    break;
                }
                if (DCEndingBalance.theSamePeriodLastYear.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("19_sameRateNumber");
                    break;
                }
                if (DCEndingBalance.yearBeginAmount.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("20_yearInitNumber");
                    break;
                }
                if (DCEndingBalance.budgetAmount.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("21_budgetNumber");
                    break;
                }
                if (DCEndingBalance.yoyGrowthRate.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("22_sameRateIncre");
                    break;
                }
                if (DCEndingBalance.momGrowthRate.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("23_sequentialIncre");
                    break;
                }
                if (DCEndingBalance.bgCompletionRate.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("24_budgetFinish");
                    break;
                }
                if (DCEndingBalance.changeAmount.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("25_yearInitChange");
                    break;
                }
                if (DCEndingBalance.yoyChangeAmount.getName().equals(dataType)) {
                    result = MobileUtil.getMultiResourceByName("26_sameRateChange");
                    break;
                }
                if (!DCEndingBalance.momChangeAmount.getName().equals(dataType)) break;
                result = MobileUtil.getMultiResourceByName("27_sequentialChange");
                break;
            }
        }
        return result;
    }

    public String getDataTypeNameByValue(Context ctx, int dataElement, String dataType) {
        boolean isDemo = this.isDemo(ctx);
        String result = "";
        switch (dataElement) {
            case 1: {
                return DCAmountEnum.getEnum(dataType + "").getAlias();
            }
            case 2: {
                if (isDemo && String.valueOf(dataType).equals("1")) {
                    return MobileUtil.getMultiResourceByName("28_benchMarking");
                }
                if (isDemo && String.valueOf(dataType).equals("0")) {
                    return MobileUtil.getMultiResourceByName("29_currentYear");
                }
                return DCCurYearCumulative.getEnum(dataType + "").getAlias();
            }
            case 3: {
                return DCEndingBalance.getEnum(dataType + "").getAlias();
            }
        }
        return result;
    }

    public static void checkCUPermission(String cuId, List<JComponent> jComponents) {
        if (cuId != null) {
            String curCuId = MobileUtil.getCurrentCompanyOrgUnitId();
            for (JComponent cuJC : jComponents) {
                cuJC.setEnabled(cuId.equals(curCuId));
            }
        }
    }

    public static String getString(String resClassName, String resName, Object[] params) {
        String s = EASResource.getString((String)resClassName, (String)resName);
        MessageFormat mf = new MessageFormat(s);
        String result = mf.format(params);
        return result;
    }

    public static String getMultiResourceByName(String name) {
        return EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)name);
    }

    public static void addGradeManageFilter(EntityViewInfo mainQuery) throws Exception {
        FilterInfo filter;
        FilterInfo gradeInfo = MobileUtil.getGradeSettingFilter();
        if (gradeInfo.getFilterItems().size() == 0) {
            gradeInfo.getFilterItems().add(new FilterItemInfo("trackRecordCreator.id", (Object)"0", CompareType.NOTEQUALS));
        }
        if ((filter = mainQuery.getFilter()) == null) {
            mainQuery.setFilter(gradeInfo);
            return;
        }
        boolean find = false;
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!"trackRecordCreator.id".equalsIgnoreCase(item.getPropertyName())) continue;
            item.setCompareValue(gradeInfo.getFilterItems().get(0).getCompareValue());
            item.setCompareType(gradeInfo.getFilterItems().get(0).getCompareType());
            find = true;
            break;
        }
        if (!find) {
            mainQuery.getFilter().mergeFilter(gradeInfo, "AND");
        }
    }

    public static FilterInfo getGradeSettingFilter() throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        String orgUnitId = MobileUtil.getCurrentCompanyOrgUnitId();
        MobileUtil.filteData(filterInfo, "trackRecordCreator.id", orgUnitId);
        return filterInfo;
    }

    public static String getCurrentCompanyOrgUnitId() {
        return SysContext.getSysContext().getCurrentFIUnit().getId().toString();
    }

    private static void filteData(FilterInfo filterInfo, String CreateOrgKey, String orgUnitId) throws BOSException, ParserException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tree.type", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("longNumber"));
        view.setSelector(coll);
        String longNumber = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(view).get(0).getLongNumber();
        String upSql = MobileUtil.getUpSql(longNumber);
        FilterInfo upFilter = new FilterInfo(CreateOrgKey + " in (" + upSql + ")");
        filterInfo.mergeFilter(upFilter, "and");
    }

    private static String getUpSql(String longNumber) {
        String longNumberCondition = MobileUtil.getUpAndSelfLongNumbersSqlCondition(longNumber);
        String subSql = "SELECT tos.FUnitId from T_ORG_Structure tos  INNER JOIN T_ORG_Tree tot  ON tos.FTreeId = tot.fid  WHERE tos.FLongNumber IN (" + longNumberCondition + ")  AND tot.FTYPE = " + 1;
        return subSql;
    }

    private static String getUpAndSelfLongNumbersSqlCondition(String longNumber) {
        String orgLongNumbers = "";
        String[] arr = longNumber.split("!");
        for (int i = arr.length - 1; i >= 0; --i) {
            String tempLongNumber = "";
            for (int j = 0; j <= i; ++j) {
                if (j > 0) {
                    tempLongNumber = tempLongNumber + "!";
                }
                tempLongNumber = tempLongNumber + arr[j];
            }
            orgLongNumbers = i == arr.length - 1 ? orgLongNumbers + "'" + tempLongNumber + "'" : orgLongNumbers + ",'" + tempLongNumber + "'";
        }
        return orgLongNumbers;
    }
}

