/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.mobile.DCAmountEnum;
import com.kingdee.eas.fi.gr.mobile.DCEndingBalance;
import com.kingdee.eas.fi.gr.mobile.IIndexAnalysis;
import com.kingdee.eas.fi.gr.mobile.IIndexAnalysisData;
import com.kingdee.eas.fi.gr.mobile.IIndexAnalysisEntry;
import com.kingdee.eas.fi.gr.mobile.IIndexAnalysisSchemeEntry;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisCollection;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisDataFactory;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisDataInfo;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisEntryCollection;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisEntryFactory;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisEntryInfo;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisFactory;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisInfo;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeEntryFactory;
import com.kingdee.eas.fi.gr.mobile.IndexDataElementEnum;
import com.kingdee.eas.fi.gr.mobile.IndexTypeInfo;
import com.kingdee.eas.fi.gr.mobile.MobileUtil;
import com.kingdee.eas.fi.gr.mobile.OrgTreeMapingCollection;
import com.kingdee.eas.fi.gr.mobile.OrgTreeMapingFactory;
import com.kingdee.eas.fi.gr.mobile.OrgTreeMapingInfo;
import com.kingdee.eas.fi.gr.mobile.app.AbstractIndexTypeControllerBean;
import com.kingdee.eas.fi.gr.mobile.app.ReportFormulaFacade;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.PsSql;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class IndexTypeControllerBean
extends AbstractIndexTypeControllerBean {
    private static final long serialVersionUID = -4472860223450348666L;
    private static Logger logger = Logger.getLogger((String)IndexTypeControllerBean.class.getName());
    private static final String Str_NotApplicable = "N/A";

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IIndexAnalysisData itf = IndexAnalysisDataFactory.getLocalInstance(ctx);
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("indexAnalysisEntry.indexAnalysis.indexType.id", (Object)pk.toString()));
        itf.delete(filter2);
        IIndexAnalysis iIndexAnalysis = IndexAnalysisFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("indextype.id", (Object)pk.toString(), CompareType.EQUALS));
        iIndexAnalysis.delete(filter);
        IIndexAnalysisSchemeEntry iIndexAnalysisSchemeEntry = IndexAnalysisSchemeEntryFactory.getLocalInstance(ctx);
        FilterInfo filter3 = new FilterInfo();
        filter3.getFilterItems().add(new FilterItemInfo("indexType.id", (Object)pk.toString(), CompareType.EQUALS));
        iIndexAnalysisSchemeEntry.delete(filter3);
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT s.FId,count(e.FId) FROM T_CSL_IndexAnalysisScheme s ");
            buffer.append("LEFT JOIN T_CSL_IndexAnalysisSchemeEntry e ON s.FId = e.FSchemeId WHERE 1 = 1 ");
            buffer.append("GROUP BY s.FId ");
            buffer.append("HAVING count(e.fid) = 0");
            IRowSet s = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
            StringBuffer sid = new StringBuffer();
            while (s.next()) {
                sid.append("'").append(s.getString("FId")).append("',");
            }
            if (sid.length() != 0) {
                buffer.setLength(0);
                buffer.append("DELETE FROM T_CSL_IndexAnalysisScheme WHERE FId IN (" + sid.substring(0, sid.length() - 1) + ")");
                DbUtil.execute((Context)ctx, (String)buffer.toString());
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected Map _calculate(Context ctx, String indexTypeID, int year, int period, int periodType, boolean is13Period) throws BOSException, EASBizException {
        IndexTypeInfo info = this.getIndexTypeInfoByID(ctx, indexTypeID);
        IndexAnalysisCollection indexCol = this.getIndexAnalysisCollectionByIndexTypeID(ctx, indexTypeID);
        String treeId = info.getOrgBound().getId().toString();
        Date date = RPTDateUtil.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType));
        treeId = this.getTreeIdByNumberAndDate(ctx, date, treeId);
        if (StringUtils.isEmpty((String)treeId)) {
            return null;
        }
        Map<String, OrgTreeMapingInfo> orgTreeMapingMap = this.getOrgTreeMapingMap(ctx, treeId, info.getOrgBound().getNumber());
        List<IndexAnalysisDataInfo> baseResult = this.getCalculateResultInfo(ctx, treeId, info, year, period, periodType, orgTreeMapingMap, is13Period);
        int size = baseResult.size();
        List<Object> amountResult = new ArrayList<Object>(Arrays.asList(new Object[size]));
        Collections.copy(amountResult, baseResult);
        amountResult = this.getOtherAmount(ctx, treeId, info, indexCol, baseResult, amountResult, year, period, periodType);
        if (amountResult != null && amountResult.size() > 0) {
            this.refreshData(ctx, amountResult, indexTypeID, info.getOrgBound().getNumber(), year, period, periodType);
        }
        this.updateIndexTypeInfo(ctx, info, year, period);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("state", "success");
        resultMap.put("account", amountResult.size());
        return resultMap;
    }

    @Override
    protected Map _getIndexCalcGuideInfo(Context ctx, Map param) throws BOSException {
        HashMap<String, Object> result = null;
        Object temp = null;
        temp = param.get("indexTypeId");
        String indexTypeId = temp == null ? "" : temp.toString();
        temp = param.get("year");
        int year = temp == null ? 0 : Integer.parseInt(temp.toString());
        temp = param.get("period");
        int period = temp == null ? 0 : Integer.parseInt(temp.toString());
        SQLBuilder buffer = new SQLBuilder();
        buffer.append("SELECT * FROM T_CSL_IndexCalcGuide ");
        buffer.append(" WHERE FIndexTypeId = ?", (Object)indexTypeId);
        buffer.append("  AND FYear = ?", (Object)year);
        buffer.append("  AND FPeriod = ?", (Object)period);
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])buffer.getParams());
            if (rowSet.next()) {
                result = new HashMap<String, Object>();
                result.put("id", rowSet.getString("FId"));
                result.put("indexTypeId", rowSet.getString("FIndexTypeId"));
                result.put("period", rowSet.getInt("FPeriod"));
                result.put("year", rowSet.getInt("FYear"));
                result.put("is13Period", rowSet.getBoolean("FIs13Period"));
                result.put("suffix", rowSet.getString("FSuffix"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private String getTreeIdByNumberAndDate(Context ctx, Date date, String treeId) throws BOSException {
        SQLBuilder buffer = new SQLBuilder();
        Timestamp ts = new Timestamp(date.getTime());
        buffer.append("SELECT FId FROM T_ORG_Tree ");
        buffer.append(" WHERE FNumber = (SELECT FNumber FROM T_ORG_Tree WHERE FId=?)", (Object)treeId);
        buffer.append("   AND ((FStatus = 2 AND FStartDate <= ? ", (Object)ts);
        buffer.append("        AND FEndDate >= ?) ", (Object)ts);
        buffer.append("    OR (FStatus = 1 AND FStartDate <= ?))", (Object)ts);
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])buffer.getParams());
            if (rowSet.next()) {
                return rowSet.getString("FId");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private void updateIndexTypeInfo(Context ctx, IndexTypeInfo itInfo, int year, int period) throws EASBizException, BOSException {
        Timestamp t = itInfo.getLastCalcTime();
        if (t != null) {
            Calendar c1 = Calendar.getInstance();
            c1.setTimeInMillis(t.getTime());
            Calendar c3 = Calendar.getInstance();
            Calendar c4 = Calendar.getInstance();
            c3.set(1, c1.get(1));
            c3.set(2, c1.get(2));
            c4.set(1, year);
            c4.set(2, period - 1);
            if (!c4.after(c3)) {
                return;
            }
        }
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, period - 1);
        Timestamp ts = new Timestamp(c.getTimeInMillis());
        IndexTypeInfo info = new IndexTypeInfo();
        info.setId(itInfo.getId());
        info.setLastCalcTime(ts);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("lastCalcTime");
        this.updatePartial(ctx, (CoreBaseInfo)info, selector);
    }

    private Map<String, OrgTreeMapingInfo> getOrgTreeMapingMap(Context ctx, String treeId, String orgTreeNumber) throws EASBizException, BOSException {
        OrgTreeMapingCollection colls;
        HashMap<String, OrgTreeMapingInfo> orgTreeMapingMap = null;
        if (orgTreeNumber != null && (colls = OrgTreeMapingFactory.getLocalInstance(ctx).getOrgTreeMapingCollection("select targetOrgUnitNumber,srcOrgTreeNumber,srcOrgUnitNumber where targetOrgTreeNumber='" + orgTreeNumber + "'")) != null && colls.size() > 0) {
            orgTreeMapingMap = new HashMap<String, OrgTreeMapingInfo>();
            for (int i = 0; i < colls.size(); ++i) {
                orgTreeMapingMap.put(colls.get(i).getTargetOrgUnitNumber(), colls.get(i));
            }
            OrgStructureCollection col = this.getTargetOrgUnit(ctx, treeId);
            OrgStructureInfo info = null;
            OrgTreeMapingInfo otmInfo = null;
            String number = null;
            for (int i = 0; i < col.size(); ++i) {
                info = col.get(i);
                number = info.getUnit().getNumber();
                otmInfo = (OrgTreeMapingInfo)orgTreeMapingMap.get(number);
                if (!info.isIsLeaf() || otmInfo != null || (otmInfo = (OrgTreeMapingInfo)orgTreeMapingMap.get(info.getParent().getUnit().getNumber())) == null) continue;
                OrgTreeMapingInfo temp = new OrgTreeMapingInfo();
                temp.setSrcOrgTreeNumber(otmInfo.getSrcOrgTreeNumber());
                temp.setSrcOrgUnitNumber(number);
                orgTreeMapingMap.put(number, temp);
            }
        }
        return orgTreeMapingMap;
    }

    private OrgStructureCollection getTargetOrgUnit(Context ctx, String targetOrgTreeId) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT ").append(" id,").append(" level,").append(" isLeaf,").append(" unit.name,").append(" unit.number,").append(" unit.id,").append(" unit.isunion,").append(" tree.number,").append(" parent.unit.number ").append("WHERE tree.id='").append(targetOrgTreeId).append("' ").append("ORDER BY longnumber ASC");
        OrgStructureCollection orgStructureColl = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(buffer.toString());
        OrgStructureInfo curOrgStrInfo = null;
        HashMap parentMap = new HashMap();
        for (int i = orgStructureColl.size() - 1; i >= 0; --i) {
            curOrgStrInfo = orgStructureColl.get(i);
            if (curOrgStrInfo.getParent() != null && curOrgStrInfo.getParent().getId() != null) {
                parentMap.put(curOrgStrInfo.getParent().getId().toString(), null);
            }
            if (parentMap.containsKey(curOrgStrInfo.getId().toString())) {
                curOrgStrInfo.setIsLeaf(false);
                continue;
            }
            curOrgStrInfo.setIsLeaf(true);
        }
        parentMap.clear();
        return orgStructureColl;
    }

    private IndexTypeInfo getIndexTypeInfoByID(Context ctx, String id) throws EASBizException, BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("select factor, name, number, precision, lastCalcTime,").append(" unit,currency.id, currency.number, orgbound.id, orgbound.name, orgbound.number").append(" where id='" + id + "'");
        return this.getIndexTypeInfo(ctx, buffer.toString());
    }

    private IndexAnalysisCollection getIndexAnalysisCollectionByIndexTypeID(Context ctx, String indexTypeID) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        entityViewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("indexType.id", (Object)indexTypeID, CompareType.EQUALS));
        IndexAnalysisCollection indexCol = IndexAnalysisFactory.getLocalInstance(ctx).getIndexAnalysisCollection(entityViewInfo);
        return indexCol;
    }

    private List<IndexAnalysisDataInfo> getCalculateResultInfo(Context ctx, String treeId, IndexTypeInfo info, int year, int period, int periodType, Map<String, OrgTreeMapingInfo> orgTreeMapingMap, boolean is13Period) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        view.setFilter(f);
        String indexTypeID = info.getId().toString();
        f.getFilterItems().add(new FilterItemInfo("indexAnalysis.indexType.id", (Object)indexTypeID));
        IIndexAnalysisEntry entryIntf = IndexAnalysisEntryFactory.getLocalInstance(ctx);
        IndexAnalysisEntryCollection entryCol = entryIntf.getIndexAnalysisEntryCollection(view);
        String currency = info.getCurrency().getNumber();
        Timestamp day = new Timestamp(System.currentTimeMillis());
        IRowSet rowSet = this.getAllOrgUnitByTree(ctx, treeId, year, period, periodType);
        ArrayList<String> formulaList = new ArrayList<String>();
        List<IndexAnalysisDataInfo> result = new ArrayList<IndexAnalysisDataInfo>();
        IndexAnalysisDataInfo dataInfo = null;
        try {
            while (rowSet.next()) {
                String unitNumber = rowSet.getString("number");
                String treeNumber = rowSet.getString("treenumber");
                String unitName = rowSet.getString("name");
                String unitID = rowSet.getString("id");
                int level = rowSet.getInt("flevel");
                boolean isLeaf = rowSet.getBoolean("isleaf");
                String longNumber = rowSet.getString("longnumber");
                boolean isUnion = rowSet.getBoolean("isUnion");
                String realTreeNumber = "";
                String realUnitNumber = "";
                for (int i = 0; i < entryCol.size(); ++i) {
                    IndexAnalysisEntryInfo entryInfo = entryCol.get(i);
                    if (StringUtils.isEmpty((String)entryInfo.getFormula())) continue;
                    dataInfo = new IndexAnalysisDataInfo();
                    dataInfo.setIndexTypeID(indexTypeID);
                    dataInfo.setIndexAnalysisEntry(entryInfo);
                    dataInfo.setIndexAnalysisID(entryInfo.getIndexAnalysis().getId().toString());
                    dataInfo.setOrgID(unitID);
                    dataInfo.setOrgNumber(unitNumber);
                    dataInfo.setOrgIsLeaf(isLeaf);
                    dataInfo.setOrgLevel(level);
                    dataInfo.setOrgLongNumber(longNumber);
                    dataInfo.setOrgName(unitName);
                    dataInfo.setDataType(entryInfo.getDataTypeNumber());
                    dataInfo.setDataTypeName(entryInfo.getDataTypeName());
                    dataInfo.setDataElement(entryInfo.getDataElementType());
                    dataInfo.setYear(year);
                    dataInfo.setPeriod(period);
                    dataInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
                    dataInfo.setDay(day);
                    realTreeNumber = treeNumber;
                    realUnitNumber = unitNumber;
                    OrgTreeMapingInfo tmpOrgTreeMaping = null;
                    if (orgTreeMapingMap != null && (tmpOrgTreeMaping = orgTreeMapingMap.get(unitNumber)) != null) {
                        realTreeNumber = tmpOrgTreeMaping.getSrcOrgTreeNumber();
                        realUnitNumber = tmpOrgTreeMaping.getSrcOrgUnitNumber();
                    }
                    String formula = "=" + this.fillFormula(entryInfo.getFormula(), realTreeNumber, realUnitNumber, isUnion, currency, year, period, is13Period);
                    formulaList.add(formula);
                    result.add(dataInfo);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        int precision = info.getPrecision();
        double factor = info.getFactor();
        result = this.calcFormulaList(formulaList, result, ctx, precision, factor, year, period, periodType, is13Period);
        return result;
    }

    private List<IndexAnalysisDataInfo> calcFormulaList(List formulaList, List<IndexAnalysisDataInfo> result, Context ctx, int precision, double factor, int year, int period, int periodType, boolean is13Period) throws BOSException {
        long start = System.currentTimeMillis();
        List<BigDecimal> amountList = this.calcFormula(ctx, formulaList, null, year, period, periodType, is13Period);
        if (amountList == null) {
            return result;
        }
        Object amount = null;
        BigDecimal fct = new BigDecimal(factor);
        for (int i = 0; i < result.size(); ++i) {
            IndexAnalysisDataInfo dataInfo = result.get(i);
            dataInfo.setAmount(amountList.get(i));
        }
        return result;
    }

    private List<BigDecimal> calcFormula(Context ctx, List formulaList, List<BigDecimal> result, int year, int period, int periodType, boolean is13Period) throws BOSException {
        int size = formulaList.size();
        if (size > 65535) {
            this.calcFormula(ctx, formulaList.subList(0, size - 65535), result, year, period, periodType, is13Period);
        }
        ReportInfo reportInfo = this.buildReportInfo(null, year, period, periodType, is13Period);
        ReportFormulaFacade iReportFacade = new ReportFormulaFacade();
        if (result == null) {
            result = iReportFacade.calcFomula(ctx, (IObjectValue)reportInfo, formulaList);
        } else {
            result.addAll(result.size(), iReportFacade.calcFomula(ctx, (IObjectValue)reportInfo, formulaList));
        }
        return result;
    }

    private IRowSet getAllOrgUnitByTree(Context ctx, String treeid, int year, int period, int periodType) throws BOSException {
        Timestamp endTimestamp = new Timestamp(RPTDateUtil.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)).getTime());
        StringBuffer buffer = new StringBuffer();
        String nameField = MultiLangHelper.getFieldName((String)"FName", (Locale)ctx.getLocale());
        String userId = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        buffer.append("SELECT DISTINCT unit.FNumber number,").append(" CASE WHEN unit.FSimpleName IS NULL THEN unit.").append(nameField).append(" ELSE unit.FSimpleName END name, unit.FIsUnion isUnion,").append(" strc.FId id,strc.FParentId parentid, strc.FIsLeaf isleaf, strc.FLevel flevel,").append(" strc.FLongNumber longnumber, tree.FNumber treenumber, tree.FId treeid, tree.").append(nameField).append(" treename \n").append(" FROM T_ORG_BaseUnit unit \n").append(" INNER JOIN T_ORG_Structure strc ON unit.FId = strc.FUnitId \n").append(" INNER JOIN T_ORG_Tree tree ON tree.FId = strc.FTreeId \n").append(" INNER JOIN T_PM_OrgRange Range ON Range.FOrgId = unit.FId \n").append(" WHERE Range.FUserId = '" + userId + "'").append(" AND Range.FType = ").append(10);
        if (StringUtils.isEmpty((String)treeid)) {
            buffer.append(" AND tree.FIsBasic=0 AND tree.FIsforBudget=0 AND tree.FType=8 \n").append(" AND ((tree.FStatus=2 AND tree.FStartDate <=? AND tree.FEndDate >= ? ) \n").append(" OR (tree.FStatus=1 AND tree.FStartDate <= ? )) ORDER BY unit.FNumber ");
        } else {
            buffer.append(" AND tree.FId = '").append(treeid).append("' \n");
        }
        IRowSet rowSet = null;
        rowSet = StringUtils.isEmpty((String)treeid) ? DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])new Object[]{endTimestamp, endTimestamp, endTimestamp}) : DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
        return rowSet;
    }

    private String fillFormula(String formulaString, String treeNumber, String unitNumber, boolean isUnion, String currency, int year, int period, boolean is13Period) {
        try {
            Expression stmt = ExcelFormulaPaserHelper.parse((String)formulaString);
            Expression expression = this.handleExpression(stmt, treeNumber, unitNumber, isUnion, currency, year, period, is13Period);
            return expression.toString();
        }
        catch (Exception e) {
            logger.error((Object)"ExcelFormulaPaserHelper.parse", (Throwable)e);
            return null;
        }
    }

    private Expression handleExpression(Expression stmt, String treeNumber, String unitNumber, boolean isUnion, String currency, int year, int period, boolean is13Period) {
        if (stmt instanceof FunctionExpr) {
            String funName = ((FunctionExpr)stmt).funcionName;
            FunctionExpr expr = (FunctionExpr)stmt;
            List param = expr.parameters;
            if (funName.equalsIgnoreCase("AcctItem")) {
                ((StringExpr)param.get((int)0)).value = treeNumber;
                ((StringExpr)param.get((int)1)).value = unitNumber;
                if (StringUtils.isEmpty((String)((StringExpr)param.get((int)3)).value)) {
                    ((StringExpr)param.get((int)3)).value = currency;
                }
                if (!isUnion) {
                    ((StringExpr)param.get((int)10)).value = RptSrcTypeEnum.COMMITREPORT.getName();
                } else if (param.get(10) != null && param.get(10).toString() != RptSrcTypeEnum.SUM.getName()) {
                    ((StringExpr)param.get((int)10)).value = RptSrcTypeEnum.CONSOLIDATION.getName();
                }
            } else if (funName.equalsIgnoreCase("BgFormula")) {
                ((StringExpr)param.get((int)0)).value = unitNumber;
            }
            return stmt;
        }
        if (stmt instanceof BinaryOperationExpr) {
            Expression expr = ((BinaryOperationExpr)stmt).left;
            this.handleExpression(expr, treeNumber, unitNumber, isUnion, currency, year, period, is13Period);
            expr = ((BinaryOperationExpr)stmt).right;
            this.handleExpression(expr, treeNumber, unitNumber, isUnion, currency, year, period, is13Period);
            return stmt;
        }
        if (stmt instanceof UnaryOperationExpr) {
            Expression expr = ((UnaryOperationExpr)stmt).operand;
            this.handleExpression(expr, treeNumber, unitNumber, isUnion, currency, year, period, is13Period);
            return stmt;
        }
        return null;
    }

    private ReportInfo buildReportInfo(String adjust, int year, int period, int periodType, boolean is13Period) {
        ReportInfo reportInfo = new ReportInfo();
        if (adjust != null) {
            if ("lastMonth".equals(adjust)) {
                if (--period == 0) {
                    period = 12;
                    --year;
                }
            } else if ("preMonth".equals(adjust)) {
                if ((period -= 2) == 0) {
                    period = 12;
                    --year;
                }
            } else if ("lastYear".equals(adjust)) {
                --year;
            }
        }
        if (is13Period) {
            period = 13;
        }
        reportInfo.setYear(year);
        reportInfo.setPeriod(Short.valueOf(String.valueOf(period)).shortValue());
        reportInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
        RptSheetParamInfo rptSheetParamInfo = new RptSheetParamInfo();
        rptSheetParamInfo.setStartYear(period);
        rptSheetParamInfo.setEndYear(period);
        reportInfo.getSheetParam().add(rptSheetParamInfo);
        return reportInfo;
    }

    private void refreshData(Context ctx, List<IndexAnalysisDataInfo> amountResult, String indexTypeId, String treeNumber, int year, int period, int periodType) throws EASBizException, BOSException {
        StringBuffer buffer = new StringBuffer();
        String userId = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        buffer.append("DELETE FROM T_CSL_IndexAnalysisData \n").append(" WHERE FYear=? AND FPeriod=? AND FIndexTypeId=? AND FPeriodType=? AND FOrgId IN \n").append(" (SELECT strc.FId \n").append("  FROM T_ORG_Structure strc \n").append("  INNER JOIN T_ORG_BaseUnit unit ON unit.FId = strc.FUnitId \n").append("  INNER JOIN T_ORG_Tree tree ON tree.FId = strc.FTreeId \n").append("  INNER JOIN T_PM_OrgRange Range ON Range.FOrgId = unit.FId \n").append("  WHERE tree.FNumber=? AND Range.FUserId=? AND Range.FType=?)");
        Object[] params = new Object[]{year, period, indexTypeId, periodType, treeNumber, userId, 10};
        DbUtil.execute((Context)ctx, (String)buffer.toString(), (Object[])params);
        try {
            String kql = PsSql.getSqlWithParams((Object)buffer.toString(), (Object[])params, (int)7, (boolean)false);
            MobileUtil.debugLog(logger, "[IndexTypeControllerBean.refreshData***************]\n" + kql);
        }
        catch (SQLException kql) {
            // empty catch block
        }
        List<Object[]> paramList = this.buildParams(amountResult);
        String sql = this.buildSql(paramList);
        CslRptUtil.executeBatch(ctx, sql.toString(), paramList);
    }

    private String buildSql(List<Object[]> paramList) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_CSL_Indexanalysisdata (");
        sql.append("FID,FIndexTypeID,FIndexAnalysisID,FIndexAnalysisEntryID,FOrgID,FOrgNumber,FOrgLongNumber,FOrgIsLeaf,FOrgLevel,");
        sql.append("FOrgName,FDataType,FDataTypeName,FDataElement,FAmount,FYear,FPeriod,FPeriodType,FDay,FSpecialValue");
        sql.append(") VALUES (");
        int len = paramList.get(0).length;
        for (int i = 0; i < len; ++i) {
            if (i == 0) {
                sql.append("?");
                continue;
            }
            sql.append(",?");
        }
        sql.append(")");
        return sql.toString();
    }

    private List<Object[]> buildParams(List<IndexAnalysisDataInfo> amountResult) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (int i = 0; i < amountResult.size(); ++i) {
            IndexAnalysisDataInfo info = amountResult.get(i);
            ArrayList<Object> param = new ArrayList<Object>();
            String newID = BOSUuid.create((BOSObjectType)new IndexAnalysisDataInfo().getBOSType()).toString();
            param.add(newID);
            param.add(info.getIndexTypeID());
            param.add(info.getIndexAnalysisID());
            param.add(info.getIndexAnalysisEntry().getId().toString());
            param.add(info.getOrgID());
            param.add(info.getOrgNumber());
            param.add(info.getOrgLongNumber());
            param.add(info.isOrgIsLeaf());
            param.add(info.getOrgLevel());
            param.add(info.getOrgName());
            param.add(info.getDataType());
            param.add(info.getDataTypeName());
            param.add(info.getDataElement().getValue());
            param.add(info.getAmount());
            param.add(info.getYear());
            param.add(info.getPeriod());
            param.add(info.getPeriodType().getValue());
            param.add(info.getDay());
            param.add(info.getSpecialValue());
            paramList.add(param.toArray());
        }
        return paramList;
    }

    private List<IndexAnalysisDataInfo> getOtherAmount(Context ctx, String treeId, IndexTypeInfo info, IndexAnalysisCollection indexCol, List<IndexAnalysisDataInfo> baseResult, List<IndexAnalysisDataInfo> result, int year, int period, int periodType) throws BOSException {
        String indexTypeID = info.getId().toString();
        StringBuffer buffer = new StringBuffer();
        buffer.append(" select * where indexAnalysis.indexType.id='" + indexTypeID + "' ").append(" and ((indexAnalysis.hasProduce=1 and dataElementType='1') ").append(" or (indexAnalysis.hasCumulation=1 and dataElementType='2') ").append(" or (indexAnalysis.hasBalance=1 and dataElementType='3')) ");
        IIndexAnalysisEntry entryIntf = IndexAnalysisEntryFactory.getLocalInstance(ctx);
        IndexAnalysisEntryCollection entryCol = entryIntf.getIndexAnalysisEntryCollection(buffer.toString());
        HashMap<String, BigDecimal> map = null;
        HashMap dataMap = new HashMap();
        for (int i = 0; i < indexCol.size(); ++i) {
            IndexAnalysisInfo indexInfo = indexCol.get(i);
            String indexId = indexInfo.getId().toString();
            map = new HashMap<String, BigDecimal>();
            for (int j = 0; j < baseResult.size(); ++j) {
                IndexAnalysisDataInfo dataInfo = baseResult.get(j);
                if (!indexId.equals(dataInfo.getIndexAnalysisID())) continue;
                map.put(dataInfo.getOrgID() + "_" + (Object)((Object)dataInfo.getDataElement()) + "_" + dataInfo.getDataType(), dataInfo.getAmount());
            }
            dataMap.put(indexId, map);
        }
        IndexAnalysisDataInfo dataInfo = null;
        Timestamp day = new Timestamp(System.currentTimeMillis());
        IRowSet rowSet = this.getAllOrgUnitByTree(ctx, treeId, year, period, periodType);
        try {
            while (rowSet.next()) {
                String unitNumber = rowSet.getString("number");
                String treeNumber = rowSet.getString("treenumber");
                String unitName = rowSet.getString("name");
                String unitID = rowSet.getString("id");
                int level = rowSet.getInt("flevel");
                boolean isLeaf = rowSet.getBoolean("isleaf");
                String longNumber = rowSet.getString("longnumber");
                String parentid = rowSet.getString("parentid");
                for (int j = 0; j < entryCol.size(); ++j) {
                    IndexAnalysisEntryInfo entryInfo = entryCol.get(j);
                    if (!StringUtils.isEmpty((String)entryInfo.getFormula())) continue;
                    IndexAnalysisInfo indexInfo = entryInfo.getIndexAnalysis();
                    if (entryInfo.getDataElementType().equals((Object)IndexDataElementEnum.Produce) && !indexInfo.isHasProduce() || entryInfo.getDataElementType().equals((Object)IndexDataElementEnum.Cumulation) && !indexInfo.isHasCumulation() || entryInfo.getDataElementType().equals((Object)IndexDataElementEnum.Balance) && !indexInfo.isHasBalance()) continue;
                    dataInfo = new IndexAnalysisDataInfo();
                    dataInfo.setIndexTypeID(indexTypeID);
                    dataInfo.setIndexAnalysisEntry(entryInfo);
                    dataInfo.setIndexAnalysisID(entryInfo.getIndexAnalysis().getId().toString());
                    dataInfo.setOrgID(unitID);
                    dataInfo.setOrgNumber(unitNumber);
                    dataInfo.setOrgIsLeaf(isLeaf);
                    dataInfo.setOrgLevel(level);
                    dataInfo.setOrgLongNumber(longNumber);
                    dataInfo.setOrgName(unitName);
                    dataInfo.setDataType(entryInfo.getDataTypeNumber());
                    dataInfo.setDataTypeName(entryInfo.getDataTypeName());
                    dataInfo.setDataElement(entryInfo.getDataElementType());
                    dataInfo.setYear(year);
                    dataInfo.setPeriod(period);
                    dataInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
                    dataInfo.setDay(day);
                    String dataTypeNumber = entryInfo.getDataTypeNumber();
                    Map recMap = (Map)dataMap.get(indexInfo.getId().toString());
                    BigDecimal curAmt = (BigDecimal)recMap.get(unitID + "_" + (Object)((Object)entryInfo.getDataElementType()) + "_" + DCEndingBalance.currentAmount.getName());
                    BigDecimal ppAmt = (BigDecimal)recMap.get(unitID + "_" + (Object)((Object)entryInfo.getDataElementType()) + "_" + DCEndingBalance.priorPeriodAmount.getName());
                    BigDecimal tsplyAmt = (BigDecimal)recMap.get(unitID + "_" + (Object)((Object)entryInfo.getDataElementType()) + "_" + DCEndingBalance.theSamePeriodLastYear.getName());
                    BigDecimal ybAmt = (BigDecimal)recMap.get(unitID + "_" + (Object)((Object)entryInfo.getDataElementType()) + "_" + DCEndingBalance.yearBeginAmount.getName());
                    BigDecimal bgAmt = (BigDecimal)recMap.get(unitID + "_" + (Object)((Object)entryInfo.getDataElementType()) + "_" + DCEndingBalance.budgetAmount.getName());
                    if (curAmt == null) continue;
                    BigDecimal amount = new BigDecimal(0);
                    int scale = 4;
                    if (dataTypeNumber.equals(DCAmountEnum.yoyGrowthRate.getName())) {
                        if (tsplyAmt != null) {
                            if (tsplyAmt.doubleValue() == 0.0) {
                                dataInfo.setSpecialValue(Str_NotApplicable);
                            } else {
                                amount = curAmt.subtract(tsplyAmt).divide(tsplyAmt.abs(), scale, 4);
                            }
                        } else {
                            dataInfo.setSpecialValue(Str_NotApplicable);
                        }
                        dataInfo.setAmount(amount);
                        result.add(dataInfo);
                        continue;
                    }
                    if (dataTypeNumber.equals(DCAmountEnum.momGrowthRate.getName())) {
                        if (ppAmt != null) {
                            if (ppAmt.doubleValue() == 0.0) {
                                dataInfo.setSpecialValue(Str_NotApplicable);
                            } else {
                                amount = curAmt.subtract(ppAmt).divide(ppAmt.abs(), scale, 4);
                            }
                        } else {
                            dataInfo.setSpecialValue(Str_NotApplicable);
                        }
                        dataInfo.setAmount(amount);
                        result.add(dataInfo);
                        continue;
                    }
                    if (dataTypeNumber.equals(DCAmountEnum.bgCompletionRate.getName())) {
                        if (bgAmt != null) {
                            if (bgAmt.doubleValue() == 0.0) {
                                dataInfo.setSpecialValue(Str_NotApplicable);
                            } else {
                                amount = curAmt.divide(bgAmt, scale, 4);
                                if (amount.doubleValue() < 0.0) {
                                    amount = new BigDecimal(0);
                                    dataInfo.setSpecialValue(Str_NotApplicable);
                                }
                            }
                        } else {
                            dataInfo.setSpecialValue(Str_NotApplicable);
                        }
                        dataInfo.setAmount(amount);
                        result.add(dataInfo);
                        continue;
                    }
                    if (dataTypeNumber.equals(DCEndingBalance.changeAmount.getName())) {
                        if (ybAmt != null) {
                            amount = curAmt.subtract(ybAmt);
                        } else {
                            dataInfo.setSpecialValue(Str_NotApplicable);
                        }
                        dataInfo.setAmount(amount);
                        result.add(dataInfo);
                        continue;
                    }
                    if (dataTypeNumber.equals(DCAmountEnum.yoyChangeAmount.getName())) {
                        if (tsplyAmt != null) {
                            amount = curAmt.subtract(tsplyAmt);
                        } else {
                            dataInfo.setSpecialValue(Str_NotApplicable);
                        }
                        dataInfo.setAmount(amount);
                        result.add(dataInfo);
                        continue;
                    }
                    if (!dataTypeNumber.equals(DCAmountEnum.momChangeAmount.getName())) continue;
                    if (ppAmt != null) {
                        amount = curAmt.subtract(ppAmt);
                    } else {
                        dataInfo.setSpecialValue(Str_NotApplicable);
                    }
                    dataInfo.setAmount(amount);
                    result.add(dataInfo);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    protected Map _getSchemeEntry(Context ctx, String indexTypeId) throws BOSException, EASBizException {
        HashMap<String, Cloneable> sum = new HashMap<String, Cloneable>();
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList schemeList = new ArrayList();
        StringBuffer buffer = new StringBuffer();
        try {
            String fName = MultiLangHelper.getFieldName((String)"FName", (Locale)ctx.getLocale());
            buffer.append("SELECT dispensed.FIndex,u.FNumber userNum,u." + fName + " userName,analysis.FNumber analysisNum,analysis." + fName + " analysisName");
            buffer.append(" FROM T_CSL_IndexDispensed dispensed ");
            buffer.append("JOIN T_PM_User u ");
            buffer.append("ON dispensed.FUser = u.FId ");
            buffer.append("JOIN T_CSL_IndexAnalysis analysis ");
            buffer.append("ON analysis.FId = dispensed.FIndex ");
            buffer.append("WHERE dispensed.FIndexType = ?");
            IRowSet dispensed = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])new Object[]{indexTypeId});
            while (dispensed.next()) {
                String num = "[" + dispensed.getString("analysisNum") + "]" + dispensed.getString("analysisName");
                String name = "[" + dispensed.getString("userNum") + "]" + dispensed.getString("userName");
                if (map.containsKey(num)) {
                    map.put(num, (String)map.get(num) + "," + name);
                    continue;
                }
                map.put(num, name);
            }
            sum.put("dispensed", map);
            buffer.setLength(0);
            buffer.append("SELECT a.FSchemeId, a.count, b.FDispenseId, c.fnumber, c." + fName + " FROM ");
            buffer.append("(SELECT t3.FSchemeId, t3.count FROM ");
            buffer.append("(SELECT t2.FSchemeId, count(1) count FROM ");
            buffer.append("(SELECT t1.FSchemeId FROM T_CSL_IndexAnalysisSchemeEntry t1 GROUP BY t1.FSchemeId, t1.FIndexTypeId) t2 ");
            buffer.append("GROUP BY FSchemeId) t3 ");
            buffer.append("WHERE t3.FSchemeId IN ");
            buffer.append("(SELECT FSchemeId FROM T_CSL_IndexAnalysisSchemeEntry WHERE FIndexTYpeId = ? GROUP BY FSchemeId)) a ");
            buffer.append("LEFT JOIN T_CSL_ReportUserGroupDispEntry b ON a.FSchemeId = b.FSchemeId ");
            buffer.append("JOIN T_CSL_IndexAnalysisScheme c ON a.FSchemeId = c.FId");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])new Object[]{indexTypeId});
            while (rowSet.next()) {
                HashMap<String, String> schemeMap = new HashMap<String, String>();
                String schemeId = rowSet.getString("FSchemeId");
                String count = rowSet.getString("count");
                String dispenseId = rowSet.getString("FDispenseId");
                String number = "[" + rowSet.getString("fnumber") + "]" + rowSet.getString(fName);
                schemeMap.put("schemeId", schemeId);
                schemeMap.put("count", count);
                schemeMap.put("dispenseId", dispenseId);
                schemeMap.put("number", number);
                schemeList.add(schemeMap);
            }
            sum.put("scheme", schemeList);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return sum;
    }

    @Override
    protected Map _getMessage(Context ctx, String indexTypeId, String operationType) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Map schemeMap = this._getSchemeEntry(ctx, indexTypeId);
            Map dispMap = (Map)schemeMap.get("dispensed");
            List scheme = (List)schemeMap.get("scheme");
            ArrayList<String> schemeIds = new ArrayList<String>();
            StringBuffer message = new StringBuffer();
            int flag = 1;
            if (dispMap.size() != 0) {
                flag = 0;
                Iterator it = dispMap.keySet().iterator();
                while (it.hasNext()) {
                    String key = it.next().toString();
                    message.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "79_IndexDispensed", new Object[]{key, dispMap.get(key)}) + "\n");
                }
                map.put("message", message);
                map.put("flag", flag);
                return map;
            }
            if (scheme.size() != 0) {
                StringBuffer sDis = new StringBuffer();
                StringBuffer sImp = new StringBuffer();
                StringBuffer sCount = new StringBuffer();
                for (int i = 0; i < scheme.size(); ++i) {
                    Map sch = (Map)scheme.get(i);
                    String schemeId = sch.get("schemeId").toString();
                    String schemeNum = sch.get("number").toString();
                    if (sch.get("dispenseId") != null) {
                        sDis.append(schemeNum + ",");
                        flag = 0;
                        continue;
                    }
                    if (Integer.parseInt(sch.get("count").toString()) == 1) {
                        sCount.append(schemeNum + ",");
                    } else {
                        schemeIds.add(schemeId);
                    }
                    sImp.append(schemeNum + ",");
                }
                message.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "85_IndexType", new Object[]{sImp.append(sDis).substring(0, sImp.length() - 1)}));
                if (sDis.length() != 0) {
                    message.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "80_Import_And_Dispensed", new Object[]{sImp.append(sDis).substring(0, sImp.length() - 1), sDis.substring(0, sDis.length() - 1)})).append("\n");
                } else {
                    if (sCount.length() != 0) {
                        message.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "86_OnlyType", new Object[]{sCount.substring(0, sCount.length() - 1)}));
                    }
                    if ("delete".equals(operationType)) {
                        message.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"87_Sure_Delete", (Locale)ctx.getLocale())).append("\n");
                    }
                    if ("modify".equals(operationType)) {
                        message.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"89_modify_IndexType", (Locale)ctx.getLocale())).append("\n");
                    }
                }
                map.put("schemeIds", schemeIds);
                map.put("flag", flag);
                map.put("message", message);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            SysUtil.abort((Throwable)e);
        }
        return map;
    }

    @Override
    protected void _updateIndexCalcGuideInfo(Context ctx, Map param) throws BOSException, EASBizException {
        String indexTypeId = (String)param.get("indexTypeId");
        int year = (Integer)param.get("year");
        int period = (Integer)param.get("period");
        String suffix = (String)param.get("suffix");
        Boolean is13Period = (Boolean)param.get("is13Period");
        SQLBuilder buffer = new SQLBuilder();
        buffer.append("DELETE FROM T_CSL_IndexCalcGuide ");
        buffer.append(" WHERE FIndexTypeId=?", (Object)indexTypeId);
        buffer.append("   AND FYear=?", (Object)year);
        buffer.append("   AND FPeriod=?", (Object)period);
        DbUtil.execute((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
        buffer.reset();
        buffer.append(" INSERT INTO T_CSL_IndexCalcGuide(FId,FIndexTypeId,FYear,FPeriod,FIs13Period,FSuffix)");
        buffer.append(" VALUES(?,?,?,?,?,?)");
        Object[] params = new Object[]{Uuid.create().toString(), indexTypeId, year, period, is13Period, suffix};
        DbUtil.execute((Context)ctx, (String)buffer.getSQL(), (Object[])params);
    }
}

