/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.pa.PaReportInfo;
import com.kingdee.eas.fi.gr.pa.PaRptTmpTypeEnum;
import com.kingdee.eas.fi.gr.pa.PaTemplateInfo;
import com.kingdee.eas.fi.gr.pa.client.PaTemplateToolClass;
import com.kingdee.eas.fi.gr.pa.client.rptguide.CompanyF7Dialog;
import com.kingdee.eas.fi.gr.pa.rptguide.CompanyTabInfo;
import com.kingdee.eas.fi.gr.pa.rptguide.ItemTabInfo;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class PaRptClientUtil {
    private static final String resClassName = "com.kingdee.eas.fi.gr.pa.PaReportResource";

    private PaRptClientUtil() {
    }

    public static String getResString(String resName) {
        return EASResource.getString((String)resClassName, (String)resName);
    }

    public static String getResString(String resName, Object[] param) {
        return MessageFormat.format(EASResource.getString((String)resClassName, (String)resName), param);
    }

    public static void prepareReportInfo4Save(IObjectValue model, Book book) {
        if (model instanceof PaReportInfo || model instanceof PaTemplateInfo) {
            VirtualSheetParamInfo virtualSheetParamInfo = (VirtualSheetParamInfo)model;
            ReportVariables variables = ReportVariables.loadFromBook((Book)book);
            virtualSheetParamInfo.getSheetParam().clear();
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                String name = sheet.getSheetName();
                RptSheetParamInfo pinfo = VariablesHelper.variables2SheetParams((ReportVariables)variables, (String)name, (boolean)true, null);
                pinfo.setSheetID(sheet.getID());
                if (virtualSheetParamInfo instanceof PaReportInfo) {
                    pinfo.setRelaType(ReportTypeEnum.CSLREPORT);
                } else if (virtualSheetParamInfo instanceof PaTemplateInfo) {
                    pinfo.setRelaType(ReportTypeEnum.PATEMPLATE);
                }
                virtualSheetParamInfo.getSheetParam().add(pinfo);
            }
        }
    }

    public static void prepareReportInfo4Display(IObjectValue model, Book book) {
        if (model instanceof PaReportInfo || model instanceof PaTemplateInfo) {
            VirtualSheetParamInfo virtualSheetParamInfo = (VirtualSheetParamInfo)model;
            BookProperties properties = BookProperties.loadFromBook((Book)book);
            ReportVariables variables = properties.getVariables();
            RptSheetParamCollection sheetParam = virtualSheetParamInfo.getSheetParam();
            RptPeriodTypeEnum periodType = RptPeriodTypeEnum.MONTHLY;
            if (virtualSheetParamInfo instanceof ReportBaseInfo) {
                periodType = ((ReportBaseInfo)virtualSheetParamInfo).getPeriodType();
            }
            for (int i = 0; sheetParam != null && i < sheetParam.size(); ++i) {
                RptSheetParamInfo p = sheetParam.get(i);
                ReportVariables sheetV = model instanceof PaTemplateInfo ? PaRptClientUtil.sheetParams2Variables(p) : VariablesHelper.sheetParams2Variables((RptSheetParamInfo)p, (RptPeriodTypeEnum)periodType);
                variables.addAll(sheetV, false);
            }
            properties.restoreToBook(book);
        }
    }

    public static ReportVariables sheetParams2Variables(RptSheetParamInfo p) {
        String sheetName = p.getSheetName();
        ReportVariables variables = null;
        variables = PaTemplateToolClass.initTemplateSheetReservedVariables((String)sheetName);
        VariableEntry variableEntry = null;
        variableEntry = variables.get("StartYear", sheetName);
        variableEntry.setValue(String.valueOf(p.getStartYear()));
        variableEntry.setType(3);
        variableEntry = variables.get("EndYear", sheetName);
        variableEntry.setValue(String.valueOf(p.getEndYear()));
        variableEntry.setType(3);
        variableEntry = variables.get("StartPeriod", sheetName);
        variableEntry.setValue(String.valueOf(p.getStartPeriod()));
        variableEntry.setType(3);
        variableEntry = variables.get("EndPeriod", sheetName);
        variableEntry.setValue(String.valueOf(p.getEndPeriod()));
        variableEntry.setType(3);
        variableEntry = variables.get("Currency", sheetName);
        variableEntry.setValue(p.getCurrency() == null ? "" : String.valueOf(p.getCurrency().getNumber()));
        variableEntry.setQuery("com.kingdee.eas.basedata.assistant.app.CurrencyAllQuery");
        variableEntry = variables.get("IncludePosted", sheetName);
        variableEntry.setValue(String.valueOf(p.isIsIncludingUnposted()));
        variableEntry.setType(1);
        return variables;
    }

    public static void setPeriodRange(KDSpinner sp, int period_type, int year, boolean isSupport13Period) {
        int max = 1;
        int min = 1;
        switch (period_type) {
            case 6: {
                break;
            }
            case 5: {
                max = 2;
                break;
            }
            case 4: {
                max = 4;
                break;
            }
            case 3: {
                if (isSupport13Period) {
                    max = 13;
                    break;
                }
                max = 12;
                break;
            }
            case 2: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(3, 1);
                } while (cal.get(1) == year);
                max = count;
                break;
            }
            case 1: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(6, 1);
                } while (cal.get(1) == year);
                max = count;
            }
        }
        CslRptUIUtil.setSpineRange((KDSpinner)sp, (int)min, (int)max, (boolean)false, (boolean)true);
    }

    public static void initOrgTreeCombox(KDComboBox OrgTreeCombox, Date rptDate) throws EASBizException, BOSException {
        Object oldValue = OrgTreeCombox.getSelectedItem();
        OrgTreeCollection otc = CslRptUIUtil.getOrgTreeCollection((Date)rptDate);
        OrgTreeCombox.removeAllItems();
        OrgTreeCombox.addItems(otc.toArray());
        if (oldValue != null) {
            OrgTreeCombox.setSelectedItem(oldValue);
        }
    }

    public static int[] getLastPeriod(RptPeriodTypeEnum t) {
        Calendar c = Calendar.getInstance();
        int thismonth = c.get(2);
        do {
            c.add(5, -1);
        } while (c.get(2) == thismonth);
        int[] period = RPTDateUtil.getPeriod(new Date(c.getTimeInMillis()), t);
        return period;
    }

    private static void moveTableRow(KDTable kdt, boolean isMoveUp) {
        if (kdt.getSelectManager() != null && kdt.getSelectManager().getActiveRowIndex() >= 0) {
            int iCurRowIndex = kdt.getSelectManager().getActiveRowIndex();
            int iRowCount = kdt.getRowCount();
            IRow curRow = kdt.getRow(iCurRowIndex);
            if (isMoveUp) {
                if (iCurRowIndex > 0) {
                    kdt.removeRow(iCurRowIndex);
                    kdt.addRow(iCurRowIndex - 1, curRow);
                    PaRptClientUtil.setActiveRowIndex(kdt, iCurRowIndex - 1);
                }
            } else if (iCurRowIndex < iRowCount - 1) {
                kdt.removeRow(iCurRowIndex);
                kdt.addRow(iCurRowIndex + 1, curRow);
                PaRptClientUtil.setActiveRowIndex(kdt, iCurRowIndex + 1);
            }
        }
    }

    private static void setActiveRowIndex(KDTable kdt, int activeRowIndex) {
        kdt.getSelectManager().setActiveRowIndex(activeRowIndex);
        kdt.getSelectManager().select(activeRowIndex, 0, activeRowIndex, kdt.getColumnCount());
    }

    public static void moveUp(KDTable kdt) {
        PaRptClientUtil.moveTableRow(kdt, true);
    }

    public static void moveDown(KDTable kdt) {
        PaRptClientUtil.moveTableRow(kdt, false);
    }

    public static void moveTop(KDTable kdt) {
        if (kdt.getSelectManager() != null && kdt.getSelectManager().getActiveRowIndex() >= 0) {
            int iCurRowIndex = kdt.getSelectManager().getActiveRowIndex();
            IRow curRow = kdt.getRow(iCurRowIndex);
            if (iCurRowIndex > 0) {
                kdt.removeRow(iCurRowIndex);
                kdt.addRow(0, curRow);
                PaRptClientUtil.setActiveRowIndex(kdt, 0);
            }
        }
    }

    public static void moveBottom(KDTable kdt) {
        if (kdt.getSelectManager() != null && kdt.getSelectManager().getActiveRowIndex() >= 0) {
            int iCurRowIndex = kdt.getSelectManager().getActiveRowIndex();
            int iRowCount = kdt.getRowCount();
            IRow curRow = kdt.getRow(iCurRowIndex);
            if (iCurRowIndex < iRowCount - 1) {
                kdt.removeRow(iCurRowIndex);
                kdt.addRow(iRowCount - 1, curRow);
                PaRptClientUtil.setActiveRowIndex(kdt, iRowCount - 1);
            }
        }
    }

    public static void deleteKdTableSelectedRows(KDTable kdt) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)kdt);
        if (selectRows != null && selectRows.length > 0) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < selectRows.length; ++i) {
                list.add(kdt.getCell(selectRows[i], 0).getValue());
            }
            block1: while (list.size() > 0) {
                for (int j = 0; j < kdt.getRowCount(); ++j) {
                    if (!list.contains(kdt.getCell(j, 0).getValue())) continue;
                    list.remove(kdt.getCell(j, 0).getValue());
                    kdt.removeRow(j);
                    continue block1;
                }
            }
        }
    }

    public static void addArrayValueToTable(KDTable kdt, Object[] arrObj) {
        if (arrObj == null) {
            return;
        }
        kdt.checkParsed();
        int arrCount = arrObj.length;
        for (int i = 0; i < arrCount; ++i) {
            PaRptClientUtil.adObjValueToTable(kdt, arrObj[i]);
        }
    }

    private static void adObjValueToTable(KDTable kdt, Object obj) {
        if (kdt.getName().equals("companyTable")) {
            PaRptClientUtil.addCompanyTabInfoToTable(kdt, obj);
            return;
        }
        if (kdt.getName().equals("tblRptItemSelected") || kdt.getName().equals("itemTable")) {
            PaRptClientUtil.addItemTabInfoToTable(kdt, obj);
            return;
        }
        IRow row = null;
        PaTemplateInfo templateInfo = null;
        if (kdt.getName().equals("templateTable") && obj instanceof PaTemplateInfo) {
            templateInfo = (PaTemplateInfo)obj;
            if (PaRptClientUtil.isExistsDouble(kdt, templateInfo.getId().toString())) {
                return;
            }
            row = kdt.addRow();
            row.getCell("id").setValue((Object)templateInfo.getId().toString());
            row.getCell("number").setValue((Object)templateInfo.getNumber());
            row.getCell("name").setValue((Object)templateInfo.getName());
            row.getCell("type").setValue((Object)PaRptTmpTypeEnum.PORTFOLIOANALYSISREPORT);
        }
        if (kdt.getName().equals("kDTable1") && obj instanceof PaTemplateInfo) {
            templateInfo = (PaTemplateInfo)obj;
            if (PaRptClientUtil.isExistsDouble(kdt, templateInfo.getId().toString())) {
                return;
            }
            row = kdt.addRow();
            row.setUserObject((Object)templateInfo);
            row.getCell("tempalteId").setValue((Object)templateInfo.getId().toString());
            row.getCell("templateNumber").setValue((Object)templateInfo.getNumber());
            row.getCell("tempalteName").setValue((Object)templateInfo.getName());
            row.getCell("reportNumber").setValue(templateInfo.get("reportNumber"));
            row.getCell("reportName").setValue((Object)templateInfo.getName());
        }
    }

    private static void addCompanyTabInfoToTable(KDTable kdt, Object obj) {
        if (kdt.getName().equals("companyTable")) {
            IRow row = null;
            if (obj instanceof CompanyTabInfo) {
                CompanyTabInfo info = (CompanyTabInfo)obj;
                if (PaRptClientUtil.isExistsDouble(kdt, info.getId())) {
                    return;
                }
                row = kdt.addRow();
                row.setUserObject((Object)info);
                row.getCell("id").setValue((Object)info.getId());
                row.getCell("number").setValue((Object)info.getNumber());
                row.getCell("name").setValue((Object)info.getShowString());
                row.getCell("source").setValue((Object)info.getSrcTypeEnum());
            }
        }
    }

    private static void addItemTabInfoToTable(KDTable kdt, Object obj) {
        if (kdt.getName().equals("tblRptItemSelected") || kdt.getName().equals("itemTable")) {
            IRow row = null;
            if (obj instanceof ItemTabInfo) {
                ItemTabInfo info = (ItemTabInfo)obj;
                if (PaRptClientUtil.isExistsDouble(kdt, info.getId())) {
                    return;
                }
                row = kdt.addRow();
                row.setUserObject((Object)info);
                row.getCell("id").setValue((Object)info.getId());
                row.getCell("code").setValue((Object)info.getRPTItemInfo().getNumber());
                row.getCell("name").setValue((Object)info.getRPTItemInfo().getName());
                row.getCell("dataElement").setValue((Object)info.getDataElementInfo());
                row.getCell("valueType").setValue((Object)info.getValueType());
            }
        }
    }

    private static boolean isExistsDouble(KDTable kdt, String strID) {
        int col = 0;
        if (kdt.getColumn("id") != null) {
            col = kdt.getColumn("id").getColumnIndex();
        }
        return PaRptClientUtil.isExistsDouble(kdt, strID, col);
    }

    private static boolean isExistsDouble(KDTable kdt, String strID, int col) {
        for (int i = 0; i < kdt.getRowCount(); ++i) {
            if (!kdt.getCell(i, col).getValue().toString().equals(strID)) continue;
            return true;
        }
        return false;
    }

    public static String autoCreateReportNumber(RptPeriodTypeEnum periodType, String templateNumber, int year, int period, String currencyNumber, String orgUnitNumber) {
        StringBuffer str = new StringBuffer();
        str.append(PaRptClientUtil.getPeriodTypeCode(periodType)).append(orgUnitNumber).append(templateNumber).append(year).append(period >= 9 ? period + "" : "0" + period).append(currencyNumber);
        if (str.length() >= 80) {
            return str.delete(0, 79).toString();
        }
        return str.toString();
    }

    private static String getPeriodTypeCode(RptPeriodTypeEnum periodType) {
        String code = "M";
        switch (periodType.getValue()) {
            case 1: {
                code = "D";
                break;
            }
            case 2: {
                code = "W";
                break;
            }
            case 3: {
                code = "M";
                break;
            }
            case 4: {
                code = "Q";
                break;
            }
            case 5: {
                code = "Hy";
                break;
            }
            case 6: {
                code = "Y";
                break;
            }
        }
        return code;
    }

    public static CompanyF7Dialog getOUUnionF7(IUIObject _uiObject, Set selectedOrgs, boolean isMultiCU, String cuID, List cuIdList, boolean isCUAdmin, List userOrgRangeList) {
        CompanyF7Dialog orgF7 = new CompanyF7Dialog(_uiObject);
        orgF7.setShowAssistantOrg(true);
        orgF7.setShowSub(true);
        orgF7.setMultiCUs(isMultiCU);
        if (cuIdList != null) {
            orgF7.setCuIdList(cuIdList);
        }
        orgF7.disableTheOUWhichIsOnlyAdmin();
        orgF7.setMultiSelect(true);
        orgF7.setIsShowContainSealUp(true);
        if (!StringUtils.isEmpty((String)cuID)) {
            orgF7.setCuID(cuID);
        }
        orgF7.setCheckedOrgIDs(selectedOrgs);
        if (!isCUAdmin) {
            orgF7.useFilter(ToolUtils.trans2Map((Collection)userOrgRangeList));
        }
        return orgF7;
    }
}

